/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.opends.messages.JebMessages;
import org.opends.server.backends.jeb.DatabaseContainer;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.EntryIDSet;
import org.opends.server.backends.jeb.Indexer;
import org.opends.server.backends.jeb.State;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Index
extends DatabaseContainer {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public Indexer indexer;
    private Comparator<byte[]> comparator;
    private int indexEntryLimit;
    private int cursorEntryLimit;
    private int entryLimitExceededCount;
    private State state;
    private boolean trusted = false;
    private boolean rebuildRunning = false;

    public Index(String name, Indexer indexer, State state, int indexEntryLimit, int cursorEntryLimit, Environment env, EntryContainer entryContainer) throws DatabaseException {
        super(name, env, entryContainer);
        this.indexer = indexer;
        this.comparator = indexer.getComparator();
        this.indexEntryLimit = indexEntryLimit;
        this.cursorEntryLimit = cursorEntryLimit;
        DatabaseConfig dbNodupsConfig = new DatabaseConfig();
        if (env.getConfig().getReadOnly()) {
            dbNodupsConfig.setReadOnly(true);
            dbNodupsConfig.setAllowCreate(false);
            dbNodupsConfig.setTransactional(false);
        } else if (!env.getConfig().getTransactional()) {
            dbNodupsConfig.setAllowCreate(true);
            dbNodupsConfig.setTransactional(false);
            dbNodupsConfig.setDeferredWrite(true);
        } else {
            dbNodupsConfig.setAllowCreate(true);
            dbNodupsConfig.setTransactional(true);
        }
        this.dbConfig = dbNodupsConfig;
        this.dbConfig.setOverrideBtreeComparator(true);
        this.dbConfig.setBtreeComparator(this.comparator.getClass());
        this.state = state;
        this.trusted = state.getIndexTrustState(null, this);
        if (!this.trusted && entryContainer.getEntryCount() <= 0L) {
            this.setTrusted(null, true);
        }
        if (!this.trusted) {
            ErrorLogger.logError(JebMessages.NOTE_JEB_INDEX_ADD_REQUIRES_REBUILD.get(name));
        }
    }

    public boolean insertID(Transaction txn, DatabaseEntry key, EntryID entryID) throws DatabaseException {
        LockMode lockMode = LockMode.RMW;
        DatabaseEntry entryIDData = entryID.getDatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        boolean success = true;
        OperationStatus status = this.read(txn, key, data, lockMode);
        if (status == OperationStatus.SUCCESS) {
            EntryIDSet entryIDList = new EntryIDSet(key.getData(), data.getData());
            if (entryIDList.isDefined()) {
                if (this.indexEntryLimit > 0 && entryIDList.size() >= this.indexEntryLimit) {
                    entryIDList = new EntryIDSet();
                    ++this.entryLimitExceededCount;
                    if (DebugLogger.debugEnabled()) {
                        StringBuilder builder = new StringBuilder();
                        StaticUtils.byteArrayToHexPlusAscii(builder, key.getData(), 4);
                        TRACER.debugInfo("Index entry exceeded in index %s. Limit: %d. ID list size: %d.\nKey:", this.name, this.indexEntryLimit, entryIDList.size(), builder);
                    }
                } else if (!entryIDList.add(entryID)) {
                    success = false;
                }
                byte[] after = entryIDList.toDatabase();
                data.setData(after);
                this.put(txn, key, data);
            }
        } else if (this.rebuildRunning || this.trusted) {
            this.put(txn, key, entryIDData);
        }
        return success;
    }

    public void removeID(Transaction txn, DatabaseEntry key, EntryID entryID) throws DatabaseException {
        DatabaseEntry data = new DatabaseEntry();
        LockMode lockMode = LockMode.RMW;
        OperationStatus status = this.read(txn, key, data, lockMode);
        if (status == OperationStatus.SUCCESS) {
            EntryIDSet entryIDList = new EntryIDSet(key.getData(), data.getData());
            if (entryIDList.isDefined()) {
                if (!entryIDList.remove(entryID) && !this.rebuildRunning) {
                    byte[] after = new EntryIDSet().toDatabase();
                    data.setData(after);
                    this.put(txn, key, data);
                    if (this.trusted) {
                        this.setTrusted(txn, false);
                        if (DebugLogger.debugEnabled()) {
                            StringBuilder builder = new StringBuilder();
                            StaticUtils.byteArrayToHexPlusAscii(builder, key.getData(), 4);
                            TRACER.debugError("The expected entry ID does not exist in the entry ID list for index %s.\nKey:%s", this.name, builder.toString());
                        }
                        ErrorLogger.logError(JebMessages.ERR_JEB_INDEX_CORRUPT_REQUIRES_REBUILD.get(this.name));
                    }
                } else {
                    byte[] after = entryIDList.toDatabase();
                    if (after == null) {
                        this.delete(txn, key);
                    } else {
                        data.setData(after);
                        this.put(txn, key, data);
                    }
                }
            }
        } else if (this.trusted && !this.rebuildRunning) {
            this.setTrusted(txn, false);
            if (DebugLogger.debugEnabled()) {
                StringBuilder builder = new StringBuilder();
                StaticUtils.byteArrayToHexPlusAscii(builder, key.getData(), 4);
                TRACER.debugError("The expected key does not exist in the index %s.\nKey:%s", this.name, builder.toString());
            }
            ErrorLogger.logError(JebMessages.ERR_JEB_INDEX_CORRUPT_REQUIRES_REBUILD.get(this.name));
        }
    }

    public ConditionResult containsID(Transaction txn, DatabaseEntry key, EntryID entryID) throws DatabaseException {
        if (this.rebuildRunning) {
            return ConditionResult.UNDEFINED;
        }
        DatabaseEntry data = new DatabaseEntry();
        LockMode lockMode = LockMode.DEFAULT;
        OperationStatus status = this.read(txn, key, data, lockMode);
        if (status == OperationStatus.SUCCESS) {
            EntryIDSet entryIDList = new EntryIDSet(key.getData(), data.getData());
            if (!entryIDList.isDefined()) {
                return ConditionResult.UNDEFINED;
            }
            if (entryIDList.contains(entryID)) {
                return ConditionResult.TRUE;
            }
            return ConditionResult.FALSE;
        }
        if (this.trusted) {
            return ConditionResult.FALSE;
        }
        return ConditionResult.UNDEFINED;
    }

    public EntryIDSet readKey(DatabaseEntry key, Transaction txn, LockMode lockMode) {
        if (this.rebuildRunning) {
            return new EntryIDSet();
        }
        try {
            DatabaseEntry data = new DatabaseEntry();
            OperationStatus status = this.read(txn, key, data, lockMode);
            if (status != OperationStatus.SUCCESS) {
                if (this.trusted) {
                    return new EntryIDSet(key.getData(), null);
                }
                return new EntryIDSet();
            }
            return new EntryIDSet(key.getData(), data.getData());
        }
        catch (DatabaseException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return new EntryIDSet();
        }
    }

    public void writeKey(Transaction txn, DatabaseEntry key, EntryIDSet entryIDList) throws DatabaseException {
        DatabaseEntry data = new DatabaseEntry();
        byte[] after = entryIDList.toDatabase();
        if (after == null) {
            this.delete(txn, key);
        } else {
            if (!entryIDList.isDefined()) {
                ++this.entryLimitExceededCount;
            }
            data.setData(after);
            this.put(txn, key, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EntryIDSet readRange(byte[] lower, byte[] upper, boolean lowerIncluded, boolean upperIncluded) {
        LockMode lockMode = LockMode.DEFAULT;
        if (this.rebuildRunning) return new EntryIDSet();
        if (!this.trusted) {
            return new EntryIDSet();
        }
        try {
            int totalIDCount = 0;
            DatabaseEntry data = new DatabaseEntry();
            ArrayList<EntryIDSet> lists = new ArrayList<EntryIDSet>();
            Cursor cursor = this.openCursor(null, CursorConfig.READ_COMMITTED);
            try {
                int cmp;
                OperationStatus status;
                DatabaseEntry key;
                if (lower.length > 0) {
                    key = new DatabaseEntry(lower);
                    status = cursor.getSearchKeyRange(key, data, lockMode);
                    if (status == OperationStatus.SUCCESS && !lowerIncluded && this.comparator.compare(key.getData(), lower) == 0) {
                        status = cursor.getNext(key, data, lockMode);
                    }
                } else {
                    key = new DatabaseEntry();
                    status = cursor.getNext(key, data, lockMode);
                }
                if (status != OperationStatus.SUCCESS) {
                    EntryIDSet entryIDSet = new EntryIDSet(key.getData(), null);
                    return entryIDSet;
                }
                while (status == OperationStatus.SUCCESS && (upper.length <= 0 || (cmp = this.comparator.compare(key.getData(), upper)) <= 0 && (cmp != 0 || upperIncluded))) {
                    EntryIDSet list = new EntryIDSet(key.getData(), data.getData());
                    if (!list.isDefined()) {
                        EntryIDSet entryIDSet = list;
                        return entryIDSet;
                    }
                    if (this.cursorEntryLimit > 0 && (totalIDCount += list.size()) > this.cursorEntryLimit) {
                        EntryIDSet entryIDSet = new EntryIDSet();
                        return entryIDSet;
                    }
                    lists.add(list);
                    status = cursor.getNext(key, data, LockMode.DEFAULT);
                }
                EntryIDSet entryIDSet = EntryIDSet.unionOfSets(lists, false);
                return entryIDSet;
            }
            finally {
                cursor.close();
            }
        }
        catch (DatabaseException e) {
            if (!DebugLogger.debugEnabled()) return new EntryIDSet();
            TRACER.debugCaught(DebugLogLevel.ERROR, e);
            return new EntryIDSet();
        }
    }

    public int getEntryLimitExceededCount() {
        return this.entryLimitExceededCount;
    }

    public boolean addEntry(Transaction txn, EntryID entryID, Entry entry) throws DatabaseException, DirectoryException {
        HashSet<ASN1OctetString> addKeys = new HashSet<ASN1OctetString>();
        boolean success = true;
        this.indexer.indexEntry(txn, entry, addKeys);
        DatabaseEntry key = new DatabaseEntry();
        for (ASN1OctetString keyBytes : addKeys) {
            key.setData(keyBytes.value());
            if (this.insertID(txn, key, entryID)) continue;
            success = false;
        }
        return success;
    }

    public void removeEntry(Transaction txn, EntryID entryID, Entry entry) throws DatabaseException, DirectoryException {
        HashSet<ASN1OctetString> delKeys = new HashSet<ASN1OctetString>();
        this.indexer.indexEntry(txn, entry, delKeys);
        DatabaseEntry key = new DatabaseEntry();
        for (ASN1OctetString keyBytes : delKeys) {
            key.setData(keyBytes.value());
            this.removeID(txn, key, entryID);
        }
    }

    public void modifyEntry(Transaction txn, EntryID entryID, Entry oldEntry, Entry newEntry, List<Modification> mods) throws DatabaseException {
        HashSet<ASN1OctetString> addKeys = new HashSet<ASN1OctetString>();
        HashSet<ASN1OctetString> delKeys = new HashSet<ASN1OctetString>();
        this.indexer.modifyEntry(txn, oldEntry, newEntry, mods, addKeys, delKeys);
        DatabaseEntry key = new DatabaseEntry();
        for (ASN1OctetString keyBytes : delKeys) {
            key.setData(keyBytes.value());
            this.removeID(txn, key, entryID);
        }
        for (ASN1OctetString keyBytes : addKeys) {
            key.setData(keyBytes.value());
            this.insertID(txn, key, entryID);
        }
    }

    public boolean setIndexEntryLimit(int indexEntryLimit) {
        boolean rebuildRequired = false;
        if (this.indexEntryLimit < indexEntryLimit && this.entryLimitExceededCount > 0) {
            rebuildRequired = true;
        }
        this.indexEntryLimit = indexEntryLimit;
        return rebuildRequired;
    }

    public void setIndexer(Indexer indexer) {
        this.indexer = indexer;
    }

    public synchronized void setTrusted(Transaction txn, boolean trusted) throws DatabaseException {
        this.trusted = trusted;
        this.state.putIndexTrustState(txn, this, trusted);
    }

    public synchronized void setRebuildStatus(boolean rebuildRunning) {
        this.rebuildRunning = rebuildRunning;
    }
}

