/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Transaction;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.Indexer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubstringIndexer
extends Indexer {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final Comparator<byte[]> comparator = new AttributeIndex.KeyComparator();
    private AttributeType attributeType;
    private int substrLength;

    public SubstringIndexer(AttributeType attributeType, int substringLength) {
        this.attributeType = attributeType;
        this.substrLength = substringLength;
    }

    public String toString() {
        return this.attributeType.getNameOrOID() + ".substring";
    }

    @Override
    public Comparator<byte[]> getComparator() {
        return comparator;
    }

    @Override
    public void indexEntry(Transaction txn, Entry entry, Set<ASN1OctetString> keys) {
        List<Attribute> attrList = entry.getAttribute(this.attributeType);
        if (attrList != null) {
            this.indexAttribute(attrList, keys);
        }
    }

    @Override
    public void replaceEntry(Transaction txn, Entry oldEntry, Entry newEntry, Set<ASN1OctetString> addKeys, Set<ASN1OctetString> delKeys) {
        List<Attribute> attrList = oldEntry.getAttribute(this.attributeType);
        HashSet<ASN1OctetString> oldSet = new HashSet<ASN1OctetString>();
        this.indexAttribute(attrList, oldSet);
        attrList = newEntry.getAttribute(this.attributeType);
        HashSet<ASN1OctetString> newSet = new HashSet<ASN1OctetString>();
        this.indexAttribute(attrList, newSet);
        HashSet<ASN1OctetString> removeSet = new HashSet<ASN1OctetString>(oldSet);
        removeSet.removeAll(newSet);
        for (ASN1OctetString k : removeSet) {
            delKeys.add(k);
        }
        HashSet<ASN1OctetString> addSet = new HashSet<ASN1OctetString>(newSet);
        addSet.removeAll(oldSet);
        for (ASN1OctetString k : addSet) {
            addKeys.add(k);
        }
    }

    @Override
    public void modifyEntry(Transaction txn, Entry oldEntry, Entry newEntry, List<Modification> mods, Set<ASN1OctetString> addKeys, Set<ASN1OctetString> delKeys) {
        this.replaceEntry(txn, oldEntry, newEntry, addKeys, delKeys);
    }

    private void indexAttribute(List<Attribute> attrList, Set<ASN1OctetString> addKeys) {
        if (attrList == null) {
            return;
        }
        for (Attribute attr : attrList) {
            LinkedHashSet<AttributeValue> values = attr.getValues();
            for (AttributeValue value : values) {
                try {
                    byte[] normalizedBytes = value.getNormalizedValue().value();
                    this.substringKeys(normalizedBytes, addKeys);
                }
                catch (DirectoryException e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }

    private void substringKeys(byte[] value, Set<ASN1OctetString> set) {
        int i = 0;
        for (int remain = value.length; remain > 0; --remain) {
            int len = Math.min(this.substrLength, remain);
            byte[] keyBytes = this.makeSubstringKey(value, i, len);
            set.add(new ASN1OctetString(keyBytes));
            ++i;
        }
    }

    private byte[] makeSubstringKey(byte[] bytes, int pos, int len) {
        byte[] keyBytes = new byte[len];
        System.arraycopy(bytes, pos, keyBytes, 0, len);
        return keyBytes;
    }
}

