/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.TreeMap;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.ImportContext;
import org.opends.server.backends.jeb.IndexBuilder;
import org.opends.server.backends.jeb.SortValues;
import org.opends.server.backends.jeb.VLVIndex;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.util.StaticUtils;

public class VLVIndexBuilder
implements IndexBuilder {
    private ImportContext importContext;
    private VLVIndex vlvIndex;
    TreeMap<SortValues, EntryID> addBuffer;
    TreeMap<SortValues, EntryID> delBuffer;
    private int bufferSize;
    private int fileNumber = 0;
    private String fileNamePrefix;
    private boolean replaceExisting = false;
    private ByteArrayOutputStream addBytesStream = new ByteArrayOutputStream();
    private ByteArrayOutputStream delBytesStream = new ByteArrayOutputStream();
    private DataOutputStream addBytesDataStream;
    private DataOutputStream delBytesDataStream;
    private FilenameFilter filter = new FilenameFilter(){

        public boolean accept(File d, String name) {
            return name.startsWith(VLVIndexBuilder.this.fileNamePrefix);
        }
    };

    public VLVIndexBuilder(ImportContext importContext, VLVIndex vlvIndex, long bufferSize) {
        this.importContext = importContext;
        this.vlvIndex = vlvIndex;
        this.bufferSize = (int)bufferSize / 100;
        long tid = Thread.currentThread().getId();
        this.fileNamePrefix = vlvIndex.getName() + "_" + tid + "_";
        this.replaceExisting = importContext.getLDIFImportConfig().appendToExistingData() && importContext.getLDIFImportConfig().replaceExistingEntries();
        this.addBytesDataStream = new DataOutputStream(this.addBytesStream);
        this.delBytesDataStream = new DataOutputStream(this.delBytesStream);
    }

    public void startProcessing() {
        File tempDir = StaticUtils.getFileForPath(this.importContext.getConfig().getBackendImportTempDirectory());
        File[] files = tempDir.listFiles(this.filter);
        if (files != null) {
            for (File f : files) {
                f.delete();
            }
        }
        this.addBuffer = new TreeMap();
        this.delBuffer = new TreeMap();
    }

    public void processEntry(Entry oldEntry, Entry newEntry, EntryID entryID) throws DatabaseException, IOException, DirectoryException {
        Object txn = null;
        SortValues newValues = new SortValues(entryID, newEntry, this.vlvIndex.sortOrder);
        if (oldEntry != null && this.vlvIndex.shouldInclude(oldEntry)) {
            SortValues oldValues = new SortValues(entryID, oldEntry, this.vlvIndex.sortOrder);
            this.removeValues(oldValues, entryID);
        }
        if (this.vlvIndex.shouldInclude(newEntry)) {
            this.insertValues(newValues, entryID);
        }
    }

    public void stopProcessing() throws IOException {
        this.flushBuffer();
    }

    private void insertValues(SortValues sortValues, EntryID entryID) throws IOException {
        if (this.addBuffer.size() + this.delBuffer.size() >= this.bufferSize) {
            this.flushBuffer();
        }
        this.addBuffer.put(sortValues, entryID);
    }

    private void removeValues(SortValues sortValues, EntryID entryID) throws IOException {
        if (this.addBuffer.size() + this.delBuffer.size() >= this.bufferSize) {
            this.flushBuffer();
        }
        this.delBuffer.remove(sortValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBuffer() throws IOException {
        byte[] valueBytes;
        if (this.addBuffer.size() + this.delBuffer.size() == 0) {
            return;
        }
        ++this.fileNumber;
        String fileName = this.fileNamePrefix + String.valueOf(this.fileNumber) + "_add";
        File file = new File(StaticUtils.getFileForPath(this.importContext.getConfig().getBackendImportTempDirectory()), fileName);
        BufferedOutputStream bufferedStream = new BufferedOutputStream(new FileOutputStream(file));
        DataOutputStream dataStream = new DataOutputStream(bufferedStream);
        try {
            for (SortValues values : this.addBuffer.keySet()) {
                dataStream.writeLong(values.getEntryID());
                for (AttributeValue value : values.getValues()) {
                    if (value != null) {
                        valueBytes = value.getValueBytes();
                        dataStream.writeInt(valueBytes.length);
                        dataStream.write(valueBytes);
                        continue;
                    }
                    dataStream.writeInt(0);
                }
            }
        }
        finally {
            dataStream.close();
        }
        if (this.replaceExisting) {
            fileName = this.fileNamePrefix + String.valueOf(this.fileNumber) + "_del";
            file = new File(StaticUtils.getFileForPath(this.importContext.getConfig().getBackendImportTempDirectory()), fileName);
            bufferedStream = new BufferedOutputStream(new FileOutputStream(file));
            dataStream = new DataOutputStream(bufferedStream);
            try {
                for (SortValues values : this.delBuffer.keySet()) {
                    dataStream.writeLong(values.getEntryID());
                    for (AttributeValue value : values.getValues()) {
                        valueBytes = value.getValueBytes();
                        dataStream.writeInt(valueBytes.length);
                        dataStream.write(valueBytes);
                    }
                }
            }
            finally {
                dataStream.close();
            }
        }
        this.addBuffer = new TreeMap();
        this.delBuffer = new TreeMap();
    }

    public String toString() {
        return this.vlvIndex.toString() + " builder";
    }
}

