/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.util.concurrent.locks.Lock;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.api.IdentityMapper;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PasswordPolicyState;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.LDAPException;
import org.opends.server.types.LockManager;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;

public class ProxiedAuthV2Control
extends Control {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ASN1OctetString authorizationID;

    public ProxiedAuthV2Control(ASN1OctetString authorizationID) {
        super("2.16.840.1.113730.3.4.18", true, authorizationID);
        Validator.ensureNotNull(authorizationID);
        this.authorizationID = authorizationID;
    }

    private ProxiedAuthV2Control(String oid, boolean isCritical, ASN1OctetString authorizationID) {
        super(oid, isCritical, authorizationID);
        this.authorizationID = authorizationID;
    }

    public static ProxiedAuthV2Control decodeControl(Control control) throws LDAPException {
        ASN1OctetString authorizationID;
        Validator.ensureNotNull(control);
        if (!control.isCritical()) {
            Message message = ProtocolMessages.ERR_PROXYAUTH2_CONTROL_NOT_CRITICAL.get();
            throw new LDAPException(2, message);
        }
        if (!control.hasValue()) {
            Message message = ProtocolMessages.ERR_PROXYAUTH2_NO_CONTROL_VALUE.get();
            throw new LDAPException(2, message);
        }
        try {
            authorizationID = ASN1OctetString.decodeAsOctetString(control.getValue().value());
        }
        catch (ASN1Exception ae) {
            String lowerAuthZIDStr = StaticUtils.toLowerCase(control.getValue().stringValue());
            if (lowerAuthZIDStr.startsWith("dn:") || lowerAuthZIDStr.startsWith("u:")) {
                authorizationID = control.getValue();
            }
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ae);
            }
            Message message = ProtocolMessages.ERR_PROXYAUTH2_CANNOT_DECODE_VALUE.get(StaticUtils.getExceptionMessage(ae));
            throw new LDAPException(2, message, ae);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_PROXYAUTH2_CANNOT_DECODE_VALUE.get(StaticUtils.getExceptionMessage(e));
            throw new LDAPException(2, message, e);
        }
        return new ProxiedAuthV2Control(control.getOID(), control.isCritical(), authorizationID);
    }

    public ASN1OctetString getAuthorizationID() {
        return this.authorizationID;
    }

    public void setAuthorizationID(ASN1OctetString authorizationID) {
        if (authorizationID == null) {
            this.authorizationID = new ASN1OctetString();
            this.setValue(this.authorizationID);
        } else {
            this.authorizationID = authorizationID;
            this.setValue(authorizationID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getAuthorizationEntry() throws DirectoryException {
        if (this.authorizationID.value().length == 0) {
            return null;
        }
        String authzID = this.authorizationID.stringValue();
        String lowerAuthzID = StaticUtils.toLowerCase(authzID);
        if (lowerAuthzID.startsWith("dn:")) {
            DN authzDN = DN.decode(authzID.substring(3));
            if (authzDN.isNullDN()) {
                return null;
            }
            DN actualDN = DirectoryServer.getActualRootBindDN(authzDN);
            if (actualDN != null) {
                authzDN = actualDN;
            }
            Lock entryLock = null;
            for (int i = 0; i < 3 && (entryLock = LockManager.lockRead(authzDN)) == null; ++i) {
            }
            if (entryLock == null) {
                Message message = ProtocolMessages.ERR_PROXYAUTH2_CANNOT_LOCK_USER.get(String.valueOf(authzDN));
                throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, message);
            }
            try {
                Entry userEntry = DirectoryServer.getEntry(authzDN);
                if (userEntry == null) {
                    Message message = ProtocolMessages.ERR_PROXYAUTH2_NO_SUCH_USER.get(authzID);
                    throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, message);
                }
                PasswordPolicyState pwpState = new PasswordPolicyState(userEntry, false, false);
                if (pwpState.isDisabled() || pwpState.isAccountExpired() || pwpState.lockedDueToFailures() || pwpState.lockedDueToIdleInterval() || pwpState.lockedDueToMaximumResetAge() || pwpState.isPasswordExpired()) {
                    Message message = ProtocolMessages.ERR_PROXYAUTH2_UNUSABLE_ACCOUNT.get(String.valueOf(authzDN));
                    throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, message);
                }
                Entry entry = userEntry;
                return entry;
            }
            finally {
                LockManager.unlock(authzDN, entryLock);
            }
        }
        if (lowerAuthzID.startsWith("u:")) {
            if (lowerAuthzID.length() == 2) {
                return null;
            }
            IdentityMapper proxyMapper = DirectoryServer.getProxiedAuthorizationIdentityMapper();
            if (proxyMapper == null) {
                Message message = ProtocolMessages.ERR_PROXYAUTH2_NO_IDENTITY_MAPPER.get();
                throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, message);
            }
            Entry userEntry = proxyMapper.getEntryForID(authzID.substring(2));
            if (userEntry == null) {
                Message message = ProtocolMessages.ERR_PROXYAUTH2_NO_SUCH_USER.get(authzID);
                throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, message);
            }
            PasswordPolicyState pwpState = new PasswordPolicyState(userEntry, false, false);
            if (pwpState.isDisabled() || pwpState.isAccountExpired() || pwpState.lockedDueToFailures() || pwpState.lockedDueToIdleInterval() || pwpState.lockedDueToMaximumResetAge() || pwpState.isPasswordExpired()) {
                Message message = ProtocolMessages.ERR_PROXYAUTH2_UNUSABLE_ACCOUNT.get(String.valueOf(userEntry.getDN()));
                throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, message);
            }
            return userEntry;
        }
        Message message = ProtocolMessages.ERR_PROXYAUTH2_INVALID_AUTHZID.get(authzID);
        throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("ProxiedAuthorizationV2Control(authzID=\"");
        this.authorizationID.toString(buffer);
        buffer.append("\")");
    }
}

