/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.EntryCacheCfgDefn;
import org.opends.server.admin.std.server.EntryCacheCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.api.EntryCache;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.DefaultEntryCache;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryCacheConfigManager
implements ConfigurationChangeListener<EntryCacheCfg>,
ConfigurationAddListener<EntryCacheCfg>,
ConfigurationDeleteListener<EntryCacheCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private EntryCache _entryCache = null;
    private EntryCache _defaultEntryCache = null;

    public void initializeDefaultEntryCache() throws InitializationException {
        try {
            DefaultEntryCache defaultCache = new DefaultEntryCache();
            defaultCache.initializeEntryCache(null);
            DirectoryServer.setEntryCache(defaultCache);
            this._defaultEntryCache = defaultCache;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ConfigMessages.ERR_CONFIG_ENTRYCACHE_CANNOT_INSTALL_DEFAULT_CACHE.get(StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message, (Throwable)e);
        }
    }

    public void initializeEntryCache() throws ConfigException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        EntryCacheCfg configuration = rootConfiguration.getEntryCache();
        configuration.addChangeListener(this);
        if (configuration.isEnabled()) {
            String className = configuration.getEntryCacheClass();
            try {
                this.loadAndInstallEntryCache(className, configuration);
            }
            catch (InitializationException ie) {
                ErrorLogger.logError(ie.getMessageObject());
            }
        }
    }

    @Override
    public boolean isConfigurationChangeAcceptable(EntryCacheCfg configuration, List<Message> unacceptableReasons) {
        boolean status = true;
        if (configuration.isEnabled()) {
            String className = configuration.getEntryCacheClass();
            try {
                this.loadEntryCache(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                status = false;
            }
        }
        return status;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(EntryCacheCfg configuration) {
        ConfigChangeResult changeResult = new ConfigChangeResult(ResultCode.SUCCESS, false, new ArrayList<Message>());
        if (!configuration.isEnabled()) {
            DirectoryServer.setEntryCache(this._defaultEntryCache);
            if (this._entryCache != null) {
                this._entryCache.finalizeEntryCache();
                this._entryCache = null;
            }
            return changeResult;
        }
        String newClassName = configuration.getEntryCacheClass();
        if (this._entryCache != null) {
            boolean classIsNew;
            String curClassName = this._entryCache.getClass().getName();
            boolean bl = classIsNew = !newClassName.equals(curClassName);
            if (classIsNew) {
                changeResult.setAdminActionRequired(true);
            }
            return changeResult;
        }
        try {
            this.loadAndInstallEntryCache(newClassName, configuration);
        }
        catch (InitializationException ie) {
            changeResult.addMessage(ie.getMessageObject());
            changeResult.setResultCode(DirectoryServer.getServerErrorResultCode());
            return changeResult;
        }
        return changeResult;
    }

    @Override
    public boolean isConfigurationAddAcceptable(EntryCacheCfg configuration, List<Message> unacceptableReasons) {
        boolean status = true;
        if (configuration.isEnabled()) {
            String className = configuration.getEntryCacheClass();
            try {
                this.loadEntryCache(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                status = false;
            }
        }
        return status;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(EntryCacheCfg configuration) {
        ConfigChangeResult changeResult = new ConfigChangeResult(ResultCode.SUCCESS, false, new ArrayList<Message>());
        configuration.addChangeListener(this);
        if (configuration.isEnabled()) {
            String className = configuration.getEntryCacheClass();
            try {
                this.loadAndInstallEntryCache(className, configuration);
            }
            catch (InitializationException ie) {
                changeResult.addMessage(ie.getMessageObject());
                changeResult.setResultCode(DirectoryServer.getServerErrorResultCode());
                return changeResult;
            }
        }
        return changeResult;
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(EntryCacheCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(EntryCacheCfg configuration) {
        ConfigChangeResult changeResult = new ConfigChangeResult(ResultCode.SUCCESS, false, new ArrayList<Message>());
        if (this._entryCache != null) {
            DirectoryServer.setEntryCache(this._defaultEntryCache);
            this._entryCache.finalizeEntryCache();
            this._entryCache = null;
        }
        return changeResult;
    }

    private void loadAndInstallEntryCache(String className, EntryCacheCfg configuration) throws InitializationException {
        EntryCache<? extends EntryCacheCfg> entryCache = this.loadEntryCache(className, configuration, true);
        DirectoryServer.setEntryCache(entryCache);
        this._entryCache = entryCache;
    }

    private EntryCache<? extends EntryCacheCfg> loadEntryCache(String className, EntryCacheCfg configuration, boolean initialize) throws InitializationException {
        try {
            EntryCacheCfgDefn definition = EntryCacheCfgDefn.getInstance();
            ClassPropertyDefinition propertyDefinition = definition.getEntryCacheClassPropertyDefinition();
            Class<EntryCache> cacheClass = propertyDefinition.loadClass(className, EntryCache.class);
            EntryCache cache = cacheClass.newInstance();
            if (initialize) {
                Method method = cache.getClass().getMethod("initializeEntryCache", configuration.definition().getServerConfigurationClass());
                method.invoke((Object)cache, configuration);
            } else {
                Method method = cache.getClass().getMethod("isConfigurationAcceptable", EntryCacheCfg.class, List.class);
                ArrayList unacceptableReasons = new ArrayList();
                Boolean acceptable = (Boolean)method.invoke((Object)cache, configuration, unacceptableReasons);
                if (!acceptable.booleanValue()) {
                    MessageBuilder buffer = new MessageBuilder();
                    if (!unacceptableReasons.isEmpty()) {
                        Iterator iterator = unacceptableReasons.iterator();
                        buffer.append((Message)iterator.next());
                        while (iterator.hasNext()) {
                            buffer.append(".  ");
                            buffer.append((Message)iterator.next());
                        }
                    }
                    Message message = ConfigMessages.ERR_CONFIG_ENTRYCACHE_CONFIG_NOT_ACCEPTABLE.get(String.valueOf(configuration.dn()), buffer.toString());
                    throw new InitializationException(message);
                }
            }
            return cache;
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_ENTRYCACHE_CANNOT_INITIALIZE_CACHE.get(className, String.valueOf(configuration.dn()));
            throw new InitializationException(message, (Throwable)e);
        }
    }
}

