/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.LogRotationPolicyCfgDefn;
import org.opends.server.admin.std.server.LogRotationPolicyCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.RotationPolicy;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogRotationPolicyConfigManager
implements ConfigurationAddListener<LogRotationPolicyCfg>,
ConfigurationDeleteListener<LogRotationPolicyCfg>,
ConfigurationChangeListener<LogRotationPolicyCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    public void initializeLogRotationPolicyConfig() throws ConfigException, InitializationException {
        ServerManagementContext context = ServerManagementContext.getInstance();
        RootCfg root = context.getRootConfiguration();
        root.addLogRotationPolicyAddListener(this);
        root.addLogRotationPolicyDeleteListener(this);
        for (String name : root.listLogRotationPolicies()) {
            LogRotationPolicyCfg config = root.getLogRotationPolicy(name);
            RotationPolicy rotationPolicy = this.getRotationPolicy(config);
            DirectoryServer.registerRotationPolicy(config.dn(), rotationPolicy);
        }
    }

    @Override
    public boolean isConfigurationAddAcceptable(LogRotationPolicyCfg configuration, List<Message> unacceptableReasons) {
        return this.isJavaClassAcceptable(configuration, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(LogRotationPolicyCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(LogRotationPolicyCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        try {
            RotationPolicy rotationPolicy = this.getRotationPolicy(config);
            DirectoryServer.registerRotationPolicy(config.dn(), rotationPolicy);
        }
        catch (ConfigException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            messages.add(e.getMessageObject());
            resultCode = DirectoryServer.getServerErrorResultCode();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            messages.add(ConfigMessages.ERR_CONFIG_ROTATION_POLICY_CANNOT_CREATE_POLICY.get(String.valueOf(config.dn().toString()), StaticUtils.stackTraceToSingleLineString(e)));
            resultCode = DirectoryServer.getServerErrorResultCode();
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(LogRotationPolicyCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        RotationPolicy policy = DirectoryServer.getRotationPolicy(config.dn());
        if (policy != null) {
            DirectoryServer.deregisterRotationPolicy(config.dn());
        } else {
            resultCode = DirectoryServer.getServerErrorResultCode();
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(LogRotationPolicyCfg configuration, List<Message> unacceptableReasons) {
        return this.isJavaClassAcceptable(configuration, unacceptableReasons);
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(LogRotationPolicyCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        RotationPolicy policy = DirectoryServer.getRotationPolicy(configuration.dn());
        String className = configuration.getJavaImplementationClass();
        if (!className.equals(policy.getClass().getName())) {
            adminActionRequired = true;
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    private boolean isJavaClassAcceptable(LogRotationPolicyCfg config, List<Message> unacceptableReasons) {
        Class<RotationPolicy> theClass;
        String className = config.getJavaImplementationClass();
        LogRotationPolicyCfgDefn d = LogRotationPolicyCfgDefn.getInstance();
        ClassPropertyDefinition pd = d.getJavaImplementationClassPropertyDefinition();
        try {
            theClass = pd.loadClass(className, RotationPolicy.class);
            theClass.newInstance();
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_ROTATION_POLICY_INVALID_CLASS.get(className, config.dn().toString(), String.valueOf(e));
            unacceptableReasons.add(message);
            return false;
        }
        try {
            theClass.getMethod("initializeLogRotationPolicy", config.definition().getServerConfigurationClass());
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_ROTATION_POLICY_INVALID_CLASS.get(className, config.dn().toString(), String.valueOf(e));
            unacceptableReasons.add(message);
            return false;
        }
        return true;
    }

    private RotationPolicy getRotationPolicy(LogRotationPolicyCfg config) throws ConfigException {
        RotationPolicy rotationPolicy;
        String className = config.getJavaImplementationClass();
        LogRotationPolicyCfgDefn d = LogRotationPolicyCfgDefn.getInstance();
        ClassPropertyDefinition pd = d.getJavaImplementationClassPropertyDefinition();
        try {
            Class<RotationPolicy> theClass = pd.loadClass(className, RotationPolicy.class);
            rotationPolicy = theClass.newInstance();
            Method method = theClass.getMethod("initializeLogRotationPolicy", config.definition().getServerConfigurationClass());
            method.invoke((Object)rotationPolicy, config);
        }
        catch (InvocationTargetException ite) {
            Throwable e = ite.getTargetException();
            Message message = ConfigMessages.ERR_CONFIG_ROTATION_POLICY_INVALID_CLASS.get(className, config.dn().toString(), StaticUtils.stackTraceToSingleLineString(e));
            throw new ConfigException(message, e);
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_ROTATION_POLICY_INVALID_CLASS.get(className, config.dn().toString(), String.valueOf(e));
            throw new ConfigException(message, (Throwable)e);
        }
        return rotationPolicy;
    }
}

