/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.core.NetworkGroupNamingContexts;
import org.opends.server.core.RootDseWorkflowTopology;
import org.opends.server.core.Workflow;
import org.opends.server.core.WorkflowImpl;
import org.opends.server.core.WorkflowTopology;
import org.opends.server.core.WorkflowTopologyNode;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.Validator;
import org.opends.server.workflowelement.WorkflowElement;

public class NetworkGroup {
    private TreeMap<String, WorkflowTopologyNode> registeredWorkflowNodes = new TreeMap();
    private static Object registeredWorkflowNodesLock = new Object();
    private RootDseWorkflowTopology rootDSEWorkflowNode = null;
    private NetworkGroupNamingContexts namingContexts = new NetworkGroupNamingContexts();
    private static NetworkGroup defaultNetworkGroup = new NetworkGroup("default");
    private static TreeMap<String, NetworkGroup> registeredNetworkGroups = new TreeMap();
    private static Object registeredNetworkGroupsLock = new Object();
    private String networkGroupID = null;

    public NetworkGroup(String networkGroupID) {
        this.networkGroupID = networkGroupID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register() throws DirectoryException {
        Validator.ensureNotNull(this.networkGroupID);
        Object object = registeredNetworkGroupsLock;
        synchronized (object) {
            if (registeredNetworkGroups.containsKey(this.networkGroupID)) {
                Message message = CoreMessages.ERR_REGISTER_NETWORK_GROUP_ALREADY_EXISTS.get(this.networkGroupID);
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
            }
            TreeMap<String, NetworkGroup> newRegisteredNetworkGroups = new TreeMap<String, NetworkGroup>((SortedMap<String, NetworkGroup>)registeredNetworkGroups);
            newRegisteredNetworkGroups.put(this.networkGroupID, this);
            registeredNetworkGroups = newRegisteredNetworkGroups;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister() {
        Object object = registeredNetworkGroupsLock;
        synchronized (object) {
            TreeMap<String, NetworkGroup> networkGroups = new TreeMap<String, NetworkGroup>((SortedMap<String, NetworkGroup>)registeredNetworkGroups);
            networkGroups.remove(this.networkGroupID);
            registeredNetworkGroups = networkGroups;
        }
    }

    public void registerWorkflow(WorkflowImpl workflow) throws DirectoryException {
        this.registerWorkflow(workflow, null, null);
    }

    private void registerWorkflow(WorkflowImpl workflow, WorkflowElement[] preWorkflowElements, WorkflowElement[] postWorkflowElements) throws DirectoryException {
        boolean registered = false;
        DN baseDN = workflow.getBaseDN();
        if (baseDN.isNullDN()) {
            this.rootDSEWorkflowNode = new RootDseWorkflowTopology(workflow, this.namingContexts);
            registered = true;
        } else {
            WorkflowTopologyNode workflowNode = new WorkflowTopologyNode(workflow, preWorkflowElements, postWorkflowElements);
            this.registerWorkflowNode(workflowNode);
            registered = true;
            for (WorkflowTopologyNode curNode : this.registeredWorkflowNodes.values()) {
                if (curNode.insertSubordinate(workflowNode) || workflowNode.insertSubordinate(curNode)) break;
            }
            this.rebuildNamingContextList();
        }
        if (registered && this != defaultNetworkGroup) {
            defaultNetworkGroup.registerWorkflow(workflow, preWorkflowElements, postWorkflowElements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterWorkflow(DN baseDN) {
        if (baseDN == null) {
            return;
        }
        if (baseDN.isNullDN()) {
            this.deregisterWorkflow(this.rootDSEWorkflowNode);
        } else {
            Object object = registeredWorkflowNodesLock;
            synchronized (object) {
                for (WorkflowTopologyNode node : this.registeredWorkflowNodes.values()) {
                    DN curDN = node.getBaseDN();
                    if (!curDN.equals(baseDN)) continue;
                    this.deregisterWorkflow(node);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterWorkflow(String workflowID) {
        String rootDSEWorkflowID = null;
        if (this.rootDSEWorkflowNode != null) {
            rootDSEWorkflowID = this.rootDSEWorkflowNode.getWorkflowImpl().getWorkflowId();
        }
        if (workflowID.equalsIgnoreCase(rootDSEWorkflowID)) {
            this.deregisterWorkflow(this.rootDSEWorkflowNode);
        } else {
            Object object = registeredWorkflowNodesLock;
            synchronized (object) {
                for (WorkflowTopologyNode node : this.registeredWorkflowNodes.values()) {
                    String curID = node.getWorkflowImpl().getWorkflowId();
                    if (!curID.equals(workflowID)) continue;
                    this.deregisterWorkflow(node);
                    break;
                }
            }
        }
    }

    private void deregisterWorkflow(Workflow workflow) {
        boolean deregistered = false;
        if (workflow == this.rootDSEWorkflowNode) {
            this.rootDSEWorkflowNode = null;
            deregistered = true;
        } else {
            WorkflowTopologyNode workflowNode = (WorkflowTopologyNode)workflow;
            this.deregisterWorkflowNode(workflowNode);
            deregistered = true;
            workflowNode.remove();
            this.rebuildNamingContextList();
        }
        if (deregistered && this != defaultNetworkGroup) {
            defaultNetworkGroup.deregisterWorkflow(workflow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerWorkflowNode(WorkflowTopologyNode workflowNode) throws DirectoryException {
        String workflowID = workflowNode.getWorkflowImpl().getWorkflowId();
        Validator.ensureNotNull(workflowID);
        Object object = registeredWorkflowNodesLock;
        synchronized (object) {
            if (this.registeredWorkflowNodes.containsKey(workflowID)) {
                Message message = CoreMessages.ERR_REGISTER_WORKFLOW_NODE_ALREADY_EXISTS.get(workflowID, this.networkGroupID);
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
            }
            TreeMap<String, WorkflowTopologyNode> newRegisteredWorkflowNodes = new TreeMap<String, WorkflowTopologyNode>((SortedMap<String, WorkflowTopologyNode>)this.registeredWorkflowNodes);
            newRegisteredWorkflowNodes.put(workflowID, workflowNode);
            this.registeredWorkflowNodes = newRegisteredWorkflowNodes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterWorkflowNode(WorkflowTopologyNode workflowNode) {
        Object object = registeredWorkflowNodesLock;
        synchronized (object) {
            TreeMap<String, WorkflowTopologyNode> newWorkflowNodes = new TreeMap<String, WorkflowTopologyNode>((SortedMap<String, WorkflowTopologyNode>)this.registeredWorkflowNodes);
            newWorkflowNodes.remove(workflowNode.getWorkflowImpl().getWorkflowId());
            this.registeredWorkflowNodes = newWorkflowNodes;
        }
    }

    public Workflow getWorkflowCandidate(DN baseDN) {
        WorkflowTopology workflowCandidate = null;
        if (baseDN.isNullDN()) {
            workflowCandidate = this.rootDSEWorkflowNode;
        } else {
            WorkflowTopologyNode curWorkflow;
            Iterator<WorkflowTopologyNode> i$ = this.namingContexts.getNamingContexts().iterator();
            while (i$.hasNext() && (workflowCandidate = (curWorkflow = i$.next()).getWorkflowCandidate(baseDN)) == null) {
            }
        }
        return workflowCandidate;
    }

    public static NetworkGroup getDefaultNetworkGroup() {
        return defaultNetworkGroup;
    }

    private void rebuildNamingContextList() {
        this.namingContexts.resetLists();
        for (WorkflowTopologyNode workflowNode : this.registeredWorkflowNodes.values()) {
            WorkflowTopologyNode parent = workflowNode.getParent();
            if (parent != null) continue;
            this.namingContexts.addNamingContext(workflowNode);
        }
    }

    private boolean baseDNAlreadyRegistered(DN baseDN) {
        boolean alreadyRegistered = false;
        for (WorkflowTopologyNode workflowNode : this.registeredWorkflowNodes.values()) {
            DN curDN = workflowNode.getBaseDN();
            if (!baseDN.equals(curDN)) continue;
            alreadyRegistered = true;
            break;
        }
        return alreadyRegistered;
    }

    public NetworkGroupNamingContexts getNamingContexts() {
        return this.namingContexts;
    }

    public StringBuffer toString(String leftMargin) {
        StringBuffer sb = new StringBuffer();
        String newMargin = leftMargin + "   ";
        sb.append(leftMargin + "Networkgroup (" + this.networkGroupID + "\n");
        sb.append(leftMargin + "List of registered workflows:\n");
        for (WorkflowTopologyNode node : this.registeredWorkflowNodes.values()) {
            sb.append(node.toString(newMargin));
        }
        this.namingContexts.toString(leftMargin);
        sb.append(leftMargin + "rootDSEWorkflow:\n");
        if (this.rootDSEWorkflowNode == null) {
            sb.append(newMargin + "null\n");
        } else {
            sb.append(this.rootDSEWorkflowNode.toString(newMargin));
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterAll() {
        Object object = registeredNetworkGroupsLock;
        synchronized (object) {
            registeredNetworkGroups = new TreeMap();
            defaultNetworkGroup = new NetworkGroup("default");
        }
    }
}

