/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.meta.PasswordPolicyCfgDefn;
import org.opends.server.admin.std.server.PasswordPolicyCfg;
import org.opends.server.admin.std.server.PasswordValidatorCfg;
import org.opends.server.api.AccountStatusNotificationHandler;
import org.opends.server.api.PasswordGenerator;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.api.PasswordValidator;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.schema.GeneralizedTimeSyntax;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.InitializationException;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasswordPolicy {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final DN configEntryDN;
    private final AttributeType passwordAttribute;
    private final boolean authPasswordSyntax;
    private boolean allowExpiredPasswordChanges;
    private boolean allowMultiplePasswordValues;
    private boolean allowPreEncodedPasswords;
    private boolean allowUserPasswordChanges;
    private boolean expirePasswordsWithoutWarning;
    private boolean forceChangeOnAdd;
    private boolean forceChangeOnReset;
    private boolean requireCurrentPassword;
    private boolean requireSecureAuthentication;
    private boolean requireSecurePasswordChanges;
    private boolean skipValidationForAdministrators;
    private ConcurrentHashMap<DN, AccountStatusNotificationHandler> notificationHandlers;
    private ConcurrentHashMap<DN, PasswordValidator<? extends PasswordValidatorCfg>> passwordValidators;
    private CopyOnWriteArrayList<PasswordStorageScheme> defaultStorageSchemes;
    private CopyOnWriteArraySet<String> deprecatedStorageSchemes;
    private DN passwordGeneratorDN;
    private PasswordGenerator passwordGenerator;
    private int graceLoginCount;
    private int historyCount;
    private int historyDuration;
    private int idleLockoutInterval;
    private int lockoutDuration;
    private int lockoutFailureCount;
    private int lockoutFailureExpirationInterval;
    private int maximumPasswordAge;
    private int maximumPasswordResetAge;
    private int minimumPasswordAge;
    private int warningInterval;
    private long requireChangeByTime;
    private AttributeType lastLoginTimeAttribute;
    private String lastLoginTimeFormat;
    private CopyOnWriteArrayList<String> previousLastLoginTimeFormats;
    private PasswordPolicyCfgDefn.StateUpdateFailurePolicy stateUpdateFailurePolicy;

    public PasswordPolicy(PasswordPolicyCfg configuration) throws ConfigException, InitializationException {
        Message message;
        block78: {
            Message message2;
            Message message3;
            block77: {
                this.allowExpiredPasswordChanges = false;
                this.allowMultiplePasswordValues = false;
                this.allowPreEncodedPasswords = false;
                this.allowUserPasswordChanges = true;
                this.expirePasswordsWithoutWarning = false;
                this.forceChangeOnAdd = false;
                this.forceChangeOnReset = false;
                this.requireCurrentPassword = false;
                this.requireSecureAuthentication = false;
                this.requireSecurePasswordChanges = false;
                this.skipValidationForAdministrators = false;
                this.notificationHandlers = new ConcurrentHashMap();
                this.passwordValidators = new ConcurrentHashMap();
                this.defaultStorageSchemes = new CopyOnWriteArrayList();
                PasswordStorageScheme defaultScheme = DirectoryServer.getPasswordStorageScheme("SSHA");
                if (defaultScheme != null) {
                    this.defaultStorageSchemes.add(defaultScheme);
                }
                this.deprecatedStorageSchemes = new CopyOnWriteArraySet();
                this.passwordGeneratorDN = null;
                this.passwordGenerator = null;
                this.graceLoginCount = 0;
                this.historyCount = 0;
                this.historyDuration = 0;
                this.idleLockoutInterval = 0;
                this.lockoutDuration = 0;
                this.lockoutFailureCount = 0;
                this.lockoutFailureExpirationInterval = 0;
                this.maximumPasswordAge = 0;
                this.maximumPasswordResetAge = 0;
                this.minimumPasswordAge = 0;
                this.warningInterval = 604800;
                this.requireChangeByTime = -1L;
                this.lastLoginTimeAttribute = null;
                this.lastLoginTimeFormat = null;
                this.previousLastLoginTimeFormats = new CopyOnWriteArrayList();
                this.stateUpdateFailurePolicy = PasswordPolicyCfgDefn.StateUpdateFailurePolicy.REACTIVE;
                LinkedHashMap<String, Double> timeUnits = new LinkedHashMap<String, Double>();
                timeUnits.put("s", 1.0);
                timeUnits.put("seconds", 1.0);
                timeUnits.put("m", 60.0);
                timeUnits.put("minutes", 60.0);
                timeUnits.put("h", 3600.0);
                timeUnits.put("hours", 3600.0);
                timeUnits.put("d", 86400.0);
                timeUnits.put("days", 86400.0);
                timeUnits.put("w", 604800.0);
                timeUnits.put("weeks", 604800.0);
                this.configEntryDN = configuration.dn();
                String passwordAttr = configuration.getPasswordAttribute();
                try {
                    if (passwordAttr == null) {
                        this.passwordAttribute = null;
                        this.authPasswordSyntax = false;
                        break block77;
                    }
                    String lowerName = StaticUtils.toLowerCase(passwordAttr);
                    AttributeType pwAttrType = DirectoryServer.getAttributeType(lowerName);
                    if (pwAttrType == null) {
                        Message message4 = CoreMessages.ERR_PWPOLICY_UNDEFINED_PASSWORD_ATTRIBUTE.get(String.valueOf(this.configEntryDN), String.valueOf(passwordAttr));
                        throw new ConfigException(message4);
                    }
                    String syntaxOID = pwAttrType.getSyntaxOID();
                    if (syntaxOID.equals("1.3.6.1.4.1.4203.1.1.2")) {
                        this.passwordAttribute = pwAttrType;
                        this.authPasswordSyntax = true;
                        break block77;
                    }
                    if (syntaxOID.equals("1.3.6.1.4.1.26027.1.3.1")) {
                        this.passwordAttribute = pwAttrType;
                        this.authPasswordSyntax = false;
                        break block77;
                    }
                    String syntax = pwAttrType.getSyntax().getSyntaxName();
                    if (syntax == null || syntax.length() == 0) {
                        syntax = syntaxOID;
                    }
                    Message message5 = CoreMessages.ERR_PWPOLICY_INVALID_PASSWORD_ATTRIBUTE_SYNTAX.get(String.valueOf(this.configEntryDN), String.valueOf(passwordAttr), String.valueOf(syntax));
                    throw new ConfigException(message5);
                }
                catch (ConfigException ce) {
                    throw ce;
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    Message message6 = CoreMessages.ERR_PWPOLICY_CANNOT_DETERMINE_PASSWORD_ATTRIBUTE.get(String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(e));
                    throw new InitializationException(message6, (Throwable)e);
                }
            }
            SortedSet<String> storageSchemes = configuration.getDefaultPasswordStorageScheme();
            try {
                if (storageSchemes == null) {
                    Message message7 = CoreMessages.ERR_PWPOLICY_NO_DEFAULT_STORAGE_SCHEMES.get(String.valueOf(this.configEntryDN));
                    throw new ConfigException(message7);
                }
                LinkedList<PasswordStorageScheme> schemes = new LinkedList<PasswordStorageScheme>();
                for (String schemeName : storageSchemes) {
                    PasswordStorageScheme scheme = this.authPasswordSyntax ? DirectoryServer.getAuthPasswordStorageScheme(schemeName) : DirectoryServer.getPasswordStorageScheme(StaticUtils.toLowerCase(schemeName));
                    if (scheme == null) {
                        Message message8 = CoreMessages.ERR_PWPOLICY_NO_SUCH_DEFAULT_SCHEME.get(String.valueOf(this.configEntryDN), String.valueOf(schemeName));
                        throw new ConfigException(message8);
                    }
                    schemes.add(scheme);
                }
                this.defaultStorageSchemes = new CopyOnWriteArrayList(schemes);
            }
            catch (ConfigException ce) {
                throw ce;
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message9 = CoreMessages.ERR_PWPOLICY_CANNOT_DETERMINE_DEFAULT_STORAGE_SCHEMES.get(String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(e));
                throw new InitializationException(message9, (Throwable)e);
            }
            SortedSet<String> deprecatedStorageSchemes = configuration.getDeprecatedPasswordStorageScheme();
            try {
                if (deprecatedStorageSchemes != null) {
                    this.deprecatedStorageSchemes = new CopyOnWriteArraySet<String>(deprecatedStorageSchemes);
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message10 = CoreMessages.ERR_PWPOLICY_CANNOT_DETERMINE_DEPRECATED_STORAGE_SCHEMES.get(String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(e));
                throw new InitializationException(message10, (Throwable)e);
            }
            SortedSet<DN> passwordValidators = configuration.getPasswordValidatorDN();
            try {
                if (passwordValidators != null) {
                    ConcurrentHashMap<DN, PasswordValidator<? extends PasswordValidatorCfg>> validators = new ConcurrentHashMap<DN, PasswordValidator<? extends PasswordValidatorCfg>>();
                    for (DN validatorDN : passwordValidators) {
                        PasswordValidator<? extends PasswordValidatorCfg> validator = DirectoryServer.getPasswordValidator(validatorDN);
                        if (validator == null) {
                            Message message11 = CoreMessages.ERR_PWPOLICY_NO_SUCH_VALIDATOR.get(String.valueOf(this.configEntryDN), String.valueOf(validatorDN));
                            throw new ConfigException(message11);
                        }
                        validators.put(validatorDN, validator);
                    }
                    this.passwordValidators = validators;
                }
            }
            catch (ConfigException ce) {
                throw ce;
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message12 = CoreMessages.ERR_PWPOLICY_CANNOT_DETERMINE_PASSWORD_VALIDATORS.get(String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(e));
                throw new InitializationException(message12, (Throwable)e);
            }
            SortedSet<DN> statusNotificationHandlers = configuration.getAccountStatusNotificationHandlerDN();
            try {
                if (statusNotificationHandlers != null) {
                    ConcurrentHashMap<DN, AccountStatusNotificationHandler> handlers = new ConcurrentHashMap<DN, AccountStatusNotificationHandler>();
                    for (DN handlerDN : statusNotificationHandlers) {
                        AccountStatusNotificationHandler handler = DirectoryServer.getAccountStatusNotificationHandler(handlerDN);
                        if (handler == null) {
                            Message message13 = CoreMessages.ERR_PWPOLICY_NO_SUCH_NOTIFICATION_HANDLER.get(String.valueOf(this.configEntryDN), String.valueOf(handlerDN));
                            throw new ConfigException(message13);
                        }
                        handlers.put(handlerDN, handler);
                    }
                    this.notificationHandlers = handlers;
                }
            }
            catch (ConfigException ce) {
                throw ce;
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                message3 = CoreMessages.ERR_PWPOLICY_CANNOT_DETERMINE_NOTIFICATION_HANDLERS.get(String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(e));
                throw new InitializationException(message3, (Throwable)e);
            }
            this.allowUserPasswordChanges = configuration.isAllowUserPasswordChanges();
            this.requireCurrentPassword = configuration.isPasswordChangeRequiresCurrentPassword();
            this.forceChangeOnAdd = configuration.isForceChangeOnAdd();
            this.forceChangeOnReset = configuration.isForceChangeOnReset();
            this.skipValidationForAdministrators = configuration.isSkipValidationForAdministrators();
            DN passGenDN = configuration.getPasswordGeneratorDN();
            try {
                if (passGenDN != null) {
                    PasswordGenerator generator = DirectoryServer.getPasswordGenerator(passGenDN);
                    if (generator == null) {
                        message2 = CoreMessages.ERR_PWPOLICY_NO_SUCH_GENERATOR.get(String.valueOf(this.configEntryDN), String.valueOf(passGenDN));
                        throw new ConfigException(message2);
                    }
                    this.passwordGeneratorDN = passGenDN;
                    this.passwordGenerator = generator;
                }
            }
            catch (ConfigException ce) {
                throw ce;
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                message2 = CoreMessages.ERR_PWPOLICY_CANNOT_DETERMINE_PASSWORD_GENERATOR.get(String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(e));
                throw new InitializationException(message2, (Throwable)e);
            }
            this.requireSecureAuthentication = configuration.isRequireSecureAuthentication();
            this.requireSecurePasswordChanges = configuration.isRequireSecurePasswordChanges();
            this.allowMultiplePasswordValues = configuration.isAllowMultiplePasswordValues();
            this.allowPreEncodedPasswords = configuration.isAllowPreEncodedPasswords();
            this.minimumPasswordAge = (int)configuration.getMinimumPasswordAge();
            this.maximumPasswordAge = (int)configuration.getMaximumPasswordAge();
            this.maximumPasswordResetAge = (int)configuration.getMaximumPasswordResetAge();
            this.warningInterval = (int)configuration.getPasswordExpirationWarningInterval();
            this.expirePasswordsWithoutWarning = configuration.isExpirePasswordsWithoutWarning();
            if (!this.expirePasswordsWithoutWarning() && this.getWarningInterval() <= 0) {
                message3 = CoreMessages.ERR_PWPOLICY_MUST_HAVE_WARNING_IF_NOT_EXPIRE_WITHOUT_WARNING.get(String.valueOf(this.configEntryDN));
                throw new ConfigException(message3);
            }
            this.allowExpiredPasswordChanges = configuration.isAllowExpiredPasswordChanges();
            this.graceLoginCount = configuration.getGraceLoginCount();
            this.lockoutFailureCount = configuration.getLockoutFailureCount();
            this.lockoutDuration = (int)configuration.getLockoutDuration();
            this.lockoutFailureExpirationInterval = (int)configuration.getLockoutFailureExpirationInterval();
            String requireChangeBy = configuration.getRequireChangeByTime();
            try {
                if (requireChangeBy != null) {
                    ByteString valueString = new ASN1OctetString(requireChangeBy);
                    GeneralizedTimeSyntax syntax = (GeneralizedTimeSyntax)DirectoryServer.getAttributeSyntax("1.3.6.1.4.1.1466.115.121.1.24", false);
                    if (syntax == null) {
                        this.requireChangeByTime = GeneralizedTimeSyntax.decodeGeneralizedTimeValue(valueString);
                    } else {
                        valueString = syntax.getEqualityMatchingRule().normalizeValue(valueString);
                        this.requireChangeByTime = GeneralizedTimeSyntax.decodeGeneralizedTimeValue(valueString);
                    }
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message14 = CoreMessages.ERR_PWPOLICY_CANNOT_DETERMINE_REQUIRE_CHANGE_BY_TIME.get(String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(e));
                throw new InitializationException(message14, (Throwable)e);
            }
            String lastLoginTimeAtt = configuration.getLastLoginTimeAttribute();
            try {
                if (lastLoginTimeAtt != null) {
                    String lowerName = StaticUtils.toLowerCase(lastLoginTimeAtt);
                    AttributeType attrType = DirectoryServer.getAttributeType(lowerName);
                    if (attrType == null) {
                        Message message15 = CoreMessages.ERR_PWPOLICY_UNDEFINED_LAST_LOGIN_TIME_ATTRIBUTE.get(String.valueOf(this.configEntryDN), String.valueOf(lastLoginTimeAtt));
                        throw new ConfigException(message15);
                    }
                    this.lastLoginTimeAttribute = attrType;
                }
            }
            catch (ConfigException ce) {
                throw ce;
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message16 = CoreMessages.ERR_PWPOLICY_CANNOT_DETERMINE_LAST_LOGIN_TIME_ATTR.get(String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(e));
                throw new InitializationException(message16, (Throwable)e);
            }
            String formatString = configuration.getLastLoginTimeFormat();
            try {
                if (formatString == null) break block78;
                try {
                    new SimpleDateFormat(formatString);
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    Message message17 = CoreMessages.ERR_PWPOLICY_INVALID_LAST_LOGIN_TIME_FORMAT.get(String.valueOf(this.configEntryDN), String.valueOf(formatString));
                    throw new ConfigException(message17);
                }
                this.lastLoginTimeFormat = formatString;
            }
            catch (ConfigException ce) {
                throw ce;
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message18 = CoreMessages.ERR_PWPOLICY_CANNOT_DETERMINE_LAST_LOGIN_TIME_FORMAT.get(String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(e));
                throw new InitializationException(message18, (Throwable)e);
            }
        }
        SortedSet<String> formatStrings = configuration.getPreviousLastLoginTimeFormat();
        try {
            if (formatStrings != null) {
                for (String s : formatStrings) {
                    try {
                        new SimpleDateFormat(s);
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        Message message19 = CoreMessages.ERR_PWPOLICY_INVALID_PREVIOUS_LAST_LOGIN_TIME_FORMAT.get(String.valueOf(this.configEntryDN), String.valueOf(s));
                        throw new ConfigException(message19);
                    }
                }
                this.previousLastLoginTimeFormats = new CopyOnWriteArrayList<String>(formatStrings);
            }
        }
        catch (ConfigException ce) {
            throw ce;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message20 = CoreMessages.ERR_PWPOLICY_CANNOT_DETERMINE_PREVIOUS_LAST_LOGIN_TIME_FORMAT.get(String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(e));
            throw new InitializationException(message20, (Throwable)e);
        }
        this.idleLockoutInterval = (int)configuration.getIdleLockoutInterval();
        this.stateUpdateFailurePolicy = configuration.getStateUpdateFailurePolicy();
        this.historyCount = configuration.getPasswordHistoryCount();
        this.historyDuration = (int)configuration.getPasswordHistoryDuration();
        if (this.passwordAttribute == null) {
            message = CoreMessages.ERR_PWPOLICY_NO_PASSWORD_ATTRIBUTE.get(String.valueOf(this.configEntryDN));
            throw new ConfigException(message);
        }
        if (this.defaultStorageSchemes.isEmpty()) {
            message = CoreMessages.ERR_PWPOLICY_NO_DEFAULT_STORAGE_SCHEMES.get(String.valueOf(this.configEntryDN));
            throw new ConfigException(message);
        }
        if (this.maximumPasswordAge > 0) {
            Message message21;
            int warnInterval = Math.max(0, this.warningInterval);
            if (this.minimumPasswordAge > 0) {
                if (warnInterval + this.minimumPasswordAge >= this.maximumPasswordAge) {
                    message21 = CoreMessages.ERR_PWPOLICY_MIN_AGE_PLUS_WARNING_GREATER_THAN_MAX_AGE.get(String.valueOf(this.configEntryDN));
                    throw new ConfigException(message21);
                }
            } else if (warnInterval >= this.maximumPasswordAge) {
                message21 = CoreMessages.ERR_PWPOLICY_WARNING_INTERVAL_LARGER_THAN_MAX_AGE.get(String.valueOf(this.configEntryDN));
                throw new ConfigException(message21);
            }
        }
    }

    public DN getConfigEntryDN() {
        return this.configEntryDN;
    }

    public AttributeType getPasswordAttribute() {
        return this.passwordAttribute;
    }

    public boolean usesAuthPasswordSyntax() {
        return this.authPasswordSyntax;
    }

    public CopyOnWriteArrayList<PasswordStorageScheme> getDefaultStorageSchemes() {
        return this.defaultStorageSchemes;
    }

    public boolean isDefaultStorageScheme(String name) {
        CopyOnWriteArrayList<PasswordStorageScheme> defaultSchemes = this.getDefaultStorageSchemes();
        if (defaultSchemes == null) {
            return false;
        }
        for (PasswordStorageScheme s : defaultSchemes) {
            if (!(this.authPasswordSyntax ? s.getAuthPasswordSchemeName().equalsIgnoreCase(name) : s.getStorageSchemeName().equalsIgnoreCase(name))) continue;
            return true;
        }
        return false;
    }

    public CopyOnWriteArraySet<String> getDeprecatedStorageSchemes() {
        return this.deprecatedStorageSchemes;
    }

    public boolean isDeprecatedStorageScheme(String name) {
        CopyOnWriteArraySet<String> deprecatedSchemes = this.getDeprecatedStorageSchemes();
        if (deprecatedSchemes == null) {
            return false;
        }
        for (String s : deprecatedSchemes) {
            if (!s.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public ConcurrentHashMap<DN, PasswordValidator<? extends PasswordValidatorCfg>> getPasswordValidators() {
        return this.passwordValidators;
    }

    public ConcurrentHashMap<DN, AccountStatusNotificationHandler> getAccountStatusNotificationHandlers() {
        return this.notificationHandlers;
    }

    public boolean allowUserPasswordChanges() {
        return this.allowUserPasswordChanges;
    }

    public boolean requireCurrentPassword() {
        return this.requireCurrentPassword;
    }

    public boolean forceChangeOnAdd() {
        return this.forceChangeOnAdd;
    }

    public boolean forceChangeOnReset() {
        return this.forceChangeOnReset;
    }

    public boolean skipValidationForAdministrators() {
        return this.skipValidationForAdministrators;
    }

    public DN getPasswordGeneratorDN() {
        return this.passwordGeneratorDN;
    }

    public PasswordGenerator getPasswordGenerator() {
        return this.passwordGenerator;
    }

    public int getPasswordHistoryCount() {
        return this.historyCount;
    }

    public int getPasswordHistoryDuration() {
        return this.historyDuration;
    }

    public boolean requireSecureAuthentication() {
        return this.requireSecureAuthentication;
    }

    public boolean requireSecurePasswordChanges() {
        return this.requireSecurePasswordChanges;
    }

    public boolean allowMultiplePasswordValues() {
        return this.allowMultiplePasswordValues;
    }

    public boolean allowPreEncodedPasswords() {
        return this.allowPreEncodedPasswords;
    }

    public int getMinimumPasswordAge() {
        if (this.minimumPasswordAge <= 0) {
            return 0;
        }
        return this.minimumPasswordAge;
    }

    public int getMaximumPasswordAge() {
        if (this.maximumPasswordAge < 0) {
            return 0;
        }
        return this.maximumPasswordAge;
    }

    public int getMaximumPasswordResetAge() {
        if (this.maximumPasswordResetAge < 0) {
            return 0;
        }
        return this.maximumPasswordResetAge;
    }

    public int getWarningInterval() {
        if (this.warningInterval < 0) {
            return 0;
        }
        return this.warningInterval;
    }

    public boolean expirePasswordsWithoutWarning() {
        return this.expirePasswordsWithoutWarning;
    }

    public boolean allowExpiredPasswordChanges() {
        return this.allowExpiredPasswordChanges;
    }

    public int getGraceLoginCount() {
        if (this.graceLoginCount < 0) {
            return 0;
        }
        return this.graceLoginCount;
    }

    public int getLockoutFailureCount() {
        if (this.lockoutFailureCount < 0) {
            return 0;
        }
        return this.lockoutFailureCount;
    }

    public int getLockoutDuration() {
        if (this.lockoutDuration < 0) {
            return 0;
        }
        return this.lockoutDuration;
    }

    public int getLockoutFailureExpirationInterval() {
        if (this.lockoutFailureExpirationInterval < 0) {
            return 0;
        }
        return this.lockoutFailureExpirationInterval;
    }

    public long getRequireChangeByTime() {
        if (this.requireChangeByTime < 0L) {
            return 0L;
        }
        return this.requireChangeByTime;
    }

    public AttributeType getLastLoginTimeAttribute() {
        return this.lastLoginTimeAttribute;
    }

    public String getLastLoginTimeFormat() {
        return this.lastLoginTimeFormat;
    }

    public CopyOnWriteArrayList<String> getPreviousLastLoginTimeFormats() {
        return this.previousLastLoginTimeFormats;
    }

    public int getIdleLockoutInterval() {
        if (this.idleLockoutInterval < 0) {
            return 0;
        }
        return this.idleLockoutInterval;
    }

    public PasswordPolicyCfgDefn.StateUpdateFailurePolicy getStateUpdateFailurePolicy() {
        return this.stateUpdateFailurePolicy;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        Iterator<Object> iterator;
        buffer.append("Password Attribute:                    ");
        buffer.append(this.passwordAttribute.getNameOrOID());
        buffer.append(ServerConstants.EOL);
        buffer.append("Default Password Storage Schemes:      ");
        if (this.defaultStorageSchemes == null || this.defaultStorageSchemes.isEmpty()) {
            buffer.append("{none specified}");
            buffer.append(ServerConstants.EOL);
        } else {
            iterator = this.defaultStorageSchemes.iterator();
            buffer.append(iterator.next().getStorageSchemeName());
            buffer.append(ServerConstants.EOL);
            while (iterator.hasNext()) {
                buffer.append("                                       ");
                buffer.append(((PasswordStorageScheme)iterator.next()).getStorageSchemeName());
                buffer.append(ServerConstants.EOL);
            }
        }
        buffer.append("Deprecated Password Storage Schemes:   ");
        if (this.deprecatedStorageSchemes == null || this.deprecatedStorageSchemes.isEmpty()) {
            buffer.append("{none specified}");
            buffer.append(ServerConstants.EOL);
        } else {
            iterator = this.deprecatedStorageSchemes.iterator();
            buffer.append((String)iterator.next());
            buffer.append(ServerConstants.EOL);
            while (iterator.hasNext()) {
                buffer.append("                                       ");
                buffer.append((String)iterator.next());
                buffer.append(ServerConstants.EOL);
            }
        }
        buffer.append("Allow Multiple Password Values:        ");
        buffer.append(this.allowMultiplePasswordValues);
        buffer.append(ServerConstants.EOL);
        buffer.append("Allow Pre-Encoded Passwords:           ");
        buffer.append(this.allowPreEncodedPasswords);
        buffer.append(ServerConstants.EOL);
        buffer.append("Allow User Password Changes:           ");
        buffer.append(this.allowUserPasswordChanges);
        buffer.append(ServerConstants.EOL);
        buffer.append("Force Password Change on Add:          ");
        buffer.append(this.forceChangeOnAdd);
        buffer.append(ServerConstants.EOL);
        buffer.append("Force Password Change on Admin Reset:  ");
        buffer.append(this.forceChangeOnReset);
        buffer.append(ServerConstants.EOL);
        buffer.append("Require Current Password:              ");
        buffer.append(this.requireCurrentPassword);
        buffer.append(ServerConstants.EOL);
        buffer.append("Require Secure Authentication:         ");
        buffer.append(this.requireSecureAuthentication);
        buffer.append(ServerConstants.EOL);
        buffer.append("Require Secure Password Changes:       ");
        buffer.append(this.requireSecurePasswordChanges);
        buffer.append(ServerConstants.EOL);
        buffer.append("Lockout Failure Expiration Interval:   ");
        buffer.append(this.lockoutFailureExpirationInterval);
        buffer.append(" seconds");
        buffer.append(ServerConstants.EOL);
        buffer.append("Password Validators:                   ");
        if (this.passwordValidators == null || this.passwordValidators.isEmpty()) {
            buffer.append("{none specified}");
            buffer.append(ServerConstants.EOL);
        } else {
            iterator = this.passwordValidators.keySet().iterator();
            ((DN)iterator.next()).toString(buffer);
            buffer.append(ServerConstants.EOL);
            while (iterator.hasNext()) {
                buffer.append("                                       ");
                ((DN)iterator.next()).toString(buffer);
                buffer.append(ServerConstants.EOL);
            }
        }
        buffer.append("Skip Validation for Administrators:    ");
        buffer.append(this.skipValidationForAdministrators);
        buffer.append(ServerConstants.EOL);
        buffer.append("Password Generator:                    ");
        if (this.passwordGenerator == null) {
            buffer.append("{none specified}");
        } else {
            this.passwordGeneratorDN.toString(buffer);
        }
        buffer.append(ServerConstants.EOL);
        buffer.append("Account Status Notification Handlers:  ");
        if (this.notificationHandlers == null || this.notificationHandlers.isEmpty()) {
            buffer.append("{none specified}");
            buffer.append(ServerConstants.EOL);
        } else {
            iterator = this.notificationHandlers.keySet().iterator();
            ((DN)iterator.next()).toString(buffer);
            buffer.append(ServerConstants.EOL);
            while (iterator.hasNext()) {
                buffer.append("                                       ");
                ((DN)iterator.next()).toString(buffer);
                buffer.append(ServerConstants.EOL);
            }
        }
        buffer.append("Minimum Password Age:                  ");
        buffer.append(this.minimumPasswordAge);
        buffer.append(" seconds");
        buffer.append(ServerConstants.EOL);
        buffer.append("Maximum Password Age:                  ");
        buffer.append(this.maximumPasswordAge);
        buffer.append(" seconds");
        buffer.append(ServerConstants.EOL);
        buffer.append("Maximum Password Reset Age:            ");
        buffer.append(this.maximumPasswordResetAge);
        buffer.append(" seconds");
        buffer.append(ServerConstants.EOL);
        buffer.append("Expiration Warning Interval:           ");
        buffer.append(this.warningInterval);
        buffer.append(" seconds");
        buffer.append(ServerConstants.EOL);
        buffer.append("Expire Passwords Without Warning:      ");
        buffer.append(this.expirePasswordsWithoutWarning);
        buffer.append(ServerConstants.EOL);
        buffer.append("Allow Expired Password Changes:        ");
        buffer.append(this.allowExpiredPasswordChanges);
        buffer.append(ServerConstants.EOL);
        buffer.append("Grace Login Count:                     ");
        buffer.append(this.graceLoginCount);
        buffer.append(ServerConstants.EOL);
        buffer.append("Lockout Failure Count:                 ");
        buffer.append(this.lockoutFailureCount);
        buffer.append(ServerConstants.EOL);
        buffer.append("Lockout Duration:                      ");
        buffer.append(this.lockoutDuration);
        buffer.append(" seconds");
        buffer.append(ServerConstants.EOL);
        buffer.append("Lockout Count Expiration Interval:     ");
        buffer.append(this.lockoutFailureExpirationInterval);
        buffer.append(" seconds");
        buffer.append(ServerConstants.EOL);
        buffer.append("Required Password Change By Time:      ");
        if (this.requireChangeByTime <= 0L) {
            buffer.append("{none specified}");
        } else {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss.SSS'Z'");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            buffer.append(dateFormat.format(new Date(this.requireChangeByTime)));
        }
        buffer.append(ServerConstants.EOL);
        buffer.append("Last Login Time Attribute:             ");
        if (this.lastLoginTimeAttribute == null) {
            buffer.append("{none specified}");
        } else {
            buffer.append(this.lastLoginTimeAttribute.getNameOrOID());
        }
        buffer.append(ServerConstants.EOL);
        buffer.append("Last Login Time Format:                ");
        if (this.lastLoginTimeFormat == null) {
            buffer.append("{none specified}");
        } else {
            buffer.append(this.lastLoginTimeFormat);
        }
        buffer.append(ServerConstants.EOL);
        buffer.append("Previous Last Login Time Formats:      ");
        if (this.previousLastLoginTimeFormats == null || this.previousLastLoginTimeFormats.isEmpty()) {
            buffer.append("{none specified}");
            buffer.append(ServerConstants.EOL);
        } else {
            iterator = this.previousLastLoginTimeFormats.iterator();
            buffer.append((String)iterator.next());
            buffer.append(ServerConstants.EOL);
            while (iterator.hasNext()) {
                buffer.append("                                       ");
                buffer.append((String)iterator.next());
                buffer.append(ServerConstants.EOL);
            }
        }
        buffer.append("Idle Lockout Interval:                 ");
        buffer.append(this.idleLockoutInterval);
        buffer.append(" seconds");
        buffer.append(ServerConstants.EOL);
        buffer.append("History Count:                         ");
        buffer.append(this.historyCount);
        buffer.append(ServerConstants.EOL);
        buffer.append("Update Failure Policy:                 ");
        buffer.append(this.stateUpdateFailurePolicy.toString());
        buffer.append(ServerConstants.EOL);
    }
}

