/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.PluginMessages;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.PluginCfgDefn;
import org.opends.server.admin.std.server.PluginCfg;
import org.opends.server.admin.std.server.PluginRootCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.plugin.DirectoryServerPlugin;
import org.opends.server.api.plugin.IntermediateResponsePluginResult;
import org.opends.server.api.plugin.LDIFPluginResult;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.api.plugin.PostConnectPluginResult;
import org.opends.server.api.plugin.PostDisconnectPluginResult;
import org.opends.server.api.plugin.PostOperationPluginResult;
import org.opends.server.api.plugin.PostResponsePluginResult;
import org.opends.server.api.plugin.PreOperationPluginResult;
import org.opends.server.api.plugin.PreParsePluginResult;
import org.opends.server.api.plugin.SearchEntryPluginResult;
import org.opends.server.api.plugin.SearchReferencePluginResult;
import org.opends.server.api.plugin.StartupPluginResult;
import org.opends.server.api.plugin.SubordinateModifyDNPluginResult;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.IntermediateResponse;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.Modification;
import org.opends.server.types.Operation;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;
import org.opends.server.types.operation.PostOperationAbandonOperation;
import org.opends.server.types.operation.PostOperationAddOperation;
import org.opends.server.types.operation.PostOperationBindOperation;
import org.opends.server.types.operation.PostOperationCompareOperation;
import org.opends.server.types.operation.PostOperationDeleteOperation;
import org.opends.server.types.operation.PostOperationExtendedOperation;
import org.opends.server.types.operation.PostOperationModifyDNOperation;
import org.opends.server.types.operation.PostOperationModifyOperation;
import org.opends.server.types.operation.PostOperationSearchOperation;
import org.opends.server.types.operation.PostOperationUnbindOperation;
import org.opends.server.types.operation.PostResponseAddOperation;
import org.opends.server.types.operation.PostResponseBindOperation;
import org.opends.server.types.operation.PostResponseCompareOperation;
import org.opends.server.types.operation.PostResponseDeleteOperation;
import org.opends.server.types.operation.PostResponseExtendedOperation;
import org.opends.server.types.operation.PostResponseModifyDNOperation;
import org.opends.server.types.operation.PostResponseModifyOperation;
import org.opends.server.types.operation.PostResponseSearchOperation;
import org.opends.server.types.operation.PreOperationAddOperation;
import org.opends.server.types.operation.PreOperationBindOperation;
import org.opends.server.types.operation.PreOperationCompareOperation;
import org.opends.server.types.operation.PreOperationDeleteOperation;
import org.opends.server.types.operation.PreOperationExtendedOperation;
import org.opends.server.types.operation.PreOperationModifyDNOperation;
import org.opends.server.types.operation.PreOperationModifyOperation;
import org.opends.server.types.operation.PreOperationSearchOperation;
import org.opends.server.types.operation.PreParseAbandonOperation;
import org.opends.server.types.operation.PreParseAddOperation;
import org.opends.server.types.operation.PreParseBindOperation;
import org.opends.server.types.operation.PreParseCompareOperation;
import org.opends.server.types.operation.PreParseDeleteOperation;
import org.opends.server.types.operation.PreParseExtendedOperation;
import org.opends.server.types.operation.PreParseModifyDNOperation;
import org.opends.server.types.operation.PreParseModifyOperation;
import org.opends.server.types.operation.PreParseSearchOperation;
import org.opends.server.types.operation.PreParseUnbindOperation;
import org.opends.server.types.operation.SearchEntrySearchOperation;
import org.opends.server.types.operation.SearchReferenceSearchOperation;
import org.opends.server.types.operation.SubordinateModifyDNOperation;
import org.opends.server.util.StaticUtils;
import org.opends.server.workflowelement.localbackend.LocalBackendSearchOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginConfigManager
implements ConfigurationAddListener<PluginCfg>,
ConfigurationDeleteListener<PluginCfg>,
ConfigurationChangeListener<PluginCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DirectoryServerPlugin[] startupPlugins;
    private DirectoryServerPlugin[] shutdownPlugins;
    private DirectoryServerPlugin[] postConnectPlugins;
    private DirectoryServerPlugin[] postDisconnectPlugins;
    private DirectoryServerPlugin[] ldifImportPlugins;
    private DirectoryServerPlugin[] ldifExportPlugins;
    private DirectoryServerPlugin[] preParseAbandonPlugins;
    private DirectoryServerPlugin[] preParseAddPlugins;
    private DirectoryServerPlugin[] preParseBindPlugins;
    private DirectoryServerPlugin[] preParseComparePlugins;
    private DirectoryServerPlugin[] preParseDeletePlugins;
    private DirectoryServerPlugin[] preParseExtendedPlugins;
    private DirectoryServerPlugin[] preParseModifyPlugins;
    private DirectoryServerPlugin[] preParseModifyDNPlugins;
    private DirectoryServerPlugin[] preParseSearchPlugins;
    private DirectoryServerPlugin[] preParseUnbindPlugins;
    private DirectoryServerPlugin[] preOperationAddPlugins;
    private DirectoryServerPlugin[] preOperationBindPlugins;
    private DirectoryServerPlugin[] preOperationComparePlugins;
    private DirectoryServerPlugin[] preOperationDeletePlugins;
    private DirectoryServerPlugin[] preOperationExtendedPlugins;
    private DirectoryServerPlugin[] preOperationModifyPlugins;
    private DirectoryServerPlugin[] preOperationModifyDNPlugins;
    private DirectoryServerPlugin[] preOperationSearchPlugins;
    private DirectoryServerPlugin[] postOperationAbandonPlugins;
    private DirectoryServerPlugin[] postOperationAddPlugins;
    private DirectoryServerPlugin[] postOperationBindPlugins;
    private DirectoryServerPlugin[] postOperationComparePlugins;
    private DirectoryServerPlugin[] postOperationDeletePlugins;
    private DirectoryServerPlugin[] postOperationExtendedPlugins;
    private DirectoryServerPlugin[] postOperationModifyPlugins;
    private DirectoryServerPlugin[] postOperationModifyDNPlugins;
    private DirectoryServerPlugin[] postOperationSearchPlugins;
    private DirectoryServerPlugin[] postOperationUnbindPlugins;
    private DirectoryServerPlugin[] postResponseAddPlugins;
    private DirectoryServerPlugin[] postResponseBindPlugins;
    private DirectoryServerPlugin[] postResponseComparePlugins;
    private DirectoryServerPlugin[] postResponseDeletePlugins;
    private DirectoryServerPlugin[] postResponseExtendedPlugins;
    private DirectoryServerPlugin[] postResponseModifyPlugins;
    private DirectoryServerPlugin[] postResponseModifyDNPlugins;
    private DirectoryServerPlugin[] postResponseSearchPlugins;
    private DirectoryServerPlugin[] searchResultEntryPlugins;
    private DirectoryServerPlugin[] searchResultReferencePlugins;
    private DirectoryServerPlugin[] subordinateModifyDNPlugins;
    private DirectoryServerPlugin[] intermediateResponsePlugins;
    private ConcurrentHashMap<DN, DirectoryServerPlugin<? extends PluginCfg>> registeredPlugins;
    private PluginRootCfg pluginRootConfig;
    private ReentrantLock pluginLock = new ReentrantLock();

    public PluginConfigManager() {
        this.startupPlugins = new DirectoryServerPlugin[0];
        this.shutdownPlugins = new DirectoryServerPlugin[0];
        this.postConnectPlugins = new DirectoryServerPlugin[0];
        this.postDisconnectPlugins = new DirectoryServerPlugin[0];
        this.ldifImportPlugins = new DirectoryServerPlugin[0];
        this.ldifExportPlugins = new DirectoryServerPlugin[0];
        this.preParseAbandonPlugins = new DirectoryServerPlugin[0];
        this.preParseAddPlugins = new DirectoryServerPlugin[0];
        this.preParseBindPlugins = new DirectoryServerPlugin[0];
        this.preParseComparePlugins = new DirectoryServerPlugin[0];
        this.preParseDeletePlugins = new DirectoryServerPlugin[0];
        this.preParseExtendedPlugins = new DirectoryServerPlugin[0];
        this.preParseModifyPlugins = new DirectoryServerPlugin[0];
        this.preParseModifyDNPlugins = new DirectoryServerPlugin[0];
        this.preParseSearchPlugins = new DirectoryServerPlugin[0];
        this.preParseUnbindPlugins = new DirectoryServerPlugin[0];
        this.preOperationAddPlugins = new DirectoryServerPlugin[0];
        this.preOperationBindPlugins = new DirectoryServerPlugin[0];
        this.preOperationComparePlugins = new DirectoryServerPlugin[0];
        this.preOperationDeletePlugins = new DirectoryServerPlugin[0];
        this.preOperationExtendedPlugins = new DirectoryServerPlugin[0];
        this.preOperationModifyPlugins = new DirectoryServerPlugin[0];
        this.preOperationModifyDNPlugins = new DirectoryServerPlugin[0];
        this.preOperationSearchPlugins = new DirectoryServerPlugin[0];
        this.postOperationAbandonPlugins = new DirectoryServerPlugin[0];
        this.postOperationAddPlugins = new DirectoryServerPlugin[0];
        this.postOperationBindPlugins = new DirectoryServerPlugin[0];
        this.postOperationComparePlugins = new DirectoryServerPlugin[0];
        this.postOperationDeletePlugins = new DirectoryServerPlugin[0];
        this.postOperationExtendedPlugins = new DirectoryServerPlugin[0];
        this.postOperationModifyPlugins = new DirectoryServerPlugin[0];
        this.postOperationModifyDNPlugins = new DirectoryServerPlugin[0];
        this.postOperationSearchPlugins = new DirectoryServerPlugin[0];
        this.postOperationUnbindPlugins = new DirectoryServerPlugin[0];
        this.postResponseAddPlugins = new DirectoryServerPlugin[0];
        this.postResponseBindPlugins = new DirectoryServerPlugin[0];
        this.postResponseComparePlugins = new DirectoryServerPlugin[0];
        this.postResponseDeletePlugins = new DirectoryServerPlugin[0];
        this.postResponseExtendedPlugins = new DirectoryServerPlugin[0];
        this.postResponseModifyPlugins = new DirectoryServerPlugin[0];
        this.postResponseModifyDNPlugins = new DirectoryServerPlugin[0];
        this.postResponseSearchPlugins = new DirectoryServerPlugin[0];
        this.searchResultEntryPlugins = new DirectoryServerPlugin[0];
        this.searchResultReferencePlugins = new DirectoryServerPlugin[0];
        this.subordinateModifyDNPlugins = new DirectoryServerPlugin[0];
        this.intermediateResponsePlugins = new DirectoryServerPlugin[0];
        this.registeredPlugins = new ConcurrentHashMap();
    }

    public void initializePluginConfig(Set<PluginType> pluginTypes) throws ConfigException, InitializationException {
        this.registeredPlugins.clear();
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        this.pluginRootConfig = rootConfiguration.getPluginRoot();
        this.pluginRootConfig.addPluginAddListener(this);
        this.pluginRootConfig.addPluginDeleteListener(this);
        for (String pluginName : this.pluginRootConfig.listPlugins()) {
            PluginCfg pluginConfiguration = this.pluginRootConfig.getPlugin(pluginName);
            pluginConfiguration.addChangeListener(this);
            if (!pluginConfiguration.isEnabled()) continue;
            HashSet<PluginType> initTypes = new HashSet<PluginType>();
            for (PluginCfgDefn.PluginType pluginType : pluginConfiguration.getPluginType()) {
                PluginType t = this.getPluginType(pluginType);
                if (pluginTypes != null && !pluginTypes.contains((Object)t)) continue;
                initTypes.add(t);
            }
            if (initTypes.isEmpty()) continue;
            try {
                DirectoryServerPlugin<? extends PluginCfg> plugin = this.loadPlugin(pluginConfiguration.getPluginClass(), initTypes, pluginConfiguration, true);
                this.registerPlugin(plugin, pluginConfiguration.dn(), initTypes);
            }
            catch (InitializationException ie) {
                ErrorLogger.logError(ie.getMessageObject());
            }
        }
    }

    private DirectoryServerPlugin<? extends PluginCfg> loadPlugin(String className, Set<PluginType> pluginTypes, PluginCfg configuration, boolean initialize) throws InitializationException {
        try {
            PluginCfgDefn definition = PluginCfgDefn.getInstance();
            ClassPropertyDefinition propertyDefinition = definition.getPluginClassPropertyDefinition();
            Class<DirectoryServerPlugin> pluginClass = propertyDefinition.loadClass(className, DirectoryServerPlugin.class);
            DirectoryServerPlugin plugin = pluginClass.newInstance();
            if (initialize) {
                Method method = plugin.getClass().getMethod("initializeInternal", DN.class, Set.class);
                method.invoke((Object)plugin, configuration.dn(), pluginTypes);
                method = plugin.getClass().getMethod("initializePlugin", Set.class, configuration.definition().getServerConfigurationClass());
                method.invoke((Object)plugin, pluginTypes, configuration);
            } else {
                Method method = plugin.getClass().getMethod("isConfigurationAcceptable", PluginCfg.class, List.class);
                ArrayList unacceptableReasons = new ArrayList();
                Boolean acceptable = (Boolean)method.invoke((Object)plugin, configuration, unacceptableReasons);
                if (!acceptable.booleanValue()) {
                    MessageBuilder buffer = new MessageBuilder();
                    if (!unacceptableReasons.isEmpty()) {
                        Iterator iterator = unacceptableReasons.iterator();
                        buffer.append((Message)iterator.next());
                        while (iterator.hasNext()) {
                            buffer.append(".  ");
                            buffer.append((Message)iterator.next());
                        }
                    }
                    Message message = ConfigMessages.ERR_CONFIG_PLUGIN_CONFIG_NOT_ACCEPTABLE.get(String.valueOf(configuration.dn()), buffer.toString());
                    throw new InitializationException(message);
                }
            }
            return plugin;
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_PLUGIN_CANNOT_INITIALIZE.get(className, String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message, (Throwable)e);
        }
    }

    private PluginType getPluginType(PluginCfgDefn.PluginType configPluginType) {
        switch (configPluginType) {
            case STARTUP: {
                return PluginType.STARTUP;
            }
            case SHUTDOWN: {
                return PluginType.SHUTDOWN;
            }
            case POSTCONNECT: {
                return PluginType.POST_CONNECT;
            }
            case POSTDISCONNECT: {
                return PluginType.POST_DISCONNECT;
            }
            case LDIFIMPORT: {
                return PluginType.LDIF_IMPORT;
            }
            case LDIFEXPORT: {
                return PluginType.LDIF_EXPORT;
            }
            case PREPARSEABANDON: {
                return PluginType.PRE_PARSE_ABANDON;
            }
            case PREPARSEADD: {
                return PluginType.PRE_PARSE_ADD;
            }
            case PREPARSEBIND: {
                return PluginType.PRE_PARSE_BIND;
            }
            case PREPARSECOMPARE: {
                return PluginType.PRE_PARSE_COMPARE;
            }
            case PREPARSEDELETE: {
                return PluginType.PRE_PARSE_DELETE;
            }
            case PREPARSEEXTENDED: {
                return PluginType.PRE_PARSE_EXTENDED;
            }
            case PREPARSEMODIFY: {
                return PluginType.PRE_PARSE_MODIFY;
            }
            case PREPARSEMODIFYDN: {
                return PluginType.PRE_PARSE_MODIFY_DN;
            }
            case PREPARSESEARCH: {
                return PluginType.PRE_PARSE_SEARCH;
            }
            case PREPARSEUNBIND: {
                return PluginType.PRE_PARSE_UNBIND;
            }
            case PREOPERATIONADD: {
                return PluginType.PRE_OPERATION_ADD;
            }
            case PREOPERATIONBIND: {
                return PluginType.PRE_OPERATION_BIND;
            }
            case PREOPERATIONCOMPARE: {
                return PluginType.PRE_OPERATION_COMPARE;
            }
            case PREOPERATIONDELETE: {
                return PluginType.PRE_OPERATION_DELETE;
            }
            case PREOPERATIONEXTENDED: {
                return PluginType.PRE_OPERATION_EXTENDED;
            }
            case PREOPERATIONMODIFY: {
                return PluginType.PRE_OPERATION_MODIFY;
            }
            case PREOPERATIONMODIFYDN: {
                return PluginType.PRE_OPERATION_MODIFY_DN;
            }
            case PREOPERATIONSEARCH: {
                return PluginType.PRE_OPERATION_SEARCH;
            }
            case POSTOPERATIONABANDON: {
                return PluginType.POST_OPERATION_ABANDON;
            }
            case POSTOPERATIONADD: {
                return PluginType.POST_OPERATION_ADD;
            }
            case POSTOPERATIONBIND: {
                return PluginType.POST_OPERATION_BIND;
            }
            case POSTOPERATIONCOMPARE: {
                return PluginType.POST_OPERATION_COMPARE;
            }
            case POSTOPERATIONDELETE: {
                return PluginType.POST_OPERATION_DELETE;
            }
            case POSTOPERATIONEXTENDED: {
                return PluginType.POST_OPERATION_EXTENDED;
            }
            case POSTOPERATIONMODIFY: {
                return PluginType.POST_OPERATION_MODIFY;
            }
            case POSTOPERATIONMODIFYDN: {
                return PluginType.POST_OPERATION_MODIFY_DN;
            }
            case POSTOPERATIONSEARCH: {
                return PluginType.POST_OPERATION_SEARCH;
            }
            case POSTOPERATIONUNBIND: {
                return PluginType.POST_OPERATION_UNBIND;
            }
            case POSTRESPONSEADD: {
                return PluginType.POST_RESPONSE_ADD;
            }
            case POSTRESPONSEBIND: {
                return PluginType.POST_RESPONSE_BIND;
            }
            case POSTRESPONSECOMPARE: {
                return PluginType.POST_RESPONSE_COMPARE;
            }
            case POSTRESPONSEDELETE: {
                return PluginType.POST_RESPONSE_DELETE;
            }
            case POSTRESPONSEEXTENDED: {
                return PluginType.POST_RESPONSE_EXTENDED;
            }
            case POSTRESPONSEMODIFY: {
                return PluginType.POST_RESPONSE_MODIFY;
            }
            case POSTRESPONSEMODIFYDN: {
                return PluginType.POST_RESPONSE_MODIFY_DN;
            }
            case POSTRESPONSESEARCH: {
                return PluginType.POST_RESPONSE_SEARCH;
            }
            case SEARCHRESULTENTRY: {
                return PluginType.SEARCH_RESULT_ENTRY;
            }
            case SEARCHRESULTREFERENCE: {
                return PluginType.SEARCH_RESULT_REFERENCE;
            }
            case SUBORDINATEMODIFYDN: {
                return PluginType.SUBORDINATE_MODIFY_DN;
            }
            case INTERMEDIATERESPONSE: {
                return PluginType.INTERMEDIATE_RESPONSE;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalizePlugins() {
        this.pluginLock.lock();
        try {
            Iterator<DirectoryServerPlugin<? extends PluginCfg>> iterator = this.registeredPlugins.values().iterator();
            while (iterator.hasNext()) {
                try {
                    iterator.next().finalizePlugin();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            this.registeredPlugins.clear();
        }
        finally {
            this.pluginLock.unlock();
        }
    }

    public ConcurrentHashMap<DN, DirectoryServerPlugin<? extends PluginCfg>> getRegisteredPlugins() {
        return this.registeredPlugins;
    }

    public DirectoryServerPlugin getRegisteredPlugin(DN pluginDN) {
        return this.registeredPlugins.get(pluginDN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerPlugin(DirectoryServerPlugin<? extends PluginCfg> plugin, DN pluginEntryDN, Set<PluginType> pluginTypes) {
        this.pluginLock.lock();
        try {
            this.registeredPlugins.put(pluginEntryDN, plugin);
            for (PluginType t : pluginTypes) {
                switch (t) {
                    case STARTUP: {
                        this.startupPlugins = PluginConfigManager.addPlugin(this.startupPlugins, plugin, t, this.pluginRootConfig.getPluginOrderStartup());
                        break;
                    }
                    case SHUTDOWN: {
                        this.shutdownPlugins = PluginConfigManager.addPlugin(this.shutdownPlugins, plugin, t, this.pluginRootConfig.getPluginOrderShutdown());
                        break;
                    }
                    case POST_CONNECT: {
                        this.postConnectPlugins = PluginConfigManager.addPlugin(this.postConnectPlugins, plugin, t, this.pluginRootConfig.getPluginOrderPostConnect());
                        break;
                    }
                    case POST_DISCONNECT: {
                        this.postDisconnectPlugins = PluginConfigManager.addPlugin(this.postDisconnectPlugins, plugin, t, this.pluginRootConfig.getPluginOrderPostDisconnect());
                        break;
                    }
                    case LDIF_IMPORT: {
                        this.ldifImportPlugins = PluginConfigManager.addPlugin(this.ldifImportPlugins, plugin, t, this.pluginRootConfig.getPluginOrderLDIFImport());
                        break;
                    }
                    case LDIF_EXPORT: {
                        this.ldifExportPlugins = PluginConfigManager.addPlugin(this.ldifExportPlugins, plugin, t, this.pluginRootConfig.getPluginOrderLDIFExport());
                        break;
                    }
                    case PRE_PARSE_ABANDON: {
                        this.preParseAbandonPlugins = PluginConfigManager.addPlugin(this.preParseAbandonPlugins, plugin, t, this.pluginRootConfig.getPluginOrderPreParseAbandon());
                        break;
                    }
                    case PRE_PARSE_ADD: {
                        this.preParseAddPlugins = PluginConfigManager.addPlugin(this.preParseAddPlugins, plugin, t, this.pluginRootConfig.getPluginOrderPreParseAdd());
                        break;
                    }
                    case PRE_PARSE_BIND: {
                        this.preParseBindPlugins = PluginConfigManager.addPlugin(this.preParseBindPlugins, plugin, t, this.pluginRootConfig.getPluginOrderPreParseBind());
                        break;
                    }
                    case PRE_PARSE_COMPARE: {
                        this.preParseComparePlugins = PluginConfigManager.addPlugin(this.preParseComparePlugins, plugin, t, this.pluginRootConfig.getPluginOrderPreParseCompare());
                        break;
                    }
                    case PRE_PARSE_DELETE: {
                        this.preParseDeletePlugins = PluginConfigManager.addPlugin(this.preParseDeletePlugins, plugin, t, this.pluginRootConfig.getPluginOrderPreParseDelete());
                        break;
                    }
                    case PRE_PARSE_EXTENDED: {
                        this.preParseExtendedPlugins = PluginConfigManager.addPlugin(this.preParseExtendedPlugins, plugin, t, this.pluginRootConfig.getPluginOrderPreParseExtended());
                        break;
                    }
                    case PRE_PARSE_MODIFY: {
                        this.preParseModifyPlugins = PluginConfigManager.addPlugin(this.preParseModifyPlugins, plugin, t, this.pluginRootConfig.getPluginOrderPreParseModify());
                        break;
                    }
                    case PRE_PARSE_MODIFY_DN: {
                        this.preParseModifyDNPlugins = PluginConfigManager.addPlugin(this.preParseModifyDNPlugins, plugin, t, this.pluginRootConfig.getPluginOrderPreParseModifyDN());
                        break;
                    }
                    case PRE_PARSE_SEARCH: {
                        this.preParseSearchPlugins = PluginConfigManager.addPlugin(this.preParseSearchPlugins, plugin, t, this.pluginRootConfig.getPluginOrderPreParseSearch());
                        break;
                    }
                    case PRE_PARSE_UNBIND: {
                        this.preParseUnbindPlugins = PluginConfigManager.addPlugin(this.preParseUnbindPlugins, plugin, t, this.pluginRootConfig.getPluginOrderPreParseUnbind());
                        break;
                    }
                    case PRE_OPERATION_ADD: {
                        this.preOperationAddPlugins = PluginConfigManager.addPlugin(this.preOperationAddPlugins, plugin, t, this.pluginRootConfig.getPluginOrderPreOperationAdd());
                        break;
                    }
                    case PRE_OPERATION_BIND: {
                        this.preOperationBindPlugins = PluginConfigManager.addPlugin(this.preOperationBindPlugins, plugin, t, this.pluginRootConfig.getPluginOrderPreOperationBind());
                        break;
                    }
                    case PRE_OPERATION_COMPARE: {
                        this.preOperationComparePlugins = PluginConfigManager.addPlugin(this.preOperationComparePlugins, plugin, t, this.pluginRootConfig.getPluginOrderPreOperationCompare());
                        break;
                    }
                    case PRE_OPERATION_DELETE: {
                        this.preOperationDeletePlugins = PluginConfigManager.addPlugin(this.preOperationDeletePlugins, plugin, t, this.pluginRootConfig.getPluginOrderPreOperationDelete());
                        break;
                    }
                    case PRE_OPERATION_EXTENDED: {
                        this.preOperationExtendedPlugins = PluginConfigManager.addPlugin(this.preOperationExtendedPlugins, plugin, t, this.pluginRootConfig.getPluginOrderPreOperationExtended());
                        break;
                    }
                    case PRE_OPERATION_MODIFY: {
                        this.preOperationModifyPlugins = PluginConfigManager.addPlugin(this.preOperationModifyPlugins, plugin, t, this.pluginRootConfig.getPluginOrderPreOperationModify());
                        break;
                    }
                    case PRE_OPERATION_MODIFY_DN: {
                        this.preOperationModifyDNPlugins = PluginConfigManager.addPlugin(this.preOperationModifyDNPlugins, plugin, t, this.pluginRootConfig.getPluginOrderPreOperationModifyDN());
                        break;
                    }
                    case PRE_OPERATION_SEARCH: {
                        this.preOperationSearchPlugins = PluginConfigManager.addPlugin(this.preOperationSearchPlugins, plugin, t, this.pluginRootConfig.getPluginOrderPreOperationSearch());
                        break;
                    }
                    case POST_OPERATION_ABANDON: {
                        this.postOperationAbandonPlugins = PluginConfigManager.addPlugin(this.postOperationAbandonPlugins, plugin, t, this.pluginRootConfig.getPluginOrderPostOperationAbandon());
                        break;
                    }
                    case POST_OPERATION_ADD: {
                        this.postOperationAddPlugins = PluginConfigManager.addPlugin(this.postOperationAddPlugins, plugin, t, this.pluginRootConfig.getPluginOrderPostOperationAdd());
                        break;
                    }
                    case POST_OPERATION_BIND: {
                        this.postOperationBindPlugins = PluginConfigManager.addPlugin(this.postOperationBindPlugins, plugin, t, this.pluginRootConfig.getPluginOrderPostOperationBind());
                        break;
                    }
                    case POST_OPERATION_COMPARE: {
                        this.postOperationComparePlugins = PluginConfigManager.addPlugin(this.postOperationComparePlugins, plugin, t, this.pluginRootConfig.getPluginOrderPostOperationCompare());
                        break;
                    }
                    case POST_OPERATION_DELETE: {
                        this.postOperationDeletePlugins = PluginConfigManager.addPlugin(this.postOperationDeletePlugins, plugin, t, this.pluginRootConfig.getPluginOrderPostOperationDelete());
                        break;
                    }
                    case POST_OPERATION_EXTENDED: {
                        this.postOperationExtendedPlugins = PluginConfigManager.addPlugin(this.postOperationExtendedPlugins, plugin, t, this.pluginRootConfig.getPluginOrderPostOperationExtended());
                        break;
                    }
                    case POST_OPERATION_MODIFY: {
                        this.postOperationModifyPlugins = PluginConfigManager.addPlugin(this.postOperationModifyPlugins, plugin, t, this.pluginRootConfig.getPluginOrderPostOperationModify());
                        break;
                    }
                    case POST_OPERATION_MODIFY_DN: {
                        this.postOperationModifyDNPlugins = PluginConfigManager.addPlugin(this.postOperationModifyDNPlugins, plugin, t, this.pluginRootConfig.getPluginOrderPostOperationModifyDN());
                        break;
                    }
                    case POST_OPERATION_SEARCH: {
                        this.postOperationSearchPlugins = PluginConfigManager.addPlugin(this.postOperationSearchPlugins, plugin, t, this.pluginRootConfig.getPluginOrderPostOperationSearch());
                        break;
                    }
                    case POST_OPERATION_UNBIND: {
                        this.postOperationUnbindPlugins = PluginConfigManager.addPlugin(this.postOperationUnbindPlugins, plugin, t, this.pluginRootConfig.getPluginOrderPostOperationUnbind());
                        break;
                    }
                    case POST_RESPONSE_ADD: {
                        this.postResponseAddPlugins = PluginConfigManager.addPlugin(this.postResponseAddPlugins, plugin, t, this.pluginRootConfig.getPluginOrderPostResponseAdd());
                        break;
                    }
                    case POST_RESPONSE_BIND: {
                        this.postResponseBindPlugins = PluginConfigManager.addPlugin(this.postResponseBindPlugins, plugin, t, this.pluginRootConfig.getPluginOrderPostResponseBind());
                        break;
                    }
                    case POST_RESPONSE_COMPARE: {
                        this.postResponseComparePlugins = PluginConfigManager.addPlugin(this.postResponseComparePlugins, plugin, t, this.pluginRootConfig.getPluginOrderPostResponseCompare());
                        break;
                    }
                    case POST_RESPONSE_DELETE: {
                        this.postResponseDeletePlugins = PluginConfigManager.addPlugin(this.postResponseDeletePlugins, plugin, t, this.pluginRootConfig.getPluginOrderPostResponseDelete());
                        break;
                    }
                    case POST_RESPONSE_EXTENDED: {
                        this.postResponseExtendedPlugins = PluginConfigManager.addPlugin(this.postResponseExtendedPlugins, plugin, t, this.pluginRootConfig.getPluginOrderPostResponseExtended());
                        break;
                    }
                    case POST_RESPONSE_MODIFY: {
                        this.postResponseModifyPlugins = PluginConfigManager.addPlugin(this.postResponseModifyPlugins, plugin, t, this.pluginRootConfig.getPluginOrderPostResponseModify());
                        break;
                    }
                    case POST_RESPONSE_MODIFY_DN: {
                        this.postResponseModifyDNPlugins = PluginConfigManager.addPlugin(this.postResponseModifyDNPlugins, plugin, t, this.pluginRootConfig.getPluginOrderPostResponseModifyDN());
                        break;
                    }
                    case POST_RESPONSE_SEARCH: {
                        this.postResponseSearchPlugins = PluginConfigManager.addPlugin(this.postResponseSearchPlugins, plugin, t, this.pluginRootConfig.getPluginOrderPostResponseSearch());
                        break;
                    }
                    case SEARCH_RESULT_ENTRY: {
                        this.searchResultEntryPlugins = PluginConfigManager.addPlugin(this.searchResultEntryPlugins, plugin, t, this.pluginRootConfig.getPluginOrderSearchResultEntry());
                        break;
                    }
                    case SEARCH_RESULT_REFERENCE: {
                        this.searchResultReferencePlugins = PluginConfigManager.addPlugin(this.searchResultReferencePlugins, plugin, t, this.pluginRootConfig.getPluginOrderSearchResultReference());
                        break;
                    }
                    case SUBORDINATE_MODIFY_DN: {
                        this.subordinateModifyDNPlugins = PluginConfigManager.addPlugin(this.subordinateModifyDNPlugins, plugin, t, this.pluginRootConfig.getPluginOrderSubordinateModifyDN());
                        break;
                    }
                    case INTERMEDIATE_RESPONSE: {
                        this.intermediateResponsePlugins = PluginConfigManager.addPlugin(this.intermediateResponsePlugins, plugin, t, this.pluginRootConfig.getPluginOrderIntermediateResponse());
                        break;
                    }
                }
            }
        }
        finally {
            this.pluginLock.unlock();
        }
    }

    static DirectoryServerPlugin[] addPlugin(DirectoryServerPlugin[] pluginArray, DirectoryServerPlugin plugin, PluginType pluginType, String pluginOrder) {
        DirectoryServerPlugin p;
        if (pluginOrder == null || (pluginOrder = pluginOrder.trim()).length() == 0 || pluginOrder.equals("*")) {
            DirectoryServerPlugin[] newPlugins = new DirectoryServerPlugin[pluginArray.length + 1];
            System.arraycopy(pluginArray, 0, newPlugins, 0, pluginArray.length);
            newPlugins[pluginArray.length] = plugin;
            return newPlugins;
        }
        boolean starFound = false;
        LinkedHashSet<String> initialPluginNames = new LinkedHashSet<String>();
        LinkedHashSet<String> finalPluginNames = new LinkedHashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(pluginOrder, ",");
        while (tokenizer.hasMoreTokens()) {
            Message message;
            Message message2;
            String token = tokenizer.nextToken().trim();
            if (token.length() == 0) {
                if (pluginArray.length != 0) continue;
                message2 = ConfigMessages.WARN_CONFIG_PLUGIN_EMPTY_ELEMENT_IN_ORDER.get(pluginType.getName());
                ErrorLogger.logError(message2);
                continue;
            }
            if (token.equals("*")) {
                if (starFound) {
                    if (pluginArray.length != 0) continue;
                    message2 = ConfigMessages.WARN_CONFIG_PLUGIN_MULTIPLE_WILDCARDS_IN_ORDER.get(pluginType.getName());
                    ErrorLogger.logError(message2);
                    continue;
                }
                starFound = true;
                continue;
            }
            String lowerName = StaticUtils.toLowerCase(token);
            if (starFound) {
                if ((initialPluginNames.contains(lowerName) || finalPluginNames.contains(lowerName)) && pluginArray.length == 0) {
                    message = ConfigMessages.WARN_CONFIG_PLUGIN_LISTED_MULTIPLE_TIMES.get(pluginType.getName(), token);
                    ErrorLogger.logError(message);
                }
                finalPluginNames.add(lowerName);
                continue;
            }
            if (initialPluginNames.contains(lowerName) && pluginArray.length == 0) {
                message = ConfigMessages.WARN_CONFIG_PLUGIN_LISTED_MULTIPLE_TIMES.get(pluginType.getName(), token);
                ErrorLogger.logError(message);
            }
            initialPluginNames.add(lowerName);
        }
        if (!starFound && pluginArray.length == 0) {
            Message message = ConfigMessages.WARN_CONFIG_PLUGIN_ORDER_NO_WILDCARD.get(pluginType.getName());
            ErrorLogger.logError(message);
        }
        HashMap<String, DirectoryServerPlugin> initialPlugins = new HashMap<String, DirectoryServerPlugin>(initialPluginNames.size());
        HashMap<String, DirectoryServerPlugin> finalPlugins = new HashMap<String, DirectoryServerPlugin>(finalPluginNames.size());
        ArrayList<DirectoryServerPlugin> otherPlugins = new ArrayList<DirectoryServerPlugin>();
        for (DirectoryServerPlugin p2 : pluginArray) {
            DN dn = p2.getPluginEntryDN();
            String lowerName = StaticUtils.toLowerCase(dn.getRDN().getAttributeValue(0).getStringValue());
            if (initialPluginNames.contains(lowerName)) {
                initialPlugins.put(lowerName, p2);
                continue;
            }
            if (finalPluginNames.contains(lowerName)) {
                finalPlugins.put(lowerName, p2);
                continue;
            }
            otherPlugins.add(p2);
        }
        DN dn = plugin.getPluginEntryDN();
        String lowerName = StaticUtils.toLowerCase(dn.getRDN().getAttributeValue(0).getStringValue());
        if (initialPluginNames.contains(lowerName)) {
            initialPlugins.put(lowerName, plugin);
        } else if (finalPluginNames.contains(lowerName)) {
            finalPlugins.put(lowerName, plugin);
        } else {
            otherPlugins.add(plugin);
        }
        ArrayList<DirectoryServerPlugin> newList = new ArrayList<DirectoryServerPlugin>(pluginArray.length + 1);
        for (String name : initialPluginNames) {
            p = (DirectoryServerPlugin)initialPlugins.get(name);
            if (p == null) continue;
            newList.add(p);
        }
        newList.addAll(otherPlugins);
        for (String name : finalPluginNames) {
            p = (DirectoryServerPlugin)finalPlugins.get(name);
            if (p == null) continue;
            newList.add(p);
        }
        DirectoryServerPlugin[] newPlugins = new DirectoryServerPlugin[newList.size()];
        newList.toArray(newPlugins);
        return newPlugins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterPlugin(DN configEntryDN) {
        DirectoryServerPlugin<? extends PluginCfg> plugin;
        this.pluginLock.lock();
        try {
            plugin = this.registeredPlugins.remove(configEntryDN);
            if (plugin == null) {
                return;
            }
            for (PluginType t : plugin.getPluginTypes()) {
                switch (t) {
                    case STARTUP: {
                        this.startupPlugins = this.removePlugin(this.startupPlugins, plugin);
                        break;
                    }
                    case SHUTDOWN: {
                        this.shutdownPlugins = this.removePlugin(this.shutdownPlugins, plugin);
                        break;
                    }
                    case POST_CONNECT: {
                        this.postConnectPlugins = this.removePlugin(this.postConnectPlugins, plugin);
                        break;
                    }
                    case POST_DISCONNECT: {
                        this.postDisconnectPlugins = this.removePlugin(this.postDisconnectPlugins, plugin);
                        break;
                    }
                    case LDIF_IMPORT: {
                        this.ldifImportPlugins = this.removePlugin(this.ldifImportPlugins, plugin);
                        break;
                    }
                    case LDIF_EXPORT: {
                        this.ldifExportPlugins = this.removePlugin(this.ldifExportPlugins, plugin);
                        break;
                    }
                    case PRE_PARSE_ABANDON: {
                        this.preParseAbandonPlugins = this.removePlugin(this.preParseAbandonPlugins, plugin);
                        break;
                    }
                    case PRE_PARSE_ADD: {
                        this.preParseAddPlugins = this.removePlugin(this.preParseAddPlugins, plugin);
                        break;
                    }
                    case PRE_PARSE_BIND: {
                        this.preParseBindPlugins = this.removePlugin(this.preParseBindPlugins, plugin);
                        break;
                    }
                    case PRE_PARSE_COMPARE: {
                        this.preParseComparePlugins = this.removePlugin(this.preParseComparePlugins, plugin);
                        break;
                    }
                    case PRE_PARSE_DELETE: {
                        this.preParseDeletePlugins = this.removePlugin(this.preParseDeletePlugins, plugin);
                        break;
                    }
                    case PRE_PARSE_EXTENDED: {
                        this.preParseExtendedPlugins = this.removePlugin(this.preParseExtendedPlugins, plugin);
                        break;
                    }
                    case PRE_PARSE_MODIFY: {
                        this.preParseModifyPlugins = this.removePlugin(this.preParseModifyPlugins, plugin);
                        break;
                    }
                    case PRE_PARSE_MODIFY_DN: {
                        this.preParseModifyDNPlugins = this.removePlugin(this.preParseModifyDNPlugins, plugin);
                        break;
                    }
                    case PRE_PARSE_SEARCH: {
                        this.preParseSearchPlugins = this.removePlugin(this.preParseSearchPlugins, plugin);
                        break;
                    }
                    case PRE_PARSE_UNBIND: {
                        this.preParseUnbindPlugins = this.removePlugin(this.preParseUnbindPlugins, plugin);
                        break;
                    }
                    case PRE_OPERATION_ADD: {
                        this.preOperationAddPlugins = this.removePlugin(this.preOperationAddPlugins, plugin);
                        break;
                    }
                    case PRE_OPERATION_BIND: {
                        this.preOperationBindPlugins = this.removePlugin(this.preOperationBindPlugins, plugin);
                        break;
                    }
                    case PRE_OPERATION_COMPARE: {
                        this.preOperationComparePlugins = this.removePlugin(this.preOperationComparePlugins, plugin);
                        break;
                    }
                    case PRE_OPERATION_DELETE: {
                        this.preOperationDeletePlugins = this.removePlugin(this.preOperationDeletePlugins, plugin);
                        break;
                    }
                    case PRE_OPERATION_EXTENDED: {
                        this.preOperationExtendedPlugins = this.removePlugin(this.preOperationExtendedPlugins, plugin);
                        break;
                    }
                    case PRE_OPERATION_MODIFY: {
                        this.preOperationModifyPlugins = this.removePlugin(this.preOperationModifyPlugins, plugin);
                        break;
                    }
                    case PRE_OPERATION_MODIFY_DN: {
                        this.preOperationModifyDNPlugins = this.removePlugin(this.preOperationModifyDNPlugins, plugin);
                        break;
                    }
                    case PRE_OPERATION_SEARCH: {
                        this.preOperationSearchPlugins = this.removePlugin(this.preOperationSearchPlugins, plugin);
                        break;
                    }
                    case POST_OPERATION_ABANDON: {
                        this.postOperationAbandonPlugins = this.removePlugin(this.postOperationAbandonPlugins, plugin);
                        break;
                    }
                    case POST_OPERATION_ADD: {
                        this.postOperationAddPlugins = this.removePlugin(this.postOperationAddPlugins, plugin);
                        break;
                    }
                    case POST_OPERATION_BIND: {
                        this.postOperationBindPlugins = this.removePlugin(this.postOperationBindPlugins, plugin);
                        break;
                    }
                    case POST_OPERATION_COMPARE: {
                        this.postOperationComparePlugins = this.removePlugin(this.postOperationComparePlugins, plugin);
                        break;
                    }
                    case POST_OPERATION_DELETE: {
                        this.postOperationDeletePlugins = this.removePlugin(this.postOperationDeletePlugins, plugin);
                        break;
                    }
                    case POST_OPERATION_EXTENDED: {
                        this.postOperationExtendedPlugins = this.removePlugin(this.postOperationExtendedPlugins, plugin);
                        break;
                    }
                    case POST_OPERATION_MODIFY: {
                        this.postOperationModifyPlugins = this.removePlugin(this.postOperationModifyPlugins, plugin);
                        break;
                    }
                    case POST_OPERATION_MODIFY_DN: {
                        this.postOperationModifyDNPlugins = this.removePlugin(this.postOperationModifyDNPlugins, plugin);
                        break;
                    }
                    case POST_OPERATION_SEARCH: {
                        this.postOperationSearchPlugins = this.removePlugin(this.postOperationSearchPlugins, plugin);
                        break;
                    }
                    case POST_OPERATION_UNBIND: {
                        this.postOperationUnbindPlugins = this.removePlugin(this.postOperationUnbindPlugins, plugin);
                        break;
                    }
                    case POST_RESPONSE_ADD: {
                        this.postResponseAddPlugins = this.removePlugin(this.postResponseAddPlugins, plugin);
                        break;
                    }
                    case POST_RESPONSE_BIND: {
                        this.postResponseBindPlugins = this.removePlugin(this.postResponseBindPlugins, plugin);
                        break;
                    }
                    case POST_RESPONSE_COMPARE: {
                        this.postResponseComparePlugins = this.removePlugin(this.postResponseComparePlugins, plugin);
                        break;
                    }
                    case POST_RESPONSE_DELETE: {
                        this.postResponseDeletePlugins = this.removePlugin(this.postResponseDeletePlugins, plugin);
                        break;
                    }
                    case POST_RESPONSE_EXTENDED: {
                        this.postResponseExtendedPlugins = this.removePlugin(this.postResponseExtendedPlugins, plugin);
                        break;
                    }
                    case POST_RESPONSE_MODIFY: {
                        this.postResponseModifyPlugins = this.removePlugin(this.postResponseModifyPlugins, plugin);
                        break;
                    }
                    case POST_RESPONSE_MODIFY_DN: {
                        this.postResponseModifyDNPlugins = this.removePlugin(this.postResponseModifyDNPlugins, plugin);
                        break;
                    }
                    case POST_RESPONSE_SEARCH: {
                        this.postResponseSearchPlugins = this.removePlugin(this.postResponseSearchPlugins, plugin);
                        break;
                    }
                    case SEARCH_RESULT_ENTRY: {
                        this.searchResultEntryPlugins = this.removePlugin(this.searchResultEntryPlugins, plugin);
                        break;
                    }
                    case SEARCH_RESULT_REFERENCE: {
                        this.searchResultReferencePlugins = this.removePlugin(this.searchResultReferencePlugins, plugin);
                        break;
                    }
                    case SUBORDINATE_MODIFY_DN: {
                        this.subordinateModifyDNPlugins = this.removePlugin(this.subordinateModifyDNPlugins, plugin);
                        break;
                    }
                    case INTERMEDIATE_RESPONSE: {
                        this.intermediateResponsePlugins = this.removePlugin(this.intermediateResponsePlugins, plugin);
                        break;
                    }
                }
            }
        }
        finally {
            this.pluginLock.unlock();
        }
        plugin.finalizePlugin();
    }

    private DirectoryServerPlugin[] removePlugin(DirectoryServerPlugin[] pluginArray, DirectoryServerPlugin plugin) {
        int slot = -1;
        int length = pluginArray.length;
        for (int i = 0; i < length; ++i) {
            if (!pluginArray[i].getPluginEntryDN().equals(plugin.getPluginEntryDN())) continue;
            slot = i;
            break;
        }
        if (slot < 0) {
            return pluginArray;
        }
        if (length == 0) {
            return new DirectoryServerPlugin[0];
        }
        DirectoryServerPlugin[] newPlugins = new DirectoryServerPlugin[length - 1];
        if (slot > 0) {
            System.arraycopy(pluginArray, 0, newPlugins, 0, slot);
        }
        if (slot < length - 1) {
            System.arraycopy(pluginArray, slot + 1, newPlugins, slot, length - slot - 1);
        }
        return newPlugins;
    }

    public StartupPluginResult invokeStartupPlugins() {
        StartupPluginResult result = null;
        for (DirectoryServerPlugin p : this.startupPlugins) {
            Message message;
            try {
                result = p.doStartup();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message2 = PluginMessages.ERR_PLUGIN_STARTUP_PLUGIN_EXCEPTION.get(String.valueOf(p.getPluginEntryDN()), StaticUtils.stackTraceToSingleLineString(e));
                result = new StartupPluginResult(false, false, message2);
                break;
            }
            if (result == null) {
                message = PluginMessages.ERR_PLUGIN_STARTUP_PLUGIN_RETURNED_NULL.get(String.valueOf(p.getPluginEntryDN()));
                ErrorLogger.logError(message);
                return new StartupPluginResult(false, false, message);
            }
            if (result.completedSuccessfully()) continue;
            if (result.continueStartup()) {
                message = PluginMessages.ERR_PLUGIN_STARTUP_PLUGIN_FAIL_CONTINUE.get(String.valueOf(p.getPluginEntryDN()), result.getErrorMessage(), result.getErrorMessage().getDescriptor().getId());
                ErrorLogger.logError(message);
                continue;
            }
            message = PluginMessages.ERR_PLUGIN_STARTUP_PLUGIN_FAIL_ABORT.get(String.valueOf(p.getPluginEntryDN()), result.getErrorMessage(), result.getErrorMessage().getDescriptor().getId());
            ErrorLogger.logError(message);
            return result;
        }
        if (result == null) {
            result = StartupPluginResult.SUCCESS;
        }
        return result;
    }

    public void invokeShutdownPlugins(Message reason) {
        for (DirectoryServerPlugin p : this.shutdownPlugins) {
            try {
                p.doShutdown(reason);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_SHUTDOWN_PLUGIN_EXCEPTION.get(String.valueOf(p.getPluginEntryDN()), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
            }
        }
    }

    public PostConnectPluginResult invokePostConnectPlugins(ClientConnection clientConnection) {
        PostConnectPluginResult result = null;
        for (DirectoryServerPlugin p : this.postConnectPlugins) {
            try {
                result = p.doPostConnect(clientConnection);
            }
            catch (Exception e) {
                block10: {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    Message message = PluginMessages.ERR_PLUGIN_POST_CONNECT_PLUGIN_EXCEPTION.get(String.valueOf(p.getPluginEntryDN()), clientConnection.getConnectionID(), clientConnection.getClientAddress(), StaticUtils.stackTraceToSingleLineString(e));
                    ErrorLogger.logError(message);
                    try {
                        clientConnection.disconnect(DisconnectReason.SERVER_ERROR, true, message);
                    }
                    catch (Exception e2) {
                        if (!DebugLogger.debugEnabled()) break block10;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e2);
                    }
                }
                return new PostConnectPluginResult(true, false);
            }
            if (result == null) {
                block11: {
                    Message message = PluginMessages.ERR_PLUGIN_POST_CONNECT_PLUGIN_RETURNED_NULL.get(String.valueOf(p.getPluginEntryDN()), clientConnection.getConnectionID(), clientConnection.getClientAddress());
                    ErrorLogger.logError(message);
                    try {
                        clientConnection.disconnect(DisconnectReason.SERVER_ERROR, true, message);
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block11;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                return new PostConnectPluginResult(true, false);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = PostConnectPluginResult.SUCCESS;
        }
        return result;
    }

    public PostDisconnectPluginResult invokePostDisconnectPlugins(ClientConnection clientConnection, DisconnectReason disconnectReason, Message message) {
        PostDisconnectPluginResult result = null;
        for (DirectoryServerPlugin p : this.postDisconnectPlugins) {
            try {
                result = p.doPostDisconnect(clientConnection, disconnectReason, message);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message msg = PluginMessages.ERR_PLUGIN_POST_DISCONNECT_PLUGIN_EXCEPTION.get(String.valueOf(p.getPluginEntryDN()), clientConnection.getConnectionID(), clientConnection.getClientAddress(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(msg);
                return new PostDisconnectPluginResult(false);
            }
            if (result == null) {
                Message msg = PluginMessages.ERR_PLUGIN_POST_DISCONNECT_PLUGIN_RETURNED_NULL.get(String.valueOf(p.getPluginEntryDN()), clientConnection.getConnectionID(), clientConnection.getClientAddress());
                ErrorLogger.logError(msg);
                return new PostDisconnectPluginResult(false);
            }
            if (result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = PostDisconnectPluginResult.SUCCESS;
        }
        return result;
    }

    public LDIFPluginResult invokeLDIFImportPlugins(LDIFImportConfig importConfig, Entry entry) {
        LDIFPluginResult result = null;
        for (DirectoryServerPlugin p : this.ldifImportPlugins) {
            try {
                result = p.doLDIFImport(importConfig, entry);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_LDIF_IMPORT_PLUGIN_EXCEPTION.get(String.valueOf(p.getPluginEntryDN()), String.valueOf(entry.getDN()), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                return new LDIFPluginResult(false, false);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_LDIF_IMPORT_PLUGIN_RETURNED_NULL.get(String.valueOf(p.getPluginEntryDN()), String.valueOf(entry.getDN()));
                ErrorLogger.logError(message);
                return new LDIFPluginResult(false, false);
            }
            if (result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = LDIFPluginResult.SUCCESS;
        }
        return result;
    }

    public LDIFPluginResult invokeLDIFExportPlugins(LDIFExportConfig exportConfig, Entry entry) {
        LDIFPluginResult result = null;
        for (DirectoryServerPlugin p : this.ldifExportPlugins) {
            try {
                result = p.doLDIFExport(exportConfig, entry);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_LDIF_EXPORT_PLUGIN_EXCEPTION.get(String.valueOf(p.getPluginEntryDN()), String.valueOf(entry.getDN()), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                return new LDIFPluginResult(false, false);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_LDIF_EXPORT_PLUGIN_RETURNED_NULL.get(String.valueOf(p.getPluginEntryDN()), String.valueOf(entry.getDN()));
                ErrorLogger.logError(message);
                return new LDIFPluginResult(false, false);
            }
            if (result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = LDIFPluginResult.SUCCESS;
        }
        return result;
    }

    public PreParsePluginResult invokePreParseAbandonPlugins(PreParseAbandonOperation abandonOperation) {
        PreParsePluginResult result = null;
        for (DirectoryServerPlugin p : this.preParseAbandonPlugins) {
            try {
                result = p.doPreParse(abandonOperation);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_PRE_PARSE_PLUGIN_EXCEPTION.get(abandonOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), abandonOperation.getConnectionID(), abandonOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                abandonOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                abandonOperation.appendErrorMessage(message);
                return new PreParsePluginResult(false, false, true);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_PRE_PARSE_PLUGIN_RETURNED_NULL.get(abandonOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), abandonOperation.getConnectionID(), String.valueOf(abandonOperation.getOperationID()));
                ErrorLogger.logError(message);
                abandonOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                abandonOperation.appendErrorMessage(message);
                return new PreParsePluginResult(false, false, true);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = PreParsePluginResult.SUCCESS;
        }
        return result;
    }

    public PreParsePluginResult invokePreParseAddPlugins(PreParseAddOperation addOperation) {
        PreParsePluginResult result = null;
        for (DirectoryServerPlugin p : this.preParseAddPlugins) {
            try {
                result = p.doPreParse(addOperation);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_PRE_PARSE_PLUGIN_EXCEPTION.get(addOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), addOperation.getConnectionID(), addOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                addOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                addOperation.appendErrorMessage(message);
                return new PreParsePluginResult(false, false, true);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_PRE_PARSE_PLUGIN_RETURNED_NULL.get(addOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), addOperation.getConnectionID(), String.valueOf(addOperation.getOperationID()));
                ErrorLogger.logError(message);
                addOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                addOperation.appendErrorMessage(message);
                return new PreParsePluginResult(false, false, true);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = PreParsePluginResult.SUCCESS;
        }
        return result;
    }

    public PreParsePluginResult invokePreParseBindPlugins(PreParseBindOperation bindOperation) {
        PreParsePluginResult result = null;
        for (DirectoryServerPlugin p : this.preParseBindPlugins) {
            try {
                result = p.doPreParse(bindOperation);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_PRE_PARSE_PLUGIN_EXCEPTION.get(bindOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), bindOperation.getConnectionID(), bindOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                bindOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                bindOperation.appendErrorMessage(message);
                return new PreParsePluginResult(false, false, true);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_PRE_PARSE_PLUGIN_RETURNED_NULL.get(bindOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), bindOperation.getConnectionID(), String.valueOf(bindOperation.getOperationID()));
                ErrorLogger.logError(message);
                bindOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                bindOperation.appendErrorMessage(message);
                return new PreParsePluginResult(false, false, true);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = PreParsePluginResult.SUCCESS;
        }
        return result;
    }

    public PreParsePluginResult invokePreParseComparePlugins(PreParseCompareOperation compareOperation) {
        PreParsePluginResult result = null;
        for (DirectoryServerPlugin p : this.preParseComparePlugins) {
            try {
                result = p.doPreParse(compareOperation);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_PRE_PARSE_PLUGIN_EXCEPTION.get(compareOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), compareOperation.getConnectionID(), compareOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                compareOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                compareOperation.appendErrorMessage(message);
                return new PreParsePluginResult(false, false, true);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_PRE_PARSE_PLUGIN_RETURNED_NULL.get(compareOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), compareOperation.getConnectionID(), String.valueOf(compareOperation.getOperationID()));
                ErrorLogger.logError(message);
                compareOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                compareOperation.appendErrorMessage(message);
                return new PreParsePluginResult(false, false, true);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = PreParsePluginResult.SUCCESS;
        }
        return result;
    }

    public PreParsePluginResult invokePreParseDeletePlugins(PreParseDeleteOperation deleteOperation) {
        PreParsePluginResult result = null;
        for (DirectoryServerPlugin p : this.preParseDeletePlugins) {
            try {
                result = p.doPreParse(deleteOperation);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_PRE_PARSE_PLUGIN_EXCEPTION.get(deleteOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), deleteOperation.getConnectionID(), deleteOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                deleteOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                deleteOperation.appendErrorMessage(message);
                return new PreParsePluginResult(false, false, true);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_PRE_PARSE_PLUGIN_RETURNED_NULL.get(deleteOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), deleteOperation.getConnectionID(), String.valueOf(deleteOperation.getOperationID()));
                ErrorLogger.logError(message);
                deleteOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                deleteOperation.appendErrorMessage(message);
                return new PreParsePluginResult(false, false, true);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = PreParsePluginResult.SUCCESS;
        }
        return result;
    }

    public PreParsePluginResult invokePreParseExtendedPlugins(PreParseExtendedOperation extendedOperation) {
        PreParsePluginResult result = null;
        for (DirectoryServerPlugin p : this.preParseExtendedPlugins) {
            try {
                result = p.doPreParse(extendedOperation);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_PRE_PARSE_PLUGIN_EXCEPTION.get(extendedOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), extendedOperation.getConnectionID(), extendedOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                extendedOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                extendedOperation.appendErrorMessage(message);
                return new PreParsePluginResult(false, false, true);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_PRE_PARSE_PLUGIN_RETURNED_NULL.get(extendedOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), extendedOperation.getConnectionID(), String.valueOf(extendedOperation.getOperationID()));
                ErrorLogger.logError(message);
                extendedOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                extendedOperation.appendErrorMessage(message);
                return new PreParsePluginResult(false, false, true);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = PreParsePluginResult.SUCCESS;
        }
        return result;
    }

    public PreParsePluginResult invokePreParseModifyPlugins(PreParseModifyOperation operation) {
        PreParsePluginResult result = null;
        for (DirectoryServerPlugin p : this.preParseModifyPlugins) {
            try {
                result = p.doPreParse(operation);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_PRE_PARSE_PLUGIN_EXCEPTION.get(operation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), operation.getConnectionID(), operation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                operation.setResultCode(DirectoryServer.getServerErrorResultCode());
                operation.appendErrorMessage(message);
                return new PreParsePluginResult(false, false, true);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_PRE_PARSE_PLUGIN_RETURNED_NULL.get(operation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), operation.getConnectionID(), String.valueOf(operation.getOperationID()));
                ErrorLogger.logError(message);
                operation.setResultCode(DirectoryServer.getServerErrorResultCode());
                operation.appendErrorMessage(message);
                return new PreParsePluginResult(false, false, true);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = PreParsePluginResult.SUCCESS;
        }
        return result;
    }

    public PreParsePluginResult invokePreParseModifyDNPlugins(PreParseModifyDNOperation modifyDNOperation) {
        PreParsePluginResult result = null;
        for (DirectoryServerPlugin p : this.preParseModifyDNPlugins) {
            try {
                result = p.doPreParse(modifyDNOperation);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_PRE_PARSE_PLUGIN_EXCEPTION.get(modifyDNOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), modifyDNOperation.getConnectionID(), modifyDNOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                modifyDNOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                modifyDNOperation.appendErrorMessage(message);
                return new PreParsePluginResult(false, false, true);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_PRE_PARSE_PLUGIN_RETURNED_NULL.get(modifyDNOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), modifyDNOperation.getConnectionID(), String.valueOf(modifyDNOperation.getOperationID()));
                ErrorLogger.logError(message);
                modifyDNOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                modifyDNOperation.appendErrorMessage(message);
                return new PreParsePluginResult(false, false, true);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = PreParsePluginResult.SUCCESS;
        }
        return result;
    }

    public PreParsePluginResult invokePreParseSearchPlugins(PreParseSearchOperation searchOperation) {
        PreParsePluginResult result = null;
        for (DirectoryServerPlugin p : this.preParseSearchPlugins) {
            try {
                result = p.doPreParse(searchOperation);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_PRE_PARSE_PLUGIN_EXCEPTION.get(searchOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), searchOperation.getConnectionID(), searchOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                searchOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                searchOperation.appendErrorMessage(message);
                return new PreParsePluginResult(false, false, true);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_PRE_PARSE_PLUGIN_RETURNED_NULL.get(searchOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), searchOperation.getConnectionID(), String.valueOf(searchOperation.getOperationID()));
                ErrorLogger.logError(message);
                searchOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                searchOperation.appendErrorMessage(message);
                return new PreParsePluginResult(false, false, true);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = PreParsePluginResult.SUCCESS;
        }
        return result;
    }

    public PreParsePluginResult invokePreParseUnbindPlugins(PreParseUnbindOperation unbindOperation) {
        PreParsePluginResult result = null;
        for (DirectoryServerPlugin p : this.preParseUnbindPlugins) {
            try {
                result = p.doPreParse(unbindOperation);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_PRE_PARSE_PLUGIN_EXCEPTION.get(unbindOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), unbindOperation.getConnectionID(), unbindOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                unbindOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                unbindOperation.appendErrorMessage(message);
                return new PreParsePluginResult(false, false, true);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_PRE_PARSE_PLUGIN_RETURNED_NULL.get(unbindOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), unbindOperation.getConnectionID(), String.valueOf(unbindOperation.getOperationID()));
                ErrorLogger.logError(message);
                unbindOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                unbindOperation.appendErrorMessage(message);
                return new PreParsePluginResult(false, false, true);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = PreParsePluginResult.SUCCESS;
        }
        return result;
    }

    public PreOperationPluginResult invokePreOperationAddPlugins(PreOperationAddOperation addOperation) {
        PreOperationPluginResult result = null;
        for (DirectoryServerPlugin p : this.preOperationAddPlugins) {
            try {
                result = p.doPreOperation(addOperation);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_PRE_OPERATION_PLUGIN_EXCEPTION.get(addOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), addOperation.getConnectionID(), addOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                addOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                addOperation.appendErrorMessage(message);
                return new PreOperationPluginResult(false, false, true);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_PRE_OPERATION_PLUGIN_RETURNED_NULL.get(addOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), addOperation.getConnectionID(), addOperation.getOperationID());
                ErrorLogger.logError(message);
                addOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                addOperation.appendErrorMessage(message);
                return new PreOperationPluginResult(false, false, true);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = PreOperationPluginResult.SUCCESS;
        }
        return result;
    }

    public PreOperationPluginResult invokePreOperationBindPlugins(PreOperationBindOperation bindOperation) {
        PreOperationPluginResult result = null;
        for (DirectoryServerPlugin p : this.preOperationBindPlugins) {
            try {
                result = p.doPreOperation(bindOperation);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_PRE_OPERATION_PLUGIN_EXCEPTION.get(bindOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), bindOperation.getConnectionID(), bindOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                bindOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                bindOperation.appendErrorMessage(message);
                return new PreOperationPluginResult(false, false, true);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_PRE_OPERATION_PLUGIN_RETURNED_NULL.get(bindOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), bindOperation.getConnectionID(), bindOperation.getOperationID());
                ErrorLogger.logError(message);
                bindOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                bindOperation.appendErrorMessage(message);
                return new PreOperationPluginResult(false, false, true);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = PreOperationPluginResult.SUCCESS;
        }
        return result;
    }

    public PreOperationPluginResult invokePreOperationComparePlugins(PreOperationCompareOperation compareOperation) {
        PreOperationPluginResult result = null;
        for (DirectoryServerPlugin p : this.preOperationComparePlugins) {
            try {
                result = p.doPreOperation(compareOperation);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_PRE_OPERATION_PLUGIN_EXCEPTION.get(compareOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), compareOperation.getConnectionID(), compareOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                compareOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                compareOperation.appendErrorMessage(message);
                return new PreOperationPluginResult(false, false, true);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_PRE_OPERATION_PLUGIN_RETURNED_NULL.get(compareOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), compareOperation.getConnectionID(), compareOperation.getOperationID());
                ErrorLogger.logError(message);
                compareOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                compareOperation.appendErrorMessage(message);
                return new PreOperationPluginResult(false, false, true);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = PreOperationPluginResult.SUCCESS;
        }
        return result;
    }

    public PreOperationPluginResult invokePreOperationDeletePlugins(PreOperationDeleteOperation deleteOperation) {
        PreOperationPluginResult result = null;
        for (DirectoryServerPlugin p : this.preOperationDeletePlugins) {
            try {
                result = p.doPreOperation(deleteOperation);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_PRE_OPERATION_PLUGIN_EXCEPTION.get(deleteOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), deleteOperation.getConnectionID(), deleteOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                deleteOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                deleteOperation.appendErrorMessage(message);
                return new PreOperationPluginResult(false, false, true);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_PRE_OPERATION_PLUGIN_RETURNED_NULL.get(deleteOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), deleteOperation.getConnectionID(), deleteOperation.getOperationID());
                ErrorLogger.logError(message);
                deleteOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                deleteOperation.appendErrorMessage(message);
                return new PreOperationPluginResult(false, false, true);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = PreOperationPluginResult.SUCCESS;
        }
        return result;
    }

    public PreOperationPluginResult invokePreOperationExtendedPlugins(PreOperationExtendedOperation extendedOperation) {
        PreOperationPluginResult result = null;
        for (DirectoryServerPlugin p : this.preOperationExtendedPlugins) {
            try {
                result = p.doPreOperation(extendedOperation);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_PRE_OPERATION_PLUGIN_EXCEPTION.get(extendedOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), extendedOperation.getConnectionID(), extendedOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                extendedOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                extendedOperation.appendErrorMessage(message);
                return new PreOperationPluginResult(false, false, true);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_PRE_OPERATION_PLUGIN_RETURNED_NULL.get(extendedOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), extendedOperation.getConnectionID(), extendedOperation.getOperationID());
                ErrorLogger.logError(message);
                extendedOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                extendedOperation.appendErrorMessage(message);
                return new PreOperationPluginResult(false, false, true);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = PreOperationPluginResult.SUCCESS;
        }
        return result;
    }

    public PreOperationPluginResult invokePreOperationModifyPlugins(PreOperationModifyOperation modifyOperation) {
        PreOperationPluginResult result = null;
        for (DirectoryServerPlugin p : this.preOperationModifyPlugins) {
            try {
                result = p.doPreOperation(modifyOperation);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_PRE_OPERATION_PLUGIN_EXCEPTION.get(modifyOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), modifyOperation.getConnectionID(), modifyOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                modifyOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                modifyOperation.appendErrorMessage(message);
                return new PreOperationPluginResult(false, false, true);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_PRE_OPERATION_PLUGIN_RETURNED_NULL.get(modifyOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), modifyOperation.getConnectionID(), modifyOperation.getOperationID());
                ErrorLogger.logError(message);
                modifyOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                modifyOperation.appendErrorMessage(message);
                return new PreOperationPluginResult(false, false, true);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = PreOperationPluginResult.SUCCESS;
        }
        return result;
    }

    public PreOperationPluginResult invokePreOperationModifyDNPlugins(PreOperationModifyDNOperation modifyDNOperation) {
        PreOperationPluginResult result = null;
        for (DirectoryServerPlugin p : this.preOperationModifyDNPlugins) {
            try {
                result = p.doPreOperation(modifyDNOperation);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_PRE_OPERATION_PLUGIN_EXCEPTION.get(modifyDNOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), modifyDNOperation.getConnectionID(), modifyDNOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                modifyDNOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                modifyDNOperation.appendErrorMessage(message);
                return new PreOperationPluginResult(false, false, true);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_PRE_OPERATION_PLUGIN_RETURNED_NULL.get(modifyDNOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), modifyDNOperation.getConnectionID(), modifyDNOperation.getOperationID());
                ErrorLogger.logError(message);
                modifyDNOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                modifyDNOperation.appendErrorMessage(message);
                return new PreOperationPluginResult(false, false, true);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = PreOperationPluginResult.SUCCESS;
        }
        return result;
    }

    public PreOperationPluginResult invokePreOperationSearchPlugins(PreOperationSearchOperation searchOperation) {
        PreOperationPluginResult result = null;
        for (DirectoryServerPlugin p : this.preOperationSearchPlugins) {
            try {
                result = p.doPreOperation(searchOperation);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_PRE_OPERATION_PLUGIN_EXCEPTION.get(searchOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), searchOperation.getConnectionID(), searchOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                searchOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                searchOperation.appendErrorMessage(message);
                return new PreOperationPluginResult(false, false, true);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_PRE_OPERATION_PLUGIN_RETURNED_NULL.get(searchOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), searchOperation.getConnectionID(), searchOperation.getOperationID());
                ErrorLogger.logError(message);
                searchOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                searchOperation.appendErrorMessage(message);
                return new PreOperationPluginResult(false, false, true);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = PreOperationPluginResult.SUCCESS;
        }
        return result;
    }

    public PostOperationPluginResult invokePostOperationAbandonPlugins(PostOperationAbandonOperation abandonOperation) {
        PostOperationPluginResult result = null;
        for (DirectoryServerPlugin p : this.postOperationAbandonPlugins) {
            try {
                result = p.doPostOperation(abandonOperation);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_POST_OPERATION_PLUGIN_EXCEPTION.get(abandonOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), abandonOperation.getConnectionID(), abandonOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                abandonOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                abandonOperation.appendErrorMessage(message);
                return new PostOperationPluginResult(false, false);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_POST_OPERATION_PLUGIN_RETURNED_NULL.get(abandonOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), abandonOperation.getConnectionID(), abandonOperation.getOperationID());
                ErrorLogger.logError(message);
                abandonOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                abandonOperation.appendErrorMessage(message);
                return new PostOperationPluginResult(false, false);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = PostOperationPluginResult.SUCCESS;
        }
        return result;
    }

    public PostOperationPluginResult invokePostOperationAddPlugins(PostOperationAddOperation addOperation) {
        PostOperationPluginResult result = null;
        for (DirectoryServerPlugin p : this.postOperationAddPlugins) {
            try {
                result = p.doPostOperation(addOperation);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_POST_OPERATION_PLUGIN_EXCEPTION.get(addOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), addOperation.getConnectionID(), addOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                addOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                addOperation.appendErrorMessage(message);
                return new PostOperationPluginResult(false, false);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_POST_OPERATION_PLUGIN_RETURNED_NULL.get(addOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), addOperation.getConnectionID(), addOperation.getOperationID());
                ErrorLogger.logError(message);
                addOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                addOperation.appendErrorMessage(message);
                return new PostOperationPluginResult(false, false);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = PostOperationPluginResult.SUCCESS;
        }
        return result;
    }

    public PostOperationPluginResult invokePostOperationBindPlugins(PostOperationBindOperation bindOperation) {
        PostOperationPluginResult result = null;
        for (DirectoryServerPlugin p : this.postOperationBindPlugins) {
            try {
                result = p.doPostOperation(bindOperation);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_POST_OPERATION_PLUGIN_EXCEPTION.get(bindOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), bindOperation.getConnectionID(), bindOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                bindOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                bindOperation.appendErrorMessage(message);
                return new PostOperationPluginResult(false, false);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_POST_OPERATION_PLUGIN_RETURNED_NULL.get(bindOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), bindOperation.getConnectionID(), bindOperation.getOperationID());
                ErrorLogger.logError(message);
                bindOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                bindOperation.appendErrorMessage(message);
                return new PostOperationPluginResult(false, false);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = PostOperationPluginResult.SUCCESS;
        }
        return result;
    }

    public PostOperationPluginResult invokePostOperationComparePlugins(PostOperationCompareOperation compareOperation) {
        PostOperationPluginResult result = null;
        for (DirectoryServerPlugin p : this.postOperationComparePlugins) {
            try {
                result = p.doPostOperation(compareOperation);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_POST_OPERATION_PLUGIN_EXCEPTION.get(compareOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), compareOperation.getConnectionID(), compareOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                compareOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                compareOperation.appendErrorMessage(message);
                return new PostOperationPluginResult(false, false);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_POST_OPERATION_PLUGIN_RETURNED_NULL.get(compareOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), compareOperation.getConnectionID(), compareOperation.getOperationID());
                ErrorLogger.logError(message);
                compareOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                compareOperation.appendErrorMessage(message);
                return new PostOperationPluginResult(false, false);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = PostOperationPluginResult.SUCCESS;
        }
        return result;
    }

    public PostOperationPluginResult invokePostOperationDeletePlugins(PostOperationDeleteOperation deleteOperation) {
        PostOperationPluginResult result = null;
        for (DirectoryServerPlugin p : this.postOperationDeletePlugins) {
            try {
                result = p.doPostOperation(deleteOperation);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_POST_OPERATION_PLUGIN_EXCEPTION.get(deleteOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), deleteOperation.getConnectionID(), deleteOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                deleteOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                deleteOperation.appendErrorMessage(message);
                return new PostOperationPluginResult(false, false);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_POST_OPERATION_PLUGIN_RETURNED_NULL.get(deleteOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), deleteOperation.getConnectionID(), deleteOperation.getOperationID());
                ErrorLogger.logError(message);
                deleteOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                deleteOperation.appendErrorMessage(message);
                return new PostOperationPluginResult(false, false);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = PostOperationPluginResult.SUCCESS;
        }
        return result;
    }

    public PostOperationPluginResult invokePostOperationExtendedPlugins(PostOperationExtendedOperation extendedOperation) {
        PostOperationPluginResult result = null;
        for (DirectoryServerPlugin p : this.postOperationExtendedPlugins) {
            try {
                result = p.doPostOperation(extendedOperation);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_POST_OPERATION_PLUGIN_EXCEPTION.get(extendedOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), extendedOperation.getConnectionID(), extendedOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                extendedOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                extendedOperation.appendErrorMessage(message);
                return new PostOperationPluginResult(false, false);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_POST_OPERATION_PLUGIN_RETURNED_NULL.get(extendedOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), extendedOperation.getConnectionID(), extendedOperation.getOperationID());
                ErrorLogger.logError(message);
                extendedOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                extendedOperation.appendErrorMessage(message);
                return new PostOperationPluginResult(false, false);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = PostOperationPluginResult.SUCCESS;
        }
        return result;
    }

    public PostOperationPluginResult invokePostOperationModifyPlugins(PostOperationModifyOperation modifyOperation) {
        PostOperationPluginResult result = null;
        for (DirectoryServerPlugin p : this.postOperationModifyPlugins) {
            try {
                result = p.doPostOperation(modifyOperation);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_POST_OPERATION_PLUGIN_EXCEPTION.get(modifyOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), modifyOperation.getConnectionID(), modifyOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                modifyOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                modifyOperation.appendErrorMessage(message);
                return new PostOperationPluginResult(false, false);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_POST_OPERATION_PLUGIN_RETURNED_NULL.get(modifyOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), modifyOperation.getConnectionID(), modifyOperation.getOperationID());
                ErrorLogger.logError(message);
                modifyOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                modifyOperation.appendErrorMessage(message);
                return new PostOperationPluginResult(false, false);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = PostOperationPluginResult.SUCCESS;
        }
        return result;
    }

    public PostOperationPluginResult invokePostOperationModifyDNPlugins(PostOperationModifyDNOperation modifyDNOperation) {
        PostOperationPluginResult result = null;
        for (DirectoryServerPlugin p : this.postOperationModifyDNPlugins) {
            try {
                result = p.doPostOperation(modifyDNOperation);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_POST_OPERATION_PLUGIN_EXCEPTION.get(modifyDNOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), modifyDNOperation.getConnectionID(), modifyDNOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                modifyDNOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                modifyDNOperation.appendErrorMessage(message);
                return new PostOperationPluginResult(false, false);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_POST_OPERATION_PLUGIN_RETURNED_NULL.get(modifyDNOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), modifyDNOperation.getConnectionID(), modifyDNOperation.getOperationID());
                ErrorLogger.logError(message);
                modifyDNOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                modifyDNOperation.appendErrorMessage(message);
                return new PostOperationPluginResult(false, false);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = PostOperationPluginResult.SUCCESS;
        }
        return result;
    }

    public PostOperationPluginResult invokePostOperationSearchPlugins(PostOperationSearchOperation searchOperation) {
        PostOperationPluginResult result = null;
        for (DirectoryServerPlugin p : this.postOperationSearchPlugins) {
            try {
                result = p.doPostOperation(searchOperation);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_POST_OPERATION_PLUGIN_EXCEPTION.get(searchOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), searchOperation.getConnectionID(), searchOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                searchOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                searchOperation.appendErrorMessage(message);
                return new PostOperationPluginResult(false, false);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_POST_OPERATION_PLUGIN_RETURNED_NULL.get(searchOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), searchOperation.getConnectionID(), searchOperation.getOperationID());
                ErrorLogger.logError(message);
                searchOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                searchOperation.appendErrorMessage(message);
                return new PostOperationPluginResult(false, false);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = PostOperationPluginResult.SUCCESS;
        }
        return result;
    }

    public PostOperationPluginResult invokePostOperationUnbindPlugins(PostOperationUnbindOperation unbindOperation) {
        PostOperationPluginResult result = null;
        for (DirectoryServerPlugin p : this.postOperationUnbindPlugins) {
            try {
                result = p.doPostOperation(unbindOperation);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_POST_OPERATION_PLUGIN_EXCEPTION.get(unbindOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), unbindOperation.getConnectionID(), unbindOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                unbindOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                unbindOperation.appendErrorMessage(message);
                return new PostOperationPluginResult(false, false);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_POST_OPERATION_PLUGIN_RETURNED_NULL.get(unbindOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), unbindOperation.getConnectionID(), unbindOperation.getOperationID());
                ErrorLogger.logError(message);
                unbindOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                unbindOperation.appendErrorMessage(message);
                return new PostOperationPluginResult(false, false);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = PostOperationPluginResult.SUCCESS;
        }
        return result;
    }

    public PostResponsePluginResult invokePostResponseAddPlugins(PostResponseAddOperation addOperation) {
        PostResponsePluginResult result = null;
        for (DirectoryServerPlugin p : this.postResponseAddPlugins) {
            try {
                result = p.doPostResponse(addOperation);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_POST_RESPONSE_PLUGIN_EXCEPTION.get(addOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), addOperation.getConnectionID(), addOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                return new PostResponsePluginResult(false, false);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_POST_RESPONSE_PLUGIN_RETURNED_NULL.get(addOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), addOperation.getConnectionID(), addOperation.getOperationID());
                ErrorLogger.logError(message);
                return new PostResponsePluginResult(false, false);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = PostResponsePluginResult.SUCCESS;
        }
        return result;
    }

    public PostResponsePluginResult invokePostResponseBindPlugins(PostResponseBindOperation bindOperation) {
        PostResponsePluginResult result = null;
        for (DirectoryServerPlugin p : this.postResponseBindPlugins) {
            try {
                result = p.doPostResponse(bindOperation);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_POST_RESPONSE_PLUGIN_EXCEPTION.get(bindOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), bindOperation.getConnectionID(), bindOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                return new PostResponsePluginResult(false, false);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_POST_RESPONSE_PLUGIN_RETURNED_NULL.get(bindOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), bindOperation.getConnectionID(), bindOperation.getOperationID());
                ErrorLogger.logError(message);
                return new PostResponsePluginResult(false, false);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = PostResponsePluginResult.SUCCESS;
        }
        return result;
    }

    public PostResponsePluginResult invokePostResponseComparePlugins(PostResponseCompareOperation compareOperation) {
        PostResponsePluginResult result = null;
        for (DirectoryServerPlugin p : this.postResponseComparePlugins) {
            try {
                result = p.doPostResponse(compareOperation);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_POST_RESPONSE_PLUGIN_EXCEPTION.get(compareOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), compareOperation.getConnectionID(), compareOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                return new PostResponsePluginResult(false, false);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_POST_RESPONSE_PLUGIN_RETURNED_NULL.get(compareOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), compareOperation.getConnectionID(), compareOperation.getOperationID());
                ErrorLogger.logError(message);
                return new PostResponsePluginResult(false, false);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = PostResponsePluginResult.SUCCESS;
        }
        return result;
    }

    public PostResponsePluginResult invokePostResponseDeletePlugins(PostResponseDeleteOperation deleteOperation) {
        PostResponsePluginResult result = null;
        for (DirectoryServerPlugin p : this.postResponseDeletePlugins) {
            try {
                result = p.doPostResponse(deleteOperation);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_POST_RESPONSE_PLUGIN_EXCEPTION.get(deleteOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), deleteOperation.getConnectionID(), deleteOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                return new PostResponsePluginResult(false, false);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_POST_RESPONSE_PLUGIN_RETURNED_NULL.get(deleteOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), deleteOperation.getConnectionID(), deleteOperation.getOperationID());
                ErrorLogger.logError(message);
                return new PostResponsePluginResult(false, false);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = PostResponsePluginResult.SUCCESS;
        }
        return result;
    }

    public PostResponsePluginResult invokePostResponseExtendedPlugins(PostResponseExtendedOperation extendedOperation) {
        PostResponsePluginResult result = null;
        for (DirectoryServerPlugin p : this.postResponseExtendedPlugins) {
            try {
                result = p.doPostResponse(extendedOperation);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_POST_RESPONSE_PLUGIN_EXCEPTION.get(extendedOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), extendedOperation.getConnectionID(), extendedOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                return new PostResponsePluginResult(false, false);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_POST_RESPONSE_PLUGIN_RETURNED_NULL.get(extendedOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), extendedOperation.getConnectionID(), extendedOperation.getOperationID());
                ErrorLogger.logError(message);
                return new PostResponsePluginResult(false, false);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = PostResponsePluginResult.SUCCESS;
        }
        return result;
    }

    public PostResponsePluginResult invokePostResponseModifyPlugins(PostResponseModifyOperation modifyOperation) {
        PostResponsePluginResult result = null;
        for (DirectoryServerPlugin p : this.postResponseModifyPlugins) {
            try {
                result = p.doPostResponse(modifyOperation);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_POST_RESPONSE_PLUGIN_EXCEPTION.get(modifyOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), modifyOperation.getConnectionID(), modifyOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                return new PostResponsePluginResult(false, false);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_POST_RESPONSE_PLUGIN_RETURNED_NULL.get(modifyOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), modifyOperation.getConnectionID(), modifyOperation.getOperationID());
                ErrorLogger.logError(message);
                return new PostResponsePluginResult(false, false);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = PostResponsePluginResult.SUCCESS;
        }
        return result;
    }

    public PostResponsePluginResult invokePostResponseModifyDNPlugins(PostResponseModifyDNOperation modifyDNOperation) {
        PostResponsePluginResult result = null;
        for (DirectoryServerPlugin p : this.postResponseModifyDNPlugins) {
            try {
                result = p.doPostResponse(modifyDNOperation);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_POST_RESPONSE_PLUGIN_EXCEPTION.get(modifyDNOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), modifyDNOperation.getConnectionID(), modifyDNOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                return new PostResponsePluginResult(false, false);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_POST_RESPONSE_PLUGIN_RETURNED_NULL.get(modifyDNOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), modifyDNOperation.getConnectionID(), modifyDNOperation.getOperationID());
                ErrorLogger.logError(message);
                return new PostResponsePluginResult(false, false);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = PostResponsePluginResult.SUCCESS;
        }
        return result;
    }

    public PostResponsePluginResult invokePostResponseSearchPlugins(PostResponseSearchOperation searchOperation) {
        PostResponsePluginResult result = null;
        for (DirectoryServerPlugin p : this.postResponseSearchPlugins) {
            try {
                result = p.doPostResponse(searchOperation);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_POST_RESPONSE_PLUGIN_EXCEPTION.get(searchOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), searchOperation.getConnectionID(), searchOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                return new PostResponsePluginResult(false, false);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_POST_RESPONSE_PLUGIN_RETURNED_NULL.get(searchOperation.getOperationType().getOperationName(), String.valueOf(p.getPluginEntryDN()), searchOperation.getConnectionID(), searchOperation.getOperationID());
                ErrorLogger.logError(message);
                return new PostResponsePluginResult(false, false);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = PostResponsePluginResult.SUCCESS;
        }
        return result;
    }

    public SearchEntryPluginResult invokeSearchResultEntryPlugins(LocalBackendSearchOperation searchOperation, SearchResultEntry searchEntry) {
        SearchEntryPluginResult result = null;
        for (DirectoryServerPlugin p : this.searchResultEntryPlugins) {
            try {
                result = p.processSearchEntry(searchOperation, searchEntry);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_SEARCH_ENTRY_PLUGIN_EXCEPTION.get(String.valueOf(p.getPluginEntryDN()), searchOperation.getConnectionID(), searchOperation.getOperationID(), String.valueOf(searchEntry.getDN()), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                return new SearchEntryPluginResult(false, false, false, false);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_SEARCH_ENTRY_PLUGIN_RETURNED_NULL.get(String.valueOf(p.getPluginEntryDN()), searchOperation.getConnectionID(), searchOperation.getOperationID(), String.valueOf(searchEntry.getDN()));
                ErrorLogger.logError(message);
                return new SearchEntryPluginResult(false, false, false, false);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = SearchEntryPluginResult.SUCCESS;
        }
        return result;
    }

    public SearchEntryPluginResult invokeSearchResultEntryPlugins(SearchEntrySearchOperation searchOperation, SearchResultEntry searchEntry) {
        SearchEntryPluginResult result = null;
        for (DirectoryServerPlugin p : this.searchResultEntryPlugins) {
            try {
                result = p.processSearchEntry(searchOperation, searchEntry);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_SEARCH_ENTRY_PLUGIN_EXCEPTION.get(String.valueOf(p.getPluginEntryDN()), searchOperation.getConnectionID(), searchOperation.getOperationID(), String.valueOf(searchEntry.getDN()), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                return new SearchEntryPluginResult(false, false, false, false);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_SEARCH_ENTRY_PLUGIN_RETURNED_NULL.get(String.valueOf(p.getPluginEntryDN()), searchOperation.getConnectionID(), searchOperation.getOperationID(), String.valueOf(searchEntry.getDN()));
                ErrorLogger.logError(message);
                return new SearchEntryPluginResult(false, false, false, false);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = SearchEntryPluginResult.SUCCESS;
        }
        return result;
    }

    public SearchReferencePluginResult invokeSearchResultReferencePlugins(LocalBackendSearchOperation searchOperation, SearchResultReference searchReference) {
        SearchReferencePluginResult result = null;
        for (DirectoryServerPlugin p : this.searchResultReferencePlugins) {
            try {
                result = p.processSearchReference(searchOperation, searchReference);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_SEARCH_REFERENCE_PLUGIN_EXCEPTION.get(String.valueOf(p.getPluginEntryDN()), searchOperation.getConnectionID(), searchOperation.getOperationID(), searchReference.getReferralURLString(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                return new SearchReferencePluginResult(false, false, false, false);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_SEARCH_REFERENCE_PLUGIN_RETURNED_NULL.get(String.valueOf(p.getPluginEntryDN()), searchOperation.getConnectionID(), searchOperation.getOperationID(), searchReference.getReferralURLString());
                ErrorLogger.logError(message);
                return new SearchReferencePluginResult(false, false, false, false);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = SearchReferencePluginResult.SUCCESS;
        }
        return result;
    }

    public SearchReferencePluginResult invokeSearchResultReferencePlugins(SearchReferenceSearchOperation searchOperation, SearchResultReference searchReference) {
        SearchReferencePluginResult result = null;
        for (DirectoryServerPlugin p : this.searchResultReferencePlugins) {
            try {
                result = p.processSearchReference(searchOperation, searchReference);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_SEARCH_REFERENCE_PLUGIN_EXCEPTION.get(String.valueOf(p.getPluginEntryDN()), searchOperation.getConnectionID(), searchOperation.getOperationID(), searchReference.getReferralURLString(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                return new SearchReferencePluginResult(false, false, false, false);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_SEARCH_REFERENCE_PLUGIN_RETURNED_NULL.get(String.valueOf(p.getPluginEntryDN()), searchOperation.getConnectionID(), searchOperation.getOperationID(), searchReference.getReferralURLString());
                ErrorLogger.logError(message);
                return new SearchReferencePluginResult(false, false, false, false);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = SearchReferencePluginResult.SUCCESS;
        }
        return result;
    }

    public SubordinateModifyDNPluginResult invokeSubordinateModifyDNPlugins(SubordinateModifyDNOperation modifyDNOperation, Entry oldEntry, Entry newEntry, List<Modification> modifications) {
        SubordinateModifyDNPluginResult result = null;
        for (DirectoryServerPlugin p : this.subordinateModifyDNPlugins) {
            try {
                DirectoryServerPlugin gp = p;
                result = gp.processSubordinateModifyDN(modifyDNOperation, oldEntry, newEntry, modifications);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                ErrorLogger.logError(PluginMessages.ERR_PLUGIN_SUBORDINATE_MODIFY_DN_PLUGIN_EXCEPTION.get(String.valueOf(p.getPluginEntryDN()), modifyDNOperation.getConnectionID(), modifyDNOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e)));
                return new SubordinateModifyDNPluginResult(false, false, true);
            }
            if (result == null) {
                ErrorLogger.logError(PluginMessages.ERR_PLUGIN_SUBORDINATE_MODIFY_DN_PLUGIN_RETURNED_NULL.get(String.valueOf(p.getPluginEntryDN()), modifyDNOperation.getConnectionID(), String.valueOf(modifyDNOperation.getOperationID())));
                return new SubordinateModifyDNPluginResult(false, false, true);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = SubordinateModifyDNPluginResult.SUCCESS;
        }
        return result;
    }

    public IntermediateResponsePluginResult invokeIntermediateResponsePlugins(IntermediateResponse intermediateResponse) {
        IntermediateResponsePluginResult result = null;
        Operation operation = intermediateResponse.getOperation();
        for (DirectoryServerPlugin p : this.intermediateResponsePlugins) {
            try {
                result = p.processIntermediateResponse(intermediateResponse);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = PluginMessages.ERR_PLUGIN_INTERMEDIATE_RESPONSE_PLUGIN_EXCEPTION.get(String.valueOf(p.getPluginEntryDN()), operation.getConnectionID(), operation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                return new IntermediateResponsePluginResult(false, false, false, false);
            }
            if (result == null) {
                Message message = PluginMessages.ERR_PLUGIN_INTERMEDIATE_RESPONSE_PLUGIN_RETURNED_NULL.get(String.valueOf(p.getPluginEntryDN()), operation.getConnectionID(), operation.getOperationID());
                ErrorLogger.logError(message);
                return new IntermediateResponsePluginResult(false, false, false, false);
            }
            if (!result.connectionTerminated() && result.continuePluginProcessing()) continue;
            return result;
        }
        if (result == null) {
            result = IntermediateResponsePluginResult.SUCCESS;
        }
        return result;
    }

    @Override
    public boolean isConfigurationAddAcceptable(PluginCfg configuration, List<Message> unacceptableReasons) {
        if (configuration.isEnabled()) {
            HashSet<PluginType> pluginTypes = new HashSet<PluginType>();
            for (PluginCfgDefn.PluginType pluginType : configuration.getPluginType()) {
                pluginTypes.add(this.getPluginType(pluginType));
            }
            String className = configuration.getPluginClass();
            try {
                this.loadPlugin(className, pluginTypes, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(PluginCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        configuration.addChangeListener(this);
        if (!configuration.isEnabled()) {
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        HashSet<PluginType> pluginTypes = new HashSet<PluginType>();
        for (PluginCfgDefn.PluginType pluginType : configuration.getPluginType()) {
            pluginTypes.add(this.getPluginType(pluginType));
        }
        DirectoryServerPlugin<? extends PluginCfg> plugin = null;
        String className = configuration.getPluginClass();
        try {
            plugin = this.loadPlugin(className, pluginTypes, configuration, true);
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessageObject());
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.registerPlugin(plugin, configuration.dn(), pluginTypes);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(PluginCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(PluginCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        this.deregisterPlugin(configuration.dn());
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(PluginCfg configuration, List<Message> unacceptableReasons) {
        if (configuration.isEnabled()) {
            HashSet<PluginType> pluginTypes = new HashSet<PluginType>();
            for (PluginCfgDefn.PluginType pluginType : configuration.getPluginType()) {
                pluginTypes.add(this.getPluginType(pluginType));
            }
            String className = configuration.getPluginClass();
            try {
                this.loadPlugin(className, pluginTypes, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(PluginCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        DirectoryServerPlugin<? extends PluginCfg> existingPlugin = this.registeredPlugins.get(configuration.dn());
        if (!configuration.isEnabled()) {
            if (existingPlugin != null) {
                this.deregisterPlugin(configuration.dn());
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        String className = configuration.getPluginClass();
        if (existingPlugin != null) {
            if (!className.equals(existingPlugin.getClass().getName())) {
                adminActionRequired = true;
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        HashSet<PluginType> pluginTypes = new HashSet<PluginType>();
        for (PluginCfgDefn.PluginType pluginType : configuration.getPluginType()) {
            pluginTypes.add(this.getPluginType(pluginType));
        }
        DirectoryServerPlugin<? extends PluginCfg> plugin = null;
        try {
            plugin = this.loadPlugin(className, pluginTypes, configuration, true);
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessageObject());
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.registerPlugin(plugin, configuration.dn(), pluginTypes);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

