/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.plugin.PreParsePluginResult;
import org.opends.server.api.plugin.SearchEntryPluginResult;
import org.opends.server.api.plugin.SearchReferencePluginResult;
import org.opends.server.controls.AccountUsableResponseControl;
import org.opends.server.controls.MatchedValuesControl;
import org.opends.server.core.AccessControlConfigManager;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.NetworkGroup;
import org.opends.server.core.PasswordPolicyState;
import org.opends.server.core.PersistentSearch;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.core.SearchOperation;
import org.opends.server.core.Workflow;
import org.opends.server.loggers.AccessLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.types.AbstractOperation;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.CancelResult;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.Entry;
import org.opends.server.types.FilterType;
import org.opends.server.types.OperationType;
import org.opends.server.types.RawFilter;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;
import org.opends.server.types.SearchScope;
import org.opends.server.types.operation.PostResponseSearchOperation;
import org.opends.server.types.operation.PreParseSearchOperation;
import org.opends.server.types.operation.SearchEntrySearchOperation;
import org.opends.server.types.operation.SearchReferenceSearchOperation;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchOperationBasis
extends AbstractOperation
implements PreParseSearchOperation,
PostResponseSearchOperation,
SearchEntrySearchOperation,
SearchReferenceSearchOperation,
SearchOperation {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private AtomicBoolean responseSent;
    private boolean clientAcceptsReferrals;
    private boolean includeUsableControl;
    private boolean realAttributesOnly;
    private boolean returnLDAPSubentries;
    private boolean typesOnly;
    private boolean virtualAttributesOnly;
    private ByteString rawBaseDN;
    private CancelRequest cancelRequest;
    private DereferencePolicy derefPolicy;
    private DN baseDN;
    private DN proxiedAuthorizationDN;
    private int entriesSent;
    private int referencesSent;
    private int sizeLimit;
    private int timeLimit;
    private RawFilter rawFilter;
    private LinkedHashSet<String> attributes;
    private List<Control> responseControls;
    private long processingStartTime;
    private long processingStopTime;
    private long timeLimitExpiration;
    private MatchedValuesControl matchedValuesControl;
    private PersistentSearch persistentSearch;
    private SearchFilter filter;
    private SearchScope scope;
    private boolean sendResponse = true;

    public SearchOperationBasis(ClientConnection clientConnection, long operationID, int messageID, List<Control> requestControls, ByteString rawBaseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, RawFilter rawFilter, LinkedHashSet<String> attributes) {
        super(clientConnection, operationID, messageID, requestControls);
        this.rawBaseDN = rawBaseDN;
        this.scope = scope;
        this.derefPolicy = derefPolicy;
        this.sizeLimit = sizeLimit;
        this.timeLimit = timeLimit;
        this.typesOnly = typesOnly;
        this.rawFilter = rawFilter;
        this.attributes = attributes == null ? new LinkedHashSet(0) : attributes;
        this.sizeLimit = clientConnection.getSizeLimit() <= 0 ? sizeLimit : (sizeLimit <= 0 ? clientConnection.getSizeLimit() : Math.min(sizeLimit, clientConnection.getSizeLimit()));
        this.timeLimit = clientConnection.getTimeLimit() <= 0 ? timeLimit : (timeLimit <= 0 ? clientConnection.getTimeLimit() : Math.min(timeLimit, clientConnection.getTimeLimit()));
        this.baseDN = null;
        this.filter = null;
        this.entriesSent = 0;
        this.referencesSent = 0;
        this.responseControls = new ArrayList<Control>();
        this.cancelRequest = null;
        this.clientAcceptsReferrals = true;
        this.includeUsableControl = false;
        this.responseSent = new AtomicBoolean(false);
        this.persistentSearch = null;
        this.returnLDAPSubentries = false;
        this.matchedValuesControl = null;
        this.realAttributesOnly = false;
        this.virtualAttributesOnly = false;
    }

    public SearchOperationBasis(ClientConnection clientConnection, long operationID, int messageID, List<Control> requestControls, DN baseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, SearchFilter filter, LinkedHashSet<String> attributes) {
        super(clientConnection, operationID, messageID, requestControls);
        this.baseDN = baseDN;
        this.scope = scope;
        this.derefPolicy = derefPolicy;
        this.sizeLimit = sizeLimit;
        this.timeLimit = timeLimit;
        this.typesOnly = typesOnly;
        this.filter = filter;
        this.attributes = attributes == null ? new LinkedHashSet(0) : attributes;
        this.rawBaseDN = new ASN1OctetString(baseDN.toString());
        this.rawFilter = new LDAPFilter(filter);
        this.sizeLimit = clientConnection.getSizeLimit() <= 0 ? sizeLimit : (sizeLimit <= 0 ? clientConnection.getSizeLimit() : Math.min(sizeLimit, clientConnection.getSizeLimit()));
        this.timeLimit = clientConnection.getTimeLimit() <= 0 ? timeLimit : (timeLimit <= 0 ? clientConnection.getTimeLimit() : Math.min(timeLimit, clientConnection.getTimeLimit()));
        this.entriesSent = 0;
        this.referencesSent = 0;
        this.responseControls = new ArrayList<Control>();
        this.cancelRequest = null;
        this.clientAcceptsReferrals = true;
        this.includeUsableControl = false;
        this.responseSent = new AtomicBoolean(false);
        this.persistentSearch = null;
        this.returnLDAPSubentries = false;
        this.matchedValuesControl = null;
    }

    @Override
    public final ByteString getRawBaseDN() {
        return this.rawBaseDN;
    }

    @Override
    public final void setRawBaseDN(ByteString rawBaseDN) {
        this.rawBaseDN = rawBaseDN;
        this.baseDN = null;
    }

    @Override
    public final DN getBaseDN() {
        try {
            if (this.baseDN == null) {
                this.baseDN = DN.decode(this.rawBaseDN);
            }
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            this.setResultCode(de.getResultCode());
            this.appendErrorMessage(de.getMessageObject());
            this.setMatchedDN(de.getMatchedDN());
            this.setReferralURLs(de.getReferralURLs());
        }
        return this.baseDN;
    }

    @Override
    public final void setBaseDN(DN baseDN) {
        this.baseDN = baseDN;
    }

    @Override
    public final SearchScope getScope() {
        return this.scope;
    }

    @Override
    public final void setScope(SearchScope scope) {
        this.scope = scope;
    }

    @Override
    public final DereferencePolicy getDerefPolicy() {
        return this.derefPolicy;
    }

    @Override
    public final void setDerefPolicy(DereferencePolicy derefPolicy) {
        this.derefPolicy = derefPolicy;
    }

    @Override
    public final int getSizeLimit() {
        return this.sizeLimit;
    }

    @Override
    public final void setSizeLimit(int sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    @Override
    public final int getTimeLimit() {
        return this.timeLimit;
    }

    @Override
    public final void setTimeLimit(int timeLimit) {
        this.timeLimit = timeLimit;
    }

    @Override
    public final boolean getTypesOnly() {
        return this.typesOnly;
    }

    @Override
    public final void setTypesOnly(boolean typesOnly) {
        this.typesOnly = typesOnly;
    }

    @Override
    public final RawFilter getRawFilter() {
        return this.rawFilter;
    }

    @Override
    public final void setRawFilter(RawFilter rawFilter) {
        this.rawFilter = rawFilter;
        this.filter = null;
    }

    @Override
    public final SearchFilter getFilter() {
        try {
            if (this.filter == null) {
                this.filter = this.rawFilter.toSearchFilter();
            }
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            this.setResultCode(de.getResultCode());
            this.appendErrorMessage(de.getMessageObject());
            this.setMatchedDN(de.getMatchedDN());
            this.setReferralURLs(de.getReferralURLs());
        }
        return this.filter;
    }

    @Override
    public final LinkedHashSet<String> getAttributes() {
        return this.attributes;
    }

    @Override
    public final void setAttributes(LinkedHashSet<String> attributes) {
        if (attributes == null) {
            this.attributes.clear();
        } else {
            this.attributes = attributes;
        }
    }

    @Override
    public final int getEntriesSent() {
        return this.entriesSent;
    }

    @Override
    public final int getReferencesSent() {
        return this.referencesSent;
    }

    @Override
    public final boolean returnEntry(Entry entry, List<Control> controls) {
        Entry entryToReturn;
        boolean typesOnly;
        block54: {
            typesOnly = this.getTypesOnly();
            if (this.getCancelRequest() != null) {
                this.setResultCode(ResultCode.CANCELED);
                return false;
            }
            if (this.getSizeLimit() > 0 && this.getEntriesSent() >= this.getSizeLimit()) {
                this.setResultCode(ResultCode.SIZE_LIMIT_EXCEEDED);
                this.appendErrorMessage(CoreMessages.ERR_SEARCH_SIZE_LIMIT_EXCEEDED.get(this.getSizeLimit()));
                return false;
            }
            if (this.getTimeLimit() > 0 && TimeThread.getTime() >= this.getTimeLimitExpiration()) {
                this.setResultCode(ResultCode.TIME_LIMIT_EXCEEDED);
                this.appendErrorMessage(CoreMessages.ERR_SEARCH_TIME_LIMIT_EXCEEDED.get(this.getTimeLimit()));
                return false;
            }
            if (this.getScope() != SearchScope.BASE_OBJECT && !this.isReturnLDAPSubentries() && entry.isLDAPSubentry()) {
                SearchFilter filter = this.getFilter();
                block3 : switch (filter.getFilterType()) {
                    case AND: 
                    case OR: {
                        for (SearchFilter f : filter.getFilterComponents()) {
                            if (f.getFilterType() != FilterType.EQUALITY || !f.getAttributeType().isObjectClassType()) continue;
                            AttributeValue v = f.getAssertionValue();
                            if (!StaticUtils.toLowerCase(v.getStringValue()).equals("ldapsubentry")) break block3;
                            this.setReturnLDAPSubentries(true);
                            break block3;
                        }
                        break;
                    }
                    case EQUALITY: {
                        AttributeValue v;
                        AttributeType t = filter.getAttributeType();
                        if (!t.isObjectClassType() || !StaticUtils.toLowerCase((v = filter.getAssertionValue()).getStringValue()).equals("ldapsubentry")) break;
                        this.setReturnLDAPSubentries(true);
                    }
                }
                if (!this.isReturnLDAPSubentries()) {
                    return true;
                }
            }
            if (this.isIncludeUsableControl()) {
                try {
                    PasswordPolicyState pwpState = new PasswordPolicyState(entry, false, false);
                    boolean isInactive = pwpState.isDisabled() || pwpState.isAccountExpired();
                    boolean isLocked = pwpState.lockedDueToFailures() || pwpState.lockedDueToMaximumResetAge() || pwpState.lockedDueToIdleInterval();
                    boolean isReset = pwpState.mustChangePassword();
                    boolean isExpired = pwpState.isPasswordExpired();
                    if (isInactive || isLocked || isReset || isExpired) {
                        int secondsBeforeUnlock = pwpState.getSecondsUntilUnlock();
                        int remainingGraceLogins = pwpState.getGraceLoginsRemaining();
                        if (controls == null) {
                            controls = new ArrayList<Control>(1);
                        }
                        controls.add(new AccountUsableResponseControl(isInactive, isReset, isExpired, remainingGraceLogins, isLocked, secondsBeforeUnlock));
                    } else {
                        if (controls == null) {
                            controls = new ArrayList<Control>(1);
                        }
                        int secondsBeforeExpiration = pwpState.getSecondsUntilExpiration();
                        controls.add(new AccountUsableResponseControl(secondsBeforeExpiration));
                    }
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block54;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
        SearchResultEntry tmpSearchEntry = new SearchResultEntry(entry, controls);
        if (!AccessControlConfigManager.getInstance().getAccessControlHandler().maySend(this, tmpSearchEntry)) {
            return true;
        }
        if (this.getAttributes() == null || this.getAttributes().isEmpty()) {
            entryToReturn = entry.duplicateWithoutOperationalAttributes(typesOnly, true);
        } else {
            entryToReturn = entry.duplicateWithoutAttributes();
            block11: for (String attrName : this.getAttributes()) {
                HashSet<String> options;
                String lowerName;
                if (attrName.equals("*")) {
                    if (typesOnly) {
                        AttributeType ocType = DirectoryServer.getObjectClassAttributeType();
                        ArrayList<Attribute> ocList = new ArrayList<Attribute>(1);
                        ocList.add(new Attribute(ocType));
                        entryToReturn.putAttribute(ocType, ocList);
                    } else {
                        Attribute ocAttr = entry.getObjectClassAttribute();
                        try {
                            entryToReturn.setObjectClasses(ocAttr.getValues());
                        }
                        catch (DirectoryException e) {
                            // empty catch block
                        }
                    }
                    for (AttributeType t : entry.getUserAttributes().keySet()) {
                        List<Attribute> attrList = entry.duplicateUserAttribute(t, null, typesOnly);
                        entryToReturn.putAttribute(t, attrList);
                    }
                    continue;
                }
                if (attrName.equals("+")) {
                    for (AttributeType t : entry.getOperationalAttributes().keySet()) {
                        List<Attribute> attrList = entry.duplicateOperationalAttribute(t, null, typesOnly);
                        entryToReturn.putAttribute(t, attrList);
                    }
                    continue;
                }
                int semicolonPos = attrName.indexOf(59);
                if (semicolonPos > 0) {
                    lowerName = StaticUtils.toLowerCase(attrName.substring(0, semicolonPos));
                    int nextPos = attrName.indexOf(59, semicolonPos + 1);
                    options = new HashSet<String>();
                    while (nextPos > 0) {
                        options.add(attrName.substring(semicolonPos + 1, nextPos));
                        semicolonPos = nextPos;
                        nextPos = attrName.indexOf(59, semicolonPos + 1);
                    }
                    options.add(attrName.substring(semicolonPos + 1));
                } else {
                    lowerName = StaticUtils.toLowerCase(attrName);
                    options = null;
                }
                AttributeType attrType = DirectoryServer.getAttributeType(lowerName);
                if (attrType == null) {
                    List<Attribute> attrList;
                    boolean added = false;
                    for (AttributeType t : entry.getUserAttributes().keySet()) {
                        if (!t.hasNameOrOID(lowerName) || (attrList = entry.duplicateUserAttribute(t, options, typesOnly)) == null) continue;
                        entryToReturn.putAttribute(t, attrList);
                        added = true;
                        break;
                    }
                    if (added) continue;
                    for (AttributeType t : entry.getOperationalAttributes().keySet()) {
                        if (!t.hasNameOrOID(lowerName) || (attrList = entry.duplicateOperationalAttribute(t, options, typesOnly)) == null) continue;
                        entryToReturn.putAttribute(t, attrList);
                        continue block11;
                    }
                    continue;
                }
                if (attrType.isObjectClassType()) {
                    if (typesOnly) {
                        AttributeType ocType = DirectoryServer.getObjectClassAttributeType();
                        ArrayList<Attribute> ocList = new ArrayList<Attribute>(1);
                        ocList.add(new Attribute(ocType));
                        entryToReturn.putAttribute(ocType, ocList);
                        continue;
                    }
                    ArrayList<Attribute> attrList = new ArrayList<Attribute>(1);
                    attrList.add(entry.getObjectClassAttribute());
                    entryToReturn.putAttribute(attrType, attrList);
                    continue;
                }
                List<Attribute> attrList = entry.duplicateOperationalAttribute(attrType, options, typesOnly);
                if (attrList == null) {
                    attrList = entry.duplicateUserAttribute(attrType, options, typesOnly);
                }
                if (attrList == null) continue;
                entryToReturn.putAttribute(attrType, attrList);
            }
        }
        if (this.isRealAttributesOnly()) {
            entryToReturn.stripVirtualAttributes();
        } else if (this.isVirtualAttributesOnly()) {
            entryToReturn.stripRealAttributes();
        }
        MatchedValuesControl matchedValuesControl = this.getMatchedValuesControl();
        if (matchedValuesControl != null && !typesOnly) {
            AttributeValue v;
            Iterator valueIterator;
            AttributeType attrType = DirectoryServer.getObjectClassAttributeType();
            Iterator<String> ocIterator = entryToReturn.getObjectClasses().values().iterator();
            while (ocIterator.hasNext()) {
                String ocName = ocIterator.next();
                AttributeValue v2 = new AttributeValue(attrType, (ByteString)new ASN1OctetString(ocName));
                if (matchedValuesControl.valueMatches(attrType, v2)) continue;
                ocIterator.remove();
            }
            for (AttributeType t : entryToReturn.getUserAttributes().keySet()) {
                for (Attribute a : entryToReturn.getUserAttribute(t)) {
                    valueIterator = a.getValues().iterator();
                    while (valueIterator.hasNext()) {
                        v = (AttributeValue)valueIterator.next();
                        if (matchedValuesControl.valueMatches(t, v)) continue;
                        valueIterator.remove();
                    }
                }
            }
            for (AttributeType t : entryToReturn.getOperationalAttributes().keySet()) {
                for (Attribute a : entryToReturn.getOperationalAttribute(t)) {
                    valueIterator = a.getValues().iterator();
                    while (valueIterator.hasNext()) {
                        v = (AttributeValue)valueIterator.next();
                        if (matchedValuesControl.valueMatches(t, v)) continue;
                        valueIterator.remove();
                    }
                }
            }
        }
        SearchResultEntry searchEntry = new SearchResultEntry(entryToReturn, controls);
        searchEntry = AccessControlConfigManager.getInstance().getAccessControlHandler().filterEntry(this, searchEntry);
        SearchEntryPluginResult pluginResult = DirectoryServer.getPluginConfigManager().invokeSearchResultEntryPlugins(this, searchEntry);
        if (pluginResult.connectionTerminated()) {
            this.setResultCode(ResultCode.CANCELED);
            this.appendErrorMessage(CoreMessages.ERR_CANCELED_BY_SEARCH_ENTRY_DISCONNECT.get(String.valueOf(entry.getDN())));
            return false;
        }
        if (pluginResult.sendEntry()) {
            try {
                this.sendSearchEntry(searchEntry);
                AccessLogger.logSearchResultEntry(this, searchEntry);
                this.incrementEntriesSent();
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                this.setResponseData(de);
                return false;
            }
        }
        return pluginResult.continueSearch();
    }

    @Override
    public final boolean returnReference(DN dn, SearchResultReference reference) {
        if (this.getCancelRequest() != null) {
            this.setResultCode(ResultCode.CANCELED);
            return false;
        }
        if (this.getTimeLimit() > 0 && TimeThread.getTime() >= this.getTimeLimitExpiration()) {
            this.setResultCode(ResultCode.TIME_LIMIT_EXCEEDED);
            this.appendErrorMessage(CoreMessages.ERR_SEARCH_TIME_LIMIT_EXCEEDED.get(this.getTimeLimit()));
            return false;
        }
        if (!this.isClientAcceptsReferrals()) {
            return true;
        }
        if (!AccessControlConfigManager.getInstance().getAccessControlHandler().maySend(dn, this, reference)) {
            return true;
        }
        SearchReferencePluginResult pluginResult = DirectoryServer.getPluginConfigManager().invokeSearchResultReferencePlugins(this, reference);
        if (pluginResult.connectionTerminated()) {
            this.setResultCode(ResultCode.CANCELED);
            this.appendErrorMessage(CoreMessages.ERR_CANCELED_BY_SEARCH_REF_DISCONNECT.get(String.valueOf(reference.getReferralURLString())));
            return false;
        }
        if (pluginResult.sendReference()) {
            try {
                if (this.sendSearchReference(reference)) {
                    AccessLogger.logSearchResultReference(this, reference);
                    this.incrementReferencesSent();
                } else {
                    this.setClientAcceptsReferrals(false);
                }
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                this.setResponseData(de);
                return false;
            }
        }
        return pluginResult.continueSearch();
    }

    @Override
    public final void sendSearchResultDone() {
        if (this.responseSent.compareAndSet(false, true)) {
            this.clientConnection.sendResponse(this);
            AccessLogger.logSearchResultDone(this);
            this.invokePostResponsePlugins();
        }
    }

    @Override
    public final OperationType getOperationType() {
        return OperationType.SEARCH;
    }

    @Override
    public final void disconnectClient(DisconnectReason disconnectReason, boolean sendNotification, Message message) {
        this.setCancelResult(CancelResult.CANCELED);
        this.clientConnection.disconnect(disconnectReason, sendNotification, message);
    }

    @Override
    public final String[][] getRequestLogElements() {
        String attrs;
        if (this.attributes == null || this.attributes.isEmpty()) {
            attrs = null;
        } else {
            StringBuilder attrBuffer = new StringBuilder();
            Iterator iterator = this.attributes.iterator();
            attrBuffer.append((String)iterator.next());
            while (iterator.hasNext()) {
                attrBuffer.append(", ");
                attrBuffer.append((String)iterator.next());
            }
            attrs = attrBuffer.toString();
        }
        return new String[][]{{"baseDN", String.valueOf(this.rawBaseDN)}, {"scope", String.valueOf((Object)this.scope)}, {"sizeLimit", String.valueOf(this.sizeLimit)}, {"timeLimit", String.valueOf(this.timeLimit)}, {"filter", String.valueOf(this.rawFilter)}, {"attributes", attrs}};
    }

    @Override
    public final String[][] getResponseLogElements() {
        String referrals;
        String resultCode = String.valueOf(this.getResultCode().getIntValue());
        MessageBuilder errorMessageBuffer = this.getErrorMessage();
        String errorMessage = errorMessageBuffer == null ? null : errorMessageBuffer.toString();
        DN matchedDN = this.getMatchedDN();
        String matchedDNStr = matchedDN == null ? null : matchedDN.toString();
        List<String> referralURLs = this.getReferralURLs();
        if (referralURLs == null || referralURLs.isEmpty()) {
            referrals = null;
        } else {
            StringBuilder buffer = new StringBuilder();
            Iterator<String> iterator = referralURLs.iterator();
            buffer.append(iterator.next());
            while (iterator.hasNext()) {
                buffer.append(", ");
                buffer.append(iterator.next());
            }
            referrals = buffer.toString();
        }
        String processingTime = String.valueOf(this.processingStopTime - this.processingStartTime);
        return new String[][]{{"resultCode", resultCode}, {"errorMessage", errorMessage}, {"matchedDN", matchedDNStr}, {"referralURLs", referrals}, {"entriesSent", String.valueOf(this.entriesSent)}, {"referencesSent", String.valueOf(this.referencesSent)}, {"processingTime", processingTime}};
    }

    @Override
    public DN getProxiedAuthorizationDN() {
        return this.proxiedAuthorizationDN;
    }

    @Override
    public final List<Control> getResponseControls() {
        return this.responseControls;
    }

    @Override
    public final void addResponseControl(Control control) {
        this.responseControls.add(control);
    }

    @Override
    public final void removeResponseControl(Control control) {
        this.responseControls.remove(control);
    }

    @Override
    public final CancelResult cancel(CancelRequest cancelRequest) {
        this.cancelRequest = cancelRequest;
        if (this.persistentSearch != null) {
            DirectoryServer.deregisterPersistentSearch(this.persistentSearch);
            this.persistentSearch = null;
        }
        CancelResult cancelResult = this.getCancelResult();
        long stopWaitingTime = System.currentTimeMillis() + 5000L;
        while (cancelResult == null && System.currentTimeMillis() < stopWaitingTime) {
            block5: {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block5;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            cancelResult = this.getCancelResult();
        }
        if (cancelResult == null) {
            cancelResult = CancelResult.CANNOT_CANCEL;
        }
        return cancelResult;
    }

    @Override
    public final CancelRequest getCancelRequest() {
        return this.cancelRequest;
    }

    @Override
    public boolean setCancelRequest(CancelRequest cancelRequest) {
        this.cancelRequest = cancelRequest;
        return true;
    }

    @Override
    public final void toString(StringBuilder buffer) {
        buffer.append("SearchOperation(connID=");
        buffer.append(this.clientConnection.getConnectionID());
        buffer.append(", opID=");
        buffer.append(this.operationID);
        buffer.append(", baseDN=");
        buffer.append(this.rawBaseDN);
        buffer.append(", scope=");
        buffer.append(this.scope.toString());
        buffer.append(", filter=");
        buffer.append(this.rawFilter.toString());
        buffer.append(")");
    }

    @Override
    public void setTimeLimitExpiration(Long timeLimitExpiration) {
        this.timeLimitExpiration = timeLimitExpiration;
    }

    @Override
    public boolean isReturnLDAPSubentries() {
        return this.returnLDAPSubentries;
    }

    @Override
    public void setReturnLDAPSubentries(boolean returnLDAPSubentries) {
        this.returnLDAPSubentries = returnLDAPSubentries;
    }

    @Override
    public MatchedValuesControl getMatchedValuesControl() {
        return this.matchedValuesControl;
    }

    @Override
    public void setMatchedValuesControl(MatchedValuesControl controls) {
        this.matchedValuesControl = controls;
    }

    @Override
    public PersistentSearch getPersistentSearch() {
        return this.persistentSearch;
    }

    @Override
    public boolean isIncludeUsableControl() {
        return this.includeUsableControl;
    }

    @Override
    public void setIncludeUsableControl(boolean includeUsableControl) {
        this.includeUsableControl = includeUsableControl;
    }

    @Override
    public void setPersistentSearch(PersistentSearch psearch) {
        this.persistentSearch = psearch;
    }

    @Override
    public Long getTimeLimitExpiration() {
        return this.timeLimitExpiration;
    }

    @Override
    public boolean isClientAcceptsReferrals() {
        return this.clientAcceptsReferrals;
    }

    @Override
    public void setClientAcceptsReferrals(boolean clientAcceptReferrals) {
        this.clientAcceptsReferrals = clientAcceptReferrals;
    }

    @Override
    public void incrementEntriesSent() {
        ++this.entriesSent;
    }

    @Override
    public void incrementReferencesSent() {
        ++this.referencesSent;
    }

    @Override
    public boolean isSendResponse() {
        return this.sendResponse;
    }

    @Override
    public void setSendResponse(boolean sendResponse) {
        this.sendResponse = sendResponse;
    }

    @Override
    public boolean isRealAttributesOnly() {
        return this.realAttributesOnly;
    }

    @Override
    public boolean isVirtualAttributesOnly() {
        return this.virtualAttributesOnly;
    }

    @Override
    public void setRealAttributesOnly(boolean realAttributesOnly) {
        this.realAttributesOnly = realAttributesOnly;
    }

    @Override
    public void setVirtualAttributesOnly(boolean virtualAttributesOnly) {
        this.virtualAttributesOnly = virtualAttributesOnly;
    }

    @Override
    public void sendSearchEntry(SearchResultEntry searchEntry) throws DirectoryException {
        this.getClientConnection().sendSearchEntry(this, searchEntry);
    }

    @Override
    public boolean sendSearchReference(SearchResultReference searchReference) throws DirectoryException {
        return this.getClientConnection().sendSearchReference(this, searchReference);
    }

    @Override
    public void setProxiedAuthorizationDN(DN proxiedAuthorizationDN) {
        this.proxiedAuthorizationDN = proxiedAuthorizationDN;
    }

    @Override
    public final void run() {
        this.setResultCode(ResultCode.UNDEFINED);
        this.setSendResponse(true);
        PluginConfigManager pluginConfigManager = DirectoryServer.getPluginConfigManager();
        this.setProcessingStartTime();
        int timeLimit = this.getTimeLimit();
        Long timeLimitExpiration = timeLimit <= 0 ? Long.valueOf(Long.MAX_VALUE) : Long.valueOf(this.getProcessingStartTime() + 1000L * (long)timeLimit);
        this.setTimeLimitExpiration(timeLimitExpiration);
        if (this.cancelRequest != null) {
            this.indicateCancelled(this.cancelRequest);
            this.setProcessingStopTime();
            AccessLogger.logSearchResultDone(this);
            return;
        }
        PreParsePluginResult preParseResult = pluginConfigManager.invokePreParseSearchPlugins(this);
        if (preParseResult.connectionTerminated()) {
            this.setResultCode(ResultCode.CANCELED);
            this.appendErrorMessage(CoreMessages.ERR_CANCELED_BY_PREPARSE_DISCONNECT.get());
            this.setProcessingStopTime();
            AccessLogger.logSearchRequest(this);
            AccessLogger.logSearchResultDone(this);
            pluginConfigManager.invokePostResponseSearchPlugins(this);
            return;
        }
        if (preParseResult.sendResponseImmediately()) {
            AccessLogger.logSearchRequest(this);
        } else if (!preParseResult.skipCoreProcessing()) {
            DN baseDN;
            AccessLogger.logSearchRequest(this);
            if (this.cancelRequest == null && (baseDN = this.getBaseDN()) != null) {
                NetworkGroup ng = this.getClientConnection().getNetworkGroup();
                Workflow workflow = ng.getWorkflowCandidate(baseDN);
                if (workflow == null) {
                    this.updateOperationErrMsgAndResCode();
                } else {
                    workflow.execute(this);
                }
            }
        }
        if (this.getCancelResult() == CancelResult.CANCELED) {
            this.setProcessingStopTime();
            AccessLogger.logSearchResultDone(this);
            return;
        }
        if (this.cancelRequest != null) {
            this.indicateCancelled(this.cancelRequest);
            this.setProcessingStopTime();
            AccessLogger.logSearchResultDone(this);
            this.invokePostResponsePlugins();
            return;
        }
        this.setCancelResult(CancelResult.TOO_LATE);
        this.setProcessingStopTime();
        if (this.isSendResponse()) {
            this.sendSearchResultDone();
        } else {
            this.setSizeLimit(0);
            this.setTimeLimit(0);
        }
    }

    private void invokePostResponsePlugins() {
        PluginConfigManager pluginConfigManager = DirectoryServer.getPluginConfigManager();
        pluginConfigManager.invokePostResponseSearchPlugins(this);
    }

    private void updateOperationErrMsgAndResCode() {
        this.setResultCode(ResultCode.NO_SUCH_OBJECT);
        Message message = CoreMessages.ERR_SEARCH_BASE_DOESNT_EXIST.get(String.valueOf(this.getBaseDN()));
        this.appendErrorMessage(message);
    }
}

