/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.Mac;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.Configuration;
import org.opends.server.api.AlertGenerator;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConfigAddListener;
import org.opends.server.api.ConfigChangeListener;
import org.opends.server.api.ConfigDeleteListener;
import org.opends.server.api.ConfigHandler;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.schema.GeneralizedTimeSyntax;
import org.opends.server.tools.LDIFModify;
import org.opends.server.types.AttributeType;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.BackupInfo;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.CryptoManager;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.LDIFImportResult;
import org.opends.server.types.Modification;
import org.opends.server.types.Privilege;
import org.opends.server.types.RestoreConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.util.LDIFException;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigFileHandler
extends ConfigHandler
implements AlertGenerator {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String CLASS_NAME = "org.opends.server.extensions.ConfigFileHandler";
    private static final Privilege[] CONFIG_READ_AND_WRITE = new Privilege[]{Privilege.CONFIG_READ, Privilege.CONFIG_WRITE};
    private byte[] configurationDigest;
    private ConcurrentHashMap<DN, ConfigEntry> configEntries;
    private ConfigEntry configRootEntry;
    private DN[] baseDNs;
    private ReentrantLock configLock;
    private String configFile;
    private String serverRoot;

    @Override
    public void initializeConfigHandler(String configFile, boolean checkSchema) throws InitializationException {
        Message message;
        block92: {
            File rootFile;
            Entry entry;
            LDIFReader reader;
            this.configLock = new ReentrantLock();
            this.configFile = configFile;
            File f = new File(configFile);
            try {
                if (!f.exists()) {
                    Message message2 = ConfigMessages.ERR_CONFIG_FILE_DOES_NOT_EXIST.get(configFile);
                    throw new InitializationException(message2);
                }
            }
            catch (InitializationException ie) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ie);
                }
                throw ie;
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message3 = ConfigMessages.ERR_CONFIG_FILE_CANNOT_VERIFY_EXISTENCE.get(configFile, String.valueOf(e));
                throw new InitializationException(message3);
            }
            try {
                this.configurationDigest = this.calculateConfigDigest();
            }
            catch (DirectoryException de) {
                throw new InitializationException(de.getMessageObject(), de.getCause());
            }
            File archiveDirectory = new File(f.getParent(), "archived-configs");
            if (archiveDirectory.exists()) {
                try {
                    byte[] lastDigest = this.getLastConfigDigest(archiveDirectory);
                    if (!Arrays.equals(this.configurationDigest, lastDigest)) {
                        this.writeConfigArchive();
                    }
                }
                catch (Exception e) {}
            } else {
                this.writeConfigArchive();
            }
            File changesFile = new File(f.getParent(), "config-changes.ldif");
            try {
                if (changesFile.exists()) {
                    this.applyChangesFile(f, changesFile);
                    this.configurationDigest = this.calculateConfigDigest();
                    this.writeConfigArchive();
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message4 = ConfigMessages.ERR_CONFIG_UNABLE_TO_APPLY_STARTUP_CHANGES.get(changesFile.getAbsolutePath(), String.valueOf(e));
                throw new InitializationException(message4, (Throwable)e);
            }
            try {
                LDIFImportConfig importConfig = new LDIFImportConfig(configFile);
                reader = new LDIFReader(importConfig);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message5 = ConfigMessages.ERR_CONFIG_FILE_CANNOT_OPEN_FOR_READ.get(configFile, String.valueOf(e));
                throw new InitializationException(message5, (Throwable)e);
            }
            try {
                entry = reader.readEntry(checkSchema);
            }
            catch (LDIFException le) {
                block81: {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, le);
                    }
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block81;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                Message message6 = ConfigMessages.ERR_CONFIG_FILE_INVALID_LDIF_ENTRY.get(le.getLineNumber(), configFile, String.valueOf(le));
                throw new InitializationException(message6, (Throwable)le);
            }
            catch (Exception e) {
                block82: {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    try {
                        reader.close();
                    }
                    catch (Exception e2) {
                        if (!DebugLogger.debugEnabled()) break block82;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e2);
                    }
                }
                Message message7 = ConfigMessages.ERR_CONFIG_FILE_READ_ERROR.get(configFile, String.valueOf(e));
                throw new InitializationException(message7, (Throwable)e);
            }
            if (entry == null) {
                block83: {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block83;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                Message message8 = ConfigMessages.ERR_CONFIG_FILE_EMPTY.get(configFile);
                throw new InitializationException(message8);
            }
            try {
                DN configRootDN = DN.decode("cn=config");
                if (!entry.getDN().equals(configRootDN)) {
                    Message message9 = ConfigMessages.ERR_CONFIG_FILE_INVALID_BASE_DN.get(configFile, entry.getDN().toString(), "cn=config");
                    throw new InitializationException(message9);
                }
            }
            catch (InitializationException ie) {
                block84: {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, ie);
                    }
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block84;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                throw ie;
            }
            catch (Exception e) {
                block85: {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    try {
                        reader.close();
                    }
                    catch (Exception e2) {
                        if (!DebugLogger.debugEnabled()) break block85;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e2);
                    }
                }
                Message message10 = ConfigMessages.ERR_CONFIG_FILE_GENERIC_ERROR.get(configFile, String.valueOf(e));
                throw new InitializationException(message10, (Throwable)e);
            }
            this.configEntries = new ConcurrentHashMap();
            this.configRootEntry = new ConfigEntry(entry, null);
            this.configEntries.put(entry.getDN(), this.configRootEntry);
            while (true) {
                Message message11;
                try {
                    entry = reader.readEntry(checkSchema);
                }
                catch (LDIFException le) {
                    block86: {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, le);
                        }
                        try {
                            reader.close();
                        }
                        catch (Exception e) {
                            if (!DebugLogger.debugEnabled()) break block86;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                    message11 = ConfigMessages.ERR_CONFIG_FILE_INVALID_LDIF_ENTRY.get(le.getLineNumber(), configFile, String.valueOf(le));
                    throw new InitializationException(message11, (Throwable)le);
                }
                catch (Exception e) {
                    block87: {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        try {
                            reader.close();
                        }
                        catch (Exception e2) {
                            if (!DebugLogger.debugEnabled()) break block87;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e2);
                        }
                    }
                    message11 = ConfigMessages.ERR_CONFIG_FILE_READ_ERROR.get(configFile, String.valueOf(e));
                    throw new InitializationException(message11, (Throwable)e);
                }
                if (entry == null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    break;
                }
                DN entryDN = entry.getDN();
                if (this.configEntries.containsKey(entryDN)) {
                    block88: {
                        try {
                            reader.close();
                        }
                        catch (Exception e) {
                            if (!DebugLogger.debugEnabled()) break block88;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                    message11 = ConfigMessages.ERR_CONFIG_FILE_DUPLICATE_ENTRY.get(entryDN.toString(), String.valueOf(reader.getLastEntryLineNumber()), configFile);
                    throw new InitializationException(message11);
                }
                DN parentDN = entryDN.getParent();
                if (parentDN == null) {
                    block89: {
                        try {
                            reader.close();
                        }
                        catch (Exception e) {
                            if (!DebugLogger.debugEnabled()) break block89;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                    message = ConfigMessages.ERR_CONFIG_FILE_UNKNOWN_PARENT.get(entryDN.toString(), reader.getLastEntryLineNumber(), configFile);
                    throw new InitializationException(message);
                }
                ConfigEntry parentEntry = this.configEntries.get(parentDN);
                if (parentEntry == null) {
                    block90: {
                        try {
                            reader.close();
                        }
                        catch (Exception e) {
                            if (!DebugLogger.debugEnabled()) break block90;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                    Message message12 = ConfigMessages.ERR_CONFIG_FILE_NO_PARENT.get(entryDN.toString(), reader.getLastEntryLineNumber(), configFile, parentDN.toString());
                    throw new InitializationException(message12);
                }
                try {
                    ConfigEntry configEntry = new ConfigEntry(entry, parentEntry);
                    parentEntry.addChild(configEntry);
                    this.configEntries.put(entryDN, configEntry);
                }
                catch (Exception e) {
                    block91: {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        try {
                            reader.close();
                        }
                        catch (Exception e2) {
                            if (!DebugLogger.debugEnabled()) break block91;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e2);
                        }
                    }
                    Message message13 = ConfigMessages.ERR_CONFIG_FILE_GENERIC_ERROR.get(configFile, String.valueOf(e));
                    throw new InitializationException(message13, (Throwable)e);
                }
            }
            if ((rootFile = DirectoryServer.getEnvironmentConfig().getServerRoot()) == null) {
                try {
                    File configDirFile = new File(configFile).getParentFile();
                    if (configDirFile != null && configDirFile.getName().equals("config")) {
                        this.serverRoot = configDirFile.getParentFile().getAbsolutePath();
                    }
                    if (this.serverRoot == null) {
                        message = ConfigMessages.ERR_CONFIG_CANNOT_DETERMINE_SERVER_ROOT.get("INSTANCE_ROOT");
                        throw new InitializationException(message);
                    }
                    break block92;
                }
                catch (InitializationException ie) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, ie);
                    }
                    throw ie;
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    message = ConfigMessages.ERR_CONFIG_CANNOT_DETERMINE_SERVER_ROOT.get("INSTANCE_ROOT");
                    throw new InitializationException(message);
                }
            }
            this.serverRoot = rootFile.getAbsolutePath();
        }
        DirectoryServer.registerAlertGenerator(this);
        this.baseDNs = new DN[]{this.configRootEntry.getDN()};
        try {
            DirectoryServer.registerBaseDN(this.configRootEntry.getDN(), this, true, false);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            message = ConfigMessages.ERR_CONFIG_CANNOT_REGISTER_AS_PRIVATE_SUFFIX.get(String.valueOf(this.configRootEntry.getDN()), StaticUtils.getExceptionMessage(e));
            throw new InitializationException(message, (Throwable)e);
        }
    }

    private byte[] calculateConfigDigest() throws DirectoryException {
        InputStream inputStream = null;
        try {
            int bytesRead;
            MessageDigest sha1Digest = MessageDigest.getInstance("SHA-1");
            inputStream = new FileInputStream(this.configFile);
            byte[] buffer = new byte[8192];
            while ((bytesRead = inputStream.read(buffer)) >= 0) {
                sha1Digest.update(buffer, 0, bytesRead);
            }
            byte[] byArray = sha1Digest.digest();
            return byArray;
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_CANNOT_CALCULATE_DIGEST.get(this.configFile, StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private byte[] getLastConfigDigest(File archiveDirectory) throws DirectoryException {
        int latestCounter = 0;
        long latestTimestamp = -1L;
        String latestFileName = null;
        for (String name : archiveDirectory.list()) {
            long timestamp;
            ASN1OctetString ts;
            int dotPos;
            if (!name.startsWith("config-") || (dotPos = name.indexOf(46, 7)) < 0) continue;
            int dashPos = name.indexOf(45, 7);
            if (dashPos < 0) {
                try {
                    ts = new ASN1OctetString(name.substring(7, dotPos));
                    timestamp = GeneralizedTimeSyntax.decodeGeneralizedTimeValue(ts);
                    if (timestamp <= latestTimestamp) continue;
                    latestFileName = name;
                    latestTimestamp = timestamp;
                    latestCounter = 0;
                }
                catch (Exception e) {}
                continue;
            }
            try {
                ts = new ASN1OctetString(name.substring(7, dashPos));
                timestamp = GeneralizedTimeSyntax.decodeGeneralizedTimeValue(ts);
                int counter = Integer.parseInt(name.substring(dashPos + 1, dotPos));
                if (timestamp > latestTimestamp) {
                    latestFileName = name;
                    latestTimestamp = timestamp;
                    latestCounter = counter;
                    continue;
                }
                if (timestamp != latestTimestamp || counter <= latestCounter) continue;
                latestFileName = name;
                latestTimestamp = timestamp;
                latestCounter = counter;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (latestFileName == null) {
            return null;
        }
        File latestFile = new File(archiveDirectory, latestFileName);
        try {
            int bytesRead;
            MessageDigest sha1Digest = MessageDigest.getInstance("SHA-1");
            GZIPInputStream inputStream = new GZIPInputStream(new FileInputStream(latestFile));
            byte[] buffer = new byte[8192];
            while ((bytesRead = inputStream.read(buffer)) >= 0) {
                sha1Digest.update(buffer, 0, bytesRead);
            }
            return sha1Digest.digest();
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_CANNOT_CALCULATE_DIGEST.get(latestFile.getAbsolutePath(), StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
    }

    private void applyChangesFile(File sourceFile, File changesFile) throws IOException, LDIFException {
        LDIFImportConfig importConfig = new LDIFImportConfig(sourceFile.getAbsolutePath());
        importConfig.setValidateSchema(false);
        LDIFReader sourceReader = new LDIFReader(importConfig);
        importConfig = new LDIFImportConfig(changesFile.getAbsolutePath());
        importConfig.setValidateSchema(false);
        LDIFReader changesReader = new LDIFReader(importConfig);
        String tempFile = changesFile.getAbsolutePath() + ".tmp";
        LDIFExportConfig exportConfig = new LDIFExportConfig(tempFile, ExistingFileBehavior.OVERWRITE);
        LDIFWriter targetWriter = new LDIFWriter(exportConfig);
        LinkedList<Message> errorList = new LinkedList<Message>();
        boolean successful = LDIFModify.modifyLDIF(sourceReader, changesReader, targetWriter, errorList);
        try {
            sourceReader.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            changesReader.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            targetWriter.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!successful) {
            for (Message s : errorList) {
                Message message = ConfigMessages.ERR_CONFIG_ERROR_APPLYING_STARTUP_CHANGE.get(s);
                ErrorLogger.logError(message);
            }
            Message message = ConfigMessages.ERR_CONFIG_UNABLE_TO_APPLY_CHANGES_FILE.get();
            throw new LDIFException(message);
        }
        File oldSource = new File(sourceFile.getAbsolutePath() + ".prechanges");
        if (oldSource.exists()) {
            oldSource.delete();
        }
        sourceFile.renameTo(oldSource);
        new File(tempFile).renameTo(sourceFile);
        File newChanges = new File(changesFile.getAbsolutePath() + ".applied");
        if (newChanges.exists()) {
            newChanges.delete();
        }
        changesFile.renameTo(newChanges);
    }

    @Override
    public void finalizeConfigHandler() {
        block2: {
            try {
                DirectoryServer.deregisterBaseDN(this.configRootEntry.getDN(), false);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block2;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    @Override
    public void finalizeBackend() {
    }

    @Override
    public ConfigEntry getConfigRootEntry() throws ConfigException {
        return this.configRootEntry;
    }

    @Override
    public ConfigEntry getConfigEntry(DN entryDN) throws ConfigException {
        return this.configEntries.get(entryDN);
    }

    @Override
    public String getServerRoot() {
        return this.serverRoot;
    }

    @Override
    public void configureBackend(Configuration cfg) throws ConfigException {
    }

    @Override
    public void initializeBackend() throws ConfigException, InitializationException {
    }

    @Override
    public DN[] getBaseDNs() {
        return this.baseDNs;
    }

    @Override
    public long getEntryCount() {
        return this.configEntries.size();
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public Entry getEntry(DN entryDN) throws DirectoryException {
        ConfigEntry configEntry = this.configEntries.get(entryDN);
        if (configEntry == null) {
            return null;
        }
        return configEntry.getEntry().duplicate(true);
    }

    @Override
    public boolean entryExists(DN entryDN) throws DirectoryException {
        return this.configEntries.containsKey(entryDN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEntry(Entry entry, AddOperation addOperation) throws DirectoryException {
        ClientConnection clientConnection;
        Entry e = entry.duplicate(false);
        if (addOperation != null && !(clientConnection = addOperation.getClientConnection()).hasAllPrivileges(CONFIG_READ_AND_WRITE, addOperation)) {
            Message message = ConfigMessages.ERR_CONFIG_FILE_ADD_INSUFFICIENT_PRIVILEGES.get();
            throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, message);
        }
        this.configLock.lock();
        try {
            DN entryDN = e.getDN();
            if (this.configEntries.containsKey(entryDN)) {
                Message message = ConfigMessages.ERR_CONFIG_FILE_ADD_ALREADY_EXISTS.get(String.valueOf(entryDN));
                throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, message);
            }
            DN parentDN = entryDN.getParent();
            if (parentDN == null) {
                Message message = ConfigMessages.ERR_CONFIG_FILE_ADD_NO_PARENT_DN.get(String.valueOf(entryDN));
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message);
            }
            ConfigEntry parentEntry = this.configEntries.get(parentDN);
            if (parentEntry == null) {
                Message message = ConfigMessages.ERR_CONFIG_FILE_ADD_NO_PARENT.get(String.valueOf(entryDN), String.valueOf(parentDN));
                DN matchedDN = null;
                for (parentDN = parentDN.getParent(); parentDN != null; parentDN = parentDN.getParent()) {
                    if (!this.configEntries.containsKey(parentDN)) continue;
                    matchedDN = parentDN;
                    break;
                }
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, matchedDN, null);
            }
            ConfigEntry newEntry = new ConfigEntry(e, parentEntry);
            CopyOnWriteArrayList<ConfigAddListener> addListeners = parentEntry.getAddListeners();
            MessageBuilder unacceptableReason = new MessageBuilder();
            for (ConfigAddListener l : addListeners) {
                if (l.configAddIsAcceptable(newEntry, unacceptableReason)) continue;
                Message message = ConfigMessages.ERR_CONFIG_FILE_ADD_REJECTED_BY_LISTENER.get(String.valueOf(entryDN), String.valueOf(parentDN), String.valueOf(unacceptableReason));
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
            }
            try {
                parentEntry.addChild(newEntry);
                this.configEntries.put(entryDN, newEntry);
                this.writeUpdatedConfig();
            }
            catch (ConfigException ce) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ce);
                }
                Message message = ConfigMessages.ERR_CONFIG_FILE_ADD_FAILED.get(String.valueOf(entryDN), String.valueOf(parentDN), StaticUtils.getExceptionMessage(ce));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
            }
            ResultCode resultCode = ResultCode.SUCCESS;
            LinkedList<Message> messages = new LinkedList<Message>();
            for (ConfigAddListener l : addListeners) {
                ConfigChangeResult result = l.applyConfigurationAdd(newEntry);
                if (result.getResultCode() != ResultCode.SUCCESS) {
                    if (resultCode == ResultCode.SUCCESS) {
                        resultCode = result.getResultCode();
                    }
                    messages.addAll(result.getMessages());
                }
                this.handleConfigChangeResult(result, newEntry.getDN(), l.getClass().getName(), "applyConfigurationAdd");
            }
            if (resultCode != ResultCode.SUCCESS) {
                MessageBuilder buffer = new MessageBuilder();
                if (!messages.isEmpty()) {
                    Iterator iterator = messages.iterator();
                    buffer.append((Message)iterator.next());
                    while (iterator.hasNext()) {
                        buffer.append(".  ");
                        buffer.append((Message)iterator.next());
                    }
                }
                Message message = ConfigMessages.ERR_CONFIG_FILE_ADD_APPLY_FAILED.get(String.valueOf(buffer));
                throw new DirectoryException(resultCode, message);
            }
        }
        finally {
            this.configLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteEntry(DN entryDN, DeleteOperation deleteOperation) throws DirectoryException {
        ClientConnection clientConnection;
        if (deleteOperation != null && !(clientConnection = deleteOperation.getClientConnection()).hasAllPrivileges(CONFIG_READ_AND_WRITE, deleteOperation)) {
            Message message = ConfigMessages.ERR_CONFIG_FILE_DELETE_INSUFFICIENT_PRIVILEGES.get();
            throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, message);
        }
        this.configLock.lock();
        try {
            ConfigEntry entry = this.configEntries.get(entryDN);
            if (entry == null) {
                DN matchedDN = null;
                if (entryDN.isDescendantOf(this.configRootEntry.getDN())) {
                    for (DN parentDN = entryDN.getParent(); parentDN != null; parentDN = parentDN.getParent()) {
                        if (!this.configEntries.containsKey(parentDN)) continue;
                        matchedDN = parentDN;
                        break;
                    }
                }
                Message message = ConfigMessages.ERR_CONFIG_FILE_DELETE_NO_SUCH_ENTRY.get(String.valueOf(entryDN));
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, matchedDN, null);
            }
            if (entry.hasChildren()) {
                Message message = ConfigMessages.ERR_CONFIG_FILE_DELETE_HAS_CHILDREN.get(String.valueOf(entryDN));
                throw new DirectoryException(ResultCode.NOT_ALLOWED_ON_NONLEAF, message);
            }
            ConfigEntry parentEntry = entry.getParent();
            if (parentEntry == null) {
                Message message = ConfigMessages.ERR_CONFIG_FILE_DELETE_NO_PARENT.get(String.valueOf(entryDN));
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
            }
            CopyOnWriteArrayList<ConfigDeleteListener> deleteListeners = parentEntry.getDeleteListeners();
            MessageBuilder unacceptableReason = new MessageBuilder();
            for (ConfigDeleteListener l : deleteListeners) {
                if (l.configDeleteIsAcceptable(entry, unacceptableReason)) continue;
                Message message = ConfigMessages.ERR_CONFIG_FILE_DELETE_REJECTED.get(String.valueOf(entryDN), String.valueOf(parentEntry.getDN()), String.valueOf(unacceptableReason));
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
            }
            try {
                parentEntry.removeChild(entryDN);
                this.configEntries.remove(entryDN);
                this.writeUpdatedConfig();
            }
            catch (ConfigException ce) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ce);
                }
                Message message = ConfigMessages.ERR_CONFIG_FILE_DELETE_FAILED.get(String.valueOf(entryDN), String.valueOf(parentEntry.getDN()), StaticUtils.getExceptionMessage(ce));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
            }
            ResultCode resultCode = ResultCode.SUCCESS;
            LinkedList<Message> messages = new LinkedList<Message>();
            for (ConfigDeleteListener l : deleteListeners) {
                ConfigChangeResult result = l.applyConfigurationDelete(entry);
                if (result.getResultCode() != ResultCode.SUCCESS) {
                    if (resultCode == ResultCode.SUCCESS) {
                        resultCode = result.getResultCode();
                    }
                    messages.addAll(result.getMessages());
                }
                this.handleConfigChangeResult(result, entry.getDN(), l.getClass().getName(), "applyConfigurationDelete");
            }
            if (resultCode != ResultCode.SUCCESS) {
                StringBuilder buffer = new StringBuilder();
                if (!messages.isEmpty()) {
                    Iterator iterator = messages.iterator();
                    buffer.append((CharSequence)iterator.next());
                    while (iterator.hasNext()) {
                        buffer.append(".  ");
                        buffer.append((CharSequence)iterator.next());
                    }
                }
                Message message = ConfigMessages.ERR_CONFIG_FILE_DELETE_APPLY_FAILED.get(String.valueOf(buffer));
                throw new DirectoryException(resultCode, message);
            }
        }
        finally {
            this.configLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceEntry(Entry entry, ModifyOperation modifyOperation) throws DirectoryException {
        Entry e = entry.duplicate(false);
        if (modifyOperation != null) {
            ClientConnection clientConnection = modifyOperation.getClientConnection();
            if (!clientConnection.hasAllPrivileges(CONFIG_READ_AND_WRITE, modifyOperation)) {
                Message message = ConfigMessages.ERR_CONFIG_FILE_MODIFY_INSUFFICIENT_PRIVILEGES.get();
                throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, message);
            }
            AttributeType privType = DirectoryServer.getAttributeType("ds-cfg-default-root-privilege-name", true);
            for (Modification m : modifyOperation.getModifications()) {
                if (!m.getAttribute().getAttributeType().equals(privType)) continue;
                if (clientConnection.hasPrivilege(Privilege.PRIVILEGE_CHANGE, modifyOperation)) break;
                Message message = ConfigMessages.ERR_CONFIG_FILE_MODIFY_PRIVS_INSUFFICIENT_PRIVILEGES.get();
                throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, message);
            }
        }
        this.configLock.lock();
        try {
            DN entryDN = e.getDN();
            ConfigEntry currentEntry = this.configEntries.get(entryDN);
            if (currentEntry == null) {
                DN matchedDN = null;
                if (entryDN.isDescendantOf(this.configRootEntry.getDN())) {
                    for (DN parentDN = entryDN.getParent(); parentDN != null; parentDN = parentDN.getParent()) {
                        if (!this.configEntries.containsKey(parentDN)) continue;
                        matchedDN = parentDN;
                        break;
                    }
                }
                Message message = ConfigMessages.ERR_CONFIG_FILE_MODIFY_NO_SUCH_ENTRY.get(String.valueOf(entryDN));
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, matchedDN, null);
            }
            if (!currentEntry.getEntry().getStructuralObjectClass().equals(entry.getStructuralObjectClass())) {
                Message message = ConfigMessages.ERR_CONFIG_FILE_MODIFY_STRUCTURAL_CHANGE_NOT_ALLOWED.get(String.valueOf(entryDN));
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message);
            }
            ConfigEntry newEntry = new ConfigEntry(e, currentEntry.getParent());
            CopyOnWriteArrayList<ConfigChangeListener> changeListeners = currentEntry.getChangeListeners();
            MessageBuilder unacceptableReason = new MessageBuilder();
            for (ConfigChangeListener l : changeListeners) {
                if (l.configChangeIsAcceptable(newEntry, unacceptableReason)) continue;
                Message message = ConfigMessages.ERR_CONFIG_FILE_MODIFY_REJECTED_BY_CHANGE_LISTENER.get(String.valueOf(entryDN), String.valueOf(unacceptableReason));
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
            }
            currentEntry.setEntry(e);
            this.writeUpdatedConfig();
            ResultCode resultCode = ResultCode.SUCCESS;
            LinkedList<Message> messages = new LinkedList<Message>();
            for (ConfigChangeListener l : changeListeners) {
                ConfigChangeResult result = l.applyConfigurationChange(newEntry);
                if (result.getResultCode() != ResultCode.SUCCESS) {
                    if (resultCode == ResultCode.SUCCESS) {
                        resultCode = result.getResultCode();
                    }
                    messages.addAll(result.getMessages());
                }
                this.handleConfigChangeResult(result, newEntry.getDN(), l.getClass().getName(), "applyConfigurationChange");
            }
            if (resultCode != ResultCode.SUCCESS) {
                MessageBuilder buffer = new MessageBuilder();
                if (!messages.isEmpty()) {
                    Iterator iterator = messages.iterator();
                    buffer.append((Message)iterator.next());
                    while (iterator.hasNext()) {
                        buffer.append(".  ");
                        buffer.append((Message)iterator.next());
                    }
                }
                Message message = ConfigMessages.ERR_CONFIG_FILE_MODIFY_APPLY_FAILED.get(String.valueOf(buffer));
                throw new DirectoryException(resultCode, message);
            }
        }
        finally {
            this.configLock.unlock();
        }
    }

    @Override
    public void renameEntry(DN currentDN, Entry entry, ModifyDNOperation modifyDNOperation) throws DirectoryException {
        ClientConnection clientConnection;
        if (modifyDNOperation != null && !(clientConnection = modifyDNOperation.getClientConnection()).hasAllPrivileges(CONFIG_READ_AND_WRITE, modifyDNOperation)) {
            Message message = ConfigMessages.ERR_CONFIG_FILE_MODDN_INSUFFICIENT_PRIVILEGES.get();
            throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, message);
        }
        Message message = ConfigMessages.ERR_CONFIG_FILE_MODDN_NOT_ALLOWED.get();
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public void search(SearchOperation searchOperation) throws DirectoryException {
        ClientConnection clientConnection = searchOperation.getClientConnection();
        if (!clientConnection.hasPrivilege(Privilege.CONFIG_READ, searchOperation)) {
            Message message = ConfigMessages.ERR_CONFIG_FILE_SEARCH_INSUFFICIENT_PRIVILEGES.get();
            throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, message);
        }
        DN baseDN = searchOperation.getBaseDN();
        ConfigEntry baseEntry = this.configEntries.get(baseDN);
        if (baseEntry == null) {
            Message message = ConfigMessages.ERR_CONFIG_FILE_SEARCH_NO_SUCH_BASE.get(String.valueOf(baseDN));
            DN matchedDN = null;
            if (baseDN.isDescendantOf(this.configRootEntry.getDN())) {
                for (DN parentDN = baseDN.getParent(); parentDN != null; parentDN = parentDN.getParent()) {
                    if (!this.configEntries.containsKey(parentDN)) continue;
                    matchedDN = parentDN;
                    break;
                }
            }
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, matchedDN, null);
        }
        SearchScope scope = searchOperation.getScope();
        SearchFilter filter = searchOperation.getFilter();
        switch (scope) {
            case BASE_OBJECT: {
                Entry e = baseEntry.getEntry().duplicate(true);
                if (!filter.matchesEntry(e)) break;
                searchOperation.returnEntry(e, null);
                break;
            }
            case SINGLE_LEVEL: {
                ConfigEntry child;
                Entry e;
                Iterator<ConfigEntry> i$ = baseEntry.getChildren().values().iterator();
                while (i$.hasNext() && (!filter.matchesEntry(e = (child = i$.next()).getEntry().duplicate(true)) || searchOperation.returnEntry(e, null))) {
                }
                break;
            }
            case WHOLE_SUBTREE: {
                this.searchSubtree(baseEntry, filter, searchOperation);
                break;
            }
            case SUBORDINATE_SUBTREE: {
                for (ConfigEntry child : baseEntry.getChildren().values()) {
                    if (!this.searchSubtree(child, filter, searchOperation)) break;
                }
                break;
            }
            default: {
                Message message = ConfigMessages.ERR_CONFIG_FILE_SEARCH_INVALID_SCOPE.get(String.valueOf((Object)scope));
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
        }
    }

    private boolean searchSubtree(ConfigEntry baseEntry, SearchFilter filter, SearchOperation searchOperation) throws DirectoryException {
        Entry e = baseEntry.getEntry().duplicate(true);
        if (filter.matchesEntry(e) && !searchOperation.returnEntry(e, null)) {
            return false;
        }
        for (ConfigEntry child : baseEntry.getChildren().values()) {
            if (this.searchSubtree(child, filter, searchOperation)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void writeUpdatedConfig() throws DirectoryException {
        Message message;
        try {
            byte[] currentDigest = this.calculateConfigDigest();
            if (!Arrays.equals(this.configurationDigest, currentDigest)) {
                int bytesRead;
                File existingCfg = new File(this.configFile);
                File newConfigFile = new File(existingCfg.getParent(), "config.manualedit-" + TimeThread.getGMTTime() + ".ldif");
                int counter = 2;
                while (newConfigFile.exists()) {
                    newConfigFile = new File(newConfigFile.getAbsolutePath() + "." + counter++);
                }
                FileInputStream inputStream = new FileInputStream(existingCfg);
                FileOutputStream outputStream = new FileOutputStream(newConfigFile);
                byte[] buffer = new byte[8192];
                while ((bytesRead = inputStream.read(buffer)) >= 0) {
                    outputStream.write(buffer, 0, bytesRead);
                }
                inputStream.close();
                outputStream.close();
                Message message2 = ConfigMessages.WARN_CONFIG_MANUAL_CHANGES_DETECTED.get(this.configFile, newConfigFile.getAbsolutePath());
                ErrorLogger.logError(message2);
                DirectoryServer.sendAlertNotification(this, "org.opends.server.ManualConfigEditHandled", message2);
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message3 = ConfigMessages.ERR_CONFIG_MANUAL_CHANGES_LOST.get(this.configFile, StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(message3);
            DirectoryServer.sendAlertNotification(this, "org.opends.server.ManualConfigEditHandled", message3);
        }
        String tempConfig = this.configFile + ".tmp";
        try {
            LDIFExportConfig exportConfig = new LDIFExportConfig(tempConfig, ExistingFileBehavior.OVERWRITE);
            this.writeLDIF(exportConfig);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            message = ConfigMessages.ERR_CONFIG_FILE_WRITE_CANNOT_EXPORT_NEW_CONFIG.get(String.valueOf(tempConfig), StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(message);
            DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotWriteConfig", message);
            return;
        }
        try {
            File actualConfig = new File(this.configFile);
            File tmpConfig = new File(tempConfig);
            StaticUtils.renameFile(tmpConfig, actualConfig);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            message = ConfigMessages.ERR_CONFIG_FILE_WRITE_CANNOT_RENAME_NEW_CONFIG.get(String.valueOf(tempConfig), String.valueOf(this.configFile), StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(message);
            DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotWriteConfig", message);
            return;
        }
        this.configurationDigest = this.calculateConfigDigest();
        this.writeConfigArchive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeConfigArchive() {
        File archiveFile;
        File configDirectory = new File(this.configFile).getParentFile();
        File archiveDirectory = new File(configDirectory, "archived-configs");
        if (!archiveDirectory.exists()) {
            try {
                if (!archiveDirectory.mkdirs()) {
                    Message message = ConfigMessages.ERR_CONFIG_FILE_CANNOT_CREATE_ARCHIVE_DIR_NO_REASON.get(archiveDirectory.getAbsolutePath());
                    ErrorLogger.logError(message);
                    DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotWriteConfig", message);
                    return;
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ConfigMessages.ERR_CONFIG_FILE_CANNOT_CREATE_ARCHIVE_DIR.get(archiveDirectory.getAbsolutePath(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotWriteConfig", message);
                return;
            }
        }
        try {
            String timestamp = TimeThread.getGMTTime();
            archiveFile = new File(archiveDirectory, "config-" + timestamp + ".gz");
            if (archiveFile.exists()) {
                int counter = 2;
                archiveFile = new File(archiveDirectory, "config-" + timestamp + "-" + counter + ".gz");
                while (archiveFile.exists()) {
                    archiveFile = new File(archiveDirectory, "config-" + timestamp + "-" + ++counter + ".gz");
                }
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ConfigMessages.ERR_CONFIG_FILE_CANNOT_WRITE_CONFIG_ARCHIVE.get(StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(message);
            DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotWriteConfig", message);
            return;
        }
        byte[] buffer = new byte[8192];
        FileInputStream inputStream = null;
        DeflaterOutputStream outputStream = null;
        try {
            inputStream = new FileInputStream(this.configFile);
            outputStream = new GZIPOutputStream(new FileOutputStream(archiveFile));
            int bytesRead = inputStream.read(buffer);
            while (bytesRead > 0) {
                ((GZIPOutputStream)outputStream).write(buffer, 0, bytesRead);
                bytesRead = inputStream.read(buffer);
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ConfigMessages.ERR_CONFIG_FILE_CANNOT_WRITE_CONFIG_ARCHIVE.get(StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(message);
            DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotWriteConfig", message);
            return;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception e) {}
            try {
                outputStream.close();
            }
            catch (Exception e) {}
        }
    }

    public HashSet<String> getSupportedControls() {
        return null;
    }

    public HashSet<String> getSupportedFeatures() {
        return null;
    }

    @Override
    public boolean supportsLDIFExport() {
        return false;
    }

    @Override
    public void exportLDIF(LDIFExportConfig exportConfig) throws DirectoryException {
        this.writeLDIF(exportConfig);
    }

    private void writeLDIF(LDIFExportConfig exportConfig) throws DirectoryException {
        LDIFWriter writer;
        try {
            writer = new LDIFWriter(exportConfig);
            writer.writeComment(ConfigMessages.INFO_CONFIG_FILE_HEADER.get(), 80);
            this.writeEntryAndChildren(writer, this.configRootEntry);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ConfigMessages.ERR_CONFIG_LDIF_WRITE_ERROR.get(String.valueOf(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        try {
            writer.close();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ConfigMessages.ERR_CONFIG_FILE_CLOSE_ERROR.get(String.valueOf(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
    }

    private void writeEntryAndChildren(LDIFWriter writer, ConfigEntry configEntry) throws DirectoryException {
        try {
            writer.writeEntry(configEntry.getEntry());
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ConfigMessages.ERR_CONFIG_FILE_WRITE_ERROR.get(configEntry.getDN().toString(), String.valueOf(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        TreeMap<DN, ConfigEntry> childMap = new TreeMap<DN, ConfigEntry>(configEntry.getChildren());
        for (ConfigEntry childEntry : childMap.values()) {
            this.writeEntryAndChildren(writer, childEntry);
        }
    }

    @Override
    public boolean supportsLDIFImport() {
        return false;
    }

    @Override
    public LDIFImportResult importLDIF(LDIFImportConfig importConfig) throws DirectoryException {
        Message message = ConfigMessages.ERR_CONFIG_FILE_UNWILLING_TO_IMPORT.get();
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public boolean supportsBackup() {
        return true;
    }

    @Override
    public boolean supportsBackup(BackupConfig backupConfig, StringBuilder unsupportedReason) {
        return true;
    }

    @Override
    public void createBackup(BackupConfig backupConfig) throws DirectoryException {
        OutputStream outputStream;
        String backupID = backupConfig.getBackupID();
        BackupDirectory backupDirectory = backupConfig.getBackupDirectory();
        boolean compress = backupConfig.compressData();
        boolean encrypt = backupConfig.encryptData();
        boolean hash = backupConfig.hashData();
        boolean signHash = backupConfig.signHash();
        HashMap<String, String> backupProperties = new HashMap<String, String>();
        CryptoManager cryptoManager = DirectoryServer.getCryptoManager();
        Mac mac = null;
        MessageDigest digest = null;
        String digestAlgorithm = null;
        String macAlgorithm = null;
        if (hash) {
            if (signHash) {
                macAlgorithm = cryptoManager.getPreferredMACAlgorithm();
                backupProperties.put("mac_algorithm", macAlgorithm);
                try {
                    mac = cryptoManager.getPreferredMACProvider();
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    Message message = ConfigMessages.ERR_CONFIG_BACKUP_CANNOT_GET_MAC.get(macAlgorithm, StaticUtils.stackTraceToSingleLineString(e));
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
                }
            }
            digestAlgorithm = cryptoManager.getPreferredMessageDigestAlgorithm();
            backupProperties.put("digest_algorithm", digestAlgorithm);
            try {
                digest = cryptoManager.getPreferredMessageDigest();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ConfigMessages.ERR_CONFIG_BACKUP_CANNOT_GET_DIGEST.get(digestAlgorithm, StaticUtils.stackTraceToSingleLineString(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
            }
        }
        String filename = null;
        try {
            filename = "config-backup-" + backupID;
            File archiveFile = new File(backupDirectory.getPath() + File.separator + filename);
            if (archiveFile.exists()) {
                int i = 1;
                while ((archiveFile = new File(backupDirectory.getPath() + File.separator + filename + "." + i)).exists()) {
                    ++i;
                }
                filename = filename + "." + i;
            }
            outputStream = new FileOutputStream(archiveFile, false);
            backupProperties.put("archive_file", filename);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ConfigMessages.ERR_CONFIG_BACKUP_CANNOT_CREATE_ARCHIVE_FILE.get(String.valueOf(filename), backupDirectory.getPath(), StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        if (encrypt) {
            Cipher cipher;
            String cipherAlgorithm = cryptoManager.getPreferredCipherAlgorithm();
            backupProperties.put("cipher_algorithm", cipherAlgorithm);
            try {
                cipher = cryptoManager.getPreferredCipher(1);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ConfigMessages.ERR_CONFIG_BACKUP_CANNOT_GET_CIPHER.get(cipherAlgorithm, StaticUtils.stackTraceToSingleLineString(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
            }
            outputStream = new CipherOutputStream(outputStream, cipher);
        }
        ZipOutputStream zipStream = new ZipOutputStream(outputStream);
        Message message = ConfigMessages.ERR_CONFIG_BACKUP_ZIP_COMMENT.get("OpenDS Directory Server", backupID);
        zipStream.setComment(message.toString());
        if (compress) {
            zipStream.setLevel(-1);
        } else {
            zipStream.setLevel(0);
        }
        String configFile = null;
        try {
            configFile = ((ConfigFileHandler)DirectoryServer.getConfigHandler()).configFile;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            message = ConfigMessages.ERR_CONFIG_BACKUP_CANNOT_DETERMINE_CONFIG_FILE_LOCATION.get(StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        byte[] buffer = new byte[8192];
        FileInputStream inputStream = null;
        try {
            int bytesRead;
            File f = new File(configFile);
            ZipEntry zipEntry = new ZipEntry(f.getName());
            zipStream.putNextEntry(zipEntry);
            inputStream = new FileInputStream(f);
            while ((bytesRead = inputStream.read(buffer)) >= 0) {
                if (hash) {
                    if (signHash) {
                        mac.update(buffer, 0, bytesRead);
                    } else {
                        digest.update(buffer, 0, bytesRead);
                    }
                }
                zipStream.write(buffer, 0, bytesRead);
            }
            inputStream.close();
            zipStream.closeEntry();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            try {
                inputStream.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                zipStream.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            message = ConfigMessages.ERR_CONFIG_BACKUP_CANNOT_BACKUP_CONFIG_FILE.get(configFile, StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        try {
            File archiveDirectory = new File(new File(configFile).getParent(), "archived-configs");
            if (archiveDirectory.exists()) {
                for (File archiveFile : archiveDirectory.listFiles()) {
                    int bytesRead;
                    ZipEntry zipEntry = new ZipEntry("archived-configs" + File.separator + archiveFile.getName());
                    zipStream.putNextEntry(zipEntry);
                    inputStream = new FileInputStream(archiveFile);
                    while ((bytesRead = inputStream.read(buffer)) >= 0) {
                        if (hash) {
                            if (signHash) {
                                mac.update(buffer, 0, bytesRead);
                            } else {
                                digest.update(buffer, 0, bytesRead);
                            }
                        }
                        zipStream.write(buffer, 0, bytesRead);
                    }
                    inputStream.close();
                    zipStream.closeEntry();
                }
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            try {
                inputStream.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                zipStream.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            message = ConfigMessages.ERR_CONFIG_BACKUP_CANNOT_BACKUP_ARCHIVED_CONFIGS.get(configFile, StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        try {
            zipStream.close();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            message = ConfigMessages.ERR_CONFIG_BACKUP_CANNOT_CLOSE_ZIP_STREAM.get(filename, backupDirectory.getPath(), StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        byte[] digestBytes = null;
        byte[] macBytes = null;
        if (hash) {
            if (signHash) {
                macBytes = mac.doFinal();
            } else {
                digestBytes = digest.digest();
            }
        }
        BackupInfo backupInfo = new BackupInfo(backupDirectory, backupID, new Date(), false, compress, encrypt, digestBytes, macBytes, null, backupProperties);
        try {
            backupDirectory.addBackup(backupInfo);
            backupDirectory.writeBackupDirectoryDescriptor();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            message = ConfigMessages.ERR_CONFIG_BACKUP_CANNOT_UPDATE_BACKUP_DESCRIPTOR.get(backupDirectory.getDescriptorPath(), StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
    }

    @Override
    public void removeBackup(BackupDirectory backupDirectory, String backupID) throws DirectoryException {
    }

    @Override
    public boolean supportsRestore() {
        return true;
    }

    @Override
    public void restoreBackup(RestoreConfig restoreConfig) throws DirectoryException {
        Message message;
        Message message2;
        InputStream inputStream;
        BackupDirectory backupDirectory = restoreConfig.getBackupDirectory();
        String backupPath = backupDirectory.getPath();
        String backupID = restoreConfig.getBackupID();
        BackupInfo backupInfo = backupDirectory.getBackupInfo(backupID);
        if (backupInfo == null) {
            Message message3 = ConfigMessages.ERR_CONFIG_RESTORE_NO_SUCH_BACKUP.get(backupID, backupPath);
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message3);
        }
        String backupFilename = backupInfo.getBackupProperty("archive_file");
        if (backupFilename == null) {
            Message message4 = ConfigMessages.ERR_CONFIG_RESTORE_NO_BACKUP_FILE.get(backupID, backupPath);
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message4);
        }
        File backupFile = new File(backupPath + File.separator + backupFilename);
        try {
            if (!backupFile.exists()) {
                Message message5 = ConfigMessages.ERR_CONFIG_RESTORE_NO_SUCH_FILE.get(backupID, backupFile.getPath());
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message5);
            }
        }
        catch (DirectoryException de) {
            throw de;
        }
        catch (Exception e) {
            Message message6 = ConfigMessages.ERR_CONFIG_RESTORE_CANNOT_CHECK_FOR_ARCHIVE.get(backupID, backupFile.getPath(), StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message6, e);
        }
        byte[] unsignedHash = backupInfo.getUnsignedHash();
        MessageDigest digest = null;
        if (unsignedHash != null) {
            String digestAlgorithm = backupInfo.getBackupProperty("digest_algorithm");
            if (digestAlgorithm == null) {
                Message message7 = ConfigMessages.ERR_CONFIG_RESTORE_UNKNOWN_DIGEST.get(backupID);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message7);
            }
            try {
                digest = DirectoryServer.getCryptoManager().getMessageDigest(digestAlgorithm);
            }
            catch (Exception e) {
                Message message8 = ConfigMessages.ERR_CONFIG_RESTORE_CANNOT_GET_DIGEST.get(backupID, digestAlgorithm);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message8, e);
            }
        }
        byte[] signedHash = backupInfo.getSignedHash();
        Mac mac = null;
        if (signedHash != null) {
            String macAlgorithm = backupInfo.getBackupProperty("mac_algorithm");
            if (macAlgorithm == null) {
                Message message9 = ConfigMessages.ERR_CONFIG_RESTORE_UNKNOWN_MAC.get(backupID);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message9);
            }
            try {
                mac = DirectoryServer.getCryptoManager().getMACProvider(macAlgorithm);
            }
            catch (Exception e) {
                Message message10 = ConfigMessages.ERR_CONFIG_RESTORE_CANNOT_GET_MAC.get(backupID, macAlgorithm);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message10, e);
            }
        }
        try {
            inputStream = new FileInputStream(backupFile);
        }
        catch (Exception e) {
            Message message11 = ConfigMessages.ERR_CONFIG_RESTORE_CANNOT_OPEN_BACKUP_FILE.get(backupID, backupFile.getPath(), StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message11, e);
        }
        if (backupInfo.isEncrypted()) {
            Cipher cipher;
            String cipherAlgorithm = backupInfo.getBackupProperty("cipher_algorithm");
            if (cipherAlgorithm == null) {
                Message message12 = ConfigMessages.ERR_CONFIG_RESTORE_UNKNOWN_CIPHER.get(backupID);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message12);
            }
            try {
                cipher = DirectoryServer.getCryptoManager().getCipher(cipherAlgorithm, 2);
            }
            catch (Exception e) {
                Message message13 = ConfigMessages.ERR_CONFIG_RESTORE_CANNOT_GET_CIPHER.get(backupFile.getPath(), cipherAlgorithm);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message13, e);
            }
            inputStream = new CipherInputStream(inputStream, cipher);
        }
        ZipInputStream zipStream = new ZipInputStream(inputStream);
        String configFilePath = ((ConfigFileHandler)DirectoryServer.getConfigHandler()).configFile;
        File configFile = new File(configFilePath);
        File configDir = configFile.getParentFile();
        String configDirPath = configDir.getPath();
        String backupDirPath = null;
        File configBackupDir = null;
        boolean verifyOnly = restoreConfig.verifyOnly();
        if (!verifyOnly) {
            try {
                if (configDir.exists()) {
                    String configBackupDirPath = configDirPath + ".save";
                    backupDirPath = configBackupDirPath;
                    configBackupDir = new File(backupDirPath);
                    if (configBackupDir.exists()) {
                        int i = 2;
                        while ((configBackupDir = new File(backupDirPath = configBackupDirPath + i)).exists()) {
                            ++i;
                        }
                    }
                    configBackupDir.mkdirs();
                    StaticUtils.moveFile(configFile, configBackupDir);
                    File archiveDirectory = new File(configDir, "archived-configs");
                    if (archiveDirectory.exists()) {
                        File archiveBackupPath = new File(configBackupDir, "archived-configs");
                        archiveDirectory.renameTo(archiveBackupPath);
                    }
                }
            }
            catch (Exception e) {
                Message message14 = ConfigMessages.ERR_CONFIG_RESTORE_CANNOT_BACKUP_EXISTING_CONFIG.get(backupID, configDirPath, String.valueOf(backupDirPath), StaticUtils.getExceptionMessage(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message14, e);
            }
            try {
                configDir.mkdirs();
            }
            catch (Exception e) {
                if (configBackupDir != null) {
                    try {
                        configBackupDir.renameTo(configDir);
                        message2 = ConfigMessages.NOTE_CONFIG_RESTORE_RESTORED_OLD_CONFIG.get(configDirPath);
                        ErrorLogger.logError(message2);
                    }
                    catch (Exception e2) {
                        message = ConfigMessages.ERR_CONFIG_RESTORE_CANNOT_RESTORE_OLD_CONFIG.get(configBackupDir.getPath());
                        ErrorLogger.logError(message);
                    }
                }
                message2 = ConfigMessages.ERR_CONFIG_RESTORE_CANNOT_CREATE_CONFIG_DIRECTORY.get(backupID, configDirPath, StaticUtils.getExceptionMessage(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message2, e);
            }
        }
        byte[] buffer = new byte[8192];
        while (true) {
            ZipEntry zipEntry;
            try {
                zipEntry = zipStream.getNextEntry();
            }
            catch (Exception e) {
                Message message15;
                if (configBackupDir != null) {
                    message15 = ConfigMessages.ERR_CONFIG_RESTORE_OLD_CONFIG_SAVED.get(configBackupDir.getPath());
                    ErrorLogger.logError(message15);
                }
                message15 = ConfigMessages.ERR_CONFIG_RESTORE_CANNOT_GET_ZIP_ENTRY.get(backupID, backupFile.getPath(), StaticUtils.stackTraceToSingleLineString(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message15, e);
            }
            if (zipEntry == null) break;
            String fileName = zipEntry.getName();
            if (digest != null) {
                digest.update(StaticUtils.getBytes(fileName));
            }
            if (mac != null) {
                mac.update(StaticUtils.getBytes(fileName));
            }
            OutputStream outputStream = null;
            if (!verifyOnly) {
                File restoreFile = new File(configDirPath + File.separator + fileName);
                File parentDir = restoreFile.getParentFile();
                try {
                    if (!parentDir.exists()) {
                        parentDir.mkdirs();
                    }
                    outputStream = new FileOutputStream(restoreFile);
                }
                catch (Exception e) {
                    Message message16;
                    if (configBackupDir != null) {
                        message16 = ConfigMessages.ERR_CONFIG_RESTORE_OLD_CONFIG_SAVED.get(configBackupDir.getPath());
                        ErrorLogger.logError(message16);
                    }
                    message16 = ConfigMessages.ERR_CONFIG_RESTORE_CANNOT_CREATE_FILE.get(backupID, restoreFile.getAbsolutePath(), StaticUtils.stackTraceToSingleLineString(e));
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message16, e);
                }
            }
            try {
                int bytesRead;
                while ((bytesRead = zipStream.read(buffer)) >= 0) {
                    if (digest != null) {
                        digest.update(buffer, 0, bytesRead);
                    }
                    if (mac != null) {
                        mac.update(buffer, 0, bytesRead);
                    }
                    if (outputStream == null) continue;
                    outputStream.write(buffer, 0, bytesRead);
                }
                if (outputStream == null) continue;
                outputStream.close();
            }
            catch (Exception e) {
                Message message17;
                if (configBackupDir != null) {
                    message17 = ConfigMessages.ERR_CONFIG_RESTORE_OLD_CONFIG_SAVED.get(configBackupDir.getPath());
                    ErrorLogger.logError(message17);
                }
                message17 = ConfigMessages.ERR_CONFIG_RESTORE_CANNOT_PROCESS_ARCHIVE_FILE.get(backupID, fileName, StaticUtils.stackTraceToSingleLineString(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message17, e);
            }
        }
        try {
            zipStream.close();
        }
        catch (Exception e) {
            message = ConfigMessages.ERR_CONFIG_RESTORE_ERROR_ON_ZIP_STREAM_CLOSE.get(backupID, backupFile.getPath(), StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        if (digest != null) {
            byte[] calculatedHash = digest.digest();
            if (Arrays.equals(calculatedHash, unsignedHash)) {
                message = ConfigMessages.NOTE_CONFIG_RESTORE_UNSIGNED_HASH_VALID.get();
                ErrorLogger.logError(message);
            } else {
                if (configBackupDir != null) {
                    message = ConfigMessages.ERR_CONFIG_RESTORE_OLD_CONFIG_SAVED.get(configBackupDir.getPath());
                    ErrorLogger.logError(message);
                }
                message = ConfigMessages.ERR_CONFIG_RESTORE_UNSIGNED_HASH_INVALID.get(backupID);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
            }
        }
        if (mac != null) {
            byte[] calculatedSignature = mac.doFinal();
            if (Arrays.equals(calculatedSignature, signedHash)) {
                message = ConfigMessages.NOTE_CONFIG_RESTORE_SIGNED_HASH_VALID.get();
                ErrorLogger.logError(message);
            } else {
                if (configBackupDir != null) {
                    message = ConfigMessages.ERR_CONFIG_RESTORE_OLD_CONFIG_SAVED.get(configBackupDir.getPath());
                    ErrorLogger.logError(message);
                }
                message = ConfigMessages.ERR_CONFIG_RESTORE_SIGNED_HASH_INVALID.get(configBackupDir.getPath());
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
            }
        }
        if (verifyOnly) {
            message2 = ConfigMessages.NOTE_CONFIG_RESTORE_VERIFY_SUCCESSFUL.get(backupID, backupPath);
            ErrorLogger.logError(message2);
            return;
        }
        if (configBackupDir != null) {
            StaticUtils.recursiveDelete(configBackupDir);
        }
        message2 = ConfigMessages.NOTE_CONFIG_RESTORE_SUCCESSFUL.get(backupID, backupPath);
        ErrorLogger.logError(message2);
    }

    @Override
    public DN getComponentEntryDN() {
        return this.configRootEntry.getDN();
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public LinkedHashMap<String, String> getAlerts() {
        LinkedHashMap<String, String> alerts = new LinkedHashMap<String, String>();
        alerts.put("org.opends.server.CannotWriteConfig", "This alert type will be used to notify administrators if the Directory Server is unable to write its updated configuration for some reason and therefore the server may not exhibit the new configuration if it is restarted.");
        alerts.put("org.opends.server.ManualConfigEditHandled", "This alert type will be used to notify administrators if the Directory Server detects that its configuration has been manually edited with the server online and those changes were overwritten by another change made through the server.  The manually-edited configuration will be copied off to another location.");
        alerts.put("org.opends.server.ManualConfigEditLost", "This alert type will be used to notify administrators if the Directory Server detects that its configuration has been manually edited with the server online and those changes were overwritten by another change made through the server.  The manually-edited configuration could not be preserved due to an unexpected error.");
        return alerts;
    }

    public void handleConfigChangeResult(ConfigChangeResult result, DN entryDN, String className, String methodName) {
        Message message;
        if (result == null) {
            Message message2 = ConfigMessages.ERR_CONFIG_CHANGE_NO_RESULT.get(String.valueOf(className), String.valueOf(methodName), String.valueOf(entryDN));
            ErrorLogger.logError(message2);
            return;
        }
        ResultCode resultCode = result.getResultCode();
        boolean adminActionRequired = result.adminActionRequired();
        List<Message> messages = result.getMessages();
        MessageBuilder messageBuffer = new MessageBuilder();
        if (messages != null) {
            for (Message s : messages) {
                if (messageBuffer.length() > 0) {
                    messageBuffer.append("  ");
                }
                messageBuffer.append(s);
            }
        }
        if (resultCode != ResultCode.SUCCESS) {
            message = ConfigMessages.ERR_CONFIG_CHANGE_RESULT_ERROR.get(String.valueOf(className), String.valueOf(methodName), String.valueOf(entryDN), String.valueOf((Object)resultCode), adminActionRequired, messageBuffer.toString());
            ErrorLogger.logError(message);
        } else if (adminActionRequired) {
            message = ConfigMessages.WARN_CONFIG_CHANGE_RESULT_ACTION_REQUIRED.get(String.valueOf(className), String.valueOf(methodName), String.valueOf(entryDN), messageBuffer.toString());
            ErrorLogger.logError(message);
        } else if (messageBuffer.length() > 0) {
            message = ConfigMessages.INFO_CONFIG_CHANGE_RESULT_MESSAGES.get(String.valueOf(className), String.valueOf(methodName), String.valueOf(entryDN), messageBuffer.toString());
            ErrorLogger.logError(message);
        }
    }
}

