/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.StatsConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.EntryCacheCfg;
import org.opends.server.admin.std.server.FileSystemEntryCacheCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.EntryCache;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.EntryCacheCommon;
import org.opends.server.extensions.FileSystemEntryCacheIndex;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.Entry;
import org.opends.server.types.EntryEncodeConfig;
import org.opends.server.types.FilePermission;
import org.opends.server.types.InitializationException;
import org.opends.server.types.OpenDsException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.util.ServerConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemEntryCache
extends EntryCache<FileSystemEntryCacheCfg>
implements ConfigurationChangeListener<FileSystemEntryCacheCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final FilePermission CACHE_HOME_PERMISSIONS = new FilePermission(448);
    private DN configEntryDN;
    private long maxAllowedMemory;
    private AtomicLong maxEntries;
    private int jeCachePercent;
    private long jeCacheSize;
    private String cacheHome;
    private String cacheType;
    private boolean persistentCache;
    private ReentrantReadWriteLock cacheLock;
    private Lock cacheReadLock;
    private Lock cacheWriteLock;
    private Map<DN, Long> dnMap;
    private Map<Backend, Map<Long, DN>> backendMap;
    boolean accessOrder = false;
    private Environment entryCacheEnv;
    private EnvironmentConfig entryCacheEnvConfig;
    private EnvironmentMutableConfig entryCacheEnvMutableConfig;
    private DatabaseConfig entryCacheDBConfig;
    private StatsConfig entryCacheEnvStatsConfig = new StatsConfig();
    private Database entryCacheDB;
    private Database entryCacheClassDB;
    private StoredClassCatalog classCatalog;
    private EntryBinding entryCacheDataBinding;
    private static final String ENTRYCACHEDBNAME = "EntryCacheDB";
    private static final String INDEXCLASSDBNAME = "IndexClassDB";
    private static final String INDEXKEY = "EntryCacheIndex";
    private static final Long JEBYTESINTERVAL = 0xA00000L;
    private static final Long JELOGFILEMAX = 0xA00000L;
    private static final Integer JEMINFILEUTILIZATION = 50;
    private static final Integer JEMINUTILIZATION = 90;
    private static final Integer JEMAXBATCHFILES = 1;
    private static final Integer JEMINAGE = 1;
    private long progressInterval = 5000L;
    private long persistentEntriesSaved = 0L;
    private long persistentEntriesRestored = 0L;
    private static EntryEncodeConfig encodeConfig = new EntryEncodeConfig(true, false, false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeEntryCache(FileSystemEntryCacheCfg configuration) throws ConfigException, InitializationException {
        block36: {
            configuration.addFileSystemChangeListener(this);
            this.configEntryDN = configuration.dn();
            boolean applyChanges = true;
            EntryCacheCommon.ConfigErrorHandler errorHandler = EntryCacheCommon.getConfigErrorHandler(EntryCacheCommon.ConfigPhase.PHASE_INIT, null, null);
            this.processEntryCacheConfig(configuration, applyChanges, errorHandler);
            if (this.cacheType.equalsIgnoreCase("LRU")) {
                this.accessOrder = true;
            } else {
                this.cacheType = "FIFO";
                this.accessOrder = false;
            }
            this.backendMap = new LinkedHashMap<Backend, Map<Long, DN>>();
            this.dnMap = new LinkedHashMapRotator<DN, Long>(16, 0.75f, this.accessOrder);
            this.cacheLock = new ReentrantReadWriteLock();
            this.cacheReadLock = this.accessOrder ? this.cacheLock.writeLock() : this.cacheLock.readLock();
            this.cacheWriteLock = this.cacheLock.writeLock();
            try {
                this.checkAndSetupCacheHome(this.cacheHome);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                ErrorLogger.logError(ExtensionMessages.ERR_FSCACHE_HOMELESS.get());
                Message message = ExtensionMessages.ERR_FSCACHE_HOMELESS.get();
                throw new InitializationException(message, (Throwable)e);
            }
            try {
                this.entryCacheEnvConfig = new EnvironmentConfig();
                this.entryCacheEnvConfig.setConfigParam("je.log.fileMax", JELOGFILEMAX.toString());
                this.entryCacheEnvConfig.setConfigParam("je.cleaner.minUtilization", JEMINUTILIZATION.toString());
                this.entryCacheEnvConfig.setConfigParam("je.cleaner.maxBatchFiles", JEMAXBATCHFILES.toString());
                this.entryCacheEnvConfig.setConfigParam("je.cleaner.minAge", JEMINAGE.toString());
                this.entryCacheEnvConfig.setConfigParam("je.cleaner.minFileUtilization", JEMINFILEUTILIZATION.toString());
                this.entryCacheEnvConfig.setConfigParam("je.checkpointer.bytesInterval", JEBYTESINTERVAL.toString());
                this.entryCacheEnvConfig.setAllowCreate(true);
                this.entryCacheEnv = new Environment(new File(this.cacheHome), this.entryCacheEnvConfig);
                this.entryCacheEnvMutableConfig = new EnvironmentMutableConfig();
                if (this.jeCachePercent != 0) {
                    try {
                        this.entryCacheEnvMutableConfig.setCachePercent(this.jeCachePercent);
                    }
                    catch (IllegalArgumentException e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        ErrorLogger.logError(ExtensionMessages.ERR_FSCACHE_CANNOT_SET_JE_MEMORY_PCT.get());
                    }
                }
                if (this.jeCacheSize != 0L) {
                    try {
                        this.entryCacheEnvMutableConfig.setCacheSize(this.jeCacheSize);
                    }
                    catch (IllegalArgumentException e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        ErrorLogger.logError(ExtensionMessages.ERR_FSCACHE_CANNOT_SET_JE_MEMORY_SIZE.get());
                    }
                }
                this.entryCacheEnv.setMutableConfig(this.entryCacheEnvMutableConfig);
                this.entryCacheDBConfig = new DatabaseConfig();
                this.entryCacheDBConfig.setAllowCreate(true);
                this.entryCacheEnvStatsConfig.setFast(true);
                if (!this.persistentCache) {
                    try {
                        this.entryCacheEnv.removeDatabase(null, INDEXCLASSDBNAME);
                    }
                    catch (DatabaseNotFoundException e) {
                        // empty catch block
                    }
                    try {
                        this.entryCacheEnv.removeDatabase(null, ENTRYCACHEDBNAME);
                    }
                    catch (DatabaseNotFoundException e) {
                        // empty catch block
                    }
                }
                this.entryCacheDB = this.entryCacheEnv.openDatabase(null, ENTRYCACHEDBNAME, this.entryCacheDBConfig);
                this.entryCacheClassDB = this.entryCacheEnv.openDatabase(null, INDEXCLASSDBNAME, this.entryCacheDBConfig);
                this.classCatalog = new StoredClassCatalog(this.entryCacheClassDB);
                this.entryCacheDataBinding = new SerialBinding((ClassCatalog)this.classCatalog, FileSystemEntryCacheIndex.class);
                if (!this.persistentCache) break block36;
                try {
                    DatabaseEntry indexData = new DatabaseEntry();
                    DatabaseEntry indexKey = new DatabaseEntry(INDEXKEY.getBytes("UTF-8"));
                    if (OperationStatus.SUCCESS != this.entryCacheDB.get(null, indexKey, indexData, LockMode.DEFAULT)) {
                        throw new CacheIndexNotFoundException();
                    }
                    FileSystemEntryCacheIndex entryCacheIndex = (FileSystemEntryCacheIndex)this.entryCacheDataBinding.entryToObject(indexData);
                    if (entryCacheIndex.dnMap.isEmpty() || entryCacheIndex.backendMap.isEmpty() || entryCacheIndex.offlineState.isEmpty()) {
                        throw new CacheIndexImpairedException();
                    }
                    AtomicLong currentMaxEntries = this.maxEntries;
                    this.maxEntries.set(Long.MAX_VALUE);
                    Set<String> backendSet = entryCacheIndex.backendMap.keySet();
                    Iterator<String> backendIterator = backendSet.iterator();
                    final long persistentEntriesTotal = entryCacheIndex.dnMap.size();
                    Timer timer = new Timer();
                    TimerTask progressTask = new TimerTask(){

                        public void run() {
                            if (FileSystemEntryCache.this.persistentEntriesRestored > 0L && FileSystemEntryCache.this.persistentEntriesRestored < persistentEntriesTotal) {
                                Message message = ExtensionMessages.INFO_FSCACHE_RESTORE_PROGRESS_REPORT.get(FileSystemEntryCache.this.persistentEntriesRestored, persistentEntriesTotal);
                                ErrorLogger.logError(message);
                            }
                        }
                    };
                    timer.scheduleAtFixedRate(progressTask, this.progressInterval, this.progressInterval);
                    try {
                        while (backendIterator.hasNext()) {
                            String backend = backendIterator.next();
                            Map<Long, String> entriesMap = entryCacheIndex.backendMap.get(backend);
                            Set<Long> entriesSet = entriesMap.keySet();
                            Iterator<Long> entriesIterator = entriesSet.iterator();
                            LinkedHashMap<Long, DN> entryMap = new LinkedHashMap<Long, DN>();
                            while (entriesIterator.hasNext()) {
                                Long entryID = entriesIterator.next();
                                String entryStringDN = entriesMap.get(entryID);
                                DN entryDN = DN.decode(entryStringDN);
                                this.dnMap.put(entryDN, entryID);
                                entryMap.put(entryID, entryDN);
                                ++this.persistentEntriesRestored;
                            }
                            this.backendMap.put(DirectoryServer.getBackend(backend), entryMap);
                        }
                    }
                    finally {
                        timer.cancel();
                        Message message = ExtensionMessages.INFO_FSCACHE_RESTORE_PROGRESS_REPORT.get(this.persistentEntriesRestored, persistentEntriesTotal);
                        ErrorLogger.logError(message);
                    }
                    Map<String, Long> currentBackendsState = DirectoryServer.getOfflineBackendsStateIDs();
                    Set<String> offlineBackendSet = entryCacheIndex.offlineState.keySet();
                    for (String backend : offlineBackendSet) {
                        Long currentId;
                        Long offlineId = entryCacheIndex.offlineState.get(backend);
                        if (offlineId.equals(currentId = currentBackendsState.get(backend))) continue;
                        this.clearBackend(DirectoryServer.getBackend(backend));
                        ErrorLogger.logError(ExtensionMessages.WARN_FSCACHE_OFFLINE_STATE_FAIL.get(backend));
                    }
                    this.maxEntries = currentMaxEntries;
                }
                catch (CacheIndexNotFoundException e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    ErrorLogger.logError(ExtensionMessages.INFO_FSCACHE_INDEX_NOT_FOUND.get());
                    this.clear();
                }
                catch (CacheIndexImpairedException e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    ErrorLogger.logError(ExtensionMessages.ERR_FSCACHE_INDEX_IMPAIRED.get());
                    this.clear();
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    ErrorLogger.logError(ExtensionMessages.ERR_FSCACHE_CANNOT_LOAD_PERSISTENT_DATA.get());
                    this.clear();
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ExtensionMessages.ERR_FSCACHE_CANNOT_INITIALIZE.get();
                throw new InitializationException(message, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finalizeEntryCache() {
        block24: {
            this.cacheWriteLock.lock();
            if (this.persistentCache && !this.dnMap.isEmpty()) {
                FileSystemEntryCacheIndex entryCacheIndex = new FileSystemEntryCacheIndex();
                entryCacheIndex.offlineState = DirectoryServer.getOfflineBackendsStateIDs();
                Set<Backend> backendSet = this.backendMap.keySet();
                Iterator<Backend> backendIterator = backendSet.iterator();
                final long persistentEntriesTotal = this.dnMap.size();
                Timer timer = new Timer();
                TimerTask progressTask = new TimerTask(){

                    public void run() {
                        if (FileSystemEntryCache.this.persistentEntriesSaved > 0L && FileSystemEntryCache.this.persistentEntriesSaved < persistentEntriesTotal) {
                            Message message = ExtensionMessages.INFO_FSCACHE_SAVE_PROGRESS_REPORT.get(FileSystemEntryCache.this.persistentEntriesSaved, persistentEntriesTotal);
                            ErrorLogger.logError(message);
                        }
                    }
                };
                timer.scheduleAtFixedRate(progressTask, this.progressInterval, this.progressInterval);
                try {
                    while (backendIterator.hasNext()) {
                        Backend backend = backendIterator.next();
                        Map<Long, DN> entriesMap = this.backendMap.get(backend);
                        LinkedHashMap<Long, String> entryMap = new LinkedHashMap<Long, String>();
                        for (Long entryID : entriesMap.keySet()) {
                            DN entryDN = entriesMap.get(entryID);
                            entryCacheIndex.dnMap.put(entryDN.toNormalizedString(), entryID);
                            entryMap.put(entryID, entryDN.toNormalizedString());
                            ++this.persistentEntriesSaved;
                        }
                        entryCacheIndex.backendMap.put(backend.getBackendID(), entryMap);
                    }
                }
                finally {
                    timer.cancel();
                    Message message = ExtensionMessages.INFO_FSCACHE_SAVE_PROGRESS_REPORT.get(this.persistentEntriesSaved, persistentEntriesTotal);
                    ErrorLogger.logError(message);
                }
                try {
                    DatabaseEntry indexData = new DatabaseEntry();
                    this.entryCacheDataBinding.objectToEntry((Object)entryCacheIndex, indexData);
                    DatabaseEntry indexKey = new DatabaseEntry(INDEXKEY.getBytes("UTF-8"));
                    if (OperationStatus.SUCCESS != this.entryCacheDB.put(null, indexKey, indexData)) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    ErrorLogger.logError(ExtensionMessages.ERR_FSCACHE_CANNOT_STORE_PERSISTENT_DATA.get());
                }
            }
            try {
                this.backendMap.clear();
                this.dnMap.clear();
                if (this.entryCacheDB != null) {
                    this.entryCacheDB.close();
                }
                if (this.entryCacheClassDB != null) {
                    this.entryCacheClassDB.close();
                }
                if (this.entryCacheEnv == null) break block24;
                if (!this.persistentCache) {
                    try {
                        this.entryCacheEnv.removeDatabase(null, INDEXCLASSDBNAME);
                    }
                    catch (DatabaseNotFoundException e) {
                        // empty catch block
                    }
                    try {
                        this.entryCacheEnv.removeDatabase(null, ENTRYCACHEDBNAME);
                    }
                    catch (DatabaseNotFoundException e) {
                        // empty catch block
                    }
                }
                this.entryCacheEnv.cleanLog();
                this.entryCacheEnv.close();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            finally {
                this.cacheWriteLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsEntry(DN entryDN) {
        boolean containsEntry = false;
        this.cacheReadLock.lock();
        try {
            containsEntry = this.dnMap.containsKey(entryDN);
        }
        finally {
            this.cacheReadLock.unlock();
        }
        return containsEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Entry getEntry(DN entryDN) {
        Entry entry = null;
        this.cacheReadLock.lock();
        try {
            if (this.dnMap.get(entryDN) != null) {
                entry = this.getEntryFromDB(entryDN);
            }
        }
        finally {
            this.cacheReadLock.unlock();
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getEntryID(DN entryDN) {
        long entryID = -1L;
        this.cacheReadLock.lock();
        try {
            Long eid = this.dnMap.get(entryDN);
            if (eid != null) {
                entryID = eid;
            }
        }
        finally {
            this.cacheReadLock.unlock();
        }
        return entryID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected DN getEntryDN(Backend backend, long entryID) {
        DN entryDN = null;
        this.cacheReadLock.lock();
        try {
            Map<Long, DN> map = this.backendMap.get(backend);
            if (map != null) {
                entryDN = map.get(entryID);
            }
        }
        finally {
            this.cacheReadLock.unlock();
        }
        return entryDN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putEntry(Entry entry, Backend backend, long entryID) {
        if (!this.filtersAllowCaching(entry)) {
            return;
        }
        try {
            if (!this.cacheWriteLock.tryLock(this.getLockTimeout(), TimeUnit.MILLISECONDS)) {
                return;
            }
            this.putEntryToDB(entry, backend, entryID);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return;
        }
        finally {
            if (this.cacheLock.isWriteLockedByCurrentThread()) {
                this.cacheWriteLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putEntryIfAbsent(Entry entry, Backend backend, long entryID) {
        if (!this.filtersAllowCaching(entry)) {
            return true;
        }
        try {
            if (!this.cacheWriteLock.tryLock(this.getLockTimeout(), TimeUnit.MILLISECONDS)) {
                boolean bl = false;
                return bl;
            }
            if (this.dnMap.containsKey(entry.getDN())) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.putEntryToDB(entry, backend, entryID);
            return bl;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.cacheLock.isWriteLockedByCurrentThread()) {
                this.cacheWriteLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEntry(DN entryDN) {
        this.cacheWriteLock.lock();
        try {
            Long entryID = this.dnMap.get(entryDN);
            if (entryID == null) {
                return;
            }
            Set<Backend> backendSet = this.backendMap.keySet();
            Iterator<Backend> backendIterator = backendSet.iterator();
            while (backendIterator.hasNext()) {
                Map<Long, DN> map = this.backendMap.get(backendIterator.next());
                if (map.get(entryID) == null || !map.get(entryID).equals(entryDN)) continue;
                map.remove(entryID);
                if (!map.isEmpty()) break;
                backendIterator.remove();
                break;
            }
            this.dnMap.remove(entryDN);
            this.entryCacheDB.delete(null, new DatabaseEntry(entryDN.toNormalizedString().getBytes("UTF-8")));
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        finally {
            this.cacheWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.cacheWriteLock.lock();
        this.dnMap.clear();
        this.backendMap.clear();
        try {
            if (this.entryCacheDB != null && this.entryCacheEnv != null && this.entryCacheClassDB != null && this.entryCacheDBConfig != null) {
                this.entryCacheDBConfig = this.entryCacheDB.getConfig();
                this.entryCacheDB.close();
                this.entryCacheClassDB.close();
                this.entryCacheEnv.truncateDatabase(null, ENTRYCACHEDBNAME, false);
                this.entryCacheEnv.truncateDatabase(null, INDEXCLASSDBNAME, false);
                this.entryCacheEnv.cleanLog();
                this.entryCacheDB = this.entryCacheEnv.openDatabase(null, ENTRYCACHEDBNAME, this.entryCacheDBConfig);
                this.entryCacheClassDB = this.entryCacheEnv.openDatabase(null, INDEXCLASSDBNAME, this.entryCacheDBConfig);
                this.classCatalog = new StoredClassCatalog(this.entryCacheClassDB);
                this.entryCacheDataBinding = new SerialBinding((ClassCatalog)this.classCatalog, FileSystemEntryCacheIndex.class);
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        finally {
            this.cacheWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearBackend(Backend backend) {
        this.cacheWriteLock.lock();
        Map<Long, DN> backendEntriesMap = this.backendMap.get(backend);
        try {
            if (backendEntriesMap == null) {
                return;
            }
            int entriesExamined = 0;
            Iterator<Long> backendEntriesIterator = backendEntriesMap.keySet().iterator();
            while (backendEntriesIterator.hasNext()) {
                Long entryID = backendEntriesIterator.next();
                DN entryDN = backendEntriesMap.get(entryID);
                this.entryCacheDB.delete(null, new DatabaseEntry(entryDN.toNormalizedString().getBytes("UTF-8")));
                backendEntriesIterator.remove();
                this.dnMap.remove(entryDN);
                if (++entriesExamined % 1000 != 0) continue;
                this.cacheWriteLock.unlock();
                Thread.currentThread();
                Thread.yield();
                this.cacheWriteLock.lock();
            }
            this.backendMap.remove(backend);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        finally {
            this.cacheWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearSubtree(DN baseDN) {
        Backend backend = DirectoryServer.getBackend(baseDN);
        if (backend == null) {
            return;
        }
        this.cacheWriteLock.lock();
        try {
            this.clearSubtree(baseDN, backend);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        finally {
            this.cacheWriteLock.unlock();
        }
    }

    private void clearSubtree(DN baseDN, Backend backend) {
        Map<Long, DN> map = this.backendMap.get(backend);
        if (map == null) {
            return;
        }
        int entriesExamined = 0;
        Iterator<DN> iterator = map.values().iterator();
        while (iterator.hasNext()) {
            block8: {
                DN entryDN = iterator.next();
                if (entryDN.isDescendantOf(baseDN)) {
                    iterator.remove();
                    this.dnMap.remove(entryDN);
                    try {
                        this.entryCacheDB.delete(null, new DatabaseEntry(entryDN.toNormalizedString().getBytes("UTF-8")));
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block8;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
            }
            if (++entriesExamined % 1000 != 0) continue;
            this.cacheWriteLock.unlock();
            Thread.currentThread();
            Thread.yield();
            this.cacheWriteLock.lock();
        }
        if (map.isEmpty()) {
            this.backendMap.remove(backend);
        }
        for (Backend subBackend : backend.getSubordinateBackends()) {
            boolean isAppropriate = false;
            for (DN subBase : subBackend.getBaseDNs()) {
                if (!subBase.isDescendantOf(baseDN)) continue;
                isAppropriate = true;
                break;
            }
            if (!isAppropriate) continue;
            this.clearSubtree(baseDN, subBackend);
        }
    }

    @Override
    public void handleLowMemory() {
        block3: {
            if (this.entryCacheEnv != null) {
                try {
                    this.entryCacheEnv.evictMemory();
                    this.entryCacheEnv.cleanLog();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block3;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }

    @Override
    public boolean isConfigurationAcceptable(EntryCacheCfg configuration, List<Message> unacceptableReasons) {
        FileSystemEntryCacheCfg config = (FileSystemEntryCacheCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(FileSystemEntryCacheCfg configuration, List<Message> unacceptableReasons) {
        boolean applyChanges = false;
        EntryCacheCommon.ConfigErrorHandler errorHandler = EntryCacheCommon.getConfigErrorHandler(EntryCacheCommon.ConfigPhase.PHASE_ACCEPTABLE, unacceptableReasons, null);
        this.processEntryCacheConfig(configuration, applyChanges, errorHandler);
        return errorHandler.getIsAcceptable();
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(FileSystemEntryCacheCfg configuration) {
        boolean applyChanges = false;
        ArrayList<Message> errorMessages = new ArrayList<Message>();
        EntryCacheCommon.ConfigErrorHandler errorHandler = EntryCacheCommon.getConfigErrorHandler(EntryCacheCommon.ConfigPhase.PHASE_APPLY, null, errorMessages);
        this.processEntryCacheConfig(configuration, applyChanges, errorHandler);
        boolean adminActionRequired = false;
        ConfigChangeResult changeResult = new ConfigChangeResult(errorHandler.getResultCode(), adminActionRequired, errorHandler.getErrorMessages());
        return changeResult;
    }

    public ConfigChangeResult applyNewConfiguration(FileSystemEntryCacheCfg configuration, boolean detailedResults) {
        boolean configIsAcceptable;
        long prevLockTimeout = this.getLockTimeout();
        long prevMaxEntries = this.maxEntries.longValue();
        Set<SearchFilter> prevIncludeFilters = this.getIncludeFilters();
        Set<SearchFilter> prevExcludeFilters = this.getExcludeFilters();
        long prevMaxAllowedMemory = this.maxAllowedMemory;
        int prevJECachePercent = this.jeCachePercent;
        long prevJECacheSize = this.jeCacheSize;
        boolean prevPersistentCache = this.persistentCache;
        ConfigChangeResult changeResult = this.applyConfigurationChange(configuration);
        ResultCode resultCode = changeResult.getResultCode();
        boolean bl = configIsAcceptable = resultCode == ResultCode.SUCCESS;
        if (detailedResults && configIsAcceptable) {
            if (this.maxEntries.longValue() != prevMaxEntries) {
                changeResult.addMessage(ExtensionMessages.INFO_FSCACHE_UPDATED_MAX_ENTRIES.get(this.maxEntries));
            }
            if (this.getLockTimeout() != prevLockTimeout) {
                changeResult.addMessage(ExtensionMessages.INFO_FSCACHE_UPDATED_LOCK_TIMEOUT.get(this.getLockTimeout()));
            }
            if (!((Object)this.getIncludeFilters()).equals(prevIncludeFilters)) {
                changeResult.addMessage(ExtensionMessages.INFO_FSCACHE_UPDATED_INCLUDE_FILTERS.get());
            }
            if (!((Object)this.getExcludeFilters()).equals(prevExcludeFilters)) {
                changeResult.addMessage(ExtensionMessages.INFO_FSCACHE_UPDATED_EXCLUDE_FILTERS.get());
            }
            if (this.maxAllowedMemory != prevMaxAllowedMemory) {
                changeResult.addMessage(ExtensionMessages.INFO_FSCACHE_UPDATED_MAX_MEMORY_SIZE.get(this.maxAllowedMemory));
            }
            if (this.jeCachePercent != prevJECachePercent) {
                changeResult.addMessage(ExtensionMessages.INFO_FSCACHE_UPDATED_JE_MEMORY_PCT.get(this.jeCachePercent));
            }
            if (this.jeCacheSize != prevJECacheSize) {
                changeResult.addMessage(ExtensionMessages.INFO_FSCACHE_UPDATED_JE_MEMORY_SIZE.get(this.jeCacheSize));
            }
            if (this.persistentCache != prevPersistentCache) {
                changeResult.addMessage(ExtensionMessages.INFO_FSCACHE_UPDATED_IS_PERSISTENT.get(String.valueOf(this.persistentCache)));
            }
        }
        return changeResult;
    }

    public boolean processEntryCacheConfig(FileSystemEntryCacheCfg configuration, boolean applyChanges, EntryCacheCommon.ConfigErrorHandler errorHandler) {
        HashSet<SearchFilter> newIncludeFilters = null;
        HashSet<SearchFilter> newExcludeFilters = null;
        String newCacheType = "FIFO";
        String newCacheHome = "/tmp/OpenDS.FSCache";
        DN newConfigEntryDN = configuration.dn();
        long newLockTimeout = configuration.getLockTimeout();
        long newMaxEntries = configuration.getMaxEntries();
        if (newMaxEntries <= 0L) {
            newMaxEntries = Long.MAX_VALUE;
        }
        long newMaxAllowedMemory = configuration.getMaxMemorySize();
        int newJECachePercent = configuration.getDatabaseCachePercent();
        long newJECacheSize = configuration.getDatabaseCacheSize();
        boolean newPersistentCache = configuration.isPersistentCache();
        switch (errorHandler.getConfigPhase()) {
            case PHASE_INIT: {
                newCacheType = configuration.getCacheType().toString();
                newCacheHome = configuration.getCacheDirectory();
                newIncludeFilters = EntryCacheCommon.getFilters(configuration.getIncludeFilter(), ExtensionMessages.ERR_FIFOCACHE_INVALID_INCLUDE_FILTER, ExtensionMessages.WARN_FIFOCACHE_CANNOT_DECODE_ANY_INCLUDE_FILTERS, errorHandler, this.configEntryDN);
                newExcludeFilters = EntryCacheCommon.getFilters(configuration.getExcludeFilter(), ExtensionMessages.WARN_FIFOCACHE_CANNOT_DECODE_EXCLUDE_FILTER, ExtensionMessages.WARN_FIFOCACHE_CANNOT_DECODE_ANY_EXCLUDE_FILTERS, errorHandler, this.configEntryDN);
                break;
            }
            case PHASE_ACCEPTABLE: 
            case PHASE_APPLY: {
                newIncludeFilters = EntryCacheCommon.getFilters(configuration.getIncludeFilter(), ExtensionMessages.ERR_FIFOCACHE_INVALID_INCLUDE_FILTER, null, errorHandler, this.configEntryDN);
                newExcludeFilters = EntryCacheCommon.getFilters(configuration.getExcludeFilter(), ExtensionMessages.ERR_FIFOCACHE_INVALID_EXCLUDE_FILTER, null, errorHandler, this.configEntryDN);
            }
        }
        if (applyChanges && errorHandler.getIsAcceptable()) {
            switch (errorHandler.getConfigPhase()) {
                case PHASE_INIT: {
                    this.cacheType = newCacheType;
                    this.cacheHome = newCacheHome;
                    this.jeCachePercent = newJECachePercent;
                    this.jeCacheSize = newJECacheSize;
                    break;
                }
                case PHASE_APPLY: {
                    EnvironmentConfig envConfig;
                    this.jeCachePercent = newJECachePercent;
                    try {
                        envConfig = this.entryCacheEnv.getConfig();
                        envConfig.setCachePercent(this.jeCachePercent);
                        this.entryCacheEnv.setMutableConfig((EnvironmentMutableConfig)envConfig);
                        this.entryCacheEnv.evictMemory();
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        errorHandler.reportError(ExtensionMessages.ERR_FSCACHE_CANNOT_SET_JE_MEMORY_PCT.get(), false, DirectoryServer.getServerErrorResultCode());
                    }
                    this.jeCacheSize = newJECacheSize;
                    try {
                        envConfig = this.entryCacheEnv.getConfig();
                        envConfig.setCacheSize(this.jeCacheSize);
                        this.entryCacheEnv.setMutableConfig((EnvironmentMutableConfig)envConfig);
                        this.entryCacheEnv.evictMemory();
                        break;
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        errorHandler.reportError(ExtensionMessages.ERR_FSCACHE_CANNOT_SET_JE_MEMORY_SIZE.get(), false, DirectoryServer.getServerErrorResultCode());
                    }
                }
            }
            this.configEntryDN = newConfigEntryDN;
            this.maxEntries = new AtomicLong(newMaxEntries);
            this.maxAllowedMemory = newMaxAllowedMemory;
            this.persistentCache = newPersistentCache;
            this.setLockTimeout(newLockTimeout);
            this.setIncludeFilters(newIncludeFilters);
            this.setExcludeFilters(newExcludeFilters);
        }
        return errorHandler.getIsAcceptable();
    }

    private Entry getEntryFromDB(DN entryDN) {
        DatabaseEntry cacheEntryKey = new DatabaseEntry();
        DatabaseEntry primaryData = new DatabaseEntry();
        try {
            cacheEntryKey.setData(entryDN.toNormalizedString().getBytes("UTF-8"));
            if (this.entryCacheDB.get(null, cacheEntryKey, primaryData, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                Entry entry = Entry.decode(primaryData.getData());
                entry.setDN(entryDN);
                return entry;
            }
            throw new Exception();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            ErrorLogger.logError(ExtensionMessages.ERR_FSCACHE_CANNOT_RETRIEVE_ENTRY.get());
            return null;
        }
    }

    private boolean putEntryToDB(Entry entry, Backend backend, long entryID) {
        try {
            long usedMemory = 0L;
            if (this.maxAllowedMemory != 0L && (usedMemory = this.entryCacheEnv.getStats(this.entryCacheEnvStatsConfig).getTotalLogSize()) > this.maxAllowedMemory) {
                long savedMaxEntries = this.maxEntries.longValue();
                this.maxEntries.set(this.dnMap.isEmpty() ? 0 : this.dnMap.size() - 1);
                this.dnMap.put(entry.getDN(), entryID);
                this.dnMap.remove(entry.getDN());
                this.maxEntries.set(savedMaxEntries);
                return true;
            }
            DatabaseEntry cacheEntryKey = new DatabaseEntry();
            cacheEntryKey.setData(entry.getDN().toNormalizedString().getBytes("UTF-8"));
            if (this.entryCacheDB.put(null, cacheEntryKey, new DatabaseEntry(entry.encode(encodeConfig))) == OperationStatus.SUCCESS) {
                Map<Long, DN> map = this.backendMap.get(backend);
                if (map == null) {
                    map = new LinkedHashMap<Long, DN>();
                    map.put(entryID, entry.getDN());
                    this.backendMap.put(backend, map);
                } else {
                    map.put(entryID, entry.getDN());
                }
                this.dnMap.put(entry.getDN(), entryID);
            }
            return true;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            ErrorLogger.logError(ExtensionMessages.ERR_FSCACHE_CANNOT_STORE_ENTRY.get());
            return false;
        }
    }

    private void checkAndSetupCacheHome(String cacheHome) throws Exception {
        boolean cacheHasHome = false;
        File cacheHomeDir = new File(cacheHome);
        if (cacheHomeDir.exists() && cacheHomeDir.canRead() && cacheHomeDir.canWrite()) {
            cacheHasHome = true;
        } else {
            try {
                cacheHasHome = cacheHomeDir.mkdirs();
            }
            catch (SecurityException e) {
                cacheHasHome = false;
            }
        }
        if (cacheHasHome) {
            if (FilePermission.canSetPermissions()) {
                try {
                    if (!FilePermission.setPermissions(cacheHomeDir, CACHE_HOME_PERMISSIONS)) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    Message message = ExtensionMessages.WARN_FSCACHE_SET_PERMISSIONS_FAILED.get(cacheHome);
                    ErrorLogger.logError(message);
                }
            }
        } else {
            throw new Exception();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toVerboseString() {
        LinkedHashMap<Backend, Map<Long, DN>> backendMapCopy;
        LinkedHashMap<DN, Long> dnMapCopy;
        String verboseString = new String();
        StringBuilder sb = new StringBuilder();
        this.cacheWriteLock.lock();
        try {
            dnMapCopy = new LinkedHashMap<DN, Long>(this.dnMap);
            backendMapCopy = new LinkedHashMap<Backend, Map<Long, DN>>(this.backendMap);
        }
        finally {
            this.cacheWriteLock.unlock();
        }
        for (DN dn : dnMapCopy.keySet()) {
            sb.append(dn.toString());
            sb.append(":");
            sb.append(dnMapCopy.get(dn) != null ? ((Long)dnMapCopy.get(dn)).toString() : null);
            sb.append(":");
            Backend backend2 = null;
            String backendID = null;
            for (Backend backend2 : backendMapCopy.keySet()) {
                Map map = (Map)backendMapCopy.get(backend2);
                if (map == null || map.get(dnMapCopy.get(dn)) == null || !((DN)map.get(dnMapCopy.get(dn))).equals(dn)) continue;
                backendID = backend2.getBackendID();
                break;
            }
            sb.append(backendID);
            sb.append(ServerConstants.EOL);
        }
        Backend backend3 = null;
        for (Backend backend3 : backendMapCopy.keySet()) {
            Map map = (Map)backendMapCopy.get(backend3);
            for (Long id : map.keySet()) {
                if (dnMapCopy.containsKey(map.get(id)) && map.get(id) != null) continue;
                sb.append(map.get(id) != null ? (DN)map.get(id) : null);
                sb.append(":");
                sb.append(id.toString());
                sb.append(":");
                sb.append(backend3.getBackendID());
                sb.append(ServerConstants.EOL);
            }
        }
        verboseString = sb.toString();
        return verboseString.length() > 0 ? verboseString : null;
    }

    private class CacheIndexImpairedException
    extends OpenDsException {
        static final long serialVersionUID = -369455697709478407L;

        public CacheIndexImpairedException() {
        }

        public CacheIndexImpairedException(Message message) {
            super(message);
        }
    }

    private class CacheIndexNotFoundException
    extends OpenDsException {
        static final long serialVersionUID = 6444756053577853869L;

        public CacheIndexNotFoundException() {
        }

        public CacheIndexNotFoundException(Message message) {
            super(message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LinkedHashMapRotator<K, V>
    extends LinkedHashMap<K, V> {
        static final long serialVersionUID = 5271482121415968435L;

        public LinkedHashMapRotator(int initialCapacity, float loadFactor, boolean accessOrder) {
            super(initialCapacity, loadFactor, accessOrder);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            if ((long)this.size() > FileSystemEntryCache.this.maxEntries.longValue()) {
                DatabaseEntry cacheEntryKey = new DatabaseEntry();
                FileSystemEntryCache.this.cacheWriteLock.lock();
                try {
                    DN entryDN = (DN)eldest.getKey();
                    long entryID = (Long)eldest.getValue();
                    cacheEntryKey.setData(entryDN.toNormalizedString().getBytes("UTF-8"));
                    Set backendSet = FileSystemEntryCache.this.backendMap.keySet();
                    Iterator backendIterator = backendSet.iterator();
                    while (backendIterator.hasNext()) {
                        Map map = (Map)FileSystemEntryCache.this.backendMap.get(backendIterator.next());
                        if (map.get(entryID) == null || !((DN)map.get(entryID)).equals(entryDN)) continue;
                        map.remove(entryID);
                        if (!map.isEmpty()) break;
                        backendIterator.remove();
                        break;
                    }
                    FileSystemEntryCache.this.entryCacheDB.delete(null, cacheEntryKey);
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                finally {
                    FileSystemEntryCache.this.cacheWriteLock.unlock();
                }
                return true;
            }
            return false;
        }
    }
}

