/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.PasswordStorageSchemeCfg;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringFactory;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.Base64;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaltedMD5PasswordStorageScheme
extends PasswordStorageScheme<PasswordStorageSchemeCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String CLASS_NAME = "org.opends.server.extensions.SaltedMD5PasswordStorageScheme";
    private static final int NUM_SALT_BYTES = 8;
    private MessageDigest messageDigest;
    private ReentrantLock digestLock;
    private SecureRandom random;

    @Override
    public void initializePasswordStorageScheme(PasswordStorageSchemeCfg configuration) throws ConfigException, InitializationException {
        try {
            this.messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_PWSCHEME_CANNOT_INITIALIZE_MESSAGE_DIGEST.get("MD5", String.valueOf(e));
            throw new InitializationException(message, (Throwable)e);
        }
        this.digestLock = new ReentrantLock();
        this.random = new SecureRandom();
    }

    @Override
    public String getStorageSchemeName() {
        return "SMD5";
    }

    @Override
    public ByteString encodePassword(ByteString plaintext) throws DirectoryException {
        byte[] digestBytes;
        byte[] plainBytes = plaintext.value();
        byte[] saltBytes = new byte[8];
        byte[] plainPlusSalt = new byte[plainBytes.length + 8];
        System.arraycopy(plainBytes, 0, plainPlusSalt, 0, plainBytes.length);
        this.digestLock.lock();
        try {
            this.random.nextBytes(saltBytes);
            System.arraycopy(saltBytes, 0, plainPlusSalt, plainBytes.length, 8);
            digestBytes = this.messageDigest.digest(plainPlusSalt);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_PWSCHEME_CANNOT_ENCODE_PASSWORD.get(CLASS_NAME, StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        finally {
            this.digestLock.unlock();
        }
        byte[] hashPlusSalt = new byte[digestBytes.length + 8];
        System.arraycopy(digestBytes, 0, hashPlusSalt, 0, digestBytes.length);
        System.arraycopy(saltBytes, 0, hashPlusSalt, digestBytes.length, 8);
        return ByteStringFactory.create(Base64.encode(hashPlusSalt));
    }

    @Override
    public ByteString encodePasswordWithScheme(ByteString plaintext) throws DirectoryException {
        byte[] digestBytes;
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        buffer.append("SMD5");
        buffer.append('}');
        byte[] plainBytes = plaintext.value();
        byte[] saltBytes = new byte[8];
        byte[] plainPlusSalt = new byte[plainBytes.length + 8];
        System.arraycopy(plainBytes, 0, plainPlusSalt, 0, plainBytes.length);
        this.digestLock.lock();
        try {
            this.random.nextBytes(saltBytes);
            System.arraycopy(saltBytes, 0, plainPlusSalt, plainBytes.length, 8);
            digestBytes = this.messageDigest.digest(plainPlusSalt);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_PWSCHEME_CANNOT_ENCODE_PASSWORD.get(CLASS_NAME, StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        finally {
            this.digestLock.unlock();
        }
        byte[] hashPlusSalt = new byte[digestBytes.length + 8];
        System.arraycopy(digestBytes, 0, hashPlusSalt, 0, digestBytes.length);
        System.arraycopy(saltBytes, 0, hashPlusSalt, digestBytes.length, 8);
        buffer.append(Base64.encode(hashPlusSalt));
        return ByteStringFactory.create(buffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean passwordMatches(ByteString plaintextPassword, ByteString storedPassword) {
        byte[] userDigestBytes;
        byte[] digestBytes;
        byte[] saltBytes = new byte[8];
        try {
            byte[] decodedBytes = Base64.decode(storedPassword.stringValue());
            int digestLength = decodedBytes.length - 8;
            digestBytes = new byte[digestLength];
            System.arraycopy(decodedBytes, 0, digestBytes, 0, digestLength);
            System.arraycopy(decodedBytes, digestLength, saltBytes, 0, 8);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_PWSCHEME_CANNOT_BASE64_DECODE_STORED_PASSWORD.get(storedPassword.stringValue(), String.valueOf(e));
            ErrorLogger.logError(message);
            return false;
        }
        byte[] plainBytes = plaintextPassword.value();
        byte[] plainPlusSalt = new byte[plainBytes.length + 8];
        System.arraycopy(plainBytes, 0, plainPlusSalt, 0, plainBytes.length);
        System.arraycopy(saltBytes, 0, plainPlusSalt, plainBytes.length, 8);
        this.digestLock.lock();
        try {
            userDigestBytes = this.messageDigest.digest(plainPlusSalt);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.digestLock.unlock();
        }
        return Arrays.equals(digestBytes, userDigestBytes);
    }

    @Override
    public boolean supportsAuthPasswordSyntax() {
        return true;
    }

    @Override
    public String getAuthPasswordSchemeName() {
        return "MD5";
    }

    @Override
    public ByteString encodeAuthPassword(ByteString plaintext) throws DirectoryException {
        byte[] digestBytes;
        byte[] plainBytes = plaintext.value();
        byte[] saltBytes = new byte[8];
        byte[] plainPlusSalt = new byte[plainBytes.length + 8];
        System.arraycopy(plainBytes, 0, plainPlusSalt, 0, plainBytes.length);
        this.digestLock.lock();
        try {
            this.random.nextBytes(saltBytes);
            System.arraycopy(saltBytes, 0, plainPlusSalt, plainBytes.length, 8);
            digestBytes = this.messageDigest.digest(plainPlusSalt);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_PWSCHEME_CANNOT_ENCODE_PASSWORD.get(CLASS_NAME, StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        finally {
            this.digestLock.unlock();
        }
        StringBuilder authPWValue = new StringBuilder();
        authPWValue.append("MD5");
        authPWValue.append('$');
        authPWValue.append(Base64.encode(saltBytes));
        authPWValue.append('$');
        authPWValue.append(Base64.encode(digestBytes));
        return ByteStringFactory.create(authPWValue.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean authPasswordMatches(ByteString plaintextPassword, String authInfo, String authValue) {
        byte[] digestBytes;
        byte[] saltBytes;
        try {
            saltBytes = Base64.decode(authInfo);
            digestBytes = Base64.decode(authValue);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return false;
        }
        byte[] plainBytes = plaintextPassword.value();
        byte[] plainPlusSaltBytes = new byte[plainBytes.length + saltBytes.length];
        System.arraycopy(plainBytes, 0, plainPlusSaltBytes, 0, plainBytes.length);
        System.arraycopy(saltBytes, 0, plainPlusSaltBytes, plainBytes.length, saltBytes.length);
        this.digestLock.lock();
        try {
            boolean bl = Arrays.equals(digestBytes, this.messageDigest.digest(plainPlusSaltBytes));
            return bl;
        }
        finally {
            this.digestLock.unlock();
        }
    }

    @Override
    public boolean isReversible() {
        return false;
    }

    @Override
    public ByteString getPlaintextValue(ByteString storedPassword) throws DirectoryException {
        Message message = ExtensionMessages.ERR_PWSCHEME_NOT_REVERSIBLE.get("SMD5");
        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
    }

    @Override
    public ByteString getAuthPasswordPlaintextValue(String authInfo, String authValue) throws DirectoryException {
        Message message = ExtensionMessages.ERR_PWSCHEME_NOT_REVERSIBLE.get("MD5");
        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
    }

    @Override
    public boolean isStorageSchemeSecure() {
        return true;
    }
}

