/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.ExtendedOperationHandlerCfg;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ExtendedOperationHandler;
import org.opends.server.config.ConfigException;
import org.opends.server.controls.ProxiedAuthV1Control;
import org.opends.server.controls.ProxiedAuthV2Control;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDAPException;
import org.opends.server.types.Privilege;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WhoAmIExtendedOperation
extends ExtendedOperationHandler<ExtendedOperationHandlerCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    @Override
    public void initializeExtendedOperationHandler(ExtendedOperationHandlerCfg config) throws ConfigException, InitializationException {
        DirectoryServer.registerSupportedExtension("1.3.6.1.4.1.4203.1.11.3", this);
        this.registerControlsAndFeatures();
    }

    @Override
    public void finalizeExtendedOperationHandler() {
        DirectoryServer.deregisterSupportedExtension("1.3.6.1.4.1.4203.1.11.3");
        this.deregisterControlsAndFeatures();
    }

    @Override
    public Set<String> getSupportedControls() {
        HashSet<String> supportedControls = new HashSet<String>(2);
        supportedControls.add("2.16.840.1.113730.3.4.12");
        supportedControls.add("2.16.840.1.113730.3.4.18");
        return supportedControls;
    }

    @Override
    public void processExtendedOperation(ExtendedOperation operation) {
        DN authzDN;
        ClientConnection clientConnection = operation.getClientConnection();
        List<Control> requestControls = operation.getRequestControls();
        if (requestControls != null) {
            for (Control c : requestControls) {
                Entry authorizationEntry;
                Control proxyControl;
                String oid = c.getOID();
                if (oid.equals("2.16.840.1.113730.3.4.12")) {
                    if (!clientConnection.hasPrivilege(Privilege.PROXIED_AUTH, operation)) {
                        operation.appendErrorMessage(ExtensionMessages.ERR_EXTOP_WHOAMI_PROXYAUTH_INSUFFICIENT_PRIVILEGES.get());
                        operation.setResultCode(ResultCode.AUTHORIZATION_DENIED);
                        return;
                    }
                    if (c instanceof ProxiedAuthV1Control) {
                        proxyControl = (ProxiedAuthV1Control)c;
                    } else {
                        try {
                            proxyControl = ProxiedAuthV1Control.decodeControl(c);
                        }
                        catch (LDAPException le) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, le);
                            }
                            operation.setResultCode(ResultCode.valueOf(le.getResultCode()));
                            operation.appendErrorMessage(le.getMessageObject());
                            return;
                        }
                    }
                    try {
                        authorizationEntry = ((ProxiedAuthV1Control)proxyControl).getAuthorizationEntry();
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        operation.setResultCode(de.getResultCode());
                        operation.appendErrorMessage(de.getMessageObject());
                        return;
                    }
                    operation.setAuthorizationEntry(authorizationEntry);
                    continue;
                }
                if (!oid.equals("2.16.840.1.113730.3.4.18")) continue;
                if (!clientConnection.hasPrivilege(Privilege.PROXIED_AUTH, operation)) {
                    operation.appendErrorMessage(ExtensionMessages.ERR_EXTOP_WHOAMI_PROXYAUTH_INSUFFICIENT_PRIVILEGES.get());
                    operation.setResultCode(ResultCode.AUTHORIZATION_DENIED);
                    return;
                }
                if (c instanceof ProxiedAuthV2Control) {
                    proxyControl = (ProxiedAuthV2Control)c;
                } else {
                    try {
                        proxyControl = ProxiedAuthV2Control.decodeControl(c);
                    }
                    catch (LDAPException le) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, le);
                        }
                        operation.setResultCode(ResultCode.valueOf(le.getResultCode()));
                        operation.appendErrorMessage(le.getMessageObject());
                        return;
                    }
                }
                try {
                    authorizationEntry = ((ProxiedAuthV2Control)proxyControl).getAuthorizationEntry();
                }
                catch (DirectoryException de) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, de);
                    }
                    operation.setResultCode(de.getResultCode());
                    operation.appendErrorMessage(de.getMessageObject());
                    return;
                }
                operation.setAuthorizationEntry(authorizationEntry);
            }
        }
        String authzID = (authzDN = operation.getAuthorizationDN()) == null ? "" : "dn:" + authzDN.toString();
        operation.setResponseValue(new ASN1OctetString(authzID));
        operation.appendAdditionalLogMessage(Message.raw("authzID=\"" + authzID + "\"", new Object[0]));
        operation.setResultCode(ResultCode.SUCCESS);
    }
}

