/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.std.meta.ErrorLogPublisherCfgDefn;
import org.opends.server.admin.std.server.ErrorLogPublisherCfg;
import org.opends.server.api.DirectoryThread;
import org.opends.server.api.ErrorLogPublisher;
import org.opends.server.backends.task.Task;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorLogger
implements ConfigurationAddListener<ErrorLogPublisherCfg>,
ConfigurationDeleteListener<ErrorLogPublisherCfg>,
ConfigurationChangeListener<ErrorLogPublisherCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static CopyOnWriteArrayList<ErrorLogPublisher> errorPublishers = new CopyOnWriteArrayList();
    private static final ErrorLogger instance = new ErrorLogger();

    public static ErrorLogger getInstance() {
        return instance;
    }

    public static synchronized void addErrorLogPublisher(ErrorLogPublisher publisher) {
        errorPublishers.add(publisher);
    }

    public static synchronized boolean removeErrorLogPublisher(ErrorLogPublisher publisher) {
        boolean removed = errorPublishers.remove(publisher);
        if (removed) {
            publisher.close();
        }
        return removed;
    }

    public static synchronized void removeAllErrorLogPublishers() {
        for (ErrorLogPublisher publisher : errorPublishers) {
            publisher.close();
        }
        errorPublishers.clear();
    }

    public void initializeErrorLogger(List<ErrorLogPublisherCfg> configs) throws ConfigException, InitializationException {
        for (ErrorLogPublisherCfg config : configs) {
            config.addErrorChangeListener(this);
            if (!config.isEnabled()) continue;
            ErrorLogPublisher errorLogPublisher = this.getErrorPublisher(config);
            ErrorLogger.addErrorLogPublisher(errorLogPublisher);
        }
    }

    @Override
    public boolean isConfigurationAddAcceptable(ErrorLogPublisherCfg config, List<Message> unacceptableReasons) {
        return !config.isEnabled() || this.isJavaClassAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(ErrorLogPublisherCfg config, List<Message> unacceptableReasons) {
        return !config.isEnabled() || this.isJavaClassAcceptable(config, unacceptableReasons);
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(ErrorLogPublisherCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        config.addErrorChangeListener(this);
        if (config.isEnabled()) {
            try {
                ErrorLogPublisher errorLogPublisher = this.getErrorPublisher(config);
                ErrorLogger.addErrorLogPublisher(errorLogPublisher);
            }
            catch (ConfigException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                messages.add(e.getMessageObject());
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                messages.add(ConfigMessages.ERR_CONFIG_LOGGER_CANNOT_CREATE_LOGGER.get(String.valueOf(config.dn().toString()), StaticUtils.stackTraceToSingleLineString(e)));
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(ErrorLogPublisherCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        DN dn = config.dn();
        ErrorLogPublisher errorLogPublisher = null;
        for (ErrorLogPublisher publisher : errorPublishers) {
            if (!publisher.getDN().equals(dn)) continue;
            errorLogPublisher = publisher;
            break;
        }
        if (errorLogPublisher == null) {
            if (config.isEnabled()) {
                return this.applyConfigurationAdd(config);
            }
        } else if (config.isEnabled()) {
            String className = config.getJavaImplementationClass();
            if (!className.equals(errorLogPublisher.getClass().getName())) {
                adminActionRequired = true;
            }
        } else {
            ErrorLogger.removeErrorLogPublisher(errorLogPublisher);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(ErrorLogPublisherCfg config, List<Message> unacceptableReasons) {
        DN dn = config.dn();
        ErrorLogPublisher errorLogPublisher = null;
        for (ErrorLogPublisher publisher : errorPublishers) {
            if (!publisher.getDN().equals(dn)) continue;
            errorLogPublisher = publisher;
            break;
        }
        return errorLogPublisher != null;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(ErrorLogPublisherCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ErrorLogPublisher errorLogPublisher = null;
        for (ErrorLogPublisher publisher : errorPublishers) {
            if (!publisher.getDN().equals(config.dn())) continue;
            errorLogPublisher = publisher;
            break;
        }
        if (errorLogPublisher != null) {
            ErrorLogger.removeErrorLogPublisher(errorLogPublisher);
        } else {
            resultCode = ResultCode.NO_SUCH_OBJECT;
        }
        return new ConfigChangeResult(resultCode, adminActionRequired);
    }

    private boolean isJavaClassAcceptable(ErrorLogPublisherCfg config, List<Message> unacceptableReasons) {
        Class<ErrorLogPublisher> theClass;
        String className = config.getJavaImplementationClass();
        ErrorLogPublisherCfgDefn d = ErrorLogPublisherCfgDefn.getInstance();
        ClassPropertyDefinition pd = d.getJavaImplementationClassPropertyDefinition();
        ErrorLogPublisher publisher = null;
        try {
            theClass = pd.loadClass(className, ErrorLogPublisher.class);
            publisher = theClass.newInstance();
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGER_INVALID_ERROR_LOGGER_CLASS.get(className, config.dn().toString(), String.valueOf(e));
            unacceptableReasons.add(message);
            return false;
        }
        try {
            Method method = theClass.getMethod("isConfigurationAcceptable", ErrorLogPublisherCfg.class, List.class);
            Boolean acceptable = (Boolean)method.invoke((Object)publisher, config, unacceptableReasons);
            if (!acceptable.booleanValue()) {
                return false;
            }
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGER_INVALID_ERROR_LOGGER_CLASS.get(className, config.dn().toString(), String.valueOf(e));
            unacceptableReasons.add(message);
            return false;
        }
        return true;
    }

    private ErrorLogPublisher getErrorPublisher(ErrorLogPublisherCfg config) throws ConfigException {
        ErrorLogPublisher errorLogPublisher;
        String className = config.getJavaImplementationClass();
        ErrorLogPublisherCfgDefn d = ErrorLogPublisherCfgDefn.getInstance();
        ClassPropertyDefinition pd = d.getJavaImplementationClassPropertyDefinition();
        try {
            Class<ErrorLogPublisher> theClass = pd.loadClass(className, ErrorLogPublisher.class);
            errorLogPublisher = theClass.newInstance();
            Method method = theClass.getMethod("initializeErrorLogPublisher", config.definition().getServerConfigurationClass());
            method.invoke((Object)errorLogPublisher, config);
        }
        catch (InvocationTargetException ite) {
            Throwable e = ite.getTargetException();
            Message message = ConfigMessages.ERR_CONFIG_LOGGER_INVALID_ERROR_LOGGER_CLASS.get(className, config.dn().toString(), StaticUtils.stackTraceToSingleLineString(e));
            throw new ConfigException(message, e);
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGER_INVALID_ERROR_LOGGER_CLASS.get(className, config.dn().toString(), String.valueOf(e));
            throw new ConfigException(message, (Throwable)e);
        }
        return errorLogPublisher;
    }

    public static void logError(Message message) {
        DirectoryThread thread;
        Task task;
        for (ErrorLogPublisher publisher : errorPublishers) {
            publisher.logError(message);
        }
        if (Thread.currentThread() instanceof DirectoryThread && (task = (thread = (DirectoryThread)Thread.currentThread()).getAssociatedTask()) != null) {
            task.addLogMessage(message);
        }
    }
}

