/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.io.File;
import org.opends.messages.LoggerMessages;
import org.opends.messages.Message;
import org.opends.server.types.DN;
import org.opends.server.util.StaticUtils;

public class LogPublisherErrorHandler {
    private DN publisherConfigDN;
    private boolean writeErroroccurred = false;

    public LogPublisherErrorHandler(DN publisherConfigDN) {
        this.publisherConfigDN = publisherConfigDN;
    }

    public void handleWriteError(String record, Throwable ex) {
        if (!this.writeErroroccurred) {
            Message msg = LoggerMessages.ERR_LOGGER_ERROR_WRITING_RECORD.get(this.publisherConfigDN.toString(), StaticUtils.stackTraceToSingleLineString(ex));
            System.err.println(msg);
            this.writeErroroccurred = true;
        }
    }

    public void handleOpenError(File file, Throwable ex) {
        Message msg = LoggerMessages.ERR_LOGGER_ERROR_OPENING_FILE.get(file.toString(), this.publisherConfigDN.toString(), StaticUtils.stackTraceToSingleLineString(ex));
        System.err.println(msg);
    }

    public void handleCloseError(Throwable ex) {
        Message msg = LoggerMessages.ERR_LOGGER_ERROR_CLOSING_FILE.get(this.publisherConfigDN.toString(), StaticUtils.stackTraceToSingleLineString(ex));
        System.err.println(msg);
    }

    public void handleFlushError(Throwable ex) {
        Message msg = LoggerMessages.ERR_LOGGER_ERROR_FLUSHING_BUFFER.get(this.publisherConfigDN.toString(), StaticUtils.stackTraceToSingleLineString(ex));
        System.err.println(msg);
    }
}

