/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers.debug;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.std.meta.DebugLogPublisherCfgDefn;
import org.opends.server.admin.std.server.DebugLogPublisherCfg;
import org.opends.server.admin.std.server.DebugTargetCfg;
import org.opends.server.admin.std.server.FileBasedDebugLogPublisherCfg;
import org.opends.server.api.DebugLogPublisher;
import org.opends.server.api.DirectoryThread;
import org.opends.server.api.ProtocolElement;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.AsyncronousTextWriter;
import org.opends.server.loggers.LogCategory;
import org.opends.server.loggers.LogLevel;
import org.opends.server.loggers.LogPublisherErrorHandler;
import org.opends.server.loggers.MultifileTextWriter;
import org.opends.server.loggers.RetentionPolicy;
import org.opends.server.loggers.RotationPolicy;
import org.opends.server.loggers.TextWriter;
import org.opends.server.loggers.TimeStampNaming;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugMessageFormatter;
import org.opends.server.loggers.debug.DebugStackTraceFormatter;
import org.opends.server.loggers.debug.TraceSettings;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogCategory;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.FilePermission;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextDebugLogPublisher
extends DebugLogPublisher<FileBasedDebugLogPublisherCfg>
implements ConfigurationChangeListener<FileBasedDebugLogPublisherCfg>,
ConfigurationAddListener<DebugTargetCfg>,
ConfigurationDeleteListener<DebugTargetCfg> {
    private static long globalSequenceNumber;
    private TextWriter writer;
    private FileBasedDebugLogPublisherCfg currentConfig;

    public static TextDebugLogPublisher getStartupTextDebugPublisher(TextWriter writer) {
        TextDebugLogPublisher startupPublisher = new TextDebugLogPublisher();
        startupPublisher.writer = writer;
        Set<Map.Entry<Object, Object>> propertyEntries = System.getProperties().entrySet();
        for (Map.Entry<Object, Object> entry : propertyEntries) {
            String value;
            int settingsStart;
            if (!((String)entry.getKey()).startsWith("org.opends.server.debug.target") || (settingsStart = (value = (String)entry.getValue()).indexOf(":")) <= 0) continue;
            String scope = value.substring(0, settingsStart);
            TraceSettings settings = TraceSettings.parseTraceSettings(value.substring(settingsStart + 1));
            if (settings == null) continue;
            startupPublisher.addTraceSettings(scope, settings);
        }
        return startupPublisher;
    }

    @Override
    public void initializeDebugLogPublisher(FileBasedDebugLogPublisherCfg config) throws ConfigException, InitializationException {
        File logFile = StaticUtils.getFileForPath(config.getLogFile());
        TimeStampNaming fnPolicy = new TimeStampNaming(logFile);
        try {
            Object policy;
            FilePermission perm = FilePermission.decodeUNIXMode(config.getLogFileMode());
            LogPublisherErrorHandler errorHandler = new LogPublisherErrorHandler(config.dn());
            boolean writerAutoFlush = config.isAutoFlush() && !config.isAsynchronous();
            MultifileTextWriter writer = new MultifileTextWriter("Multifile Text Writer for " + config.dn().toNormalizedString(), config.getTimeInterval(), fnPolicy, perm, errorHandler, "UTF-8", writerAutoFlush, config.isAppend(), (int)config.getBufferSize());
            for (DN dn : config.getRotationPolicyDN()) {
                policy = DirectoryServer.getRotationPolicy(dn);
                if (policy != null) {
                    writer.addRotationPolicy((RotationPolicy)policy);
                    continue;
                }
                Message message = ConfigMessages.ERR_CONFIG_LOGGER_INVALID_ROTATION_POLICY.get(dn.toString(), config.dn().toString());
                throw new ConfigException(message);
            }
            for (DN dn : config.getRetentionPolicyDN()) {
                policy = DirectoryServer.getRetentionPolicy(dn);
                if (policy != null) {
                    writer.addRetentionPolicy((RetentionPolicy)policy);
                    continue;
                }
                Message message = ConfigMessages.WARN_CONFIG_LOGGER_INVALID_RETENTION_POLICY.get(dn.toString(), config.dn().toString());
                throw new ConfigException(message);
            }
            this.writer = config.isAsynchronous() ? new AsyncronousTextWriter("Asyncronous Text Writer for " + config.dn().toNormalizedString(), config.getQueueSize(), config.isAutoFlush(), writer) : writer;
        }
        catch (DirectoryException e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGING_CANNOT_CREATE_WRITER.get(config.dn().toString(), String.valueOf(e));
            throw new InitializationException(message, (Throwable)e);
        }
        catch (IOException e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGING_CANNOT_CREATE_WRITER.get(config.dn().toString(), String.valueOf(e));
            throw new InitializationException(message, (Throwable)e);
        }
        config.addDebugTargetAddListener(this);
        config.addDebugTargetDeleteListener(this);
        LogLevel logLevel = DebugLogLevel.parse(config.getDefaultDebugLevel().toString());
        HashSet<LogCategory> logCategories = null;
        if (!config.getDefaultDebugCategory().isEmpty()) {
            logCategories = new HashSet<LogCategory>(config.getDefaultDebugCategory().size());
            for (DebugLogPublisherCfgDefn.DefaultDebugCategory category : config.getDefaultDebugCategory()) {
                logCategories.add(DebugLogCategory.parse(category.toString()));
            }
        }
        TraceSettings defaultSettings = new TraceSettings(logLevel, logCategories, config.isDefaultOmitMethodEntryArguments(), config.isDefaultOmitMethodReturnValue(), config.getDefaultThrowableStackFrames(), config.isDefaultIncludeThrowableCause());
        this.addTraceSettings(null, defaultSettings);
        for (String name : config.listDebugTargets()) {
            DebugTargetCfg targetCfg = config.getDebugTarget(name);
            this.addTraceSettings(targetCfg.getDebugScope(), new TraceSettings(targetCfg));
        }
        this.currentConfig = config;
        config.addFileBasedDebugChangeListener(this);
    }

    @Override
    public boolean isConfigurationAcceptable(DebugLogPublisherCfg configuration, List<Message> unacceptableReasons) {
        Object policy;
        FileBasedDebugLogPublisherCfg config = (FileBasedDebugLogPublisherCfg)configuration;
        for (DN dn : config.getRotationPolicyDN()) {
            policy = DirectoryServer.getRotationPolicy(dn);
            if (policy != null) continue;
            Message message = ConfigMessages.ERR_CONFIG_LOGGER_INVALID_ROTATION_POLICY.get(dn.toString(), config.dn().toString());
            unacceptableReasons.add(message);
            return false;
        }
        for (DN dn : config.getRetentionPolicyDN()) {
            policy = DirectoryServer.getRetentionPolicy(dn);
            if (policy == null) continue;
            Message message = ConfigMessages.WARN_CONFIG_LOGGER_INVALID_RETENTION_POLICY.get(dn.toString(), config.dn().toString());
            unacceptableReasons.add(message);
            return false;
        }
        return true;
    }

    @Override
    public boolean isConfigurationChangeAcceptable(FileBasedDebugLogPublisherCfg config, List<Message> unacceptableReasons) {
        try {
            File logFile;
            if (!this.currentConfig.getLogFileMode().equalsIgnoreCase(config.getLogFileMode())) {
                FilePermission.decodeUNIXMode(config.getLogFileMode());
            }
            if (!this.currentConfig.getLogFile().equalsIgnoreCase(config.getLogFile()) && (logFile = StaticUtils.getFileForPath(config.getLogFile())).createNewFile()) {
                logFile.delete();
            }
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGING_CANNOT_CREATE_WRITER.get(config.dn().toString(), StaticUtils.stackTraceToSingleLineString(e));
            unacceptableReasons.add(message);
            return false;
        }
        return this.isConfigurationAcceptable(config, unacceptableReasons);
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(FileBasedDebugLogPublisherCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        LogLevel logLevel = DebugLogLevel.parse(config.getDefaultDebugLevel().toString());
        HashSet<LogCategory> logCategories = null;
        if (!config.getDefaultDebugCategory().isEmpty()) {
            logCategories = new HashSet<LogCategory>(config.getDefaultDebugCategory().size());
            for (DebugLogPublisherCfgDefn.DefaultDebugCategory category : config.getDefaultDebugCategory()) {
                logCategories.add(DebugLogCategory.parse(category.toString()));
            }
        }
        TraceSettings defaultSettings = new TraceSettings(logLevel, logCategories, config.isDefaultOmitMethodEntryArguments(), config.isDefaultOmitMethodReturnValue(), config.getDefaultThrowableStackFrames(), config.isDefaultIncludeThrowableCause());
        this.addTraceSettings(null, defaultSettings);
        DebugLogger.updateTracerSettings();
        File logFile = StaticUtils.getFileForPath(config.getLogFile());
        TimeStampNaming fnPolicy = new TimeStampNaming(logFile);
        try {
            FilePermission perm = FilePermission.decodeUNIXMode(config.getLogFileMode());
            boolean writerAutoFlush = config.isAutoFlush() && !config.isAsynchronous();
            TextWriter currentWriter = this.writer instanceof AsyncronousTextWriter ? ((AsyncronousTextWriter)this.writer).getWrappedWriter() : this.writer;
            if (currentWriter instanceof MultifileTextWriter) {
                AsyncronousTextWriter asyncWriter;
                Message message;
                Object policy;
                MultifileTextWriter mfWriter = (MultifileTextWriter)this.writer;
                mfWriter.setNamingPolicy(fnPolicy);
                mfWriter.setFilePermissions(perm);
                mfWriter.setAppend(config.isAppend());
                mfWriter.setAutoFlush(writerAutoFlush);
                mfWriter.setBufferSize((int)config.getBufferSize());
                mfWriter.setInterval(config.getTimeInterval());
                mfWriter.removeAllRetentionPolicies();
                mfWriter.removeAllRotationPolicies();
                for (DN dn : config.getRotationPolicyDN()) {
                    policy = DirectoryServer.getRotationPolicy(dn);
                    if (policy != null) {
                        mfWriter.addRotationPolicy((RotationPolicy)policy);
                        continue;
                    }
                    message = ConfigMessages.ERR_CONFIG_LOGGER_INVALID_ROTATION_POLICY.get(dn.toString(), config.dn().toString());
                    resultCode = DirectoryServer.getServerErrorResultCode();
                    messages.add(message);
                }
                for (DN dn : config.getRetentionPolicyDN()) {
                    policy = DirectoryServer.getRetentionPolicy(dn);
                    if (policy != null) {
                        mfWriter.addRetentionPolicy((RetentionPolicy)policy);
                        continue;
                    }
                    message = ConfigMessages.WARN_CONFIG_LOGGER_INVALID_RETENTION_POLICY.get(dn.toString(), config.dn().toString());
                    resultCode = DirectoryServer.getServerErrorResultCode();
                    messages.add(message);
                }
                if (this.writer instanceof AsyncronousTextWriter && !config.isAsynchronous()) {
                    asyncWriter = (AsyncronousTextWriter)this.writer;
                    this.writer = mfWriter;
                    asyncWriter.shutdown(false);
                }
                if (!(this.writer instanceof AsyncronousTextWriter) && config.isAsynchronous()) {
                    asyncWriter = new AsyncronousTextWriter("Asyncronous Text Writer for " + config.dn().toNormalizedString(), config.getQueueSize(), config.isAutoFlush(), mfWriter);
                    this.writer = asyncWriter;
                }
                if (this.currentConfig.isAsynchronous() && config.isAsynchronous() && this.currentConfig.getQueueSize() != config.getQueueSize()) {
                    adminActionRequired = true;
                }
                this.currentConfig = config;
            }
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGING_CANNOT_CREATE_WRITER.get(config.dn().toString(), StaticUtils.stackTraceToSingleLineString(e));
            resultCode = DirectoryServer.getServerErrorResultCode();
            messages.add(message);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationAddAcceptable(DebugTargetCfg config, List<Message> unacceptableReasons) {
        return this.getTraceSettings(config.getDebugScope()) == null;
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(DebugTargetCfg config, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(DebugTargetCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        this.addTraceSettings(config.getDebugScope(), new TraceSettings(config));
        DebugLogger.updateTracerSettings();
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(DebugTargetCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        this.removeTraceSettings(config.getDebugScope());
        DebugLogger.updateTracerSettings();
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public void traceConstructor(LogLevel level, TraceSettings settings, String signature, String sourceLocation, Object[] args, StackTraceElement[] stackTrace) {
        LogCategory category = DebugLogCategory.CONSTRUCTOR;
        String msg = "";
        if (args != null) {
            msg = this.buildDefaultEntryMessage(args);
        }
        String stack = null;
        if (stackTrace != null) {
            stack = DebugStackTraceFormatter.formatStackTrace(stackTrace, settings.stackDepth);
        }
        this.publish(category, level, signature, sourceLocation, msg, stack);
    }

    @Override
    public void traceMethodEntry(LogLevel level, TraceSettings settings, String signature, String sourceLocation, Object obj, Object[] args, StackTraceElement[] stackTrace) {
        LogCategory category = DebugLogCategory.ENTER;
        String msg = "";
        if (args != null) {
            msg = this.buildDefaultEntryMessage(args);
        }
        String stack = null;
        if (stackTrace != null) {
            stack = DebugStackTraceFormatter.formatStackTrace(stackTrace, settings.stackDepth);
        }
        this.publish(category, level, signature, sourceLocation, msg, stack);
    }

    @Override
    public void traceStaticMethodEntry(LogLevel level, TraceSettings settings, String signature, String sourceLocation, Object[] args, StackTraceElement[] stackTrace) {
        LogCategory category = DebugLogCategory.ENTER;
        String msg = "";
        if (args != null) {
            msg = this.buildDefaultEntryMessage(args);
        }
        String stack = null;
        if (stackTrace != null) {
            stack = DebugStackTraceFormatter.formatStackTrace(stackTrace, settings.stackDepth);
        }
        this.publish(category, level, signature, sourceLocation, msg, stack);
    }

    @Override
    public void traceReturn(LogLevel level, TraceSettings settings, String signature, String sourceLocation, Object ret, StackTraceElement[] stackTrace) {
        LogCategory category = DebugLogCategory.EXIT;
        String msg = "";
        if (ret != null) {
            msg = DebugMessageFormatter.format("returned={%s}", new Object[]{ret});
        }
        String stack = null;
        if (stackTrace != null) {
            stack = DebugStackTraceFormatter.formatStackTrace(stackTrace, settings.stackDepth);
        }
        this.publish(category, level, signature, sourceLocation, msg, stack);
    }

    @Override
    public void traceThrown(LogLevel level, TraceSettings settings, String signature, String sourceLocation, Throwable ex, StackTraceElement[] stackTrace) {
        LogCategory category = DebugLogCategory.THROWN;
        String msg = DebugMessageFormatter.format("thrown={%s}", new Object[]{ex});
        String stack = null;
        if (stackTrace != null) {
            stack = DebugStackTraceFormatter.formatStackTrace(ex, settings.stackDepth, settings.includeCause);
        }
        this.publish(category, level, signature, sourceLocation, msg, stack);
    }

    @Override
    public void traceMessage(LogLevel level, TraceSettings settings, String signature, String sourceLocation, String msg, StackTraceElement[] stackTrace) {
        LogCategory category = DebugLogCategory.MESSAGE;
        String stack = null;
        if (stackTrace != null) {
            stack = DebugStackTraceFormatter.formatStackTrace(stackTrace, settings.stackDepth);
        }
        this.publish(category, level, signature, sourceLocation, msg, stack);
    }

    @Override
    public void traceCaught(LogLevel level, TraceSettings settings, String signature, String sourceLocation, Throwable ex, StackTraceElement[] stackTrace) {
        LogCategory category = DebugLogCategory.CAUGHT;
        String msg = DebugMessageFormatter.format("caught={%s}", new Object[]{ex});
        String stack = null;
        if (stackTrace != null) {
            stack = DebugStackTraceFormatter.formatStackTrace(ex, settings.stackDepth, settings.includeCause);
        }
        this.publish(category, level, signature, sourceLocation, msg, stack);
    }

    @Override
    public void traceJEAccess(LogLevel level, TraceSettings settings, String signature, String sourceLocation, OperationStatus status, Database database, Transaction txn, DatabaseEntry key, DatabaseEntry data, StackTraceElement[] stackTrace) {
        LogCategory category = DebugLogCategory.DATABASE_ACCESS;
        StringBuilder builder = new StringBuilder();
        builder.append(" (");
        builder.append(status.toString());
        builder.append(")");
        builder.append(" db=");
        try {
            builder.append(database.getDatabaseName());
        }
        catch (DatabaseException de) {
            builder.append(de.toString());
        }
        if (txn != null) {
            builder.append(" txnid=");
            try {
                builder.append(txn.getId());
            }
            catch (DatabaseException de) {
                builder.append(de.toString());
            }
        } else {
            builder.append(" txnid=none");
        }
        builder.append(ServerConstants.EOL);
        if (key != null) {
            builder.append("key:");
            builder.append(ServerConstants.EOL);
            StaticUtils.byteArrayToHexPlusAscii(builder, key.getData(), 4);
        }
        if (status == OperationStatus.SUCCESS && data != null) {
            builder.append("data(len=");
            builder.append(data.getSize());
            builder.append("):");
            builder.append(ServerConstants.EOL);
            StaticUtils.byteArrayToHexPlusAscii(builder, data.getData(), 4);
        }
        String stack = null;
        if (stackTrace != null) {
            stack = DebugStackTraceFormatter.formatStackTrace(stackTrace, settings.stackDepth);
        }
        this.publish(category, level, signature, sourceLocation, builder.toString(), stack);
    }

    @Override
    public void traceData(LogLevel level, TraceSettings settings, String signature, String sourceLocation, byte[] data, StackTraceElement[] stackTrace) {
        LogCategory category = DebugLogCategory.DATA;
        if (data != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(ServerConstants.EOL);
            builder.append("data(len=");
            builder.append(data.length);
            builder.append("):");
            builder.append(ServerConstants.EOL);
            StaticUtils.byteArrayToHexPlusAscii(builder, data, 4);
            String stack = null;
            if (stackTrace != null) {
                stack = DebugStackTraceFormatter.formatStackTrace(stackTrace, settings.stackDepth);
            }
            this.publish(category, level, signature, sourceLocation, builder.toString(), stack);
        }
    }

    @Override
    public void traceProtocolElement(LogLevel level, TraceSettings settings, String signature, String sourceLocation, ProtocolElement element, StackTraceElement[] stackTrace) {
        LogCategory category = DebugLogCategory.PROTOCOL;
        StringBuilder builder = new StringBuilder();
        builder.append(ServerConstants.EOL);
        element.toString(builder, 4);
        String stack = null;
        if (stackTrace != null) {
            stack = DebugStackTraceFormatter.formatStackTrace(stackTrace, settings.stackDepth);
        }
        this.publish(category, level, signature, sourceLocation, builder.toString(), stack);
    }

    @Override
    public void close() {
        this.writer.shutdown();
        if (this.currentConfig != null) {
            this.currentConfig.removeFileBasedDebugChangeListener(this);
        }
    }

    private void publish(LogCategory category, LogLevel level, String signature, String sourceLocation, String msg, String stack) {
        Thread thread = Thread.currentThread();
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        buf.append(TimeThread.getLocalTime());
        buf.append("] ");
        buf.append(globalSequenceNumber++);
        buf.append(" ");
        buf.append(category);
        buf.append(" ");
        buf.append(level);
        buf.append(" ");
        buf.append("thread={");
        buf.append(thread.getName());
        buf.append("(");
        buf.append(thread.getId());
        buf.append(")} ");
        if (thread instanceof DirectoryThread) {
            buf.append("threadDetail={");
            for (Map.Entry<String, String> entry : ((DirectoryThread)thread).getDebugProperties().entrySet()) {
                buf.append((Object)entry.getKey());
                buf.append("=");
                buf.append((Object)entry.getValue());
                buf.append(" ");
            }
            buf.append("} ");
        }
        buf.append("method={");
        buf.append(signature);
        buf.append(" @ ");
        buf.append(sourceLocation);
        buf.append("} ");
        buf.append(msg);
        if (stack != null) {
            buf.append("\nStack Trace:\n");
            buf.append(stack);
        }
        this.writer.writeRecord(buf.toString());
    }

    private String buildDefaultEntryMessage(Object[] args) {
        StringBuffer format = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            if (i != 0) {
                format.append(", ");
            }
            format.append("arg");
            format.append(i + 1);
            format.append("={%s}");
        }
        return DebugMessageFormatter.format(format.toString(), args);
    }

    @Override
    public DN getDN() {
        if (this.currentConfig != null) {
            return this.currentConfig.dn();
        }
        return null;
    }
}

