/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;
import org.opends.server.util.ServerConstants;

public class ExtendedRequestProtocolOp
extends ProtocolOp {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ASN1OctetString value;
    private String oid;

    public ExtendedRequestProtocolOp(String oid) {
        this.oid = oid;
        this.value = null;
    }

    public ExtendedRequestProtocolOp(String oid, ASN1OctetString value) {
        this.oid = oid;
        this.value = value;
    }

    public String getOID() {
        return this.oid;
    }

    public void setOID(String oid) {
        this.oid = oid;
    }

    public ASN1OctetString getValue() {
        return this.value;
    }

    public void setValue(ASN1OctetString value) {
        this.value = value;
    }

    public byte getType() {
        return 119;
    }

    public String getProtocolOpName() {
        return "Extended Request";
    }

    public ASN1Element encode() {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(2);
        elements.add(new ASN1OctetString(-128, this.oid));
        if (this.value != null) {
            this.value.setType((byte)-127);
            elements.add(this.value);
        }
        return new ASN1Sequence(119, elements);
    }

    public static ExtendedRequestProtocolOp decodeExtendedRequest(ASN1Element element) throws LDAPException {
        ASN1OctetString value;
        String oid;
        ArrayList<ASN1Element> elements;
        try {
            elements = element.decodeAsSequence().elements();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_EXTENDED_REQUEST_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        int numElements = elements.size();
        if (numElements < 1 || numElements > 2) {
            Message message = ProtocolMessages.ERR_LDAP_EXTENDED_REQUEST_DECODE_INVALID_ELEMENT_COUNT.get(numElements);
            throw new LDAPException(2, message);
        }
        try {
            oid = elements.get(0).decodeAsOctetString().stringValue();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_EXTENDED_REQUEST_DECODE_OID.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        if (numElements == 2) {
            try {
                value = elements.get(1).decodeAsOctetString();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ProtocolMessages.ERR_LDAP_EXTENDED_REQUEST_DECODE_VALUE.get(String.valueOf(e));
                throw new LDAPException(2, message, e);
            }
        } else {
            value = null;
        }
        return new ExtendedRequestProtocolOp(oid, value);
    }

    public void toString(StringBuilder buffer) {
        buffer.append("ExtendedRequest(oid=");
        buffer.append(this.oid);
        if (this.value != null) {
            buffer.append(", value=");
            this.value.toString(buffer);
        }
        buffer.append(")");
    }

    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("Extended Request");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  OID:  ");
        buffer.append(this.oid);
        buffer.append(ServerConstants.EOL);
        if (this.value != null) {
            buffer.append((CharSequence)indentBuf);
            buffer.append("  Value:");
            buffer.append(ServerConstants.EOL);
            this.value.toString(buffer, indent + 4);
        }
    }
}

