/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

public class IntermediateResponseProtocolOp
extends ProtocolOp {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ASN1OctetString value;
    private String oid;

    public IntermediateResponseProtocolOp(String oid) {
        this.oid = oid;
        this.value = null;
    }

    public IntermediateResponseProtocolOp(String oid, ASN1OctetString value) {
        this.oid = oid;
        this.value = value;
    }

    public String getOID() {
        return this.oid;
    }

    public void setOID(String oid) {
        this.oid = oid;
    }

    public ASN1OctetString getValue() {
        return this.value;
    }

    public void setValue(ASN1OctetString value) {
        this.value = value;
    }

    public byte getType() {
        return 121;
    }

    public String getProtocolOpName() {
        return "Intermediate Response";
    }

    public ASN1Element encode() {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(2);
        if (this.oid != null) {
            elements.add(new ASN1OctetString(-128, this.oid));
        }
        if (this.value != null) {
            this.value.setType((byte)-127);
            elements.add(this.value);
        }
        return new ASN1Sequence(121, elements);
    }

    public static IntermediateResponseProtocolOp decodeIntermediateResponse(ASN1Element element) throws LDAPException {
        ArrayList<ASN1Element> elements;
        try {
            elements = element.decodeAsSequence().elements();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_INTERMEDIATE_RESPONSE_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        int numElements = elements.size();
        if (numElements > 2) {
            Message message = ProtocolMessages.ERR_LDAP_INTERMEDIATE_RESPONSE_DECODE_INVALID_ELEMENT_COUNT.get(numElements);
            throw new LDAPException(2, message);
        }
        String oid = null;
        ASN1OctetString value = null;
        if (elements.size() == 1) {
            ASN1Element e = elements.get(0);
            switch (e.getType()) {
                case -128: {
                    try {
                        oid = e.decodeAsOctetString().stringValue();
                        break;
                    }
                    catch (ASN1Exception ae) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, ae);
                        }
                        Message message = ProtocolMessages.ERR_LDAP_INTERMEDIATE_RESPONSE_CANNOT_DECODE_OID.get(ae.getMessage());
                        throw new LDAPException(2, message);
                    }
                }
                case -127: {
                    try {
                        value = e.decodeAsOctetString();
                        break;
                    }
                    catch (ASN1Exception ae) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, ae);
                        }
                        Message message = ProtocolMessages.ERR_LDAP_INTERMEDIATE_RESPONSE_CANNOT_DECODE_VALUE.get(ae.getMessage());
                        throw new LDAPException(2, message);
                    }
                }
                default: {
                    Message message = ProtocolMessages.ERR_LDAP_INTERMEDIATE_RESPONSE_INVALID_ELEMENT_TYPE.get(StaticUtils.byteToHex(e.getType()));
                    throw new LDAPException(2, message);
                }
            }
        } else if (elements.size() == 2) {
            try {
                oid = elements.get(0).decodeAsOctetString().stringValue();
            }
            catch (ASN1Exception ae) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ae);
                }
                Message message = ProtocolMessages.ERR_LDAP_INTERMEDIATE_RESPONSE_CANNOT_DECODE_OID.get(ae.getMessage());
                throw new LDAPException(2, message);
            }
            try {
                value = elements.get(1).decodeAsOctetString();
            }
            catch (ASN1Exception ae) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ae);
                }
                Message message = ProtocolMessages.ERR_LDAP_INTERMEDIATE_RESPONSE_CANNOT_DECODE_OID.get(ae.getMessage());
                throw new LDAPException(2, message);
            }
        }
        return new IntermediateResponseProtocolOp(oid, value);
    }

    public void toString(StringBuilder buffer) {
        buffer.append("IntermediateResponse(oid=");
        buffer.append(String.valueOf(this.oid));
        if (this.value != null) {
            buffer.append(", value=");
            this.value.toString(buffer);
        }
        buffer.append(")");
    }

    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("Intermediate Response");
        buffer.append(ServerConstants.EOL);
        if (this.oid != null) {
            buffer.append((CharSequence)indentBuf);
            buffer.append("  OID:  ");
            buffer.append(this.oid);
            buffer.append(ServerConstants.EOL);
        }
        if (this.value != null) {
            buffer.append((CharSequence)indentBuf);
            buffer.append("  Value:");
            buffer.append(ServerConstants.EOL);
            this.value.toString(buffer, indent + 4);
        }
    }
}

