/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.LDAPConnectionHandlerCfgDefn;
import org.opends.server.admin.std.server.ConnectionHandlerCfg;
import org.opends.server.admin.std.server.LDAPConnectionHandlerCfg;
import org.opends.server.api.AlertGenerator;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConnectionHandler;
import org.opends.server.api.ConnectionSecurityProvider;
import org.opends.server.api.KeyManagerProvider;
import org.opends.server.api.ServerShutdownListener;
import org.opends.server.api.TrustManagerProvider;
import org.opends.server.api.plugin.PostConnectPluginResult;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.loggers.AccessLogger;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.ldap.LDAPClientConnection;
import org.opends.server.protocols.ldap.LDAPRequestHandler;
import org.opends.server.protocols.ldap.LDAPStatistics;
import org.opends.server.types.AddressMask;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.HostPort;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SSLClientAuthPolicy;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LDAPConnectionHandler
extends ConnectionHandler<LDAPConnectionHandlerCfg>
implements ConfigurationChangeListener<LDAPConnectionHandlerCfg>,
ServerShutdownListener,
AlertGenerator {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String CLASS_NAME = "org.opends.server.protocols.ldap.LDAPConnectionHandler";
    private LDAPConnectionHandlerCfg currentConfig;
    private Set<InetAddress> listenAddresses;
    private int listenPort;
    private SSLClientAuthPolicy sslClientAuthPolicy;
    private int backlog;
    private boolean allowReuseAddress;
    private int numRequestHandlers;
    private boolean shutdownRequested;
    private boolean enabled;
    private AddressMask[] allowedClients;
    private AddressMask[] deniedClients;
    private String[] enabledSSLCipherSuites;
    private String[] enabledSSLProtocols;
    private int requestHandlerIndex;
    private LinkedList<HostPort> listeners;
    private LDAPRequestHandler[] requestHandlers;
    private LDAPStatistics statTracker;
    private Selector selector;
    private String handlerName;
    private String protocol;
    private ConnectionSecurityProvider securityProvider;

    public LDAPConnectionHandler() {
        super("LDAP Connection Handler Thread");
    }

    public boolean allowLDAPv2() {
        return this.currentConfig.isAllowLDAPV2();
    }

    public boolean allowStartTLS() {
        if (this.currentConfig.isAllowStartTLS()) {
            return !this.currentConfig.isUseSSL();
        }
        return false;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(LDAPConnectionHandlerCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        if (this.currentConfig.isAllowLDAPV2() != config.isAllowLDAPV2() && config.isAllowLDAPV2()) {
            if (this.statTracker == null) {
                this.statTracker = new LDAPStatistics(this.handlerName + " Statistics");
            } else {
                this.statTracker.clearStatistics();
            }
        }
        this.currentConfig = config;
        this.enabled = config.isEnabled();
        this.allowedClients = config.getAllowedClients().toArray(new AddressMask[0]);
        this.deniedClients = config.getDeniedClients().toArray(new AddressMask[0]);
        SortedSet<String> ciphers = config.getSSLCipherSuites();
        this.enabledSSLCipherSuites = ciphers.isEmpty() ? null : ciphers.toArray(new String[0]);
        SortedSet<String> protocols = config.getSSLProtocols();
        this.enabledSSLProtocols = protocols.isEmpty() ? null : protocols.toArray(new String[0]);
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public void finalizeConnectionHandler(Message finalizeReason, boolean closeConnections) {
        block6: {
            this.shutdownRequested = true;
            this.currentConfig.removeLDAPChangeListener(this);
            try {
                this.selector.wakeup();
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block6;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        if (closeConnections) {
            for (LDAPRequestHandler requestHandler : this.requestHandlers) {
                requestHandler.processServerShutdown(finalizeReason);
            }
        } else {
            for (LDAPRequestHandler requestHandler : this.requestHandlers) {
                requestHandler.registerShutdownListener();
            }
        }
    }

    @Override
    public LinkedHashMap<String, String> getAlerts() {
        LinkedHashMap<String, String> alerts = new LinkedHashMap<String, String>();
        alerts.put("org.opends.server.LDAPHandlerDisabledByConsecutiveFailures", "This alert type will be used to notify administrators of consecutive failures that have occurred in the LDAP connection handler that have caused it to become disabled.");
        alerts.put("org.opends.server.LDAPHandlerUncaughtError", "This alert type will be used to notify administrators of uncaught errors in the LDAP connection handler that have caused it to become disabled.");
        return alerts;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public Collection<ClientConnection> getClientConnections() {
        LinkedList<ClientConnection> connectionList = new LinkedList<ClientConnection>();
        for (LDAPRequestHandler requestHandler : this.requestHandlers) {
            connectionList.addAll(requestHandler.getClientConnections());
        }
        return connectionList;
    }

    @Override
    public DN getComponentEntryDN() {
        return this.currentConfig.dn();
    }

    @Override
    public String getConnectionHandlerName() {
        return this.handlerName;
    }

    public String[] getEnabledSSLCipherSuites() {
        return this.enabledSSLCipherSuites;
    }

    public String[] getEnabledSSLProtocols() {
        return this.enabledSSLProtocols;
    }

    public DN getKeyManagerProviderDN() {
        return this.currentConfig.getKeyManagerProviderDN();
    }

    @Override
    public Collection<HostPort> getListeners() {
        return this.listeners;
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public int getMaxRequestSize() {
        return (int)this.currentConfig.getMaxRequestSize();
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public String getShutdownListenerName() {
        return this.handlerName;
    }

    public String getSSLServerCertNickname() {
        return this.currentConfig.getSSLCertNickname();
    }

    public SSLClientAuthPolicy getSSLClientAuthPolicy() {
        return this.sslClientAuthPolicy;
    }

    public LDAPStatistics getStatTracker() {
        return this.statTracker;
    }

    public DN getTrustManagerProviderDN() {
        return this.currentConfig.getTrustManagerProviderDN();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void initializeConnectionHandler(LDAPConnectionHandlerCfg config) throws ConfigException, InitializationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean isConfigurationAcceptable(ConnectionHandlerCfg configuration, List<Message> unacceptableReasons) {
        LDAPConnectionHandlerCfg config = (LDAPConnectionHandlerCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(LDAPConnectionHandlerCfg config, List<Message> unacceptableReasons) {
        boolean isAcceptable = true;
        if (config.isAllowStartTLS() && config.isUseSSL()) {
            unacceptableReasons.add(ProtocolMessages.ERR_LDAP_CONNHANDLER_CANNOT_HAVE_SSL_AND_STARTTLS.get(String.valueOf(config.dn())));
            isAcceptable = false;
        }
        if (config.isAllowStartTLS() || config.isUseSSL()) {
            DN keyManagerProviderDN = config.getKeyManagerProviderDN();
            if (keyManagerProviderDN == null) {
                Message message = ProtocolMessages.ERR_LDAP_CONNHANDLER_NO_KEYMANAGER_DN.get(String.valueOf(config.dn()));
                unacceptableReasons.add(message);
                isAcceptable = false;
            } else {
                KeyManagerProvider provider = DirectoryServer.getKeyManagerProvider(keyManagerProviderDN);
                if (provider == null) {
                    unacceptableReasons.add(ProtocolMessages.ERR_LDAP_CONNHANDLER_INVALID_KEYMANAGER_DN.get(String.valueOf(config.dn()), String.valueOf(keyManagerProviderDN)));
                    isAcceptable = false;
                }
            }
            DN trustManagerProviderDN = config.getTrustManagerProviderDN();
            if (trustManagerProviderDN == null) {
                Message message = ProtocolMessages.ERR_LDAP_CONNHANDLER_NO_TRUSTMANAGER_DN.get(String.valueOf(config.dn()));
                unacceptableReasons.add(message);
                isAcceptable = false;
            } else {
                TrustManagerProvider provider = DirectoryServer.getTrustManagerProvider(trustManagerProviderDN);
                if (provider == null) {
                    unacceptableReasons.add(ProtocolMessages.ERR_LDAP_CONNHANDLER_INVALID_TRUSTMANAGER_DN.get(String.valueOf(config.dn()), String.valueOf(trustManagerProviderDN)));
                    isAcceptable = false;
                }
            }
        }
        return isAcceptable;
    }

    public boolean keepStats() {
        return this.currentConfig.isKeepStats();
    }

    @Override
    public void processServerShutdown(Message reason) {
        this.shutdownRequested = true;
        try {
            for (LDAPRequestHandler requestHandler : this.requestHandlers) {
                try {
                    requestHandler.processServerShutdown(reason);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        this.setName(this.handlerName);
        boolean listening = false;
        while (!this.shutdownRequested) {
            if (!this.enabled) {
                if (listening) {
                    this.cleanUpSelector();
                    listening = false;
                    ErrorLogger.logError(ProtocolMessages.ERR_LDAP_CONNHANDLER_STOPPED_LISTENING.get(this.handlerName));
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e) {}
                continue;
            }
            try {
                this.cleanUpSelector();
                int numRegistered = 0;
                for (InetAddress a : this.listenAddresses) {
                    try {
                        ServerSocketChannel channel = ServerSocketChannel.open();
                        channel.socket().setReuseAddress(this.allowReuseAddress);
                        channel.socket().bind(new InetSocketAddress(a, this.listenPort), this.backlog);
                        channel.configureBlocking(false);
                        channel.register(this.selector, 16);
                        ++numRegistered;
                        ErrorLogger.logError(ProtocolMessages.ERR_LDAP_CONNHANDLER_STARTED_LISTENING.get(this.handlerName));
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        ErrorLogger.logError(ProtocolMessages.ERR_LDAP_CONNHANDLER_CREATE_CHANNEL_FAILED.get(String.valueOf(this.currentConfig.dn()), a.getHostAddress(), this.listenPort, StaticUtils.stackTraceToSingleLineString(e)));
                    }
                }
                if (numRegistered == 0) {
                    ErrorLogger.logError(ProtocolMessages.ERR_LDAP_CONNHANDLER_NO_ACCEPTORS.get(String.valueOf(this.currentConfig.dn())));
                    this.enabled = false;
                    continue;
                }
                listening = true;
                boolean lastIterationFailed = false;
                while (this.enabled && !this.shutdownRequested) {
                    try {
                        if (this.selector.select() > 0) {
                            Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
                            while (iterator.hasNext()) {
                                block39: {
                                    SelectionKey key = iterator.next();
                                    if (key.isAcceptable()) {
                                        ServerSocketChannel serverChannel = (ServerSocketChannel)key.channel();
                                        SocketChannel clientChannel = serverChannel.accept();
                                        LDAPClientConnection clientConnection = new LDAPClientConnection(this, clientChannel);
                                        if (clientConnection.getConnectionID() < 0L) {
                                            iterator.remove();
                                            continue;
                                        }
                                        InetAddress clientAddr = clientConnection.getRemoteAddress();
                                        if (this.deniedClients.length > 0 && AddressMask.maskListContains(clientAddr.getAddress(), clientAddr.getHostName(), this.deniedClients)) {
                                            clientConnection.disconnect(DisconnectReason.CONNECTION_REJECTED, this.currentConfig.isSendRejectionNotice(), ProtocolMessages.ERR_LDAP_CONNHANDLER_DENIED_CLIENT.get(clientConnection.getClientHostPort(), clientConnection.getServerHostPort()));
                                            iterator.remove();
                                            continue;
                                        }
                                        if (this.allowedClients.length > 0 && !AddressMask.maskListContains(clientAddr.getAddress(), clientAddr.getHostName(), this.allowedClients)) {
                                            clientConnection.disconnect(DisconnectReason.CONNECTION_REJECTED, this.currentConfig.isSendRejectionNotice(), ProtocolMessages.ERR_LDAP_CONNHANDLER_DISALLOWED_CLIENT.get(clientConnection.getClientHostPort(), clientConnection.getServerHostPort()));
                                            iterator.remove();
                                            continue;
                                        }
                                        clientChannel.socket().setKeepAlive(this.currentConfig.isUseTCPKeepAlive());
                                        clientChannel.socket().setTcpNoDelay(this.currentConfig.isUseTCPNoDelay());
                                        try {
                                            ConnectionSecurityProvider connectionSecurityProvider = this.securityProvider.newInstance(clientConnection, clientChannel);
                                            clientConnection.setConnectionSecurityProvider(connectionSecurityProvider);
                                        }
                                        catch (Exception e) {
                                            if (DebugLogger.debugEnabled()) {
                                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                            }
                                            clientConnection.disconnect(DisconnectReason.SECURITY_PROBLEM, false, ProtocolMessages.ERR_LDAP_CONNHANDLER_CANNOT_SET_SECURITY_PROVIDER.get(String.valueOf(e)));
                                            iterator.remove();
                                            continue;
                                        }
                                        try {
                                            PluginConfigManager pluginManager = DirectoryServer.getPluginConfigManager();
                                            PostConnectPluginResult pluginResult = pluginManager.invokePostConnectPlugins(clientConnection);
                                            if (pluginResult.connectionTerminated()) {
                                                iterator.remove();
                                                continue;
                                            }
                                            LDAPRequestHandler requestHandler = this.requestHandlers[this.requestHandlerIndex++];
                                            if (this.requestHandlerIndex >= this.numRequestHandlers) {
                                                this.requestHandlerIndex = 0;
                                            }
                                            if (requestHandler.registerClient(clientConnection)) {
                                                AccessLogger.logConnect(clientConnection);
                                                break block39;
                                            }
                                            iterator.remove();
                                        }
                                        catch (Exception e) {
                                            if (DebugLogger.debugEnabled()) {
                                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                            }
                                            Message message = ProtocolMessages.INFO_LDAP_CONNHANDLER_UNABLE_TO_REGISTER_CLIENT.get(clientConnection.getClientHostPort(), clientConnection.getServerHostPort(), StaticUtils.getExceptionMessage(e));
                                            ErrorLogger.logError(message);
                                            clientConnection.disconnect(DisconnectReason.SERVER_ERROR, this.currentConfig.isSendRejectionNotice(), message);
                                            iterator.remove();
                                        }
                                        continue;
                                    }
                                }
                                iterator.remove();
                            }
                        } else if (this.shutdownRequested) {
                            this.cleanUpSelector();
                            listening = false;
                            this.enabled = false;
                            continue;
                        }
                        lastIterationFailed = false;
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        ErrorLogger.logError(ProtocolMessages.ERR_LDAP_CONNHANDLER_CANNOT_ACCEPT_CONNECTION.get(String.valueOf(this.currentConfig.dn()), StaticUtils.getExceptionMessage(e)));
                        if (lastIterationFailed) {
                            Message message = ProtocolMessages.ERR_LDAP_CONNHANDLER_CONSECUTIVE_ACCEPT_FAILURES.get(String.valueOf(this.currentConfig.dn()), StaticUtils.stackTraceToSingleLineString(e));
                            ErrorLogger.logError(message);
                            DirectoryServer.sendAlertNotification(this, "org.opends.server.LDAPHandlerDisabledByConsecutiveFailures", message);
                            this.enabled = false;
                            try {
                                this.cleanUpSelector();
                            }
                            catch (Exception e2) {}
                            continue;
                        }
                        lastIterationFailed = true;
                    }
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ProtocolMessages.ERR_LDAP_CONNHANDLER_UNCAUGHT_ERROR.get(String.valueOf(this.currentConfig.dn()), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                DirectoryServer.sendAlertNotification(this, "org.opends.server.LDAPHandlerUncaughtError", message);
                try {
                    this.cleanUpSelector();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                this.enabled = false;
            }
        }
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append(this.handlerName);
    }

    public boolean useSSL() {
        return this.currentConfig.isUseSSL();
    }

    private void cleanUpSelector() {
        block8: {
            try {
                for (SelectionKey key : this.selector.keys()) {
                    block7: {
                        try {
                            key.cancel();
                        }
                        catch (Exception e) {
                            if (!DebugLogger.debugEnabled()) break block7;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                    try {
                        key.channel().close();
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) continue;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block8;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$opends$server$admin$std$meta$LDAPConnectionHandlerCfgDefn$SSLClientAuthPolicy;

        static {
            $SwitchMap$org$opends$server$admin$std$meta$LDAPConnectionHandlerCfgDefn$SSLClientAuthPolicy = new int[LDAPConnectionHandlerCfgDefn.SSLClientAuthPolicy.values().length];
            try {
                1.$SwitchMap$org$opends$server$admin$std$meta$LDAPConnectionHandlerCfgDefn$SSLClientAuthPolicy[LDAPConnectionHandlerCfgDefn.SSLClientAuthPolicy.DISABLED.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$opends$server$admin$std$meta$LDAPConnectionHandlerCfgDefn$SSLClientAuthPolicy[LDAPConnectionHandlerCfgDefn.SSLClientAuthPolicy.REQUIRED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

