/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.api.ConnectionSecurityProvider;
import org.opends.server.api.DirectoryThread;
import org.opends.server.api.ServerShutdownListener;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.ldap.LDAPClientConnection;
import org.opends.server.protocols.ldap.LDAPConnectionHandler;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.InitializationException;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPRequestHandler
extends DirectoryThread
implements ServerShutdownListener {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public static final int BUFFER_SIZE = 8192;
    private boolean shutdownRequested;
    private ConcurrentLinkedQueue<LDAPClientConnection> pendingConnections;
    private LDAPConnectionHandler connectionHandler;
    private Selector selector;
    private String handlerName;

    public LDAPRequestHandler(LDAPConnectionHandler connectionHandler, int requestHandlerID) throws InitializationException {
        block5: {
            super("LDAP Request Handler " + requestHandlerID + " for connection handler " + connectionHandler.toString());
            this.connectionHandler = connectionHandler;
            this.handlerName = this.getName();
            this.pendingConnections = new ConcurrentLinkedQueue();
            try {
                this.selector = Selector.open();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ProtocolMessages.ERR_LDAP_REQHANDLER_OPEN_SELECTOR_FAILED.get(this.handlerName, String.valueOf(e));
                throw new InitializationException(message, (Throwable)e);
            }
            try {
                this.selector.selectNow();
            }
            catch (IOException ioe) {
                StackTraceElement ste;
                StackTraceElement[] stackElements = ioe.getStackTrace();
                if (stackElements == null || stackElements.length <= 0 || !(ste = stackElements[0]).getClassName().equals("sun.nio.ch.DevPollArrayWrapper") || ste.getMethodName().indexOf("poll") < 0 || !ioe.getMessage().equalsIgnoreCase("Invalid argument")) break block5;
                Message message = ProtocolMessages.ERR_LDAP_REQHANDLER_DETECTED_JVM_ISSUE_CR6322825.get(String.valueOf(ioe));
                throw new InitializationException(message, (Throwable)ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.shutdownRequested) {
            int selectedKeys;
            block24: {
                selectedKeys = 0;
                try {
                    selectedKeys = this.selector.select();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block24;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            if (selectedKeys > 0) {
                Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
                while (iterator.hasNext()) {
                    SelectionKey key = iterator.next();
                    try {
                        if (key.isReadable()) {
                            LDAPClientConnection clientConnection = null;
                            try {
                                clientConnection = (LDAPClientConnection)key.attachment();
                                try {
                                    ConnectionSecurityProvider securityProvider = clientConnection.getConnectionSecurityProvider();
                                    if (securityProvider.readData()) continue;
                                    key.cancel();
                                }
                                catch (Exception e) {
                                    if (DebugLogger.debugEnabled()) {
                                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                    }
                                    key.cancel();
                                    clientConnection.disconnect(DisconnectReason.SERVER_ERROR, false, null);
                                }
                            }
                            catch (Exception e) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                }
                                key.cancel();
                                if (clientConnection == null) continue;
                                clientConnection.disconnect(DisconnectReason.SERVER_ERROR, false, null);
                            }
                            continue;
                        }
                        if (key.isValid()) continue;
                        key.cancel();
                    }
                    catch (CancelledKeyException cke) {
                        if (!DebugLogger.debugEnabled()) continue;
                        TRACER.debugCaught(DebugLogLevel.ERROR, cke);
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        Message message = ProtocolMessages.ERR_LDAP_REQHANDLER_UNEXPECTED_SELECT_EXCEPTION.get(this.getName(), StaticUtils.getExceptionMessage(e));
                        ErrorLogger.logError(message);
                    }
                    finally {
                        iterator.remove();
                    }
                }
            }
            while (!this.pendingConnections.isEmpty()) {
                LDAPClientConnection c = (LDAPClientConnection)this.pendingConnections.remove();
                try {
                    SocketChannel socketChannel = c.getSocketChannel();
                    socketChannel.configureBlocking(false);
                    socketChannel.register(this.selector, 1, c);
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    c.disconnect(DisconnectReason.SERVER_ERROR, true, ProtocolMessages.ERR_LDAP_REQHANDLER_CANNOT_REGISTER.get(this.handlerName, String.valueOf(e)));
                }
            }
        }
    }

    public boolean registerClient(LDAPClientConnection clientConnection) {
        if (this.shutdownRequested) {
            clientConnection.disconnect(DisconnectReason.SERVER_SHUTDOWN, true, ProtocolMessages.ERR_LDAP_REQHANDLER_REJECT_DUE_TO_SHUTDOWN.get());
            return false;
        }
        if (this.pendingConnections.offer(clientConnection)) {
            this.selector.wakeup();
            return true;
        }
        clientConnection.disconnect(DisconnectReason.ADMIN_LIMIT_EXCEEDED, true, ProtocolMessages.ERR_LDAP_REQHANDLER_REJECT_DUE_TO_QUEUE_FULL.get(this.handlerName));
        return false;
    }

    public void deregisterClient(LDAPClientConnection clientConnection) {
        SelectionKey[] keyArray;
        for (SelectionKey key : keyArray = this.selector.keys().toArray(new SelectionKey[0])) {
            block5: {
                LDAPClientConnection conn = (LDAPClientConnection)key.attachment();
                if (!clientConnection.equals(conn)) continue;
                try {
                    key.channel().close();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block5;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            try {
                key.cancel();
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    public void deregisterAllClients() {
        SelectionKey[] keyArray;
        for (SelectionKey key : keyArray = this.selector.keys().toArray(new SelectionKey[0])) {
            block5: {
                try {
                    key.channel().close();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block5;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            try {
                key.cancel();
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    public Collection<LDAPClientConnection> getClientConnections() {
        SelectionKey[] keyArray = this.selector.keys().toArray(new SelectionKey[0]);
        ArrayList<LDAPClientConnection> connList = new ArrayList<LDAPClientConnection>(keyArray.length);
        for (SelectionKey key : keyArray) {
            connList.add((LDAPClientConnection)key.attachment());
        }
        return connList;
    }

    @Override
    public String getShutdownListenerName() {
        return this.handlerName;
    }

    public void registerShutdownListener() {
        DirectoryServer.registerShutdownListener(this);
    }

    @Override
    public void processServerShutdown(Message reason) {
        block7: {
            this.shutdownRequested = true;
            Collection<LDAPClientConnection> clientConnections = this.getClientConnections();
            this.deregisterAllClients();
            if (clientConnections != null) {
                for (LDAPClientConnection c : clientConnections) {
                    try {
                        c.disconnect(DisconnectReason.SERVER_SHUTDOWN, true, ProtocolMessages.ERR_LDAP_REQHANDLER_DEREGISTER_DUE_TO_SHUTDOWN.get(reason));
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) continue;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
            }
            try {
                if (this.selector != null) {
                    this.selector.wakeup();
                }
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block7;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }
}

