/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.plugin;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.DataFormatException;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ReplicationMessages;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.MultimasterDomainCfgDefn;
import org.opends.server.admin.std.server.BackendCfg;
import org.opends.server.admin.std.server.MultimasterDomainCfg;
import org.opends.server.admin.std.server.SynchronizationProviderCfg;
import org.opends.server.api.AlertGenerator;
import org.opends.server.api.Backend;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.DirectoryThread;
import org.opends.server.api.SynchronizationProvider;
import org.opends.server.backends.jeb.BackendImpl;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskState;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockFileManager;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyDNOperationBasis;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.ModifyOperationBasis;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.ChangeNumberGenerator;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.plugin.Historical;
import org.opends.server.replication.plugin.ListenerThread;
import org.opends.server.replication.plugin.MultimasterReplication;
import org.opends.server.replication.plugin.PendingChanges;
import org.opends.server.replication.plugin.PersistentServerState;
import org.opends.server.replication.plugin.RemotePendingChanges;
import org.opends.server.replication.plugin.ReplLDIFInputStream;
import org.opends.server.replication.plugin.ReplLDIFOutputStream;
import org.opends.server.replication.plugin.ReplicationBroker;
import org.opends.server.replication.plugin.ReplicationMonitor;
import org.opends.server.replication.protocol.AckMessage;
import org.opends.server.replication.protocol.AddContext;
import org.opends.server.replication.protocol.AddMsg;
import org.opends.server.replication.protocol.DeleteContext;
import org.opends.server.replication.protocol.DoneMessage;
import org.opends.server.replication.protocol.EntryMessage;
import org.opends.server.replication.protocol.ErrorMessage;
import org.opends.server.replication.protocol.InitializeRequestMessage;
import org.opends.server.replication.protocol.InitializeTargetMessage;
import org.opends.server.replication.protocol.ModifyContext;
import org.opends.server.replication.protocol.ModifyDNMsg;
import org.opends.server.replication.protocol.ModifyDnContext;
import org.opends.server.replication.protocol.OperationContext;
import org.opends.server.replication.protocol.ReplicationMessage;
import org.opends.server.replication.protocol.RoutableMessage;
import org.opends.server.replication.protocol.UpdateMessage;
import org.opends.server.tasks.InitializeTargetTask;
import org.opends.server.tasks.InitializeTask;
import org.opends.server.tasks.TaskUtils;
import org.opends.server.types.AbstractOperation;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.LDAPException;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.Operation;
import org.opends.server.types.RDN;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchScope;
import org.opends.server.types.SynchronizationProviderResult;
import org.opends.server.types.operation.PluginOperation;
import org.opends.server.types.operation.PostOperationOperation;
import org.opends.server.types.operation.PreOperationAddOperation;
import org.opends.server.types.operation.PreOperationDeleteOperation;
import org.opends.server.types.operation.PreOperationModifyDNOperation;
import org.opends.server.types.operation.PreOperationModifyOperation;
import org.opends.server.types.operation.PreOperationOperation;
import org.opends.server.util.StaticUtils;
import org.opends.server.workflowelement.localbackend.LocalBackendModifyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationDomain
extends DirectoryThread
implements ConfigurationChangeListener<MultimasterDomainCfg>,
AlertGenerator {
    private static final String CLASS_NAME = "org.opends.server.replication.plugin.ReplicationDomain";
    public static final String DS_SYNC_CONFLICT = "ds-sync-conflict";
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final int SHUTDOWN_JOIN_TIMEOUT = 30000;
    private ReplicationMonitor monitor;
    private ReplicationBroker broker;
    private List<ListenerThread> synchroThreads = new ArrayList<ListenerThread>();
    private SortedMap<ChangeNumber, UpdateMessage> waitingAckMsgs = new TreeMap<ChangeNumber, UpdateMessage>();
    private AtomicInteger numRcvdUpdates = new AtomicInteger(0);
    private AtomicInteger numSentUpdates = new AtomicInteger(0);
    private AtomicInteger numProcessedUpdates = new AtomicInteger();
    private AtomicInteger numResolvedNamingConflicts = new AtomicInteger();
    private AtomicInteger numResolvedModifyConflicts = new AtomicInteger();
    private AtomicInteger numUnresolvedNamingConflicts = new AtomicInteger();
    private int debugCount = 0;
    private PersistentServerState state;
    private int numReplayedPostOpCalled = 0;
    private int maxReceiveQueue = 0;
    private int maxSendQueue = 0;
    private int maxReceiveDelay = 0;
    private int maxSendDelay = 0;
    private PendingChanges pendingChanges;
    private RemotePendingChanges remotePendingChanges;
    private long heartbeatInterval = 0L;
    short serverId;
    private IEContext ieContext = null;
    private Backend backend;
    private int listenerThreadNumber = 10;
    private Collection<String> replicationServers;
    private DN baseDN;
    private boolean shutdown = false;
    private InternalClientConnection conn = InternalClientConnection.getRootConnection();
    private boolean solveConflictFlag = true;
    private boolean disabled = false;
    private boolean stateSavingDisabled = false;
    private int window = 100;
    private MultimasterDomainCfgDefn.IsolationPolicy isolationpolicy;
    private DN configDn;

    public ReplicationDomain(MultimasterDomainCfg configuration) throws ConfigException {
        super("replication flush");
        this.replicationServers = configuration.getReplicationServer();
        this.serverId = (short)configuration.getServerId();
        this.baseDN = configuration.getReplicationDN();
        this.maxReceiveQueue = configuration.getMaxReceiveQueue();
        this.maxReceiveDelay = (int)configuration.getMaxReceiveDelay();
        this.maxSendQueue = configuration.getMaxSendQueue();
        this.maxSendDelay = (int)configuration.getMaxSendDelay();
        this.window = configuration.getWindowSize();
        this.heartbeatInterval = configuration.getHeartbeatInterval();
        this.isolationpolicy = configuration.getIsolationPolicy();
        this.configDn = configuration.dn();
        this.solveConflictFlag = this.baseDN.compareTo(DirectoryServer.getSchemaDN()) != 0;
        this.state = new PersistentServerState(this.baseDN);
        this.monitor = new ReplicationMonitor(this);
        DirectoryServer.registerMonitorProvider(this.monitor);
        this.broker = new ReplicationBroker(this.state, this.baseDN, this.serverId, this.maxReceiveQueue, this.maxReceiveDelay, this.maxSendQueue, this.maxSendDelay, this.window, this.heartbeatInterval);
        this.broker.start(this.replicationServers);
        try {
            this.retrievesBackendInfos(this.baseDN);
        }
        catch (DirectoryException e) {
            // empty catch block
        }
        ChangeNumberGenerator generator = new ChangeNumberGenerator(this.serverId, this.state);
        this.pendingChanges = new PendingChanges(new ChangeNumberGenerator(this.serverId, this.state), this.broker, this.state);
        this.remotePendingChanges = new RemotePendingChanges(generator, this.state);
        configuration.addChangeListener(this);
        DirectoryServer.registerAlertGenerator(this);
    }

    public DN getBaseDN() {
        return this.baseDN;
    }

    public SynchronizationProviderResult handleConflictResolution(PreOperationDeleteOperation deleteOperation) {
        if (!deleteOperation.isSynchronizationOperation() && !this.brokerIsConnected(deleteOperation)) {
            return new SynchronizationProviderResult(false);
        }
        DeleteContext ctx = (DeleteContext)deleteOperation.getAttachment("replicationContext");
        Entry deletedEntry = deleteOperation.getEntryToDelete();
        if (ctx != null) {
            String modifiedEntryUUID;
            String operationEntryUUID = ctx.getEntryUid();
            if (!operationEntryUUID.equals(modifiedEntryUUID = Historical.getEntryUuid(deletedEntry))) {
                deleteOperation.setResultCode(ResultCode.NO_SUCH_OBJECT);
                return new SynchronizationProviderResult(false);
            }
        } else {
            ChangeNumber changeNumber = this.generateChangeNumber(deleteOperation);
            String modifiedEntryUUID = Historical.getEntryUuid(deletedEntry);
            ctx = new DeleteContext(changeNumber, modifiedEntryUUID);
            deleteOperation.setAttachment("replicationContext", ctx);
        }
        return new SynchronizationProviderResult(true);
    }

    public SynchronizationProviderResult handleConflictResolution(PreOperationAddOperation addOperation) {
        if (!addOperation.isSynchronizationOperation() && !this.brokerIsConnected(addOperation)) {
            return new SynchronizationProviderResult(false);
        }
        if (addOperation.isSynchronizationOperation()) {
            AddContext ctx = (AddContext)addOperation.getAttachment("replicationContext");
            String uuid = ctx.getEntryUid();
            if (this.findEntryDN(uuid) != null) {
                addOperation.setResultCode(ResultCode.CANCELED);
                return new SynchronizationProviderResult(false);
            }
            String parentUid = ctx.getParentUid();
            if (parentUid != null) {
                DN parentDnFromCtx = this.findEntryDN(ctx.getParentUid());
                if (parentDnFromCtx == null) {
                    addOperation.setResultCode(ResultCode.NO_SUCH_OBJECT);
                    return new SynchronizationProviderResult(false);
                }
                DN entryDN = addOperation.getEntryDN();
                DN parentDnFromEntryDn = entryDN.getParentDNInSuffix();
                if (parentDnFromEntryDn != null && !parentDnFromCtx.equals(parentDnFromEntryDn)) {
                    addOperation.setResultCode(ResultCode.NO_SUCH_OBJECT);
                    return new SynchronizationProviderResult(false);
                }
            }
        }
        return new SynchronizationProviderResult(true);
    }

    private boolean brokerIsConnected(PreOperationOperation op) {
        if (this.isolationpolicy.equals((Object)MultimasterDomainCfgDefn.IsolationPolicy.ACCEPT_ALL_UPDATES)) {
            return true;
        }
        if (this.isolationpolicy.equals((Object)MultimasterDomainCfgDefn.IsolationPolicy.REJECT_ALL_UPDATES)) {
            if (this.broker.isConnected()) {
                return true;
            }
            Message msg = ReplicationMessages.ERR_REPLICATION_COULD_NOT_CONNECT.get(this.baseDN.toString());
            DirectoryException result = new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, msg);
            op.setResponseData(result);
            return false;
        }
        return true;
    }

    public SynchronizationProviderResult handleConflictResolution(PreOperationModifyDNOperation modifyDNOperation) {
        if (!modifyDNOperation.isSynchronizationOperation() && !this.brokerIsConnected(modifyDNOperation)) {
            return new SynchronizationProviderResult(false);
        }
        ModifyDnContext ctx = (ModifyDnContext)modifyDNOperation.getAttachment("replicationContext");
        if (ctx != null) {
            String newParentId;
            String modifiedEntryUUID = Historical.getEntryUuid(modifyDNOperation.getOriginalEntry());
            if (!modifiedEntryUUID.equals(ctx.getEntryUid())) {
                modifyDNOperation.setResultCode(ResultCode.NO_SUCH_OBJECT);
                return new SynchronizationProviderResult(false);
            }
            if (modifyDNOperation.getNewSuperior() != null && (newParentId = this.findEntryId(modifyDNOperation.getNewSuperior())) != null && !newParentId.equals(ctx.getNewParentId())) {
                modifyDNOperation.setResultCode(ResultCode.NO_SUCH_OBJECT);
                return new SynchronizationProviderResult(false);
            }
        } else {
            ChangeNumber changeNumber = this.generateChangeNumber(modifyDNOperation);
            String newParentId = null;
            if (modifyDNOperation.getNewSuperior() != null) {
                newParentId = this.findEntryId(modifyDNOperation.getNewSuperior());
            }
            Entry modifiedEntry = modifyDNOperation.getOriginalEntry();
            String modifiedEntryUUID = Historical.getEntryUuid(modifiedEntry);
            ctx = new ModifyDnContext(changeNumber, modifiedEntryUUID, newParentId);
            modifyDNOperation.setAttachment("replicationContext", ctx);
        }
        return new SynchronizationProviderResult(true);
    }

    public SynchronizationProviderResult handleConflictResolution(PreOperationModifyOperation modifyOperation) {
        if (!modifyOperation.isSynchronizationOperation() && !this.brokerIsConnected(modifyOperation)) {
            return new SynchronizationProviderResult(false);
        }
        ModifyContext ctx = (ModifyContext)modifyOperation.getAttachment("replicationContext");
        Entry modifiedEntry = modifyOperation.getModifiedEntry();
        if (ctx == null) {
            ChangeNumber changeNumber = this.generateChangeNumber(modifyOperation);
            String modifiedEntryUUID = Historical.getEntryUuid(modifiedEntry);
            if (modifiedEntryUUID == null) {
                modifiedEntryUUID = modifyOperation.getEntryDN().toString();
            }
            ctx = new ModifyContext(changeNumber, modifiedEntryUUID);
            modifyOperation.setAttachment("replicationContext", ctx);
        } else {
            String modifiedEntryUUID = ctx.getEntryUid();
            String currentEntryUUID = Historical.getEntryUuid(modifiedEntry);
            if (currentEntryUUID != null && !currentEntryUUID.equals(modifiedEntryUUID)) {
                modifyOperation.setResultCode(ResultCode.NO_SUCH_OBJECT);
                return new SynchronizationProviderResult(false);
            }
            Historical historicalInformation = Historical.load(modifiedEntry);
            modifyOperation.setAttachment("ds-synch-historical", historicalInformation);
            if (historicalInformation.replayOperation(modifyOperation, modifiedEntry)) {
                this.numResolvedModifyConflicts.incrementAndGet();
            }
            if (modifyOperation.getModifications().isEmpty()) {
                modifyOperation.setResultCode(ResultCode.SUCCESS);
                return new SynchronizationProviderResult(false);
            }
        }
        return new SynchronizationProviderResult(true);
    }

    public void doPreOperation(PreOperationAddOperation addOperation) {
        AddContext ctx = new AddContext(this.generateChangeNumber(addOperation), Historical.getEntryUuid(addOperation), this.findEntryId(addOperation.getEntryDN().getParentDNInSuffix()));
        addOperation.setAttachment("replicationContext", ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UpdateMessage receive() {
        UpdateMessage update = this.remotePendingChanges.getNextUpdate();
        if (update != null) return update;
        ReplicationBroker replicationBroker = this.broker;
        synchronized (replicationBroker) {
            while (update == null) {
                try {
                    RoutableMessage initMsg;
                    ReplicationMessage msg = this.broker.receive();
                    if (msg == null) {
                        return null;
                    }
                    this.log(Message.raw("Broker received message :" + msg, new Object[0]));
                    if (msg instanceof AckMessage) {
                        AckMessage ack = (AckMessage)msg;
                        this.receiveAck(ack);
                        continue;
                    }
                    if (msg instanceof InitializeRequestMessage) {
                        initMsg = (InitializeRequestMessage)msg;
                        try {
                            this.initializeTarget(initMsg.getsenderID(), initMsg.getsenderID(), null);
                        }
                        catch (DirectoryException de) {}
                        continue;
                    }
                    if (msg instanceof InitializeTargetMessage) {
                        initMsg = (InitializeTargetMessage)msg;
                        try {
                            this.importBackend((InitializeTargetMessage)initMsg);
                        }
                        catch (DirectoryException de) {
                            ErrorMessage errorMsg = new ErrorMessage(initMsg.getsenderID(), de.getMessageObject());
                            MessageBuilder mb = new MessageBuilder();
                            mb.append(de.getMessageObject());
                            mb.append("Backend ID: ");
                            mb.append(this.backend.getBackendID());
                            this.log(mb.toMessage());
                            this.broker.publish(errorMsg);
                        }
                        continue;
                    }
                    if (msg instanceof ErrorMessage) {
                        if (this.ieContext == null) continue;
                        this.abandonImportExport((ErrorMessage)msg);
                        continue;
                    }
                    if (!(msg instanceof UpdateMessage)) continue;
                    update = (UpdateMessage)msg;
                    this.receiveUpdate(update);
                }
                catch (SocketTimeoutException e) {}
            }
            return update;
        }
    }

    public void receiveUpdate(UpdateMessage update) {
        this.remotePendingChanges.putRemoteUpdate(update);
        this.numRcvdUpdates.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveAck(AckMessage ack) {
        UpdateMessage update;
        ChangeNumber changeNumber = ack.getChangeNumber();
        Object object = this.waitingAckMsgs;
        synchronized (object) {
            update = (UpdateMessage)this.waitingAckMsgs.remove(changeNumber);
        }
        if (update != null) {
            object = update;
            synchronized (object) {
                update.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronize(PostOperationOperation op) {
        ResultCode result = op.getResultCode();
        if (result == ResultCode.SUCCESS && op.isSynchronizationOperation()) {
            ++this.numReplayedPostOpCalled;
        }
        UpdateMessage msg = null;
        ChangeNumber curChangeNumber = OperationContext.getChangeNumber(op);
        boolean isAssured = this.isAssured(op);
        if (result == ResultCode.SUCCESS && !op.isSynchronizationOperation() && (msg = UpdateMessage.generateMsg(op, isAssured)) == null) {
            this.pendingChanges.remove(curChangeNumber);
            Message message = ReplicationMessages.ERR_UNKNOWN_TYPE.get(op.getOperationType().toString());
            ErrorLogger.logError(message);
            return;
        }
        if (result == ResultCode.SUCCESS) {
            try {
                if (op.isSynchronizationOperation()) {
                    this.remotePendingChanges.commit(curChangeNumber);
                } else {
                    this.pendingChanges.commit(curChangeNumber, msg);
                }
            }
            catch (NoSuchElementException e) {
                Message message = ReplicationMessages.ERR_OPERATION_NOT_FOUND_IN_PENDING.get(curChangeNumber.toString(), op.toString());
                ErrorLogger.logError(message);
                return;
            }
            if (msg != null && isAssured) {
                SortedMap<ChangeNumber, UpdateMessage> e = this.waitingAckMsgs;
                synchronized (e) {
                    this.waitingAckMsgs.put(curChangeNumber, msg);
                }
            }
        } else if (!op.isSynchronizationOperation() && curChangeNumber != null) {
            this.pendingChanges.remove(curChangeNumber);
        }
        if (!op.isSynchronizationOperation()) {
            int pushedChanges = this.pendingChanges.pushCommittedChanges();
            this.numSentUpdates.addAndGet(pushedChanges);
        }
        if (msg != null && isAssured) {
            UpdateMessage updateMessage = msg;
            synchronized (updateMessage) {
                while (this.waitingAckMsgs.containsKey(msg.getChangeNumber())) {
                    try {
                        msg.wait(1000L);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }
    }

    public int getNumRcvdUpdates() {
        return this.numRcvdUpdates.get();
    }

    public int getNumSentUpdates() {
        return this.numSentUpdates.get();
    }

    public int getPendingUpdatesCount() {
        return this.pendingChanges.size();
    }

    public void incProcessedUpdates() {
        this.numProcessedUpdates.incrementAndGet();
    }

    public int getNumProcessedUpdates() {
        return this.numProcessedUpdates.get();
    }

    public int getNumReplayedPostOpCalled() {
        return this.numReplayedPostOpCalled;
    }

    public ServerState getServerState() {
        return this.state;
    }

    public int getDebugCount() {
        return this.debugCount;
    }

    public void ack(ChangeNumber changeNumber) {
        this.broker.publish(new AckMessage(changeNumber));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.createListeners();
        while (!this.shutdown) {
            try {
                ReplicationDomain replicationDomain = this;
                synchronized (replicationDomain) {
                    this.wait(1000L);
                    if (!this.disabled && !this.stateSavingDisabled) {
                        this.state.save();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        this.state.save();
    }

    private void createListeners() {
        this.synchroThreads.clear();
        for (int i = 0; i < this.listenerThreadNumber; ++i) {
            ListenerThread myThread = new ListenerThread(this);
            myThread.start();
            this.synchroThreads.add(myThread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        for (ListenerThread thread : this.synchroThreads) {
            thread.shutdown();
        }
        this.shutdown = true;
        Iterator<ListenerThread> i$ = this;
        synchronized (i$) {
            this.notify();
        }
        DirectoryServer.deregisterMonitorProvider(this.monitor.getMonitorInstanceName());
        DirectoryServer.deregisterAlertGenerator(this);
        this.broker.stop();
        for (ListenerThread thread : this.synchroThreads) {
            thread.shutdown();
        }
    }

    public String getReplicationServer() {
        return this.broker.getReplicationServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replay(UpdateMessage msg) {
        Object op = null;
        boolean done = false;
        boolean dependency = false;
        ChangeNumber changeNumber = null;
        int retryCount = 10;
        boolean firstTry = true;
        try {
            while (!dependency && !done && retryCount-- > 0) {
                op = msg.createOperation(this.conn);
                op.setInternalOperation(true);
                op.setSynchronizationOperation(true);
                changeNumber = OperationContext.getChangeNumber((Operation)op);
                ((AbstractOperation)op).run();
                ResultCode result = op.getResultCode();
                if (result != ResultCode.SUCCESS) {
                    Operation newOp;
                    if (op instanceof ModifyOperation) {
                        newOp = (ModifyOperation)op;
                        dependency = this.remotePendingChanges.checkDependencies((ModifyOperation)newOp);
                        if (!dependency) {
                            done = this.solveNamingConflict((ModifyOperation)newOp, msg);
                        }
                    } else if (op instanceof DeleteOperation) {
                        newOp = (DeleteOperation)op;
                        dependency = this.remotePendingChanges.checkDependencies((DeleteOperation)newOp);
                        if (!dependency && !firstTry) {
                            done = this.solveNamingConflict((DeleteOperation)newOp, msg);
                        }
                    } else if (op instanceof AddOperation) {
                        newOp = (AddOperation)op;
                        AddMsg addMsg = (AddMsg)msg;
                        dependency = this.remotePendingChanges.checkDependencies((AddOperation)newOp);
                        if (!dependency) {
                            done = this.solveNamingConflict((AddOperation)newOp, addMsg);
                        }
                    } else if (op instanceof ModifyDNOperationBasis) {
                        ModifyDNMsg newMsg = (ModifyDNMsg)msg;
                        dependency = this.remotePendingChanges.checkDependencies(newMsg);
                        if (!dependency) {
                            ModifyDNOperationBasis newOp2 = (ModifyDNOperationBasis)op;
                            done = this.solveNamingConflict(newOp2, msg);
                        }
                    } else {
                        done = true;
                    }
                    if (done) {
                        this.updateError(changeNumber);
                    }
                } else {
                    done = true;
                }
                firstTry = false;
            }
            if (!done && !dependency) {
                Message message = ReplicationMessages.ERR_LOOP_REPLAYING_OPERATION.get(op.toString(), op.getErrorMessage().toString());
                ErrorLogger.logError(message);
                this.numUnresolvedNamingConflicts.incrementAndGet();
                this.updateError(changeNumber);
            }
        }
        catch (ASN1Exception e) {
            Message message = ReplicationMessages.ERR_EXCEPTION_DECODING_OPERATION.get(String.valueOf(msg) + StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(message);
        }
        catch (LDAPException e) {
            Message message = ReplicationMessages.ERR_EXCEPTION_DECODING_OPERATION.get(String.valueOf(msg) + StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(message);
        }
        catch (DataFormatException e) {
            Message message = ReplicationMessages.ERR_EXCEPTION_DECODING_OPERATION.get(String.valueOf(msg) + StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(message);
        }
        catch (Exception e) {
            if (changeNumber != null) {
                Message message = ReplicationMessages.ERR_EXCEPTION_REPLAYING_OPERATION.get(StaticUtils.stackTraceToSingleLineString(e), op.toString());
                ErrorLogger.logError(message);
                this.updateError(changeNumber);
            } else {
                Message message = ReplicationMessages.ERR_EXCEPTION_DECODING_OPERATION.get(String.valueOf(msg) + StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
            }
        }
        finally {
            if (!dependency) {
                if (msg.isAssured()) {
                    this.ack(msg.getChangeNumber());
                }
                this.incProcessedUpdates();
            }
        }
    }

    public void updateError(ChangeNumber changeNumber) {
        this.remotePendingChanges.commit(changeNumber);
    }

    private ChangeNumber generateChangeNumber(PluginOperation operation) {
        return this.pendingChanges.putLocalOperation(operation);
    }

    private String findEntryId(DN dn) {
        if (dn == null) {
            return null;
        }
        try {
            SearchResultEntry resultEntry;
            LinkedList<SearchResultEntry> result;
            LinkedHashSet<String> attrs = new LinkedHashSet<String>(1);
            attrs.add("entryuuid");
            InternalSearchOperation search = this.conn.processSearch(dn, SearchScope.BASE_OBJECT, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, SearchFilter.createFilterFromString("objectclass=*"), attrs);
            if (search.getResultCode() == ResultCode.SUCCESS && !(result = search.getSearchEntries()).isEmpty() && (resultEntry = result.getFirst()) != null) {
                return Historical.getEntryUuid(resultEntry);
            }
        }
        catch (DirectoryException directoryException) {
            // empty catch block
        }
        return null;
    }

    private DN findEntryDN(String uuid) {
        try {
            SearchResultEntry resultEntry;
            LinkedList<SearchResultEntry> result;
            InternalSearchOperation search = this.conn.processSearch(this.baseDN, SearchScope.WHOLE_SUBTREE, SearchFilter.createFilterFromString("entryuuid=" + uuid));
            if (search.getResultCode() == ResultCode.SUCCESS && !(result = search.getSearchEntries()).isEmpty() && (resultEntry = result.getFirst()) != null) {
                return resultEntry.getDN();
            }
        }
        catch (DirectoryException directoryException) {
            // empty catch block
        }
        return null;
    }

    private boolean solveNamingConflict(ModifyOperation op, UpdateMessage msg) {
        ResultCode result = op.getResultCode();
        ModifyContext ctx = (ModifyContext)op.getAttachment("replicationContext");
        String entryUid = ctx.getEntryUid();
        if (result == ResultCode.NO_SUCH_OBJECT) {
            DN newdn = this.findEntryDN(entryUid);
            if (newdn != null) {
                msg.setDn(newdn.toString());
                this.numResolvedNamingConflicts.incrementAndGet();
                return false;
            }
            this.numResolvedNamingConflicts.incrementAndGet();
            return true;
        }
        Message message = ReplicationMessages.ERR_ERROR_REPLAYING_OPERATION.get(op.toString(), ctx.getChangeNumber().toString(), result.toString(), op.getErrorMessage().toString());
        ErrorLogger.logError(message);
        return true;
    }

    private boolean solveNamingConflict(DeleteOperation op, UpdateMessage msg) {
        ResultCode result = op.getResultCode();
        DeleteContext ctx = (DeleteContext)op.getAttachment("replicationContext");
        String entryUid = ctx.getEntryUid();
        if (result == ResultCode.NO_SUCH_OBJECT) {
            DN currentDn = this.findEntryDN(entryUid);
            if (currentDn == null) {
                this.numResolvedNamingConflicts.incrementAndGet();
                return true;
            }
            msg.setDn(currentDn.toString());
            this.numResolvedNamingConflicts.incrementAndGet();
            return false;
        }
        if (result == ResultCode.NOT_ALLOWED_ON_NONLEAF) {
            this.findAndRenameChild(entryUid, op.getEntryDN(), op);
            this.numUnresolvedNamingConflicts.incrementAndGet();
            return false;
        }
        Message message = ReplicationMessages.ERR_ERROR_REPLAYING_OPERATION.get(op.toString(), ctx.getChangeNumber().toString(), result.toString(), op.getErrorMessage().toString());
        ErrorLogger.logError(message);
        return true;
    }

    private boolean solveNamingConflict(ModifyDNOperation op, UpdateMessage msg) throws Exception {
        ResultCode result = op.getResultCode();
        ModifyDnContext ctx = (ModifyDnContext)op.getAttachment("replicationContext");
        String entryUid = ctx.getEntryUid();
        String newSuperiorID = ctx.getNewParentId();
        DN entryDN = op.getEntryDN();
        DN newSuperior = this.findEntryDN(newSuperiorID);
        RDN newRDN = op.getNewRDN();
        DN parentDN = newSuperior == null ? entryDN.getParent() : newSuperior;
        if (parentDN == null || parentDN.isNullDN()) {
            throw new Exception("operation parameters are invalid");
        }
        DN newDN = parentDN.concat(newRDN);
        DN currentDN = this.findEntryDN(entryUid);
        if (currentDN == null) {
            this.numResolvedNamingConflicts.incrementAndGet();
            return true;
        }
        if (newDN.equals(currentDN)) {
            this.numResolvedNamingConflicts.incrementAndGet();
            return true;
        }
        if (result == ResultCode.NO_SUCH_OBJECT || result == ResultCode.OBJECTCLASS_VIOLATION) {
            ModifyDNMsg modifyDnMsg = (ModifyDNMsg)msg;
            msg.setDn(currentDN.toString());
            modifyDnMsg.setNewSuperior(newSuperior.toString());
            this.numResolvedNamingConflicts.incrementAndGet();
            return false;
        }
        if (result == ResultCode.ENTRY_ALREADY_EXISTS) {
            ModifyDNMsg modifyDnMsg = (ModifyDNMsg)msg;
            this.markConflictEntry(op, op.getEntryDN(), newDN);
            modifyDnMsg.setNewRDN(this.generateConflictRDN(entryUid, modifyDnMsg.getNewRDN()));
            modifyDnMsg.setNewSuperior(newSuperior.toString());
            this.numUnresolvedNamingConflicts.incrementAndGet();
            return false;
        }
        Message message = ReplicationMessages.ERR_ERROR_REPLAYING_OPERATION.get(op.toString(), ctx.getChangeNumber().toString(), result.toString(), op.getErrorMessage().toString());
        ErrorLogger.logError(message);
        return true;
    }

    private boolean solveNamingConflict(AddOperation op, AddMsg msg) throws Exception {
        ResultCode result = op.getResultCode();
        AddContext ctx = (AddContext)op.getAttachment("replicationContext");
        String entryUid = ctx.getEntryUid();
        String parentUniqueId = ctx.getParentUid();
        if (result == ResultCode.NO_SUCH_OBJECT) {
            if (parentUniqueId == null) {
                return true;
            }
            DN parentDn = this.findEntryDN(parentUniqueId);
            if (parentDn == null) {
                this.addConflict(msg);
                msg.setDn(this.generateConflictRDN(entryUid, op.getEntryDN().getRDN().toString()) + "," + this.baseDN);
                msg.setParentUid(null);
                this.numUnresolvedNamingConflicts.incrementAndGet();
                return false;
            }
            RDN entryRdn = DN.decode(msg.getDn()).getRDN();
            msg.setDn(entryRdn + "," + parentDn);
            this.numResolvedNamingConflicts.incrementAndGet();
            return false;
        }
        if (result == ResultCode.ENTRY_ALREADY_EXISTS) {
            if (this.findEntryDN(entryUid) != null) {
                return true;
            }
            this.addConflict(msg);
            msg.setDn(this.generateConflictRDN(entryUid, msg.getDn()));
            this.numUnresolvedNamingConflicts.incrementAndGet();
            return false;
        }
        Message message = ReplicationMessages.ERR_ERROR_REPLAYING_OPERATION.get(op.toString(), ctx.getChangeNumber().toString(), result.toString(), op.getErrorMessage().toString());
        ErrorLogger.logError(message);
        return true;
    }

    private void findAndRenameChild(String entryUid, DN entryDN, Operation conflictOp) {
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        try {
            LinkedHashSet<String> attrs = new LinkedHashSet<String>(1);
            attrs.add("entryuuid");
            SearchFilter ALLMATCH = SearchFilter.createFilterFromString("(objectClass=*)");
            InternalSearchOperation op = conn.processSearch(entryDN, SearchScope.SINGLE_LEVEL, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, ALLMATCH, attrs);
            if (op.getResultCode() == ResultCode.SUCCESS) {
                LinkedList<SearchResultEntry> entries = op.getSearchEntries();
                if (entries != null) {
                    for (SearchResultEntry entry : entries) {
                        this.markConflictEntry(conflictOp, entry.getDN(), entryDN);
                        this.renameConflictEntry(conflictOp, entry.getDN(), Historical.getEntryUuid(entry));
                    }
                }
            } else {
                MessageBuilder mb = new MessageBuilder();
                mb.append(ReplicationMessages.ERR_CANNOT_RENAME_CONFLICT_ENTRY.get());
                mb.append(String.valueOf(entryDN));
                mb.append(" ");
                mb.append(String.valueOf(conflictOp));
                mb.append(" ");
                mb.append(String.valueOf((Object)op.getResultCode()));
                ErrorLogger.logError(mb.toMessage());
            }
        }
        catch (DirectoryException e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_EXCEPTION_RENAME_CONFLICT_ENTRY.get());
            mb.append(String.valueOf(entryDN));
            mb.append(" ");
            mb.append(String.valueOf(conflictOp));
            mb.append(" ");
            mb.append(e.getLocalizedMessage());
            ErrorLogger.logError(mb.toMessage());
        }
    }

    private void renameConflictEntry(Operation conflictOp, DN dn, String uid) {
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        ModifyDNOperation newOp = conn.processModifyDN(dn, this.generateDeleteConflictDn(uid, dn), false, this.baseDN);
        if (newOp.getResultCode() != ResultCode.SUCCESS) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_CANNOT_RENAME_CONFLICT_ENTRY.get());
            mb.append(String.valueOf(dn));
            mb.append(" ");
            mb.append(String.valueOf(conflictOp));
            mb.append(" ");
            mb.append(String.valueOf((Object)newOp.getResultCode()));
            ErrorLogger.logError(mb.toMessage());
        }
    }

    private void markConflictEntry(Operation op, DN currentDN, DN conflictDN) {
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        AttributeType attrType = DirectoryServer.getAttributeType(DS_SYNC_CONFLICT, true);
        LinkedHashSet<AttributeValue> values = new LinkedHashSet<AttributeValue>();
        values.add(new AttributeValue(attrType, conflictDN.toString()));
        Attribute attr = new Attribute(attrType, DS_SYNC_CONFLICT, values);
        ArrayList<Modification> mods = new ArrayList<Modification>();
        Modification mod = new Modification(ModificationType.REPLACE, attr);
        mods.add(mod);
        ModifyOperation newOp = conn.processModify(currentDN, mods);
        if (newOp.getResultCode() != ResultCode.SUCCESS) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_CANNOT_ADD_CONFLICT_ATTRIBUTE.get());
            mb.append(String.valueOf(op));
            mb.append(" ");
            mb.append(String.valueOf((Object)newOp.getResultCode()));
            ErrorLogger.logError(mb.toMessage());
        }
        Message alertMessage = ReplicationMessages.NOTE_UNRESOLVED_CONFLICT.get(conflictDN.toString());
        DirectoryServer.sendAlertNotification(this, "org.opends.server.replication.UnresolvedConflict", alertMessage);
    }

    private void addConflict(AddMsg msg) throws ASN1Exception {
        Message alertMessage = ReplicationMessages.NOTE_UNRESOLVED_CONFLICT.get(msg.getDn());
        DirectoryServer.sendAlertNotification(this, "org.opends.server.replication.UnresolvedConflict", alertMessage);
        msg.addAttribute(DS_SYNC_CONFLICT, msg.getDn());
    }

    private String generateConflictRDN(String entryUid, String rdn) {
        return "entryuuid=" + entryUid + "+" + rdn;
    }

    private RDN generateDeleteConflictDn(String entryUid, DN dn) {
        String newRDN = "entryuuid=" + entryUid + "+" + dn.getRDN();
        RDN rdn = null;
        try {
            rdn = RDN.decode(newRDN);
        }
        catch (DirectoryException e) {
            // empty catch block
        }
        return rdn;
    }

    private boolean isAssured(PostOperationOperation op) {
        return false;
    }

    public int getMaxRcvWindow() {
        return this.broker.getMaxRcvWindow();
    }

    public int getCurrentRcvWindow() {
        return this.broker.getCurrentRcvWindow();
    }

    public int getMaxSendWindow() {
        return this.broker.getMaxSendWindow();
    }

    public int getCurrentSendWindow() {
        return this.broker.getCurrentSendWindow();
    }

    public int getNumLostConnections() {
        return this.broker.getNumLostConnections();
    }

    public int getNumResolvedModifyConflicts() {
        return this.numResolvedModifyConflicts.get();
    }

    public int getNumResolvedNamingConflicts() {
        return this.numResolvedNamingConflicts.get();
    }

    public int getNumUnresolvedNamingConflicts() {
        return this.numUnresolvedNamingConflicts.get();
    }

    public boolean solveConflict() {
        return this.solveConflictFlag;
    }

    public void disable() {
        this.state.save();
        this.state.clear();
        this.disabled = true;
        for (ListenerThread thread : this.synchroThreads) {
            thread.shutdown();
        }
        this.broker.stop();
        for (ListenerThread thread : this.synchroThreads) {
            try {
                thread.join(30000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void enable() {
        this.state.clear();
        this.state.loadState();
        this.disabled = false;
        this.broker.start(this.replicationServers);
        this.createListeners();
    }

    public void backupStart() {
        this.state.save();
    }

    public void backupEnd() {
    }

    public byte[] receiveEntryBytes() {
        try {
            ReplicationMessage msg;
            do {
                if ((msg = this.broker.receive()) == null) {
                    return null;
                }
                this.log(Message.raw("receiveEntryBytes: received " + msg, new Object[0]));
                if (msg instanceof EntryMessage) {
                    EntryMessage entryMsg = (EntryMessage)msg;
                    byte[] entryBytes = (byte[])entryMsg.getEntryBytes().clone();
                    this.ieContext.updateTaskCounters();
                    return entryBytes;
                }
                if (!(msg instanceof DoneMessage)) continue;
                return null;
            } while (!(msg instanceof ErrorMessage));
            ErrorMessage errorMsg = (ErrorMessage)msg;
            this.ieContext.exception = new DirectoryException(ResultCode.OTHER, errorMsg.getDetails());
            return null;
        }
        catch (Exception e) {
            this.ieContext.exception = new DirectoryException(ResultCode.OTHER, Message.raw("received an unexpected message type", new Object[0]), e);
            return null;
        }
    }

    protected void abandonImportExport(ErrorMessage errorMsg) {
        if (this.ieContext != null) {
            this.ieContext.exception = new DirectoryException(ResultCode.OTHER, errorMsg.getDetails());
            if (this.ieContext.initializeTask instanceof InitializeTask) {
                ((InitializeTask)this.ieContext.initializeTask).setState(this.ieContext.updateTaskCompletionState(), this.ieContext.exception);
                this.releaseIEContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearJEBackend(boolean createBaseEntry, String beID, String dn) throws Exception {
        BackendImpl backend = (BackendImpl)DirectoryServer.getBackend(beID);
        TaskUtils.disableBackend(beID);
        try {
            String lockFile = LockFileManager.getBackendLockFileName(backend);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.acquireExclusiveLock(lockFile, failureReason)) {
                throw new RuntimeException(failureReason.toString());
            }
            try {
                backend.clearBackend();
            }
            finally {
                LockFileManager.releaseLock(lockFile, failureReason);
            }
        }
        finally {
            TaskUtils.enableBackend(beID);
        }
        if (createBaseEntry) {
            DN baseDN = DN.decode(dn);
            Entry e = StaticUtils.createEntry(baseDN);
            backend = (BackendImpl)DirectoryServer.getBackend(beID);
            backend.addEntry(e, null);
        }
    }

    private void log(Message message) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("DebugInfo" + message);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void exportBackend() throws DirectoryException {
        this.retrievesBackendInfos(this.baseDN);
        try {
            String lockFile = LockFileManager.getBackendLockFileName(this.backend);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.acquireSharedLock(lockFile, failureReason)) {
                Message message = ToolMessages.ERR_LDIFEXPORT_CANNOT_LOCK_BACKEND.get(this.backend.getBackendID(), String.valueOf(failureReason));
                ErrorLogger.logError(message);
                throw new DirectoryException(ResultCode.OTHER, message, null);
            }
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_LDIFEXPORT_CANNOT_LOCK_BACKEND.get(this.backend.getBackendID(), e.getLocalizedMessage());
            ErrorLogger.logError(message);
            throw new DirectoryException(ResultCode.OTHER, message, null);
        }
        ReplLDIFOutputStream os = new ReplLDIFOutputStream(this);
        LDIFExportConfig exportConfig = new LDIFExportConfig(os);
        ArrayList<DN> includeBranches = new ArrayList<DN>(1);
        includeBranches.add(this.baseDN);
        exportConfig.setIncludeBranches(includeBranches);
        try {
            try {
                this.backend.exportLDIF(exportConfig);
            }
            catch (DirectoryException de) {
                Message message = ToolMessages.ERR_LDIFEXPORT_ERROR_DURING_EXPORT.get(de.getMessageObject());
                ErrorLogger.logError(message);
                throw new DirectoryException(ResultCode.OTHER, message, null);
            }
            catch (Exception e) {
                Message message = ToolMessages.ERR_LDIFEXPORT_ERROR_DURING_EXPORT.get(StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                throw new DirectoryException(ResultCode.OTHER, message, null);
            }
            Object var7_7 = null;
            exportConfig.close();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            exportConfig.close();
            try {
                String lockFile = LockFileManager.getBackendLockFileName(this.backend);
                StringBuilder failureReason = new StringBuilder();
                if (LockFileManager.releaseLock(lockFile, failureReason)) throw throwable;
                Message message = ToolMessages.WARN_LDIFEXPORT_CANNOT_UNLOCK_BACKEND.get(this.backend.getBackendID(), String.valueOf(failureReason));
                ErrorLogger.logError(message);
                throw new DirectoryException(ResultCode.OTHER, message, null);
            }
            catch (Exception e) {
                Message message = ToolMessages.WARN_LDIFEXPORT_CANNOT_UNLOCK_BACKEND.get(this.backend.getBackendID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                throw new DirectoryException(ResultCode.OTHER, message, null);
            }
        }
        try {}
        catch (Exception e) {
            Message message = ToolMessages.WARN_LDIFEXPORT_CANNOT_UNLOCK_BACKEND.get(this.backend.getBackendID(), StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(message);
            throw new DirectoryException(ResultCode.OTHER, message, null);
        }
        String lockFile = LockFileManager.getBackendLockFileName(this.backend);
        StringBuilder failureReason = new StringBuilder();
        if (LockFileManager.releaseLock(lockFile, failureReason)) return;
        Message message = ToolMessages.WARN_LDIFEXPORT_CANNOT_UNLOCK_BACKEND.get(this.backend.getBackendID(), String.valueOf(failureReason));
        ErrorLogger.logError(message);
        throw new DirectoryException(ResultCode.OTHER, message, null);
    }

    protected void retrievesBackendInfos(DN baseDN) throws DirectoryException {
        Backend domainBackend = DirectoryServer.getBackend(baseDN);
        if (domainBackend == null) {
            Message message = ToolMessages.ERR_CANNOT_DECODE_BASE_DN.get("cn=Backends,cn=config", "");
            throw new DirectoryException(ResultCode.OTHER, message, null);
        }
        BackendCfg backendCfg = TaskUtils.getConfigEntry(domainBackend);
        if (backendCfg == null) {
            Message message = ToolMessages.ERR_LDIFIMPORT_NO_BACKENDS_FOR_ID.get();
            ErrorLogger.logError(message);
            throw new DirectoryException(ResultCode.OTHER, message, null);
        }
        this.backend = domainBackend;
        if (!domainBackend.supportsLDIFImport()) {
            Message message = ToolMessages.ERR_LDIFIMPORT_CANNOT_IMPORT.get(String.valueOf(baseDN));
            ErrorLogger.logError(message);
            throw new DirectoryException(ResultCode.OTHER, message, null);
        }
    }

    public void sendEntryLines(String lDIFEntry) throws IOException {
        if (this.ieContext.exception != null) {
            IOException ioe = new IOException(this.ieContext.exception.getMessage());
            this.ieContext = null;
            throw ioe;
        }
        EntryMessage entryMessage = new EntryMessage(this.serverId, this.ieContext.exportTarget, lDIFEntry.getBytes());
        this.broker.publish(entryMessage);
        this.ieContext.updateTaskCounters();
    }

    public void initialize(short source, Task initTask) throws DirectoryException {
        this.acquireIEContext();
        this.ieContext.initializeTask = initTask;
        InitializeRequestMessage initializeMsg = new InitializeRequestMessage(this.baseDN, this.serverId, source);
        this.broker.publish(initializeMsg);
    }

    public short decodeSource(String sourceString) throws DirectoryException {
        short source = 0;
        Exception cause = null;
        try {
            source = Integer.decode(sourceString).shortValue();
            if (source >= -1 && source != this.serverId) {
                this.log(Message.raw("Source decoded for import:" + source, new Object[0]));
                return source;
            }
        }
        catch (Exception e) {
            cause = e;
        }
        ResultCode resultCode = ResultCode.OTHER;
        Message message = ReplicationMessages.ERR_INVALID_IMPORT_SOURCE.get();
        if (cause != null) {
            throw new DirectoryException(resultCode, message, cause);
        }
        throw new DirectoryException(resultCode, message);
    }

    public short decodeTarget(String targetString) throws DirectoryException {
        short target = 0;
        if (targetString.equalsIgnoreCase("all")) {
            return -2;
        }
        try {
            target = Integer.decode(targetString).shortValue();
            if (target >= 0) {
                // empty if block
            }
            return target;
        }
        catch (Exception e) {
            Exception cause = e;
            ResultCode resultCode = ResultCode.OTHER;
            Message message = ReplicationMessages.ERR_INVALID_EXPORT_TARGET.get();
            if (cause != null) {
                throw new DirectoryException(resultCode, message, cause);
            }
            throw new DirectoryException(resultCode, message);
        }
    }

    private synchronized void acquireIEContext() throws DirectoryException {
        if (this.ieContext != null) {
            Message message = ReplicationMessages.ERR_SIMULTANEOUS_IMPORT_EXPORT_REJECTED.get();
            throw new DirectoryException(ResultCode.OTHER, message);
        }
        this.ieContext = new IEContext();
    }

    private synchronized void releaseIEContext() {
        this.ieContext = null;
    }

    public void initializeTarget(short target, Task initTask) throws DirectoryException {
        this.initializeTarget(target, this.serverId, initTask);
    }

    public void initializeTarget(short target, short requestorID, Task initTask) throws DirectoryException {
        this.retrievesBackendInfos(this.baseDN);
        this.acquireIEContext();
        this.ieContext.exportTarget = target;
        if (initTask != null) {
            this.ieContext.initializeTask = initTask;
            this.ieContext.initTaskCounters(this.backend.getEntryCount());
        }
        InitializeTargetMessage initializeMessage = new InitializeTargetMessage(this.baseDN, this.serverId, this.ieContext.exportTarget, requestorID, this.backend.getEntryCount());
        this.log(Message.raw("SD : publishes " + initializeMessage + " for #entries=" + this.backend.getEntryCount() + this.ieContext.entryLeftCount, new Object[0]));
        this.broker.publish(initializeMessage);
        try {
            this.exportBackend();
            DoneMessage doneMsg = new DoneMessage(this.serverId, initializeMessage.getDestination());
            this.broker.publish(doneMsg);
            this.releaseIEContext();
        }
        catch (DirectoryException de) {
            ErrorMessage errorMsg = new ErrorMessage(target, de.getMessageObject());
            this.broker.publish(errorMsg);
            this.releaseIEContext();
            throw de;
        }
    }

    private void preBackendImport(Backend backend) throws Exception {
        this.stateSavingDisabled = true;
        TaskUtils.disableBackend(backend.getBackendID());
        String lockFile = LockFileManager.getBackendLockFileName(backend);
        StringBuilder failureReason = new StringBuilder();
        if (!LockFileManager.acquireExclusiveLock(lockFile, failureReason)) {
            Message message = ToolMessages.ERR_LDIFIMPORT_CANNOT_LOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
            ErrorLogger.logError(message);
            throw new DirectoryException(ResultCode.OTHER, message);
        }
    }

    protected void importBackend(InitializeTargetMessage initializeMessage) throws DirectoryException {
        LDIFImportConfig importConfig = null;
        try {
            this.log(Message.raw("startImport", new Object[0]));
            if (initializeMessage.getRequestorID() != (long)this.serverId) {
                this.acquireIEContext();
            }
            this.ieContext.importSource = initializeMessage.getsenderID();
            this.ieContext.entryLeftCount = initializeMessage.getEntryCount();
            this.ieContext.initTaskCounters(initializeMessage.getEntryCount());
            this.preBackendImport(this.backend);
            this.ieContext.ldifImportInputStream = new ReplLDIFInputStream(this);
            importConfig = new LDIFImportConfig(this.ieContext.ldifImportInputStream);
            ArrayList<DN> includeBranches = new ArrayList<DN>();
            includeBranches.add(this.baseDN);
            importConfig.setIncludeBranches(includeBranches);
            importConfig.setAppendToExistingData(false);
            this.backend.importLDIF(importConfig);
            this.stateSavingDisabled = false;
            this.broker.stop();
            this.broker.start(this.replicationServers);
        }
        catch (Exception e) {
            throw new DirectoryException(ResultCode.OTHER, Message.raw(e.getLocalizedMessage(), new Object[0]));
        }
        finally {
            importConfig.close();
            this.closeBackendImport(this.backend);
            if (this.ieContext != null && this.ieContext.initializeTask != null) {
                ((InitializeTask)this.ieContext.initializeTask).setState(this.ieContext.updateTaskCompletionState(), this.ieContext.exception);
            }
            this.releaseIEContext();
            this.log(Message.raw("End importBackend", new Object[0]));
        }
    }

    protected void closeBackendImport(Backend backend) throws DirectoryException {
        StringBuilder failureReason;
        String lockFile = LockFileManager.getBackendLockFileName(backend);
        if (!LockFileManager.releaseLock(lockFile, failureReason = new StringBuilder())) {
            Message message = ToolMessages.WARN_LDIFIMPORT_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
            ErrorLogger.logError(message);
            throw new DirectoryException(ResultCode.OTHER, message);
        }
        TaskUtils.enableBackend(backend.getBackendID());
    }

    public static ReplicationDomain retrievesReplicationDomain(DN baseDN) throws DirectoryException {
        ReplicationDomain replicationDomain = null;
        DirectoryServer.getSynchronizationProviders();
        for (SynchronizationProvider<SynchronizationProviderCfg> provider : DirectoryServer.getSynchronizationProviders()) {
            if (!(provider instanceof MultimasterReplication)) {
                Message message = ReplicationMessages.ERR_INVALID_PROVIDER.get();
                throw new DirectoryException(ResultCode.OTHER, message);
            }
            ReplicationDomain sdomain = MultimasterReplication.findDomain(baseDN, null);
            if (sdomain == null) break;
            if (replicationDomain != null) {
                Message message = ReplicationMessages.ERR_MULTIPLE_MATCHING_DOMAIN.get();
                throw new DirectoryException(ResultCode.OTHER, message);
            }
            replicationDomain = sdomain;
        }
        if (replicationDomain == null) {
            MessageBuilder mb = new MessageBuilder(ReplicationMessages.ERR_NO_MATCHING_DOMAIN.get());
            mb.append(" ");
            mb.append(String.valueOf(baseDN));
            throw new DirectoryException(ResultCode.OTHER, mb.toMessage());
        }
        return replicationDomain;
    }

    public Backend getBackend() {
        return this.backend;
    }

    public boolean ieRunning() {
        return this.ieContext != null;
    }

    public void synchronizeModifications(List<Modification> modifications) {
        ModifyOperationBasis opBasis = new ModifyOperationBasis((ClientConnection)InternalClientConnection.getRootConnection(), InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), null, DirectoryServer.getSchemaDN(), modifications);
        LocalBackendModifyOperation op = new LocalBackendModifyOperation(opBasis);
        ChangeNumber cn = this.generateChangeNumber(op);
        ModifyContext ctx = new ModifyContext(cn, "schema");
        op.setAttachment("replicationContext", ctx);
        op.setResultCode(ResultCode.SUCCESS);
        this.synchronize(op);
    }

    public static boolean isConfigurationAcceptable(MultimasterDomainCfg configuration, List<Message> unacceptableReasons) {
        DN dn = configuration.getReplicationDN();
        if (MultimasterReplication.findDomain(dn, null) != null) {
            Message message = ReplicationMessages.ERR_SYNC_INVALID_DN.get();
            unacceptableReasons.add(message);
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(MultimasterDomainCfg configuration) {
        this.replicationServers = configuration.getReplicationServer();
        this.maxReceiveQueue = configuration.getMaxReceiveQueue();
        this.maxReceiveDelay = (int)configuration.getMaxReceiveDelay();
        this.maxSendQueue = configuration.getMaxSendQueue();
        this.maxSendDelay = (int)configuration.getMaxSendDelay();
        this.window = configuration.getWindowSize();
        this.heartbeatInterval = configuration.getHeartbeatInterval();
        this.broker.changeConfig(this.replicationServers, this.maxReceiveQueue, this.maxReceiveDelay, this.maxSendQueue, this.maxSendDelay, this.window, this.heartbeatInterval);
        this.isolationpolicy = configuration.getIsolationPolicy();
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(MultimasterDomainCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public LinkedHashMap<String, String> getAlerts() {
        LinkedHashMap<String, String> alerts = new LinkedHashMap<String, String>();
        alerts.put("org.opends.server.replication.UnresolvedConflict", "This alert type will be used to notify administrators if the  multimaster replication cannot resolve automatically a conflict.");
        return alerts;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public DN getComponentEntryDN() {
        return this.configDn;
    }

    private class IEContext {
        Task initializeTask;
        ReplLDIFInputStream ldifImportInputStream = null;
        short exportTarget = (short)-1;
        short importSource = (short)-1;
        long entryCount = 0L;
        long entryLeftCount = 0L;
        DirectoryException exception = null;

        private IEContext() {
        }

        public void initTaskCounters(long count) {
            this.entryCount = count;
            this.entryLeftCount = count;
            if (this.initializeTask != null) {
                if (this.initializeTask instanceof InitializeTask) {
                    ((InitializeTask)this.initializeTask).setTotal(this.entryCount);
                    ((InitializeTask)this.initializeTask).setLeft(this.entryCount);
                } else if (this.initializeTask instanceof InitializeTargetTask) {
                    ((InitializeTargetTask)this.initializeTask).setTotal(this.entryCount);
                    ((InitializeTargetTask)this.initializeTask).setLeft(this.entryCount);
                }
            }
        }

        public void updateTaskCounters() {
            --this.entryLeftCount;
            if (this.initializeTask != null) {
                if (this.initializeTask instanceof InitializeTask) {
                    ((InitializeTask)this.initializeTask).setLeft(this.entryLeftCount);
                } else if (this.initializeTask instanceof InitializeTargetTask) {
                    ((InitializeTargetTask)this.initializeTask).setLeft(this.entryLeftCount);
                }
            }
        }

        protected TaskState updateTaskCompletionState() {
            if (this.exception == null) {
                return TaskState.COMPLETED_SUCCESSFULLY;
            }
            return TaskState.STOPPED_BY_ERROR;
        }
    }
}

