/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.ModifyDNOperationBasis;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.protocol.ModifyDnContext;
import org.opends.server.replication.protocol.OperationContext;
import org.opends.server.replication.protocol.UpdateMessage;
import org.opends.server.types.AbstractOperation;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.operation.PostOperationModifyDNOperation;

public class ModifyDNMsg
extends UpdateMessage {
    private String newRDN;
    private String newSuperior;
    private boolean deleteOldRdn;
    private String newSuperiorId;
    private static final long serialVersionUID = -4905520652801395185L;

    public ModifyDNMsg(PostOperationModifyDNOperation operation) {
        super((OperationContext)operation.getAttachment("replicationContext"), operation.getRawEntryDN().stringValue());
        ModifyDnContext ctx = (ModifyDnContext)operation.getAttachment("replicationContext");
        this.newSuperiorId = ctx.getNewParentId();
        this.deleteOldRdn = operation.deleteOldRDN();
        this.newSuperior = operation.getRawNewSuperior() != null ? operation.getRawNewSuperior().stringValue() : null;
        this.newRDN = operation.getRawNewRDN().stringValue();
    }

    public ModifyDNMsg(String dn, ChangeNumber changeNumber, String uid, String newParentUid, boolean deleteOldRdn, String newSuperior, String newRDN) {
        super(new ModifyDnContext(changeNumber, uid, newParentUid), dn);
        this.newSuperiorId = newParentUid;
        this.deleteOldRdn = deleteOldRdn;
        this.newSuperior = newSuperior;
        this.newRDN = newRDN;
    }

    public ModifyDNMsg(byte[] in) throws DataFormatException, UnsupportedEncodingException {
        super(in);
        int pos = this.decodeHeader((byte)4, in);
        int length = this.getNextLength(in, pos);
        this.newRDN = new String(in, pos, length, "UTF-8");
        pos += length + 1;
        length = this.getNextLength(in, pos);
        this.newSuperior = length != 0 ? new String(in, pos, length, "UTF-8") : null;
        pos += length + 1;
        length = this.getNextLength(in, pos);
        this.newSuperiorId = length != 0 ? new String(in, pos, length, "UTF-8") : null;
        this.deleteOldRdn = in[pos += length + 1] != 0;
    }

    public AbstractOperation createOperation(InternalClientConnection connection, String newDn) {
        ModifyDNOperationBasis moddn = new ModifyDNOperationBasis((ClientConnection)connection, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), null, new ASN1OctetString(newDn), new ASN1OctetString(this.newRDN), this.deleteOldRdn, this.newSuperior == null ? null : new ASN1OctetString(this.newSuperior));
        ModifyDnContext ctx = new ModifyDnContext(this.getChangeNumber(), this.getUniqueId(), this.newSuperiorId);
        moddn.setAttachment("replicationContext", ctx);
        return moddn;
    }

    public byte[] getBytes() throws UnsupportedEncodingException {
        byte[] byteNewRdn = this.newRDN.getBytes("UTF-8");
        byte[] byteNewSuperior = null;
        byte[] byteNewSuperiorId = null;
        int length = byteNewRdn.length + 1 + 1;
        if (this.newSuperior != null) {
            byteNewSuperior = this.newSuperior.getBytes("UTF-8");
            length += byteNewSuperior.length + 1;
        } else {
            ++length;
        }
        if (this.newSuperiorId != null) {
            byteNewSuperiorId = this.newSuperiorId.getBytes("UTF-8");
            length += byteNewSuperiorId.length + 1;
        } else {
            ++length;
        }
        byte[] resultByteArray = this.encodeHeader((byte)4, length);
        int pos = resultByteArray.length - length;
        pos = this.addByteArray(byteNewRdn, resultByteArray, pos);
        if (this.newSuperior != null) {
            pos = this.addByteArray(byteNewSuperior, resultByteArray, pos);
        } else {
            resultByteArray[pos++] = 0;
        }
        if (this.newSuperiorId != null) {
            pos = this.addByteArray(byteNewSuperiorId, resultByteArray, pos);
        } else {
            resultByteArray[pos++] = 0;
        }
        resultByteArray[pos++] = this.deleteOldRdn ? (byte)1 : 0;
        return resultByteArray;
    }

    public String toString() {
        return "Modify DN " + this.getDn() + " " + this.newRDN + " " + this.newSuperior + " " + this.getChangeNumber();
    }

    public void setNewSuperior(String string) {
        this.newSuperior = string;
    }

    public String getNewRDN() {
        return this.newRDN;
    }

    public void setNewRDN(String newRDN) {
        this.newRDN = newRDN;
    }

    public boolean newDNIsParent(DN targetDn) {
        try {
            String newStringDN = this.newRDN + "," + this.newSuperior;
            DN newDN = DN.decode(newStringDN);
            return newDN.isAncestorOf(targetDn);
        }
        catch (DirectoryException e) {
            return false;
        }
    }

    public boolean newDNIsEqual(DN targetDN) {
        try {
            String newStringDN = this.newRDN + "," + this.newSuperior;
            DN newDN = DN.decode(newStringDN);
            return newDN.equals(targetDN);
        }
        catch (DirectoryException e) {
            return false;
        }
    }

    public boolean newParentIsEqual(DN targetDN) {
        try {
            DN newSuperiorDN = DN.decode(this.newSuperior);
            return newSuperiorDN.equals(targetDN);
        }
        catch (DirectoryException e) {
            return false;
        }
    }
}

