/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import org.opends.server.replication.protocol.ReplicationMessage;

public abstract class StartMessage
extends ReplicationMessage {
    private short protocolVersion;
    protected int headerLength;

    public StartMessage(short protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public StartMessage(byte type, byte[] encodedMsg) throws DataFormatException {
        this.headerLength = this.decodeHeader(type, encodedMsg);
    }

    public byte[] encodeHeader(byte type, int additionalLength) throws UnsupportedEncodingException {
        byte[] versionByte = Short.toString(this.protocolVersion).getBytes("UTF-8");
        int length = 1 + versionByte.length + 1 + additionalLength;
        byte[] encodedMsg = new byte[length];
        encodedMsg[0] = type;
        int pos = 1;
        this.headerLength = this.addByteArray(versionByte, encodedMsg, pos);
        return encodedMsg;
    }

    public int decodeHeader(byte type, byte[] encodedMsg) throws DataFormatException {
        if (encodedMsg[0] != type) {
            throw new DataFormatException("byte[] is not a valid msg");
        }
        try {
            int pos = 1;
            int length = this.getNextLength(encodedMsg, pos);
            this.protocolVersion = Short.valueOf(new String(encodedMsg, pos, length, "UTF-8"));
            return pos += length + 1;
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    public short getVersion() {
        return this.protocolVersion;
    }
}

