/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import com.sleepycat.je.DatabaseException;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ReplicationMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.admin.std.server.ReplicationServerCfg;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.replication.protocol.SocketSession;
import org.opends.server.replication.server.DbHandler;
import org.opends.server.replication.server.ReplicationCache;
import org.opends.server.replication.server.ReplicationDBException;
import org.opends.server.replication.server.ReplicationDbEnv;
import org.opends.server.replication.server.ReplicationServerConnectThread;
import org.opends.server.replication.server.ReplicationServerListenThread;
import org.opends.server.replication.server.ServerHandler;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationServer
extends MonitorProvider<MonitorProviderCfg>
implements Runnable,
ConfigurationChangeListener<ReplicationServerCfg> {
    private short serverId;
    private String serverURL;
    private ServerSocket listenSocket;
    private Thread listenThread;
    private Thread connectThread;
    private Collection<String> replicationServers;
    private HashMap<DN, ReplicationCache> baseDNs = new HashMap();
    private String localURL = "null";
    private boolean shutdown = false;
    private short replicationServerId;
    private ReplicationDbEnv dbEnv;
    private int rcvWindow;
    private int queueSize;
    private String dbDirname = null;
    private long trimAge;
    private int replicationPort;
    private boolean stopListen = false;

    public ReplicationServer(ReplicationServerCfg configuration) throws ConfigException {
        super("Replication Server" + configuration.getReplicationPort());
        this.replicationPort = configuration.getReplicationPort();
        this.replicationServerId = (short)configuration.getReplicationServerId();
        this.replicationServers = configuration.getReplicationServer();
        if (this.replicationServers == null) {
            this.replicationServers = new ArrayList<String>();
        }
        this.queueSize = configuration.getQueueSize();
        this.trimAge = configuration.getReplicationPurgeDelay();
        this.dbDirname = configuration.getReplicationDbDirectory();
        this.rcvWindow = configuration.getWindowSize();
        if (this.dbDirname == null) {
            this.dbDirname = "changelogDb";
        }
        File f = StaticUtils.getFileForPath(this.dbDirname);
        try {
            if (!f.exists()) {
                f.mkdir();
            }
        }
        catch (Exception e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(e.getLocalizedMessage());
            mb.append(" ");
            mb.append(String.valueOf(StaticUtils.getFileForPath(this.dbDirname)));
            Message msg = ReplicationMessages.ERR_FILE_CHECK_CREATE_FAILED.get(mb.toString());
            throw new ConfigException(msg, (Throwable)e);
        }
        this.initialize(this.replicationServerId, this.replicationPort);
        configuration.addChangeListener(this);
        DirectoryServer.registerMonitorProvider(this);
    }

    void runListen() {
        Socket newSocket = null;
        while (!this.shutdown && !this.stopListen) {
            try {
                newSocket = this.listenSocket.accept();
                newSocket.setReceiveBufferSize(1000000);
                newSocket.setTcpNoDelay(true);
                newSocket.setKeepAlive(true);
                ServerHandler handler = new ServerHandler(new SocketSession(newSocket), this.queueSize);
                handler.start(null, this.serverId, this.serverURL, this.rcvWindow, this);
            }
            catch (IOException e) {
                Message message = ReplicationMessages.DEBUG_REPLICATION_PORT_IOEXCEPTION.get();
                ErrorLogger.logError(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runConnect() {
        while (!this.shutdown) {
            for (ReplicationCache replicationCache : this.baseDNs.values()) {
                Set<String> connectedReplServers = replicationCache.getChangelogs();
                for (String serverURL : this.replicationServers) {
                    int separator = serverURL.lastIndexOf(58);
                    String port = serverURL.substring(separator + 1);
                    String hostname = serverURL.substring(0, separator);
                    try {
                        InetAddress inetAddress = InetAddress.getByName(hostname);
                        String serverAddress = inetAddress.getHostAddress() + ":" + port;
                        if (serverAddress.compareTo("127.0.0.1:" + this.replicationPort) == 0 || serverAddress.compareTo(this.localURL) == 0 || connectedReplServers.contains(serverAddress)) continue;
                        this.connect(serverURL, replicationCache.getBaseDn());
                    }
                    catch (IOException e) {
                        Message message = ReplicationMessages.ERR_COULD_NOT_SOLVE_HOSTNAME.get(hostname);
                        ErrorLogger.logError(message);
                    }
                }
            }
            try {
                ReplicationServer i$ = this;
                synchronized (i$) {
                    int randomizer = (int)Math.random() * 100;
                    this.wait(1000 + randomizer);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private void connect(String serverURL, DN baseDn) {
        int separator = serverURL.lastIndexOf(58);
        String port = serverURL.substring(separator + 1);
        String hostname = serverURL.substring(0, separator);
        try {
            InetSocketAddress ServerAddr = new InetSocketAddress(InetAddress.getByName(hostname), Integer.parseInt(port));
            Socket socket = new Socket();
            socket.setReceiveBufferSize(1000000);
            socket.setTcpNoDelay(true);
            socket.connect(ServerAddr, 500);
            ServerHandler handler = new ServerHandler(new SocketSession(socket), this.queueSize);
            handler.start(baseDn, this.serverId, this.serverURL, this.rcvWindow, this);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void initialize(short changelogId, int changelogPort) {
        try {
            this.dbEnv = new ReplicationDbEnv(StaticUtils.getFileForPath(this.dbDirname).getAbsolutePath(), this);
            this.serverId = changelogId;
            String localhostname = InetAddress.getLocalHost().getHostName();
            String localAdddress = InetAddress.getLocalHost().getHostAddress();
            this.serverURL = localhostname + ":" + String.valueOf(changelogPort);
            this.localURL = localAdddress + ":" + String.valueOf(changelogPort);
            this.listenSocket = new ServerSocket();
            this.listenSocket.setReceiveBufferSize(1000000);
            this.listenSocket.bind(new InetSocketAddress(changelogPort));
            this.listenThread = new ReplicationServerListenThread("Replication Server Listener", this);
            this.listenThread.start();
            this.connectThread = new ReplicationServerConnectThread("Replication Server Connect", this);
            this.connectThread.start();
        }
        catch (DatabaseException e) {
            Message message = ReplicationMessages.ERR_COULD_NOT_INITIALIZE_DB.get(this.dbDirname);
            ErrorLogger.logError(message);
        }
        catch (ReplicationDBException e) {
            Message message = ReplicationMessages.ERR_COULD_NOT_READ_DB.get(this.dbDirname);
            ErrorLogger.logError(message);
        }
        catch (UnknownHostException e) {
            Message message = ReplicationMessages.ERR_UNKNOWN_HOSTNAME.get();
            ErrorLogger.logError(message);
        }
        catch (IOException e) {
            Message message = ReplicationMessages.ERR_COULD_NOT_BIND_CHANGELOG.get(changelogPort, e.getMessage());
            ErrorLogger.logError(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplicationCache getReplicationCache(DN baseDn) {
        ReplicationCache replicationCache;
        HashMap<DN, ReplicationCache> hashMap = this.baseDNs;
        synchronized (hashMap) {
            replicationCache = this.baseDNs.get(baseDn);
            if (replicationCache == null) {
                replicationCache = new ReplicationCache(baseDn, this);
            }
            this.baseDNs.put(baseDn, replicationCache);
        }
        return replicationCache;
    }

    public void shutdown() {
        this.shutdown = true;
        if (this.connectThread != null) {
            this.connectThread.interrupt();
        }
        try {
            if (this.listenSocket != null) {
                this.listenSocket.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        for (ReplicationCache replicationCache : this.baseDNs.values()) {
            replicationCache.shutdown();
        }
        if (this.dbEnv != null) {
            this.dbEnv.shutdown();
        }
        DirectoryServer.deregisterMonitorProvider(this.getMonitorInstanceName());
    }

    DbHandler newDbHandler(short id, DN baseDn) throws DatabaseException {
        return new DbHandler(id, baseDn, this, this.dbEnv);
    }

    long getTrimage() {
        return this.trimAge * 1000L;
    }

    public static boolean isConfigurationAcceptable(ReplicationServerCfg configuration, List<Message> unacceptableReasons) {
        int port = configuration.getReplicationPort();
        try {
            ServerSocket tmpSocket = new ServerSocket();
            tmpSocket.bind(new InetSocketAddress(port));
            tmpSocket.close();
        }
        catch (Exception e) {
            Message message = ReplicationMessages.ERR_COULD_NOT_BIND_CHANGELOG.get(port, e.getMessage());
            unacceptableReasons.add(message);
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(ReplicationServerCfg configuration) {
        this.replicationServers = configuration.getReplicationServer();
        if (this.replicationServers == null) {
            this.replicationServers = new ArrayList<String>();
        }
        this.queueSize = configuration.getQueueSize();
        this.trimAge = configuration.getReplicationPurgeDelay();
        this.rcvWindow = configuration.getWindowSize();
        int newPort = configuration.getReplicationPort();
        if (newPort != this.replicationPort) {
            this.stopListen = true;
            try {
                this.listenSocket.close();
                this.listenThread.join();
                this.stopListen = false;
                this.replicationPort = newPort;
                String localhostname = InetAddress.getLocalHost().getHostName();
                String localAdddress = InetAddress.getLocalHost().getHostAddress();
                this.serverURL = localhostname + ":" + String.valueOf(this.replicationPort);
                this.localURL = localAdddress + ":" + String.valueOf(this.replicationPort);
                this.listenSocket = new ServerSocket();
                this.listenSocket.setReceiveBufferSize(1000000);
                this.listenSocket.bind(new InetSocketAddress(this.replicationPort));
                this.listenThread = new ReplicationServerListenThread("Replication Server Listener", this);
                this.listenThread.start();
            }
            catch (IOException e) {
                Message message = ReplicationMessages.ERR_COULD_NOT_CLOSE_THE_SOCKET.get(e.toString());
                ErrorLogger.logError(message);
                new ConfigChangeResult(ResultCode.OPERATIONS_ERROR, false);
            }
            catch (InterruptedException e) {
                Message message = ReplicationMessages.ERR_COULD_NOT_STOP_LISTEN_THREAD.get(e.toString());
                ErrorLogger.logError(message);
                new ConfigChangeResult(ResultCode.OPERATIONS_ERROR, false);
            }
        }
        if (configuration.getReplicationDbDirectory() != null && this.dbDirname != configuration.getReplicationDbDirectory()) {
            return new ConfigChangeResult(ResultCode.SUCCESS, true);
        }
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(ReplicationServerCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public void initializeMonitorProvider(MonitorProviderCfg configuraiton) {
    }

    @Override
    public String getMonitorInstanceName() {
        return "Replication Server " + this.replicationPort + " " + this.replicationServerId;
    }

    @Override
    public long getUpdateInterval() {
        return 0L;
    }

    @Override
    public void updateMonitorData() {
    }

    public ArrayList<Attribute> getMonitorData() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute("replication server id", String.valueOf(this.serverId)));
        attributes.add(new Attribute("replication server port", String.valueOf(this.replicationPort)));
        AttributeType baseType = DirectoryServer.getAttributeType("base-dn", true);
        LinkedHashSet<AttributeValue> baseValues = new LinkedHashSet<AttributeValue>();
        for (DN base : this.baseDNs.keySet()) {
            baseValues.add(new AttributeValue(baseType, base.toString()));
        }
        Attribute bases = new Attribute(baseType, "base-dn", baseValues);
        attributes.add(bases);
        return attributes;
    }
}

