/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import java.io.IOException;
import java.net.SocketException;
import java.util.NoSuchElementException;
import org.opends.messages.Message;
import org.opends.messages.ReplicationMessages;
import org.opends.server.api.DirectoryThread;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.protocol.ProtocolSession;
import org.opends.server.replication.protocol.UpdateMessage;
import org.opends.server.replication.server.ReplicationCache;
import org.opends.server.replication.server.ServerHandler;

public class ServerWriter
extends DirectoryThread {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ProtocolSession session;
    private ServerHandler handler;
    private ReplicationCache replicationCache;
    private short serverId;

    public ServerWriter(ProtocolSession session, short serverId, ServerHandler handler, ReplicationCache replicationCache) {
        super(handler.toString() + " writer");
        this.serverId = serverId;
        this.session = session;
        this.handler = handler;
        this.replicationCache = replicationCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (DebugLogger.debugEnabled()) {
            if (this.handler.isReplicationServer()) {
                TRACER.debugInfo("Replication server writer starting " + this.serverId);
            } else {
                TRACER.debugInfo("LDAP server writer starting " + this.serverId);
            }
        }
        try {
            while (true) {
                UpdateMessage update;
                if ((update = this.replicationCache.take(this.handler)) == null) {
                    return;
                }
                this.session.publish(update);
                continue;
                break;
            }
        }
        catch (NoSuchElementException e) {
            Message message = ReplicationMessages.NOTE_SERVER_DISCONNECT.get(this.handler.toString());
            ErrorLogger.logError(message);
            return;
        }
        catch (SocketException e) {
            Message message = ReplicationMessages.NOTE_SERVER_DISCONNECT.get(this.handler.toString());
            ErrorLogger.logError(message);
            return;
        }
        catch (Exception e) {
            Message message = ReplicationMessages.ERR_WRITER_UNEXPECTED_EXCEPTION.get(this.handler.toString());
            ErrorLogger.logError(message);
            return;
        }
        finally {
            try {
                this.session.close();
            }
            catch (IOException e) {}
            this.replicationCache.stopServer(this.handler);
            if (DebugLogger.debugEnabled()) {
                if (this.handler.isReplicationServer()) {
                    TRACER.debugInfo("Replication server writer stopping " + this.serverId);
                } else {
                    TRACER.debugInfo("LDAP server writer stopping " + this.serverId);
                }
            }
        }
    }
}

