/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Arrays;
import org.opends.messages.Message;
import org.opends.messages.SchemaMessages;
import org.opends.server.admin.std.server.EqualityMatchingRuleCfg;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;

public class BooleanEqualityMatchingRule
extends EqualityMatchingRule {
    public void initializeMatchingRule(EqualityMatchingRuleCfg configuration) throws ConfigException, InitializationException {
    }

    public String getName() {
        return "booleanMatch";
    }

    public String getOID() {
        return "2.5.13.13";
    }

    public String getDescription() {
        return null;
    }

    public String getSyntaxOID() {
        return "1.3.6.1.4.1.1466.115.121.1.7";
    }

    public ByteString normalizeValue(ByteString value) throws DirectoryException {
        String valueString = value.stringValue().toUpperCase();
        if (valueString.equals("TRUE") || valueString.equals("YES") || valueString.equals("ON") || valueString.equals("1")) {
            return new ASN1OctetString("TRUE");
        }
        if (valueString.equals("FALSE") || valueString.equals("NO") || valueString.equals("OFF") || valueString.equals("0")) {
            return new ASN1OctetString("FALSE");
        }
        Message message = SchemaMessages.WARN_ATTR_SYNTAX_ILLEGAL_BOOLEAN.get(value.stringValue());
        switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
            case REJECT: {
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
            case WARN: {
                ErrorLogger.logError(message);
                return new ASN1OctetString(valueString);
            }
        }
        return new ASN1OctetString(valueString);
    }

    public boolean areEqual(ByteString value1, ByteString value2) {
        return Arrays.equals(value1.value(), value2.value());
    }
}

