/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Arrays;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.SchemaMessages;
import org.opends.server.admin.std.server.EqualityMatchingRuleCfg;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.MatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.NameForm;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class ObjectIdentifierEqualityMatchingRule
extends EqualityMatchingRule {
    public void initializeMatchingRule(EqualityMatchingRuleCfg configuration) throws ConfigException, InitializationException {
    }

    public String getName() {
        return "objectIdentifierMatch";
    }

    public String getOID() {
        return "2.5.13.0";
    }

    public String getDescription() {
        return null;
    }

    public String getSyntaxOID() {
        return "1.3.6.1.4.1.1466.115.121.1.38";
    }

    public ByteString normalizeValue(ByteString value) throws DirectoryException {
        NameForm nameForm;
        MatchingRule matchingRule;
        ObjectClass objectClass;
        StringBuilder buffer = new StringBuilder();
        StaticUtils.toLowerCase(value.value(), buffer, true);
        String lowerValue = buffer.toString();
        String schemaName = null;
        AttributeType attributeType = DirectoryServer.getAttributeType(lowerValue);
        if (attributeType != null) {
            schemaName = attributeType.getNameOrOID();
        }
        if (schemaName == null && (objectClass = DirectoryServer.getObjectClass(lowerValue)) != null) {
            schemaName = objectClass.getNameOrOID();
        }
        if (schemaName == null && (matchingRule = DirectoryServer.getMatchingRule(lowerValue)) != null) {
            schemaName = matchingRule.getNameOrOID();
        }
        if (schemaName == null && (nameForm = DirectoryServer.getNameForm(lowerValue)) != null) {
            schemaName = nameForm.getNameOrOID();
        }
        if (schemaName != null) {
            return new ASN1OctetString(StaticUtils.toLowerCase(schemaName));
        }
        switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
            case REJECT: {
                MessageBuilder invalidReason = new MessageBuilder();
                if (StaticUtils.isValidSchemaElement(lowerValue, 0, lowerValue.length(), invalidReason)) {
                    return new ASN1OctetString(lowerValue);
                }
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_OID_INVALID_VALUE.get(lowerValue, invalidReason.toString());
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
            case WARN: {
                MessageBuilder invalidReason = new MessageBuilder();
                if (!StaticUtils.isValidSchemaElement(lowerValue, 0, lowerValue.length(), invalidReason)) {
                    Message message = SchemaMessages.ERR_ATTR_SYNTAX_OID_INVALID_VALUE.get(lowerValue, invalidReason.toString());
                    ErrorLogger.logError(message);
                }
                return new ASN1OctetString(lowerValue);
            }
        }
        return new ASN1OctetString(lowerValue);
    }

    public boolean areEqual(ByteString value1, ByteString value2) {
        return Arrays.equals(value1.value(), value2.value());
    }
}

