/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.FilePermission;
import org.opends.server.types.NullOutputStream;
import org.opends.server.types.OperatingSystem;
import org.opends.server.util.EmbeddedUtils;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;

public class CreateRCScript {
    public static void main(String[] args) {
        int exitCode = CreateRCScript.main(args, System.out, System.err);
        if (exitCode != 0) {
            System.exit(exitCode);
        }
    }

    public static int main(String[] args, OutputStream outStream, OutputStream errStream) {
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        EmbeddedUtils.initializeForClientUse();
        OperatingSystem operatingSystem = DirectoryServer.getOperatingSystem();
        if (!OperatingSystem.isUNIXBased(operatingSystem)) {
            err.println(ToolMessages.ERR_CREATERC_ONLY_RUNS_ON_UNIX.get().toString());
            return 1;
        }
        File serverRoot = DirectoryServer.getEnvironmentConfig().getServerRoot();
        if (serverRoot == null) {
            err.println(ToolMessages.ERR_CREATERC_UNABLE_TO_DETERMINE_SERVER_ROOT.get("org.opends.server.ServerRoot", "INSTANCE_ROOT").toString());
            return 1;
        }
        Message description = ToolMessages.INFO_CREATERC_TOOL_DESCRIPTION.get();
        ArgumentParser argParser = new ArgumentParser(CreateRCScript.class.getName(), description, false);
        BooleanArgument showUsage = null;
        StringArgument outputFile = null;
        try {
            outputFile = new StringArgument("outputfile", Character.valueOf('f'), "outputFile", true, false, true, "{path}", null, null, ToolMessages.INFO_CREATERC_OUTFILE_DESCRIPTION.get());
            argParser.addArgument(outputFile);
            showUsage = new BooleanArgument("help", Character.valueOf('H'), "help", ToolMessages.INFO_DESCRIPTION_SHOWUSAGE.get());
            argParser.addArgument(showUsage);
            argParser.setUsageArgument(showUsage);
        }
        catch (ArgumentException ae) {
            err.println(ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage()));
            return 1;
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            err.println(ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage()).toString());
            return 1;
        }
        if (showUsage.isPresent()) {
            return 0;
        }
        String javaHomeDir = System.getenv("JAVA_HOME");
        if (javaHomeDir == null) {
            javaHomeDir = System.getProperty("java.home");
        }
        try {
            File f = new File(outputFile.getValue());
            PrintWriter w = new PrintWriter(f);
            w.println("#!/bin/sh");
            w.println("#");
            for (String headerLine : ServerConstants.CDDL_HEADER_LINES) {
                w.println("# " + headerLine);
            }
            w.println();
            w.println();
            w.println("# Set the path to the OpenDS instance to manage");
            w.println("INSTANCE_ROOT=" + serverRoot.getAbsolutePath());
            w.println("export INSTANCE_ROOT");
            w.println();
            w.println("# Specify the path to the Java installation to use");
            w.println("JAVA_HOME=" + javaHomeDir);
            w.println("export JAVA_HOME");
            w.println();
            w.println("# Determine what action should be performed on the server");
            w.println("case \"${1}\" in");
            w.println("start)");
            w.println("  ${INSTANCE_ROOT}/bin/start-ds");
            w.println("  exit ${?}");
            w.println("  ;;");
            w.println("stop)");
            w.println("  ${INSTANCE_ROOT}/bin/stop-ds");
            w.println("  exit ${?}");
            w.println("  ;;");
            w.println("restart)");
            w.println("  ${INSTANCE_ROOT}/bin/stop-ds --restart");
            w.println("  exit ${?}");
            w.println("  ;;");
            w.println("*)");
            w.println("  echo \"Usage:  $0 { start | stop | restart }\"");
            w.println("  exit 1");
            w.println("  ;;");
            w.println("esac");
            w.println();
            w.close();
            if (FilePermission.canSetPermissions()) {
                FilePermission.setPermissions(f, FilePermission.decodeUNIXMode("755"));
            }
        }
        catch (Exception e) {
            err.println(ToolMessages.ERR_CREATERC_CANNOT_WRITE.get(StaticUtils.getExceptionMessage(e)).toString());
            return 1;
        }
        return 0;
    }
}

