/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.tools.ConfigureDS;
import org.opends.server.tools.ConfigureWindowsService;
import org.opends.server.tools.ImportLDIF;
import org.opends.server.tools.ToolConstants;
import org.opends.server.types.DN;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.PasswordReader;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.SetupUtils;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;

public class InstallDS {
    private static final String CLASS_NAME = "org.opends.server.tools.InstallDS";
    private static final boolean isWindows = SetupUtils.isWindows();
    private static String versionString;
    private static String programName;
    private static final int POPULATE_TYPE_BASE_ONLY = 1;
    private static final int POPULATE_TYPE_LEAVE_EMPTY = 2;
    private static final int POPULATE_TYPE_IMPORT_FROM_LDIF = 3;
    private static final int POPULATE_TYPE_GENERATE_SAMPLE_DATA = 4;

    public static void main(String[] args) {
        int exitCode = InstallDS.installMain(args);
        if (exitCode != 0) {
            System.exit(StaticUtils.filterExitCode(exitCode));
        }
    }

    public static int installMain(String[] args) {
        Message message;
        int returnValue;
        LinkedList<String> ldifFiles;
        int numUsers;
        int populateType;
        LinkedList<DN> baseDNs;
        String rootPassword;
        LinkedList<DN> rootDNs;
        int jmxPortNumber;
        int ldapPortNumber;
        String configClassName;
        String configFileName;
        BooleanArgument enableWindowsService;
        BooleanArgument quietInstall;
        block114: {
            Message message2;
            FileBasedArgument rootPWFile;
            StringArgument rootPWString;
            StringArgument rootDN;
            IntegerArgument sampleData;
            StringArgument importLDIF;
            BooleanArgument addBaseEntry;
            StringArgument baseDN;
            block113: {
                BooleanArgument skipPortCheck;
                IntegerArgument jmxPort;
                block112: {
                    Message message3;
                    IntegerArgument ldapPort;
                    StringArgument configClass;
                    StringArgument configFile;
                    BooleanArgument testOnly;
                    versionString = DirectoryServer.getVersionString();
                    programName = isWindows ? "setup.bat" : "setup";
                    Message toolDescription = ToolMessages.INFO_INSTALLDS_TOOL_DESCRIPTION.get();
                    ArgumentParser argParser = new ArgumentParser(CLASS_NAME, toolDescription, false);
                    try {
                        testOnly = new BooleanArgument("test", Character.valueOf('t'), "testOnly", ToolMessages.INFO_INSTALLDS_DESCRIPTION_TESTONLY.get());
                        testOnly.setHidden(true);
                        argParser.addArgument(testOnly);
                        StringArgument progName = new StringArgument("progname", Character.valueOf('P'), "programName", false, false, true, "{programName}", programName, null, ToolMessages.INFO_INSTALLDS_DESCRIPTION_PROGNAME.get());
                        progName.setHidden(true);
                        argParser.addArgument(progName);
                        configFile = new StringArgument("configfile", Character.valueOf('c'), "configFile", false, false, true, "{configFile}", null, null, ToolMessages.INFO_DESCRIPTION_CONFIG_FILE.get());
                        configFile.setHidden(true);
                        argParser.addArgument(configFile);
                        configClass = new StringArgument("configclass", Character.valueOf('C'), "configClass", false, false, true, "{configClass}", ConfigFileHandler.class.getName(), null, ToolMessages.INFO_DESCRIPTION_CONFIG_CLASS.get());
                        configClass.setHidden(true);
                        argParser.addArgument(configClass);
                        BooleanArgument cliMode = new BooleanArgument("cli", null, "cli", ToolMessages.INFO_INSTALLDS_DESCRIPTION_CLI.get());
                        argParser.addArgument(cliMode);
                        quietInstall = new BooleanArgument("quiet", ToolConstants.OPTION_SHORT_QUIET, "quiet", ToolMessages.INFO_INSTALLDS_DESCRIPTION_SILENT.get());
                        argParser.addArgument(quietInstall);
                        baseDN = new StringArgument("basedn", Character.valueOf('b'), "baseDN", false, true, true, "{baseDN}", "dc=example,dc=com", null, ToolMessages.INFO_INSTALLDS_DESCRIPTION_BASEDN.get());
                        argParser.addArgument(baseDN);
                        addBaseEntry = new BooleanArgument("addbase", Character.valueOf('a'), "addBaseEntry", ToolMessages.INFO_INSTALLDS_DESCRIPTION_ADDBASE.get());
                        argParser.addArgument(addBaseEntry);
                        importLDIF = new StringArgument("importldif", Character.valueOf('l'), "ldifFile", false, true, true, "{ldifFile}", null, null, ToolMessages.INFO_INSTALLDS_DESCRIPTION_IMPORTLDIF.get());
                        argParser.addArgument(importLDIF);
                        sampleData = new IntegerArgument("sampledata", Character.valueOf('d'), "sampleData", false, false, true, "{numEntries}", 0, null, true, 0, false, 0, ToolMessages.INFO_INSTALLDS_DESCRIPTION_SAMPLE_DATA.get());
                        argParser.addArgument(sampleData);
                        ldapPort = new IntegerArgument("ldapport", Character.valueOf('p'), "ldapPort", false, false, true, "{port}", 389, null, true, 1, true, 65535, ToolMessages.INFO_INSTALLDS_DESCRIPTION_LDAPPORT.get());
                        argParser.addArgument(ldapPort);
                        jmxPort = new IntegerArgument("jmxport", Character.valueOf('x'), "jmxPort", false, false, true, "{jmxPort}", SetupUtils.getDefaultJMXPort(), null, true, 1, true, 65535, ToolMessages.INFO_INSTALLDS_DESCRIPTION_JMXPORT.get());
                        argParser.addArgument(jmxPort);
                        skipPortCheck = new BooleanArgument("skipportcheck", Character.valueOf('S'), "skipPortCheck", ToolMessages.INFO_INSTALLDS_DESCRIPTION_SKIPPORT.get());
                        argParser.addArgument(skipPortCheck);
                        rootDN = new StringArgument("rootdn", Character.valueOf('D'), "rootUserDN", false, true, true, "{rootUserDN}", "cn=Directory Manager", null, ToolMessages.INFO_INSTALLDS_DESCRIPTION_ROOTDN.get());
                        argParser.addArgument(rootDN);
                        rootPWString = new StringArgument("rootpwstring", Character.valueOf('w'), "rootUserPassword", false, false, true, "{password}", null, null, ToolMessages.INFO_INSTALLDS_DESCRIPTION_ROOTPW.get());
                        argParser.addArgument(rootPWString);
                        rootPWFile = new FileBasedArgument("rootpwfile", Character.valueOf('j'), "rootUserPasswordFile", false, false, "{bindPasswordFile}", null, null, ToolMessages.INFO_INSTALLDS_DESCRIPTION_ROOTPWFILE.get());
                        argParser.addArgument(rootPWFile);
                        enableWindowsService = new BooleanArgument("enablewindowsservice", Character.valueOf('e'), "enableWindowsService", ToolMessages.INFO_INSTALLDS_DESCRIPTION_ENABLE_WINDOWS_SERVICE.get());
                        if (SetupUtils.isWindows()) {
                            argParser.addArgument(enableWindowsService);
                        }
                        BooleanArgument showUsage = new BooleanArgument("help", Character.valueOf('H'), "help", ToolMessages.INFO_INSTALLDS_DESCRIPTION_HELP.get());
                        argParser.addArgument(showUsage);
                        argParser.setUsageArgument(showUsage);
                    }
                    catch (ArgumentException ae) {
                        System.err.println(StaticUtils.wrapText(ae.getMessage(), ServerConstants.MAX_LINE_WIDTH));
                        System.err.println(argParser.getUsage());
                        return 1;
                    }
                    try {
                        argParser.parseArguments(args);
                    }
                    catch (ArgumentException ae) {
                        System.err.println(StaticUtils.wrapText(ae.getMessage(), ServerConstants.MAX_LINE_WIDTH));
                        System.err.println(argParser.getUsage());
                        return 1;
                    }
                    if (argParser.usageOrVersionDisplayed() || testOnly.isPresent()) {
                        return 0;
                    }
                    try {
                        HashSet<Integer> ports = new HashSet<Integer>();
                        if (ldapPort.isPresent()) {
                            ports.add(ldapPort.getIntValue());
                        }
                        if (jmxPort.isPresent()) {
                            if (ports.contains(jmxPort.getIntValue())) {
                                Message message4 = ToolMessages.ERR_CONFIGDS_PORT_ALREADY_SPECIFIED.get(String.valueOf(jmxPort.getIntValue()));
                                System.err.println(StaticUtils.wrapText(message4, ServerConstants.MAX_LINE_WIDTH));
                                System.err.println(argParser.getUsage());
                                return 1;
                            }
                            ports.add(jmxPort.getIntValue());
                        }
                    }
                    catch (ArgumentException ae) {
                        Message message5 = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
                        System.err.println(StaticUtils.wrapText(message5, ServerConstants.MAX_LINE_WIDTH));
                        return 1;
                    }
                    if (addBaseEntry.isPresent()) {
                        if (importLDIF.isPresent()) {
                            message3 = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(addBaseEntry.getLongIdentifier(), importLDIF.getLongIdentifier());
                            System.err.println(StaticUtils.wrapText(message3, ServerConstants.MAX_LINE_WIDTH));
                            return 1;
                        }
                        if (sampleData.isPresent()) {
                            message3 = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(addBaseEntry.getLongIdentifier(), sampleData.getLongIdentifier());
                            System.err.println(StaticUtils.wrapText(message3, ServerConstants.MAX_LINE_WIDTH));
                            return 1;
                        }
                    } else if (importLDIF.isPresent() && sampleData.isPresent()) {
                        message3 = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(importLDIF.getLongIdentifier(), sampleData.getLongIdentifier());
                        System.err.println(StaticUtils.wrapText(message3, ServerConstants.MAX_LINE_WIDTH));
                        return 1;
                    }
                    if (!configFile.isPresent()) {
                        Message message6 = ToolMessages.ERR_INSTALLDS_NO_CONFIG_FILE.get(configFile.getLongIdentifier());
                        System.err.println(StaticUtils.wrapText(message6, ServerConstants.MAX_LINE_WIDTH));
                        return 1;
                    }
                    configFileName = configFile.getValue();
                    configClassName = configClass.getValue();
                    if (!quietInstall.isPresent()) {
                        System.out.println(versionString);
                        System.out.println();
                        Message message7 = ToolMessages.INFO_INSTALLDS_INITIALIZING.get();
                        System.out.println(StaticUtils.wrapText(message7, ServerConstants.MAX_LINE_WIDTH));
                    }
                    DirectoryServer directoryServer = DirectoryServer.getInstance();
                    directoryServer.bootstrapClient();
                    try {
                        directoryServer.initializeJMX();
                    }
                    catch (Exception e) {
                        Message message8 = ToolMessages.ERR_INSTALLDS_CANNOT_INITIALIZE_JMX.get(String.valueOf(configFile.getValue()), e.getMessage());
                        System.err.println(StaticUtils.wrapText(message8, ServerConstants.MAX_LINE_WIDTH));
                        return 1;
                    }
                    try {
                        directoryServer.initializeConfiguration(configClass.getValue(), configFile.getValue());
                    }
                    catch (Exception e) {
                        Message message9 = ToolMessages.ERR_INSTALLDS_CANNOT_INITIALIZE_CONFIG.get(String.valueOf(configFile.getValue()), e.getMessage());
                        System.err.println(StaticUtils.wrapText(message9, ServerConstants.MAX_LINE_WIDTH));
                        return 1;
                    }
                    try {
                        directoryServer.initializeSchema();
                    }
                    catch (Exception e) {
                        Message message10 = ToolMessages.ERR_INSTALLDS_CANNOT_INITIALIZE_SCHEMA.get(String.valueOf(configFile.getValue()), e.getMessage());
                        System.err.println(StaticUtils.wrapText(message10, ServerConstants.MAX_LINE_WIDTH));
                        return 1;
                    }
                    if (quietInstall.isPresent() || ldapPort.isPresent()) {
                        try {
                            ldapPortNumber = ldapPort.getIntValue();
                            if (!skipPortCheck.isPresent() && !SetupUtils.canUseAsPort(ldapPortNumber)) {
                                if (SetupUtils.isPriviledgedPort(ldapPortNumber)) {
                                    Message message11 = ToolMessages.ERR_INSTALLDS_CANNOT_BIND_TO_PRIVILEGED_PORT.get(ldapPortNumber);
                                    System.err.println(StaticUtils.wrapText(message11, ServerConstants.MAX_LINE_WIDTH));
                                } else {
                                    Message message12 = ToolMessages.ERR_INSTALLDS_CANNOT_BIND_TO_PORT.get(ldapPortNumber);
                                    System.err.println(StaticUtils.wrapText(message12, ServerConstants.MAX_LINE_WIDTH));
                                }
                                return 1;
                            }
                            break block112;
                        }
                        catch (ArgumentException ae) {
                            System.err.println(StaticUtils.wrapText(ae.getMessage(), ServerConstants.MAX_LINE_WIDTH));
                            return 1;
                        }
                    }
                    while (true) {
                        Message message13 = ToolMessages.INFO_INSTALLDS_PROMPT_LDAPPORT.get();
                        ldapPortNumber = InstallDS.promptForInteger(message13, 389, 1, 65535);
                        if (skipPortCheck.isPresent() || SetupUtils.canUseAsPort(ldapPortNumber)) break;
                        if (SetupUtils.isPriviledgedPort(ldapPortNumber)) {
                            message13 = ToolMessages.ERR_INSTALLDS_CANNOT_BIND_TO_PRIVILEGED_PORT.get(ldapPortNumber);
                            System.err.println(StaticUtils.wrapText(message13, ServerConstants.MAX_LINE_WIDTH));
                            continue;
                        }
                        message13 = ToolMessages.ERR_INSTALLDS_CANNOT_BIND_TO_PORT.get(ldapPortNumber);
                        System.err.println(StaticUtils.wrapText(message13, ServerConstants.MAX_LINE_WIDTH));
                    }
                }
                if (quietInstall.isPresent() || jmxPort.isPresent()) {
                    try {
                        jmxPortNumber = jmxPort.getIntValue();
                        if (!skipPortCheck.isPresent() && !SetupUtils.canUseAsPort(jmxPortNumber)) {
                            if (SetupUtils.isPriviledgedPort(jmxPortNumber)) {
                                Message message14 = ToolMessages.ERR_INSTALLDS_CANNOT_BIND_TO_PRIVILEGED_PORT.get(jmxPortNumber);
                                System.err.println(StaticUtils.wrapText(message14, ServerConstants.MAX_LINE_WIDTH));
                            } else {
                                Message message15 = ToolMessages.ERR_INSTALLDS_CANNOT_BIND_TO_PORT.get(jmxPortNumber);
                                System.err.println(StaticUtils.wrapText(message15, ServerConstants.MAX_LINE_WIDTH));
                            }
                            return 1;
                        }
                        break block113;
                    }
                    catch (ArgumentException ae) {
                        System.err.println(StaticUtils.wrapText(ae.getMessage(), ServerConstants.MAX_LINE_WIDTH));
                        return 1;
                    }
                }
                jmxPortNumber = -1;
            }
            if (rootDN.isPresent()) {
                rootDNs = new LinkedList<DN>();
                for (String s : rootDN.getValues()) {
                    try {
                        rootDNs.add(DN.decode(s));
                    }
                    catch (Exception e) {
                        Message message16 = ToolMessages.ERR_INSTALLDS_CANNOT_PARSE_DN.get(s, e.getMessage());
                        System.err.println(StaticUtils.wrapText(message16, ServerConstants.MAX_LINE_WIDTH));
                        return 1;
                    }
                }
            } else if (quietInstall.isPresent()) {
                rootDNs = new LinkedList();
                try {
                    rootDNs.add(DN.decode(rootDN.getDefaultValue()));
                }
                catch (Exception e) {
                    Message message17 = ToolMessages.ERR_INSTALLDS_CANNOT_PARSE_DN.get(rootDN.getDefaultValue(), e.getMessage());
                    System.err.println(StaticUtils.wrapText(message17, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
            } else {
                Message message18 = ToolMessages.INFO_INSTALLDS_PROMPT_ROOT_DN.get();
                rootDNs = new LinkedList();
                rootDNs.add(InstallDS.promptForDN(message18, rootDN.getDefaultValue()));
            }
            if (rootPWString.isPresent()) {
                rootPassword = rootPWString.getValue();
                if (rootPWFile.isPresent()) {
                    message2 = ToolMessages.ERR_INSTALLDS_TWO_CONFLICTING_ARGUMENTS.get(rootPWString.getLongIdentifier(), rootPWFile.getLongIdentifier());
                    System.err.println(StaticUtils.wrapText(message2, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
            } else if (rootPWFile.isPresent()) {
                rootPassword = rootPWFile.getValue();
            } else {
                if (quietInstall.isPresent()) {
                    message2 = ToolMessages.ERR_INSTALLDS_NO_ROOT_PASSWORD.get(rootPWString.getLongIdentifier(), rootPWFile.getLongIdentifier());
                    System.err.println(StaticUtils.wrapText(message2, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
                Message initialPrompt = ToolMessages.INFO_INSTALLDS_PROMPT_ROOT_PASSWORD.get();
                Message confirmPrompt = ToolMessages.INFO_INSTALLDS_PROMPT_CONFIRM_ROOT_PASSWORD.get();
                rootPassword = new String(InstallDS.promptForPassword(initialPrompt, confirmPrompt));
            }
            if (baseDN.isPresent()) {
                baseDNs = new LinkedList<DN>();
                for (String s : baseDN.getValues()) {
                    try {
                        baseDNs.add(DN.decode(s));
                    }
                    catch (Exception e) {
                        Message message19 = ToolMessages.ERR_INSTALLDS_CANNOT_PARSE_DN.get(s, e.getMessage());
                        System.err.println(StaticUtils.wrapText(message19, ServerConstants.MAX_LINE_WIDTH));
                        return 1;
                    }
                }
            } else if (quietInstall.isPresent()) {
                try {
                    baseDNs = new LinkedList();
                    baseDNs.add(DN.decode(baseDN.getDefaultValue()));
                }
                catch (Exception e) {
                    Message message20 = ToolMessages.ERR_INSTALLDS_CANNOT_PARSE_DN.get(baseDN.getDefaultValue(), e.getMessage());
                    System.err.println(StaticUtils.wrapText(message20, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
            } else {
                Message message21 = ToolMessages.INFO_INSTALLDS_PROMPT_BASEDN.get();
                baseDNs = new LinkedList();
                baseDNs.add(InstallDS.promptForDN(message21, baseDN.getDefaultValue()));
            }
            populateType = 2;
            numUsers = -1;
            ldifFiles = null;
            if (addBaseEntry.isPresent()) {
                populateType = 1;
            } else if (importLDIF.isPresent()) {
                ldifFiles = importLDIF.getValues();
                populateType = 3;
            } else {
                if (sampleData.isPresent()) {
                    try {
                        numUsers = sampleData.getIntValue();
                        populateType = 4;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return 1;
                    }
                }
                if (quietInstall.isPresent()) {
                    populateType = 2;
                } else {
                    Message message22;
                    System.out.println(StaticUtils.wrapText(ToolMessages.INFO_INSTALLDS_HEADER_POPULATE_TYPE.get(), ServerConstants.MAX_LINE_WIDTH));
                    System.out.println(StaticUtils.wrapText("1.  " + ToolMessages.INFO_INSTALLDS_POPULATE_OPTION_BASE_ONLY.get(), ServerConstants.MAX_LINE_WIDTH));
                    System.out.println(StaticUtils.wrapText("2.  " + ToolMessages.INFO_INSTALLDS_POPULATE_OPTION_LEAVE_EMPTY.get(), ServerConstants.MAX_LINE_WIDTH));
                    System.out.println(StaticUtils.wrapText("3.  " + ToolMessages.INFO_INSTALLDS_POPULATE_OPTION_IMPORT_LDIF.get(), ServerConstants.MAX_LINE_WIDTH));
                    System.out.println(StaticUtils.wrapText("4.  " + ToolMessages.INFO_INSTALLDS_POPULATE_OPTION_GENERATE_SAMPLE.get(), ServerConstants.MAX_LINE_WIDTH));
                    populateType = InstallDS.promptForInteger(ToolMessages.INFO_INSTALLDS_PROMPT_POPULATE_CHOICE.get(), 1, 1, 4);
                    System.out.println();
                    if (populateType == 3) {
                        ldifFiles = new LinkedList();
                        while (true) {
                            String path;
                            if (new File(path = InstallDS.promptForString(message22 = ToolMessages.INFO_INSTALLDS_PROMPT_IMPORT_FILE.get(), "")).exists()) {
                                ldifFiles.add(path);
                                System.out.println();
                                break block114;
                            }
                            message22 = ToolMessages.ERR_INSTALLDS_NO_SUCH_LDIF_FILE.get(path);
                            System.err.println(StaticUtils.wrapText(message22, ServerConstants.MAX_LINE_WIDTH));
                            System.err.println();
                        }
                    }
                    if (populateType == 4) {
                        message22 = ToolMessages.INFO_INSTALLDS_PROMPT_NUM_ENTRIES.get();
                        numUsers = InstallDS.promptForInteger(message22, 2000, 0, Integer.MAX_VALUE);
                        System.out.println();
                    }
                }
            }
        }
        boolean enableService = false;
        if (SetupUtils.isWindows()) {
            if (quietInstall.isPresent()) {
                enableService = enableWindowsService.isPresent();
            } else if (enableWindowsService.isPresent()) {
                enableService = true;
            } else {
                Message message23 = ToolMessages.INFO_INSTALLDS_PROMPT_ENABLE_SERVICE.get();
                enableService = InstallDS.promptForBoolean(message23, Boolean.TRUE);
            }
        }
        ArrayList<String> argList = new ArrayList<String>();
        argList.add("-C");
        argList.add(configClassName);
        argList.add("-c");
        argList.add(configFileName);
        argList.add("-p");
        argList.add(String.valueOf(ldapPortNumber));
        if (jmxPortNumber != -1) {
            argList.add("-x");
            argList.add(String.valueOf(jmxPortNumber));
        }
        for (DN dn : baseDNs) {
            argList.add("-b");
            argList.add(dn.toString());
        }
        for (DN dn : rootDNs) {
            argList.add("-D");
            argList.add(dn.toString());
        }
        argList.add("-w");
        argList.add(rootPassword);
        String[] configureDSArguments = new String[argList.size()];
        argList.toArray(configureDSArguments);
        if (!quietInstall.isPresent()) {
            System.out.println();
            Message message24 = ToolMessages.INFO_INSTALLDS_STATUS_CONFIGURING_DS.get();
            System.out.println(StaticUtils.wrapText(message24, ServerConstants.MAX_LINE_WIDTH));
        }
        if ((returnValue = ConfigureDS.configMain(configureDSArguments)) != 0) {
            return returnValue;
        }
        if (populateType == 1) {
            if (!quietInstall.isPresent()) {
                message = ToolMessages.INFO_INSTALLDS_STATUS_CREATING_BASE_LDIF.get();
                System.out.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            }
            try {
                File ldifFile = File.createTempFile("opends-base-entry", ".ldif");
                String ldifFilePath = ldifFile.getAbsolutePath();
                ldifFile.deleteOnExit();
                LDIFExportConfig exportConfig = new LDIFExportConfig(ldifFilePath, ExistingFileBehavior.OVERWRITE);
                LDIFWriter writer = new LDIFWriter(exportConfig);
                for (DN dn : baseDNs) {
                    writer.writeEntry(StaticUtils.createEntry(dn));
                }
                writer.close();
                if (ldifFiles == null) {
                    ldifFiles = new LinkedList();
                }
                ldifFiles.add(ldifFilePath);
            }
            catch (Exception e) {
                Message message25 = ToolMessages.ERR_INSTALLDS_CANNOT_CREATE_BASE_ENTRY_LDIF.get(String.valueOf(e));
                System.err.println(StaticUtils.wrapText(message25, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        }
        if (populateType == 4) {
            try {
                File templateFile = SetupUtils.createTemplateFile(((DN)baseDNs.getFirst()).toString(), numUsers);
                if (ldifFiles == null) {
                    ldifFiles = new LinkedList();
                }
                ldifFiles.add(templateFile.getAbsolutePath());
            }
            catch (Exception e) {
                Message message26 = ToolMessages.ERR_INSTALLDS_CANNOT_CREATE_TEMPLATE_FILE.get(String.valueOf(e));
                System.err.println(StaticUtils.wrapText(message26, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        }
        if (ldifFiles != null && !ldifFiles.isEmpty()) {
            Message message27;
            if (!quietInstall.isPresent()) {
                message = ToolMessages.INFO_INSTALLDS_STATUS_IMPORTING_LDIF.get();
                System.out.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            }
            argList = new ArrayList();
            argList.add("-C");
            argList.add(configClassName);
            argList.add("-f");
            argList.add(configFileName);
            argList.add("-n");
            argList.add("userRoot");
            for (String s : ldifFiles) {
                if (populateType == 4) {
                    argList.add("-t");
                } else {
                    argList.add("-l");
                }
                argList.add(s);
            }
            if (populateType == 4) {
                argList.add("-s");
                argList.add("0");
            }
            if (populateType == 1) {
                argList.add("-q");
            }
            String[] importLDIFArguments = new String[argList.size()];
            argList.toArray(importLDIFArguments);
            returnValue = ImportLDIF.mainImportLDIF(importLDIFArguments);
            if (returnValue != 0) {
                message27 = ToolMessages.ERR_INSTALLDS_IMPORT_UNSUCCESSFUL.get();
                System.out.println(StaticUtils.wrapText(message27, ServerConstants.MAX_LINE_WIDTH));
                return returnValue;
            }
            message27 = ToolMessages.INFO_INSTALLDS_IMPORT_SUCCESSFUL.get();
            System.out.println(StaticUtils.wrapText(message27, ServerConstants.MAX_LINE_WIDTH));
        }
        try {
            String serverRoot = System.getenv("INSTANCE_ROOT");
            if (serverRoot == null || serverRoot.length() == 0) {
                File f = new File(configFileName);
                serverRoot = f.getParentFile().getParentFile().getAbsolutePath();
            }
            SetupUtils.writeSetJavaHome(serverRoot);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (enableService) {
            message = ToolMessages.INFO_INSTALLDS_ENABLING_WINDOWS_SERVICE.get();
            System.out.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            int code = ConfigureWindowsService.enableService(System.out, System.err);
            switch (code) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    return code;
                }
            }
        }
        if (!quietInstall.isPresent()) {
            message = ToolMessages.INFO_INSTALLDS_STATUS_SUCCESS.get();
            System.out.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
        }
        return 0;
    }

    private static boolean promptForBoolean(Message prompt, Boolean defaultValue) {
        String wrappedPrompt = StaticUtils.wrapText(prompt, ServerConstants.MAX_LINE_WIDTH);
        while (true) {
            Message message;
            System.out.println();
            System.out.println(wrappedPrompt);
            if (defaultValue == null) {
                System.out.print(": ");
            } else {
                System.out.print("[");
                if (defaultValue.booleanValue()) {
                    System.out.print(ToolMessages.INFO_INSTALLDS_PROMPT_VALUE_YES.get());
                } else {
                    System.out.print(ToolMessages.INFO_INSTALLDS_PROMPT_VALUE_NO.get());
                }
                System.out.print("]: ");
            }
            System.out.flush();
            String response = StaticUtils.toLowerCase(InstallDS.readLine());
            if (response.equals("true") || response.equals("yes") || response.equals("t") || response.equals("y")) {
                return true;
            }
            if (response.equals("false") || response.equals("no") || response.equals("f") || response.equals("n")) {
                return false;
            }
            if (response.equals("")) {
                if (defaultValue == null) {
                    message = ToolMessages.ERR_INSTALLDS_INVALID_YESNO_RESPONSE.get();
                    System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                    continue;
                }
                return defaultValue;
            }
            message = ToolMessages.ERR_INSTALLDS_INVALID_YESNO_RESPONSE.get();
            System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
        }
    }

    private static int promptForInteger(Message prompt, Integer defaultValue, Integer lowerBound, Integer upperBound) {
        String wrappedPrompt = StaticUtils.wrapText(prompt, ServerConstants.MAX_LINE_WIDTH);
        while (true) {
            Message message;
            System.out.println();
            System.out.println(wrappedPrompt);
            if (defaultValue == null) {
                System.out.print(": ");
            } else {
                System.out.print("[");
                System.out.print(defaultValue);
                System.out.print("]: ");
            }
            System.out.flush();
            String response = InstallDS.readLine();
            if (response.equals("")) {
                if (defaultValue == null) {
                    Message message2 = ToolMessages.ERR_INSTALLDS_INVALID_INTEGER_RESPONSE.get();
                    System.err.println(StaticUtils.wrapText(message2, ServerConstants.MAX_LINE_WIDTH));
                    continue;
                }
                return defaultValue;
            }
            try {
                int intValue = Integer.parseInt(response);
                if (lowerBound != null && intValue < lowerBound) {
                    message = ToolMessages.ERR_INSTALLDS_INTEGER_BELOW_LOWER_BOUND.get(lowerBound);
                    System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                    continue;
                }
                if (upperBound != null && intValue > upperBound) {
                    message = ToolMessages.ERR_INSTALLDS_INTEGER_ABOVE_UPPER_BOUND.get(upperBound);
                    System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                    continue;
                }
                return intValue;
            }
            catch (NumberFormatException nfe) {
                message = ToolMessages.ERR_INSTALLDS_INVALID_INTEGER_RESPONSE.get();
                System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                continue;
            }
            break;
        }
    }

    private static DN promptForDN(Message prompt, String defaultValue) {
        String wrappedPrompt = StaticUtils.wrapText(prompt, ServerConstants.MAX_LINE_WIDTH);
        while (true) {
            Message message;
            System.out.println();
            System.out.println(wrappedPrompt);
            if (defaultValue == null) {
                System.out.print(": ");
            } else {
                System.out.print("[");
                System.out.print(defaultValue);
                System.out.print("]: ");
            }
            System.out.flush();
            String response = InstallDS.readLine();
            if (response.equals("")) {
                if (defaultValue == null) {
                    Message message2 = ToolMessages.ERR_INSTALLDS_INVALID_DN_RESPONSE.get();
                    System.err.println(StaticUtils.wrapText(message2, ServerConstants.MAX_LINE_WIDTH));
                    continue;
                }
                try {
                    return DN.decode(defaultValue);
                }
                catch (Exception e) {
                    message = ToolMessages.ERR_INSTALLDS_INVALID_DN_RESPONSE.get();
                    System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                    continue;
                }
            }
            try {
                return DN.decode(response);
            }
            catch (Exception e) {
                message = ToolMessages.ERR_INSTALLDS_INVALID_DN_RESPONSE.get();
                System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                continue;
            }
            break;
        }
    }

    private static String promptForString(Message prompt, String defaultValue) {
        String response;
        block3: {
            System.out.println();
            String wrappedPrompt = StaticUtils.wrapText(prompt, ServerConstants.MAX_LINE_WIDTH);
            while (true) {
                System.out.println(wrappedPrompt);
                if (defaultValue == null) {
                    System.out.print(": ");
                } else {
                    System.out.print("[");
                    System.out.print(defaultValue);
                    System.out.print("]: ");
                }
                System.out.flush();
                response = InstallDS.readLine();
                if (!response.equals("")) break block3;
                if (defaultValue != null) break;
                Message message = ToolMessages.ERR_INSTALLDS_INVALID_STRING_RESPONSE.get();
                System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            }
            return defaultValue;
        }
        return response;
    }

    private static char[] promptForPassword(Message initialPrompt, Message reEntryPrompt) {
        char[] password;
        String wrappedInitialPrompt = StaticUtils.wrapText(initialPrompt, ServerConstants.MAX_LINE_WIDTH);
        String wrappedReEntryPrompt = StaticUtils.wrapText(reEntryPrompt, ServerConstants.MAX_LINE_WIDTH);
        while (true) {
            System.out.println();
            System.out.print(wrappedInitialPrompt);
            System.out.print(": ");
            System.out.flush();
            password = PasswordReader.readPassword();
            if (password == null || password.length == 0) {
                Message message = ToolMessages.ERR_INSTALLDS_INVALID_PASSWORD_RESPONSE.get();
                System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                continue;
            }
            System.out.print(wrappedReEntryPrompt);
            System.out.print(": ");
            System.out.flush();
            char[] confirmedPassword = PasswordReader.readPassword();
            if (confirmedPassword != null && Arrays.equals(password, confirmedPassword)) break;
            Message message = ToolMessages.ERR_INSTALLDS_PASSWORDS_DONT_MATCH.get();
            System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
        }
        return password;
    }

    private static String readLine() {
        try {
            int b;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((b = System.in.read()) >= 0 && b != 10) {
                if (b == 13) {
                    int b2 = System.in.read();
                    if (b2 == 10) break;
                    baos.write(b);
                    baos.write(b2);
                    continue;
                }
                baos.write(b);
            }
            return new String(baos.toByteArray(), "UTF-8");
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_INSTALLDS_ERROR_READING_FROM_STDIN.get(String.valueOf(e));
            System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return null;
        }
    }
}

