/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.dsconfig;

import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.DefaultBehaviorException;
import org.opends.server.admin.IllegalPropertyValueException;
import org.opends.server.admin.IllegalPropertyValueStringException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyDefinitionUsageBuilder;
import org.opends.server.admin.PropertyException;
import org.opends.server.admin.PropertyIsMandatoryException;
import org.opends.server.admin.PropertyIsReadOnlyException;
import org.opends.server.admin.PropertyIsSingleValuedException;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.admin.client.IllegalManagedObjectNameException;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArgumentExceptionFactory {
    public static ArgumentException adaptIllegalManagedObjectNameException(IllegalManagedObjectNameException e, AbstractManagedObjectDefinition<?, ?> d) {
        String illegalName = e.getIllegalName();
        PropertyDefinition<?> pd = e.getNamingPropertyDefinition();
        if (illegalName.length() == 0) {
            Message message = ToolMessages.ERR_DSCFG_ERROR_ILLEGAL_NAME_EMPTY.get(d.getUserFriendlyPluralName());
            return new ArgumentException(message);
        }
        if (illegalName.trim().length() == 0) {
            Message message = ToolMessages.ERR_DSCFG_ERROR_ILLEGAL_NAME_BLANK.get(d.getUserFriendlyPluralName());
            return new ArgumentException(message);
        }
        if (pd != null) {
            try {
                pd.decodeValue(illegalName);
            }
            catch (IllegalPropertyValueStringException e1) {
                PropertyDefinitionUsageBuilder b = new PropertyDefinitionUsageBuilder(true);
                Message syntax = b.getUsage(pd);
                Message message = ToolMessages.ERR_DSCFG_ERROR_ILLEGAL_NAME_SYNTAX.get(illegalName, d.getUserFriendlyName(), syntax);
                return new ArgumentException(message);
            }
        }
        Message message = ToolMessages.ERR_DSCFG_ERROR_ILLEGAL_NAME_UNKNOWN.get(illegalName, d.getUserFriendlyName());
        return new ArgumentException(message);
    }

    public static ArgumentException adaptMissingMandatoryPropertiesException(MissingMandatoryPropertiesException e, AbstractManagedObjectDefinition<?, ?> d) {
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        for (PropertyIsMandatoryException pe : e.getCauses()) {
            if (!isFirst) {
                builder.append(", ");
            }
            builder.append(pe.getPropertyDefinition().getName());
            isFirst = false;
        }
        Message msg = ToolMessages.ERR_DSCFG_ERROR_CREATE_MMPE.get(d.getUserFriendlyName(), builder.toString());
        return new ArgumentException(msg);
    }

    public static ArgumentException adaptPropertyException(PropertyException e, AbstractManagedObjectDefinition<?, ?> d) {
        if (e instanceof IllegalPropertyValueException) {
            IllegalPropertyValueException pe = (IllegalPropertyValueException)e;
            return ArgumentExceptionFactory.adapt(d, pe);
        }
        if (e instanceof IllegalPropertyValueStringException) {
            IllegalPropertyValueStringException pe = (IllegalPropertyValueStringException)e;
            return ArgumentExceptionFactory.adapt(d, pe);
        }
        if (e instanceof PropertyIsMandatoryException) {
            PropertyIsMandatoryException pe = (PropertyIsMandatoryException)e;
            return ArgumentExceptionFactory.adapt(d, pe);
        }
        if (e instanceof PropertyIsSingleValuedException) {
            PropertyIsSingleValuedException pe = (PropertyIsSingleValuedException)e;
            return ArgumentExceptionFactory.adapt(d, pe);
        }
        if (e instanceof PropertyIsReadOnlyException) {
            PropertyIsReadOnlyException pe = (PropertyIsReadOnlyException)e;
            return ArgumentExceptionFactory.adapt(d, pe);
        }
        if (e instanceof DefaultBehaviorException) {
            DefaultBehaviorException pe = (DefaultBehaviorException)e;
            return ArgumentExceptionFactory.adapt(d, pe);
        }
        Message message = ToolMessages.ERR_DSCFG_ERROR_PROPERTY_UNKNOWN_ERROR.get(d.getUserFriendlyName(), e.getPropertyDefinition().getName(), e.getMessage());
        return new ArgumentException(message);
    }

    public static ArgumentException incompatiblePropertyModification(String arg) {
        Message msg = ToolMessages.ERR_DSCFG_ERROR_INCOMPATIBLE_PROPERTY_MOD.get(arg);
        return new ArgumentException(msg);
    }

    public static ArgumentException missingBindPassword(String bindDN) {
        Message msg = ToolMessages.ERR_DSCFG_ERROR_NO_PASSWORD.get(bindDN);
        return new ArgumentException(msg);
    }

    public static ArgumentException missingMandatoryNonInteractiveArgument(Argument arg) {
        Message msg = ToolMessages.ERR_DSCFG_ERROR_MISSING_NON_INTERACTIVE_ARG.get(arg.getLongIdentifier());
        return new ArgumentException(msg);
    }

    public static ArgumentException missingNameInPropertyArgument(String arg) {
        Message msg = ToolMessages.ERR_DSCFG_ERROR_NO_NAME_IN_PROPERTY_VALUE.get(arg);
        return new ArgumentException(msg);
    }

    public static ArgumentException missingNameInPropertyModification(String arg) {
        Message msg = ToolMessages.ERR_DSCFG_ERROR_NO_NAME_IN_PROPERTY_MOD.get(arg);
        return new ArgumentException(msg);
    }

    public static ArgumentException missingSeparatorInPropertyArgument(String arg) {
        Message msg = ToolMessages.ERR_DSCFG_ERROR_NO_SEPARATOR_IN_PROPERTY_VALUE.get(arg);
        return new ArgumentException(msg);
    }

    public static ArgumentException missingSeparatorInPropertyModification(String arg) {
        Message msg = ToolMessages.ERR_DSCFG_ERROR_NO_SEPARATOR_IN_PROPERTY_MOD.get(arg);
        return new ArgumentException(msg);
    }

    public static ArgumentException missingValueInPropertyArgument(String arg) {
        Message msg = ToolMessages.ERR_DSCFG_ERROR_NO_VALUE_IN_PROPERTY_VALUE.get(arg);
        return new ArgumentException(msg);
    }

    public static ArgumentException missingValueInPropertyModification(String arg) {
        Message msg = ToolMessages.ERR_DSCFG_ERROR_NO_NAME_IN_PROPERTY_MOD.get(arg);
        return new ArgumentException(msg);
    }

    public static ArgumentException unableToReadBindPassword(Exception cause) {
        Message message = ToolMessages.ERR_DSCFG_ERROR_CANNOT_READ_LDAP_BIND_PASSWORD.get(cause.getMessage());
        return new ArgumentException(message, (Throwable)cause);
    }

    public static ArgumentException unableToReadBindPasswordInteractively() {
        Message message = ToolMessages.ERR_DSCFG_ERROR_BIND_PASSWORD_NONINTERACTIVE.get();
        return new ArgumentException(message);
    }

    public static ArgumentException unableToReadConsoleInput(Exception cause) {
        Message message = ToolMessages.ERR_DSCFG_ERROR_CANNOT_READ_CONSOLE_INPUT.get(cause.getMessage());
        return new ArgumentException(message, (Throwable)cause);
    }

    public static ArgumentException unableToResetMandatoryProperty(AbstractManagedObjectDefinition<?, ?> d, String name, String setOption) {
        Message message = ToolMessages.ERR_DSCFG_ERROR_UNABLE_TO_RESET_MANDATORY_PROPERTY.get(d.getUserFriendlyPluralName(), name, setOption);
        return new ArgumentException(message);
    }

    public static ArgumentException unableToSetNamingProperty(AbstractManagedObjectDefinition<?, ?> d, PropertyDefinition<?> pd) {
        Message message = ToolMessages.ERR_DSCFG_ERROR_UNABLE_TO_SET_NAMING_PROPERTY.get(pd.getName(), d.getUserFriendlyName());
        return new ArgumentException(message);
    }

    public static ArgumentException unknownCategory(String categoryName) {
        Message msg = ToolMessages.ERR_DSCFG_ERROR_CATEGORY_UNRECOGNIZED.get(categoryName);
        return new ArgumentException(msg);
    }

    public static ArgumentException unknownProperty(AbstractManagedObjectDefinition<?, ?> d, String name) {
        Message message = ToolMessages.ERR_DSCFG_ERROR_PROPERTY_UNRECOGNIZED.get(name, d.getUserFriendlyPluralName());
        return new ArgumentException(message);
    }

    public static ArgumentException unknownProperty(String name) {
        Message message = ToolMessages.ERR_DSCFG_ERROR_PROPERTY_UNRECOGNIZED_NO_DEFN.get(name);
        return new ArgumentException(message);
    }

    public static ArgumentException unknownSubType(RelationDefinition<?, ?> r, String typeName, String typeUsage) {
        Message msg = ToolMessages.ERR_DSCFG_ERROR_SUB_TYPE_UNRECOGNIZED.get(typeName, r.getUserFriendlyName(), typeUsage);
        return new ArgumentException(msg);
    }

    public static ArgumentException unknownType(String typeName) {
        Message msg = ToolMessages.ERR_DSCFG_ERROR_TYPE_UNRECOGNIZED.get(typeName);
        return new ArgumentException(msg);
    }

    public static ArgumentException unknownTypeInCategory(String categoryName, String typeName) {
        Message msg = ToolMessages.ERR_DSCFG_ERROR_CATEGORY_TYPE_UNRECOGNIZED.get(typeName, categoryName);
        return new ArgumentException(msg);
    }

    public static ArgumentException wrongManagedObjectType(RelationDefinition<?, ?> r, ManagedObjectDefinition<?, ?> d) {
        Message msg = ToolMessages.ERR_DSCFG_ERROR_TYPE_UNRECOGNIZED.get(d.getUserFriendlyName());
        return new ArgumentException(msg);
    }

    private static ArgumentException adapt(AbstractManagedObjectDefinition<?, ?> d, DefaultBehaviorException e) {
        Message message = ToolMessages.ERR_DSCFG_ERROR_PROPERTY_DEFAULT_BEHAVIOR.get(d.getUserFriendlyName(), e.getPropertyDefinition().getName(), e.getMessage());
        return new ArgumentException(message);
    }

    private static ArgumentException adapt(AbstractManagedObjectDefinition<?, ?> d, IllegalPropertyValueException e) {
        PropertyDefinitionUsageBuilder b = new PropertyDefinitionUsageBuilder(true);
        Message syntax = b.getUsage(e.getPropertyDefinition());
        if (syntax.length() > 20) {
            // empty if block
        }
        Message message = ToolMessages.ERR_DSCFG_ERROR_PROPERTY_INVALID_VALUE.get(String.valueOf(e.getIllegalValue()), d.getUserFriendlyName(), e.getPropertyDefinition().getName(), syntax);
        return new ArgumentException(message);
    }

    private static ArgumentException adapt(AbstractManagedObjectDefinition<?, ?> d, IllegalPropertyValueStringException e) {
        PropertyDefinitionUsageBuilder b = new PropertyDefinitionUsageBuilder(true);
        Message syntax = b.getUsage(e.getPropertyDefinition());
        if (syntax.length() > 20) {
            // empty if block
        }
        Message message = ToolMessages.ERR_DSCFG_ERROR_PROPERTY_INVALID_VALUE.get(String.valueOf(e.getIllegalValueString()), d.getUserFriendlyName(), e.getPropertyDefinition().getName(), syntax);
        return new ArgumentException(message);
    }

    private static ArgumentException adapt(AbstractManagedObjectDefinition<?, ?> d, PropertyIsMandatoryException e) {
        Message message = ToolMessages.ERR_DSCFG_ERROR_PROPERTY_MANDATORY.get(d.getUserFriendlyName(), e.getPropertyDefinition().getName());
        return new ArgumentException(message);
    }

    private static ArgumentException adapt(AbstractManagedObjectDefinition<?, ?> d, PropertyIsReadOnlyException e) {
        Message message = ToolMessages.ERR_DSCFG_ERROR_PROPERTY_READ_ONLY.get(d.getUserFriendlyName(), e.getPropertyDefinition().getName());
        return new ArgumentException(message);
    }

    private static ArgumentException adapt(AbstractManagedObjectDefinition<?, ?> d, PropertyIsSingleValuedException e) {
        Message message = ToolMessages.ERR_DSCFG_ERROR_PROPERTY_SINGLE_VALUED.get(d.getUserFriendlyName(), e.getPropertyDefinition().getName());
        return new ArgumentException(message);
    }

    private ArgumentExceptionFactory() {
    }
}

