/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.dsconfig;

import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.DefinitionDecodingException;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.ManagedObjectNotFoundException;
import org.opends.server.admin.ManagedObjectPath;
import org.opends.server.admin.OptionalRelationDefinition;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.ManagedObjectDecodingException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.tools.ClientException;
import org.opends.server.tools.dsconfig.ConsoleApplication;
import org.opends.server.tools.dsconfig.SubCommandHandler;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.args.SubCommand;
import org.opends.server.util.args.SubCommandArgumentParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DeleteSubCommandHandler
extends SubCommandHandler {
    private static final String OPTION_DSCFG_LONG_FORCE = "force";
    private static final char OPTION_DSCFG_SHORT_FORCE = 'f';
    private final BooleanArgument forceArgument;
    private final List<StringArgument> namingArgs;
    private final ManagedObjectPath<?, ?> path;
    private final RelationDefinition<?, ?> relation;
    private final SubCommand subCommand;

    public static DeleteSubCommandHandler create(ConsoleApplication app, SubCommandArgumentParser parser, ManagedObjectPath<?, ?> p, InstantiableRelationDefinition<?, ?> r) throws ArgumentException {
        return new DeleteSubCommandHandler(app, parser, p, r, p.child(r, "DUMMY"));
    }

    public static DeleteSubCommandHandler create(ConsoleApplication app, SubCommandArgumentParser parser, ManagedObjectPath<?, ?> p, OptionalRelationDefinition<?, ?> r) throws ArgumentException {
        return new DeleteSubCommandHandler(app, parser, p, r, p.child(r));
    }

    private DeleteSubCommandHandler(ConsoleApplication app, SubCommandArgumentParser parser, ManagedObjectPath<?, ?> p, RelationDefinition<?, ?> r, ManagedObjectPath<?, ?> c) throws ArgumentException {
        super(app);
        this.path = p;
        this.relation = r;
        String name = "delete-" + r.getName();
        Message ufpn = r.getChildDefinition().getUserFriendlyPluralName();
        Message description = ToolMessages.INFO_DSCFG_DESCRIPTION_SUBCMD_DELETE.get(ufpn);
        this.subCommand = new SubCommand(parser, name, false, 0, 0, null, description);
        this.namingArgs = this.createNamingArgs(this.subCommand, c, false);
        this.forceArgument = new BooleanArgument(OPTION_DSCFG_LONG_FORCE, Character.valueOf('f'), OPTION_DSCFG_LONG_FORCE, ToolMessages.INFO_DSCFG_DESCRIPTION_FORCE.get(ufpn));
        this.subCommand.addArgument(this.forceArgument);
        this.addTags(this.relation.getChildDefinition().getAllTags());
    }

    @Override
    public SubCommand getSubCommand() {
        return this.subCommand;
    }

    @Override
    public int run() throws ArgumentException, ClientException {
        block20: {
            ManagedObject<?> parent;
            List<String> names;
            block19: {
                names = this.getNamingArgValues(this.namingArgs);
                parent = null;
                try {
                    parent = this.getManagedObject(this.path, names);
                }
                catch (AuthorizationException e) {
                    Message msg = ToolMessages.ERR_DSCFG_ERROR_DELETE_AUTHZ.get(this.relation.getUserFriendlyName());
                    throw new ClientException(50, msg);
                }
                catch (DefinitionDecodingException e) {
                    Message ufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
                    Message msg = ToolMessages.ERR_DSCFG_ERROR_GET_PARENT_DDE.get(ufn, ufn, ufn);
                    throw new ClientException(1, msg);
                }
                catch (ManagedObjectDecodingException e) {
                    Message ufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
                    Message msg = ToolMessages.ERR_DSCFG_ERROR_GET_PARENT_MODE.get(ufn);
                    throw new ClientException(1, msg);
                }
                catch (CommunicationException e) {
                    Message msg = ToolMessages.ERR_DSCFG_ERROR_DELETE_CE.get(this.relation.getUserFriendlyName(), e.getMessage());
                    throw new ClientException(81, msg);
                }
                catch (ConcurrentModificationException e) {
                    Message msg = ToolMessages.ERR_DSCFG_ERROR_DELETE_CME.get(this.relation.getUserFriendlyName());
                    throw new ClientException(19, msg);
                }
                catch (ManagedObjectNotFoundException e) {
                    if (this.forceArgument.isPresent()) break block19;
                    Message ufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
                    Message msg = ToolMessages.ERR_DSCFG_ERROR_GET_PARENT_MONFE.get(ufn);
                    throw new ClientException(32, msg);
                }
            }
            if (parent != null) {
                try {
                    if (this.relation instanceof InstantiableRelationDefinition) {
                        InstantiableRelationDefinition irelation = (InstantiableRelationDefinition)this.relation;
                        String childName = names.get(names.size() - 1);
                        if (childName == null) {
                            childName = this.readChildName(parent, irelation, null);
                        }
                        if (this.confirmDeletion()) {
                            parent.removeChild(irelation, childName);
                            break block20;
                        }
                        return 1;
                    }
                    if (!(this.relation instanceof OptionalRelationDefinition)) break block20;
                    OptionalRelationDefinition orelation = (OptionalRelationDefinition)this.relation;
                    if (this.confirmDeletion()) {
                        parent.removeChild(orelation);
                        break block20;
                    }
                    return 1;
                }
                catch (AuthorizationException e) {
                    Message msg = ToolMessages.ERR_DSCFG_ERROR_DELETE_AUTHZ.get(this.relation.getUserFriendlyName());
                    throw new ClientException(50, msg);
                }
                catch (OperationRejectedException e) {
                    Message msg = ToolMessages.ERR_DSCFG_ERROR_DELETE_ORE.get(this.relation.getUserFriendlyName(), e.getMessage());
                    throw new ClientException(19, msg);
                }
                catch (ManagedObjectNotFoundException e) {
                    if (!this.forceArgument.isPresent()) {
                        Message msg = ToolMessages.ERR_DSCFG_ERROR_DELETE_MONFE.get(this.relation.getUserFriendlyName());
                        throw new ClientException(32, msg);
                    }
                }
                catch (ConcurrentModificationException e) {
                    Message msg = ToolMessages.ERR_DSCFG_ERROR_DELETE_CME.get(this.relation.getUserFriendlyName());
                    throw new ClientException(19, msg);
                }
                catch (CommunicationException e) {
                    Message msg = ToolMessages.ERR_DSCFG_ERROR_DELETE_CE.get(this.relation.getUserFriendlyName(), e.getMessage());
                    throw new ClientException(81, msg);
                }
            }
        }
        Message msg = ToolMessages.INFO_DSCFG_CONFIRM_DELETE_SUCCESS.get(this.relation.getUserFriendlyName());
        this.getConsoleApplication().printVerboseMessage(msg);
        return 0;
    }

    private boolean confirmDeletion() throws ArgumentException {
        Message prompt = ToolMessages.INFO_DSCFG_CONFIRM_DELETE.get(this.relation.getUserFriendlyName());
        if (!this.getConsoleApplication().confirmAction(prompt)) {
            Message msg = ToolMessages.INFO_DSCFG_CONFIRM_DELETE_FAIL.get(this.relation.getUserFriendlyName());
            this.getConsoleApplication().printVerboseMessage(msg);
            return false;
        }
        return true;
    }
}

