/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.dsconfig;

import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.DefinitionDecodingException;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.ManagedObjectNotFoundException;
import org.opends.server.admin.ManagedObjectPath;
import org.opends.server.admin.OptionalRelationDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.ManagedObjectDecodingException;
import org.opends.server.tools.ClientException;
import org.opends.server.tools.dsconfig.CLIProfile;
import org.opends.server.tools.dsconfig.ConsoleApplication;
import org.opends.server.tools.dsconfig.PropertyValuePrinter;
import org.opends.server.tools.dsconfig.SubCommandHandler;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.args.SubCommand;
import org.opends.server.util.args.SubCommandArgumentParser;
import org.opends.server.util.table.TableBuilder;
import org.opends.server.util.table.TablePrinter;
import org.opends.server.util.table.TextTablePrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ListSubCommandHandler
extends SubCommandHandler {
    private final List<StringArgument> namingArgs;
    private final ManagedObjectPath<?, ?> path;
    private final RelationDefinition<?, ?> relation;
    private final SubCommand subCommand;

    public static ListSubCommandHandler create(ConsoleApplication app, SubCommandArgumentParser parser, ManagedObjectPath<?, ?> p, InstantiableRelationDefinition<?, ?> r) throws ArgumentException {
        return new ListSubCommandHandler(app, parser, p, r, r.getPluralName(), r.getUserFriendlyPluralName());
    }

    public static ListSubCommandHandler create(ConsoleApplication app, SubCommandArgumentParser parser, ManagedObjectPath<?, ?> p, OptionalRelationDefinition<?, ?> r) throws ArgumentException {
        return new ListSubCommandHandler(app, parser, p, r, r.getName(), r.getUserFriendlyName());
    }

    private ListSubCommandHandler(ConsoleApplication app, SubCommandArgumentParser parser, ManagedObjectPath<?, ?> p, RelationDefinition<?, ?> r, String rname, Message rufn) throws ArgumentException {
        super(app);
        this.path = p;
        this.relation = r;
        String name = "list-" + rname;
        Message desc = ToolMessages.INFO_DSCFG_DESCRIPTION_SUBCMD_LIST.get(rufn);
        this.subCommand = new SubCommand(parser, name, false, 0, 0, null, desc);
        this.namingArgs = this.createNamingArgs(this.subCommand, this.path, false);
        this.registerPropertyNameArgument(this.subCommand);
        this.registerUnitSizeArgument(this.subCommand);
        this.registerUnitTimeArgument(this.subCommand);
        this.addTags(this.relation.getChildDefinition().getAllTags());
    }

    @Override
    public SubCommand getSubCommand() {
        return this.subCommand;
    }

    @Override
    public int run() throws ArgumentException, ClientException {
        ManagedObject<?> parent;
        Message ufn;
        Set<String> propertyNames = this.getPropertyNames();
        if (propertyNames.isEmpty()) {
            propertyNames = CLIProfile.getInstance().getDefaultListPropertyNames(this.relation);
        }
        PropertyValuePrinter valuePrinter = new PropertyValuePrinter(this.getSizeUnit(), this.getTimeUnit(), this.getConsoleApplication().isScriptFriendly());
        List<String> names = this.getNamingArgValues(this.namingArgs);
        if (this.relation instanceof InstantiableRelationDefinition) {
            InstantiableRelationDefinition irelation = (InstantiableRelationDefinition)this.relation;
            ufn = irelation.getUserFriendlyPluralName();
        } else {
            ufn = this.relation.getUserFriendlyName();
        }
        try {
            parent = this.getManagedObject(this.path, names);
        }
        catch (AuthorizationException e) {
            Message msg = ToolMessages.ERR_DSCFG_ERROR_LIST_AUTHZ.get(ufn);
            throw new ClientException(50, msg);
        }
        catch (DefinitionDecodingException e) {
            ufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
            Message msg = ToolMessages.ERR_DSCFG_ERROR_GET_PARENT_DDE.get(ufn, ufn, ufn);
            throw new ClientException(1, msg);
        }
        catch (ManagedObjectDecodingException e) {
            ufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
            Message msg = ToolMessages.ERR_DSCFG_ERROR_GET_PARENT_MODE.get(ufn);
            throw new ClientException(1, msg);
        }
        catch (CommunicationException e) {
            Message msg = ToolMessages.ERR_DSCFG_ERROR_LIST_CE.get(ufn, e.getMessage());
            throw new ClientException(81, msg);
        }
        catch (ConcurrentModificationException e) {
            Message msg = ToolMessages.ERR_DSCFG_ERROR_LIST_CME.get(ufn);
            throw new ClientException(19, msg);
        }
        catch (ManagedObjectNotFoundException e) {
            ufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
            Message msg = ToolMessages.ERR_DSCFG_ERROR_GET_PARENT_MONFE.get(ufn);
            throw new ClientException(32, msg);
        }
        TreeMap children = new TreeMap();
        if (this.relation instanceof InstantiableRelationDefinition) {
            InstantiableRelationDefinition irelation = (InstantiableRelationDefinition)this.relation;
            try {
                for (String s : parent.listChildren(irelation)) {
                    try {
                        children.put(s, parent.getChild(irelation, s));
                    }
                    catch (ManagedObjectNotFoundException e) {
                        // empty catch block
                    }
                }
            }
            catch (DefinitionDecodingException e) {
                Message msg = ToolMessages.ERR_DSCFG_ERROR_LIST_DDE.get(ufn, ufn, ufn);
                throw new ClientException(1, msg);
            }
            catch (ManagedObjectDecodingException e) {
                Message msg = ToolMessages.ERR_DSCFG_ERROR_LIST_MODE.get(ufn);
                throw new ClientException(1, msg);
            }
            catch (AuthorizationException e) {
                Message msg = ToolMessages.ERR_DSCFG_ERROR_LIST_AUTHZ.get(ufn);
                throw new ClientException(50, msg);
            }
            catch (ConcurrentModificationException e) {
                Message msg = ToolMessages.ERR_DSCFG_ERROR_LIST_CME.get(ufn);
                throw new ClientException(19, msg);
            }
            catch (CommunicationException e) {
                Message msg = ToolMessages.ERR_DSCFG_ERROR_LIST_CE.get(ufn, e.getMessage());
                throw new ClientException(81, msg);
            }
        }
        if (this.relation instanceof OptionalRelationDefinition) {
            OptionalRelationDefinition orelation = (OptionalRelationDefinition)this.relation;
            try {
                if (!parent.hasChild(orelation)) {
                    throw new ManagedObjectNotFoundException();
                }
                ManagedObject child = parent.getChild(orelation);
                children.put(child.getManagedObjectDefinition().getName(), child);
            }
            catch (AuthorizationException e) {
                Message msg = ToolMessages.ERR_DSCFG_ERROR_LIST_AUTHZ.get(ufn);
                throw new ClientException(50, msg);
            }
            catch (DefinitionDecodingException e) {
                Message msg = ToolMessages.ERR_DSCFG_ERROR_LIST_DDE.get(ufn, ufn, ufn);
                throw new ClientException(1, msg);
            }
            catch (ManagedObjectDecodingException e) {
                Message msg = ToolMessages.ERR_DSCFG_ERROR_LIST_MODE.get(ufn);
                throw new ClientException(1, msg);
            }
            catch (ConcurrentModificationException e) {
                Message msg = ToolMessages.ERR_DSCFG_ERROR_LIST_CME.get(ufn);
                throw new ClientException(19, msg);
            }
            catch (CommunicationException e) {
                Message msg = ToolMessages.ERR_DSCFG_ERROR_LIST_CE.get(ufn, e.getMessage());
                throw new ClientException(81, msg);
            }
            catch (ManagedObjectNotFoundException e) {
                Message msg = ToolMessages.ERR_DSCFG_ERROR_LIST_MONFE.get(ufn);
                throw new ClientException(32, msg);
            }
        }
        if (this.getConsoleApplication().isScriptFriendly()) {
            PrintStream out = this.getConsoleApplication().getOutputStream();
            for (String name : children.keySet()) {
                out.println(name);
            }
        } else {
            TablePrinter printer;
            TableBuilder builder = new TableBuilder();
            builder.appendHeading(this.relation.getUserFriendlyName());
            builder.appendHeading(ToolMessages.INFO_DSCFG_HEADING_COMPONENT_TYPE.get());
            if (!propertyNames.isEmpty()) {
                // empty if block
            }
            for (String propertyName : propertyNames) {
                builder.appendHeading(Message.raw(propertyName, new Object[0]));
            }
            builder.addSortKey(0);
            String baseType = this.relation.getName();
            String typeSuffix = "-" + baseType;
            for (String name : children.keySet()) {
                ManagedObject child = (ManagedObject)children.get(name);
                ManagedObjectDefinition d = child.getManagedObjectDefinition();
                builder.startRow();
                builder.appendCell(name);
                String childType = d.getName();
                if (baseType.equals(childType)) {
                    builder.appendCell("generic");
                } else if (childType.endsWith(typeSuffix)) {
                    builder.appendCell(childType.substring(0, childType.length() - typeSuffix.length()));
                } else {
                    builder.appendCell(childType);
                }
                for (String propertyName : propertyNames) {
                    try {
                        PropertyDefinition<?> pd = d.getPropertyDefinition(propertyName);
                        this.displayProperty(builder, child, pd, valuePrinter);
                    }
                    catch (IllegalArgumentException e) {
                        if (this.getConsoleApplication().isScriptFriendly()) {
                            builder.appendCell();
                            continue;
                        }
                        builder.appendCell("-");
                    }
                }
            }
            PrintStream out = this.getConsoleApplication().getOutputStream();
            if (this.getConsoleApplication().isScriptFriendly()) {
                printer = this.createScriptFriendlyTablePrinter(out);
                builder.print(printer);
            } else {
                printer = new TextTablePrinter(out);
                ((TextTablePrinter)printer).setColumnSeparator(":");
                builder.print(printer);
            }
        }
        return 0;
    }

    private <T> void displayProperty(TableBuilder builder, ManagedObject<?> mo, PropertyDefinition<T> pd, PropertyValuePrinter valuePrinter) {
        SortedSet<T> values = mo.getPropertyValues(pd);
        if (values.isEmpty()) {
            if (this.getConsoleApplication().isScriptFriendly()) {
                builder.appendCell();
            } else {
                builder.appendCell("-");
            }
        } else {
            StringBuilder sb = new StringBuilder();
            boolean isFirst = true;
            for (Object value : values) {
                if (!isFirst) {
                    sb.append(", ");
                }
                sb.append(valuePrinter.print(pd, value));
                isFirst = false;
            }
            builder.appendCell(sb.toString());
        }
    }
}

