/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.dsconfig;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.DefinitionDecodingException;
import org.opends.server.admin.IllegalPropertyValueStringException;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.ManagedObjectNotFoundException;
import org.opends.server.admin.ManagedObjectPath;
import org.opends.server.admin.OptionalRelationDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyException;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.admin.SingletonRelationDefinition;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.ManagedObjectDecodingException;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.tools.ClientException;
import org.opends.server.tools.dsconfig.ArgumentExceptionFactory;
import org.opends.server.tools.dsconfig.ConsoleApplication;
import org.opends.server.tools.dsconfig.PropertyValueReader;
import org.opends.server.tools.dsconfig.SubCommandHandler;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.args.SubCommand;
import org.opends.server.util.args.SubCommandArgumentParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SetPropSubCommandHandler
extends SubCommandHandler {
    private static final String OPTION_DSCFG_LONG_ADD = "add";
    private static final String OPTION_DSCFG_LONG_REMOVE = "remove";
    private static final String OPTION_DSCFG_LONG_RESET = "reset";
    private static final String OPTION_DSCFG_LONG_SET = "set";
    private static final Character OPTION_DSCFG_SHORT_ADD = null;
    private static final Character OPTION_DSCFG_SHORT_REMOVE = null;
    private static final Character OPTION_DSCFG_SHORT_RESET = null;
    private static final Character OPTION_DSCFG_SHORT_SET = null;
    private final List<StringArgument> namingArgs;
    private final ManagedObjectPath<?, ?> path;
    private final StringArgument propertyAddArgument;
    private final StringArgument propertyRemoveArgument;
    private final StringArgument propertyResetArgument;
    private final StringArgument propertySetArgument;
    private final SubCommand subCommand;

    public static SetPropSubCommandHandler create(ConsoleApplication app, SubCommandArgumentParser parser, ManagedObjectPath<?, ?> path, InstantiableRelationDefinition<?, ?> r) throws ArgumentException {
        return new SetPropSubCommandHandler(app, parser, path.child(r, "DUMMY"), r);
    }

    public static SetPropSubCommandHandler create(ConsoleApplication app, SubCommandArgumentParser parser, ManagedObjectPath<?, ?> path, OptionalRelationDefinition<?, ?> r) throws ArgumentException {
        return new SetPropSubCommandHandler(app, parser, path.child(r), r);
    }

    public static SetPropSubCommandHandler create(ConsoleApplication app, SubCommandArgumentParser parser, ManagedObjectPath<?, ?> path, SingletonRelationDefinition<?, ?> r) throws ArgumentException {
        return new SetPropSubCommandHandler(app, parser, path.child(r), r);
    }

    private SetPropSubCommandHandler(ConsoleApplication app, SubCommandArgumentParser parser, ManagedObjectPath<?, ?> path, RelationDefinition<?, ?> r) throws ArgumentException {
        super(app);
        this.path = path;
        String name = "set-" + r.getName() + "-prop";
        Message description = ToolMessages.INFO_DSCFG_DESCRIPTION_SUBCMD_SETPROP.get(r.getChildDefinition().getUserFriendlyName());
        this.subCommand = new SubCommand(parser, name, false, 0, 0, null, description);
        this.namingArgs = this.createNamingArgs(this.subCommand, path, false);
        this.registerAdvancedModeArgument(this.subCommand, ToolMessages.INFO_DSCFG_DESCRIPTION_ADVANCED_SET.get());
        this.propertySetArgument = new StringArgument(OPTION_DSCFG_LONG_SET, OPTION_DSCFG_SHORT_SET, OPTION_DSCFG_LONG_SET, false, true, true, "{PROP:VAL}", null, null, ToolMessages.INFO_DSCFG_DESCRIPTION_PROP_VAL.get());
        this.subCommand.addArgument(this.propertySetArgument);
        this.propertyResetArgument = new StringArgument(OPTION_DSCFG_LONG_RESET, OPTION_DSCFG_SHORT_RESET, OPTION_DSCFG_LONG_RESET, false, true, true, "{PROP}", null, null, ToolMessages.INFO_DSCFG_DESCRIPTION_RESET_PROP.get());
        this.subCommand.addArgument(this.propertyResetArgument);
        this.propertyAddArgument = new StringArgument(OPTION_DSCFG_LONG_ADD, OPTION_DSCFG_SHORT_ADD, OPTION_DSCFG_LONG_ADD, false, true, true, "{PROP:VAL}", null, null, ToolMessages.INFO_DSCFG_DESCRIPTION_ADD_PROP_VAL.get());
        this.subCommand.addArgument(this.propertyAddArgument);
        this.propertyRemoveArgument = new StringArgument(OPTION_DSCFG_LONG_REMOVE, OPTION_DSCFG_SHORT_REMOVE, OPTION_DSCFG_LONG_REMOVE, false, true, true, "{PROP:VAL}", null, null, ToolMessages.INFO_DSCFG_DESCRIPTION_REMOVE_PROP_VAL.get());
        this.subCommand.addArgument(this.propertyRemoveArgument);
        this.addTags(path.getManagedObjectDefinition().getAllTags());
    }

    @Override
    public SubCommand getSubCommand() {
        return this.subCommand;
    }

    @Override
    public int run() throws ArgumentException, ClientException {
        Message msg;
        PropertyDefinition<?> pd;
        String value;
        String propertyName;
        ManagedObject<?> child;
        List<String> names = this.getNamingArgValues(this.namingArgs);
        try {
            child = this.getManagedObject(this.path, names);
        }
        catch (AuthorizationException e) {
            Message ufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
            Message msg2 = ToolMessages.ERR_DSCFG_ERROR_MODIFY_AUTHZ.get(ufn);
            throw new ClientException(50, msg2);
        }
        catch (DefinitionDecodingException e) {
            Message ufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
            Message msg3 = ToolMessages.ERR_DSCFG_ERROR_GET_CHILD_DDE.get(ufn, ufn, ufn);
            throw new ClientException(1, msg3);
        }
        catch (ManagedObjectDecodingException e) {
            Message ufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
            Message msg4 = ToolMessages.ERR_DSCFG_ERROR_GET_CHILD_MODE.get(ufn);
            throw new ClientException(1, msg4);
        }
        catch (CommunicationException e) {
            Message ufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
            Message msg5 = ToolMessages.ERR_DSCFG_ERROR_MODIFY_CE.get(ufn, e.getMessage());
            throw new ClientException(1, msg5);
        }
        catch (ConcurrentModificationException e) {
            Message ufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
            Message msg6 = ToolMessages.ERR_DSCFG_ERROR_MODIFY_CME.get(ufn);
            throw new ClientException(19, msg6);
        }
        catch (ManagedObjectNotFoundException e) {
            Message ufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
            Message msg7 = ToolMessages.ERR_DSCFG_ERROR_GET_CHILD_MONFE.get(ufn);
            throw new ClientException(32, msg7);
        }
        ManagedObjectDefinition<?, Configuration> d = child.getManagedObjectDefinition();
        HashMap<String, ModificationType> lastModTypes = new HashMap<String, ModificationType>();
        HashMap<PropertyDefinition, Set> changes = new HashMap<PropertyDefinition, Set>();
        for (String m : this.propertyResetArgument.getValues()) {
            PropertyDefinition<?> pd2;
            try {
                pd2 = d.getPropertyDefinition(m);
            }
            catch (IllegalArgumentException e) {
                throw ArgumentExceptionFactory.unknownProperty(d, m);
            }
            if (pd2.hasOption(PropertyOption.MANDATORY) && pd2.getDefaultBehaviorProvider() instanceof UndefinedDefaultBehaviorProvider) {
                throw ArgumentExceptionFactory.unableToResetMandatoryProperty(d, m, OPTION_DSCFG_LONG_SET);
            }
            lastModTypes.put(m, ModificationType.SET);
            this.modifyPropertyValues(child, pd2, changes, ModificationType.SET, null);
        }
        for (String m : this.propertySetArgument.getValues()) {
            int sep = m.indexOf(58);
            if (sep < 0) {
                throw ArgumentExceptionFactory.missingSeparatorInPropertyArgument(m);
            }
            if (sep == 0) {
                throw ArgumentExceptionFactory.missingNameInPropertyArgument(m);
            }
            propertyName = m.substring(0, sep);
            value = m.substring(sep + 1, m.length());
            if (value.length() == 0) {
                throw ArgumentExceptionFactory.missingValueInPropertyArgument(m);
            }
            try {
                pd = d.getPropertyDefinition(propertyName);
            }
            catch (IllegalArgumentException e) {
                throw ArgumentExceptionFactory.unknownProperty(d, propertyName);
            }
            if (lastModTypes.containsKey(propertyName)) {
                this.modifyPropertyValues(child, pd, changes, ModificationType.ADD, value);
                continue;
            }
            lastModTypes.put(propertyName, ModificationType.SET);
            this.modifyPropertyValues(child, pd, changes, ModificationType.SET, value);
        }
        for (String m : this.propertyRemoveArgument.getValues()) {
            int sep = m.indexOf(58);
            if (sep < 0) {
                throw ArgumentExceptionFactory.missingSeparatorInPropertyArgument(m);
            }
            if (sep == 0) {
                throw ArgumentExceptionFactory.missingNameInPropertyArgument(m);
            }
            propertyName = m.substring(0, sep);
            value = m.substring(sep + 1, m.length());
            if (value.length() == 0) {
                throw ArgumentExceptionFactory.missingValueInPropertyArgument(m);
            }
            try {
                pd = d.getPropertyDefinition(propertyName);
            }
            catch (IllegalArgumentException e) {
                throw ArgumentExceptionFactory.unknownProperty(d, propertyName);
            }
            if (lastModTypes.containsKey(propertyName)) {
                if (lastModTypes.get(propertyName) != ModificationType.SET) continue;
                throw ArgumentExceptionFactory.incompatiblePropertyModification(m);
            }
            lastModTypes.put(propertyName, ModificationType.REMOVE);
            this.modifyPropertyValues(child, pd, changes, ModificationType.REMOVE, value);
        }
        for (String m : this.propertyAddArgument.getValues()) {
            int sep = m.indexOf(58);
            if (sep < 0) {
                throw ArgumentExceptionFactory.missingSeparatorInPropertyArgument(m);
            }
            if (sep == 0) {
                throw ArgumentExceptionFactory.missingNameInPropertyArgument(m);
            }
            propertyName = m.substring(0, sep);
            value = m.substring(sep + 1, m.length());
            if (value.length() == 0) {
                throw ArgumentExceptionFactory.missingValueInPropertyArgument(m);
            }
            try {
                pd = d.getPropertyDefinition(propertyName);
            }
            catch (IllegalArgumentException e) {
                throw ArgumentExceptionFactory.unknownProperty(d, propertyName);
            }
            if (lastModTypes.containsKey(propertyName)) {
                if (lastModTypes.get(propertyName) != ModificationType.SET) continue;
                throw ArgumentExceptionFactory.incompatiblePropertyModification(m);
            }
            lastModTypes.put(propertyName, ModificationType.ADD);
            this.modifyPropertyValues(child, pd, changes, ModificationType.ADD, value);
        }
        for (PropertyDefinition pd3 : changes.keySet()) {
            try {
                child.setPropertyValues(pd3, (Collection)changes.get(pd3));
            }
            catch (PropertyException e) {
                throw ArgumentExceptionFactory.adaptPropertyException(e, d);
            }
        }
        if (this.getConsoleApplication().isInteractive()) {
            TreeSet properties = new TreeSet();
            for (PropertyDefinition<?> pd4 : d.getAllPropertyDefinitions()) {
                if (pd4.hasOption(PropertyOption.HIDDEN) || pd4.hasOption(PropertyOption.READ_ONLY) || pd4.hasOption(PropertyOption.MONITORING) || !this.isAdvancedMode() && pd4.hasOption(PropertyOption.ADVANCED)) continue;
                properties.add(pd4);
            }
            PropertyValueReader reader = new PropertyValueReader(this.getConsoleApplication());
            reader.readAll(child, properties);
        }
        try {
            Message prompt = ToolMessages.INFO_DSCFG_CONFIRM_MODIFY.get(d.getUserFriendlyName());
            if (!this.getConsoleApplication().confirmAction(prompt)) {
                msg = ToolMessages.INFO_DSCFG_CONFIRM_MODIFY_FAIL.get(d.getUserFriendlyName());
                this.getConsoleApplication().printVerboseMessage(msg);
                return 1;
            }
            child.commit();
            msg = ToolMessages.INFO_DSCFG_CONFIRM_MODIFY_SUCCESS.get(d.getUserFriendlyName());
            this.getConsoleApplication().printVerboseMessage(msg);
        }
        catch (MissingMandatoryPropertiesException e) {
            throw ArgumentExceptionFactory.adaptMissingMandatoryPropertiesException(e, d);
        }
        catch (AuthorizationException e) {
            msg = ToolMessages.ERR_DSCFG_ERROR_MODIFY_AUTHZ.get(d.getUserFriendlyName());
            throw new ClientException(50, msg);
        }
        catch (ConcurrentModificationException e) {
            msg = ToolMessages.ERR_DSCFG_ERROR_MODIFY_CME.get(d.getUserFriendlyName());
            throw new ClientException(19, msg);
        }
        catch (OperationRejectedException e) {
            msg = ToolMessages.ERR_DSCFG_ERROR_MODIFY_ORE.get(d.getUserFriendlyName(), e.getMessage());
            throw new ClientException(19, msg);
        }
        catch (CommunicationException e) {
            msg = ToolMessages.ERR_DSCFG_ERROR_MODIFY_CE.get(d.getUserFriendlyName(), e.getMessage());
            throw new ClientException(1, msg);
        }
        catch (ManagedObjectAlreadyExistsException e) {
            throw new IllegalStateException(e);
        }
        return 0;
    }

    private <T> void modifyPropertyValues(ManagedObject<?> mo, PropertyDefinition<T> pd, Map<PropertyDefinition, Set> changes, ModificationType modType, String s) throws ArgumentException {
        SortedSet<T> values = changes.get(pd);
        if (values == null) {
            values = mo.getPropertyValues(pd);
        }
        if (s == null || s.length() == 0) {
            values.clear();
        } else {
            T value;
            try {
                value = pd.decodeValue(s);
            }
            catch (IllegalPropertyValueStringException e) {
                throw ArgumentExceptionFactory.adaptPropertyException(e, mo.getManagedObjectDefinition());
            }
            switch (modType) {
                case ADD: {
                    values.add(value);
                    break;
                }
                case REMOVE: {
                    values.remove(value);
                    break;
                }
                case SET: {
                    values = new TreeSet<T>(pd);
                    values.add(value);
                }
            }
        }
        changes.put(pd, values);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ModificationType {
        ADD,
        REMOVE,
        SET;

    }
}

