/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.dsconfig;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.ConfigurationClient;
import org.opends.server.admin.DefinitionDecodingException;
import org.opends.server.admin.DurationUnit;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.ManagedObjectNotFoundException;
import org.opends.server.admin.ManagedObjectPath;
import org.opends.server.admin.ManagedObjectPathSerializer;
import org.opends.server.admin.OptionalRelationDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyDefinitionUsageBuilder;
import org.opends.server.admin.SingletonRelationDefinition;
import org.opends.server.admin.SizeUnit;
import org.opends.server.admin.Tag;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.IllegalManagedObjectNameException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.ManagedObjectDecodingException;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.tools.ClientException;
import org.opends.server.tools.dsconfig.ArgumentExceptionFactory;
import org.opends.server.tools.dsconfig.ConsoleApplication;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.args.SubCommand;
import org.opends.server.util.table.TabSeparatedTablePrinter;
import org.opends.server.util.table.TablePrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SubCommandHandler {
    private static final String OPTION_DSCFG_LONG_ADVANCED = "advanced";
    private static final String OPTION_DSCFG_LONG_PROPERTY = "property";
    private static final String OPTION_DSCFG_LONG_RECORD = "record";
    private static final String OPTION_DSCFG_LONG_UNIT_SIZE = "unit-size";
    private static final String OPTION_DSCFG_LONG_UNIT_TIME = "unit-time";
    private static final Character OPTION_DSCFG_SHORT_ADVANCED = null;
    private static final Character OPTION_DSCFG_SHORT_PROPERTY = null;
    private static final char OPTION_DSCFG_SHORT_RECORD = 'E';
    private static final char OPTION_DSCFG_SHORT_UNIT_SIZE = 'Z';
    private static final char OPTION_DSCFG_SHORT_UNIT_TIME = 'M';
    private BooleanArgument advancedModeArgument;
    private final ConsoleApplication app;
    private StringArgument propertyArgument;
    private BooleanArgument recordModeArgument;
    private final Set<Tag> tags = new HashSet<Tag>();
    private StringArgument unitSizeArgument;
    private StringArgument unitTimeArgument;

    protected SubCommandHandler(ConsoleApplication app) {
        this.app = app;
    }

    public abstract SubCommand getSubCommand();

    public final Set<Tag> getTags() {
        return this.tags;
    }

    public abstract int run() throws ArgumentException, ClientException;

    public final String toString() {
        return this.getSubCommand().getName();
    }

    protected final void addTags(Collection<Tag> tags) {
        this.tags.addAll(tags);
    }

    protected final void addTags(Tag ... tags) {
        this.addTags(Arrays.asList(tags));
    }

    protected final List<StringArgument> createNamingArgs(SubCommand subCommand, ManagedObjectPath<?, ?> p, boolean isCreate) throws ArgumentException {
        return NamingArgumentBuilder.create(subCommand, p, isCreate);
    }

    protected final TablePrinter createScriptFriendlyTablePrinter(PrintStream stream) {
        return new TabSeparatedTablePrinter(stream);
    }

    protected final ConsoleApplication getConsoleApplication() {
        return this.app;
    }

    protected final ManagedObject<?> getManagedObject(ManagedObjectPath<?, ?> path, List<String> args) throws ArgumentException, AuthorizationException, DefinitionDecodingException, ManagedObjectDecodingException, CommunicationException, ConcurrentModificationException, ManagedObjectNotFoundException, ClientException {
        ManagedObjectFinder finder = new ManagedObjectFinder();
        return finder.find(this.app.getManagementContext(), path, args);
    }

    protected final List<String> getNamingArgValues(List<StringArgument> namingArgs) throws ArgumentException {
        ArrayList<String> values = new ArrayList<String>(namingArgs.size());
        for (StringArgument arg : namingArgs) {
            String value = arg.getValue();
            if (value == null && !this.app.isInteractive()) {
                throw ArgumentExceptionFactory.missingMandatoryNonInteractiveArgument(arg);
            }
            values.add(value);
        }
        return values;
    }

    protected final Set<String> getPropertyNames() {
        if (this.propertyArgument != null) {
            return new LinkedHashSet<String>(this.propertyArgument.getValues());
        }
        return Collections.emptySet();
    }

    protected final SizeUnit getSizeUnit() throws ArgumentException {
        String value;
        if (this.unitSizeArgument != null && (value = this.unitSizeArgument.getValue()) != null) {
            try {
                return SizeUnit.getUnit(value);
            }
            catch (IllegalArgumentException e) {
                Message msg = ToolMessages.INFO_DSCFG_ERROR_SIZE_UNIT_UNRECOGNIZED.get(value);
                throw new ArgumentException(msg);
            }
        }
        return null;
    }

    protected final DurationUnit getTimeUnit() throws ArgumentException {
        String value;
        if (this.unitTimeArgument != null && (value = this.unitTimeArgument.getValue()) != null) {
            try {
                return DurationUnit.getUnit(value);
            }
            catch (IllegalArgumentException e) {
                Message msg = ToolMessages.INFO_DSCFG_ERROR_TIME_UNIT_UNRECOGNIZED.get(value);
                throw new ArgumentException(msg);
            }
        }
        return null;
    }

    protected final boolean isAdvancedMode() {
        if (this.advancedModeArgument != null) {
            return this.advancedModeArgument.isPresent();
        }
        return false;
    }

    protected final boolean isRecordMode() {
        if (this.recordModeArgument != null) {
            return this.recordModeArgument.isPresent();
        }
        return false;
    }

    protected final <C extends ConfigurationClient, S extends Configuration> String readChildName(ManagedObject<?> parent, InstantiableRelationDefinition<C, S> r, AbstractManagedObjectDefinition<? extends C, ? extends S> d) throws AuthorizationException, ConcurrentModificationException, CommunicationException, ArgumentException {
        if (d == null) {
            d = r.getChildDefinition();
        }
        String[] children = parent.listChildren(r, d);
        switch (children.length) {
            case 0: {
                Message msg = ToolMessages.ERR_DSCFG_ERROR_FINDER_NO_CHILDREN.get(d.getUserFriendlyPluralName());
                throw new ArgumentException(msg);
            }
            case 1: {
                Message msg = ToolMessages.INFO_DSCFG_FINDER_PROMPT_SINGLE.get(d.getUserFriendlyName(), children[0]);
                if (this.getConsoleApplication().confirmAction(msg)) {
                    return children[0];
                }
                msg = ToolMessages.ERR_DSCFG_ERROR_FINDER_SINGLE_CHILD_REJECTED.get(d.getUserFriendlyName());
                throw new ArgumentException(msg);
            }
        }
        Arrays.sort(children, String.CASE_INSENSITIVE_ORDER);
        ArrayList<Message> desc = new ArrayList<Message>();
        for (String s : Arrays.asList(children)) {
            desc.add(Message.raw(s, new Object[0]));
        }
        Message prompt = ToolMessages.INFO_DSCFG_FINDER_PROMPT_MANY.get(d.getUserFriendlyName());
        return this.getConsoleApplication().readChoice(prompt, desc, Arrays.asList(children), null);
    }

    protected final void registerAdvancedModeArgument(SubCommand subCommand, Message description) throws ArgumentException {
        this.advancedModeArgument = new BooleanArgument(OPTION_DSCFG_LONG_ADVANCED, OPTION_DSCFG_SHORT_ADVANCED, OPTION_DSCFG_LONG_ADVANCED, description);
        subCommand.addArgument(this.advancedModeArgument);
    }

    protected final void registerPropertyNameArgument(SubCommand subCommand) throws ArgumentException {
        this.propertyArgument = new StringArgument(OPTION_DSCFG_LONG_PROPERTY, OPTION_DSCFG_SHORT_PROPERTY, OPTION_DSCFG_LONG_PROPERTY, false, true, true, "{PROP}", null, null, ToolMessages.INFO_DSCFG_DESCRIPTION_PROP.get());
        subCommand.addArgument(this.propertyArgument);
    }

    protected final void registerRecordModeArgument(SubCommand subCommand) throws ArgumentException {
        this.recordModeArgument = new BooleanArgument(OPTION_DSCFG_LONG_RECORD, Character.valueOf('E'), OPTION_DSCFG_LONG_RECORD, ToolMessages.INFO_DSCFG_DESCRIPTION_RECORD.get());
        subCommand.addArgument(this.recordModeArgument);
    }

    protected final void registerUnitSizeArgument(SubCommand subCommand) throws ArgumentException {
        this.unitSizeArgument = new StringArgument(OPTION_DSCFG_LONG_UNIT_SIZE, Character.valueOf('Z'), OPTION_DSCFG_LONG_UNIT_SIZE, false, true, "{UNIT}", ToolMessages.INFO_DSCFG_DESCRIPTION_UNIT_SIZE.get());
        subCommand.addArgument(this.unitSizeArgument);
    }

    protected final void registerUnitTimeArgument(SubCommand subCommand) throws ArgumentException {
        this.unitTimeArgument = new StringArgument(OPTION_DSCFG_LONG_UNIT_TIME, Character.valueOf('M'), OPTION_DSCFG_LONG_UNIT_TIME, false, true, "{UNIT}", ToolMessages.INFO_DSCFG_DESCRIPTION_UNIT_TIME.get());
        subCommand.addArgument(this.unitTimeArgument);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NamingArgumentBuilder
    implements ManagedObjectPathSerializer {
        private final List<StringArgument> arguments = new LinkedList<StringArgument>();
        private ArgumentException e = null;
        private final boolean isCreate;
        private final SubCommand subCommand;
        private int sz;

        public static List<StringArgument> create(SubCommand subCommand, ManagedObjectPath<?, ?> path, boolean isCreate) throws ArgumentException {
            NamingArgumentBuilder builder = new NamingArgumentBuilder(subCommand, path.size(), isCreate);
            path.serialize(builder);
            if (builder.e != null) {
                throw builder.e;
            }
            return builder.arguments;
        }

        private NamingArgumentBuilder(SubCommand subCommand, int sz, boolean isCreate) {
            this.subCommand = subCommand;
            this.sz = sz;
            this.isCreate = isCreate;
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> void appendManagedObjectPathElement(InstantiableRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d, String name) {
            --this.sz;
            StringBuilder builder = new StringBuilder();
            String s = d.getName();
            int i = s.lastIndexOf(45);
            if (i < 0 || i == s.length() - 1) {
                builder.append(s);
            } else {
                builder.append(s.substring(i + 1));
            }
            builder.append("-name");
            String argName = builder.toString();
            try {
                StringArgument arg;
                if (this.isCreate && this.sz == 0) {
                    PropertyDefinition<?> pd = r.getNamingPropertyDefinition();
                    if (pd != null) {
                        PropertyDefinitionUsageBuilder b = new PropertyDefinitionUsageBuilder(false);
                        String usage = "{" + b.getUsage(pd) + "}";
                        arg = new StringArgument(argName, null, argName, false, true, usage, ToolMessages.INFO_DSCFG_DESCRIPTION_NAME_CREATE_EXT.get(d.getUserFriendlyName(), pd.getName(), pd.getSynopsis()));
                    } else {
                        arg = new StringArgument(argName, null, argName, false, true, "{NAME}", ToolMessages.INFO_DSCFG_DESCRIPTION_NAME_CREATE.get(d.getUserFriendlyName()));
                    }
                } else {
                    arg = new StringArgument(argName, null, argName, false, true, "{NAME}", ToolMessages.INFO_DSCFG_DESCRIPTION_NAME.get(d.getUserFriendlyName()));
                }
                this.subCommand.addArgument(arg);
                this.arguments.add(arg);
            }
            catch (ArgumentException e) {
                this.e = e;
            }
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> void appendManagedObjectPathElement(OptionalRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d) {
            --this.sz;
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> void appendManagedObjectPathElement(SingletonRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d) {
            --this.sz;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ManagedObjectFinder
    implements ManagedObjectPathSerializer {
        private ArgumentException ae;
        private int argIndex;
        private List<String> args;
        private AuthorizationException authze;
        private CommunicationException ce;
        private ConcurrentModificationException cme;
        private DefinitionDecodingException dde;
        private boolean gotException;
        private ManagedObject<?> managedObject;
        private ManagedObjectDecodingException mode;
        private ManagedObjectNotFoundException monfe;

        private ManagedObjectFinder() {
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> void appendManagedObjectPathElement(InstantiableRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d, String name) {
            if (!this.gotException) {
                String childName = this.args.get(this.argIndex++);
                try {
                    if (childName == null) {
                        try {
                            childName = SubCommandHandler.this.readChildName(this.managedObject, r, d);
                        }
                        catch (ArgumentException e) {
                            this.ae = e;
                            this.gotException = true;
                            return;
                        }
                    } else if (childName.trim().length() == 0) {
                        IllegalManagedObjectNameException e = new IllegalManagedObjectNameException(childName);
                        this.ae = ArgumentExceptionFactory.adaptIllegalManagedObjectNameException(e, d);
                        this.gotException = true;
                        return;
                    }
                    ManagedObject<C> child = this.managedObject.getChild(r, childName);
                    if (!child.getManagedObjectDefinition().isChildOf(d)) {
                        this.ae = ArgumentExceptionFactory.wrongManagedObjectType(r, child.getManagedObjectDefinition());
                        this.gotException = true;
                    } else {
                        this.managedObject = child;
                    }
                }
                catch (DefinitionDecodingException e) {
                    this.dde = e;
                    this.gotException = true;
                }
                catch (ManagedObjectDecodingException e) {
                    this.mode = e;
                    this.gotException = true;
                }
                catch (AuthorizationException e) {
                    this.authze = e;
                    this.gotException = true;
                }
                catch (ManagedObjectNotFoundException e) {
                    this.monfe = e;
                    this.gotException = true;
                }
                catch (ConcurrentModificationException e) {
                    this.cme = e;
                    this.gotException = true;
                }
                catch (CommunicationException e) {
                    this.ce = e;
                    this.gotException = true;
                }
            }
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> void appendManagedObjectPathElement(OptionalRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d) {
            if (!this.gotException) {
                try {
                    ManagedObject<C> child = this.managedObject.getChild(r);
                    if (!child.getManagedObjectDefinition().isChildOf(d)) {
                        this.ae = ArgumentExceptionFactory.wrongManagedObjectType(r, child.getManagedObjectDefinition());
                        this.gotException = true;
                    } else {
                        this.managedObject = child;
                    }
                }
                catch (DefinitionDecodingException e) {
                    this.dde = e;
                    this.gotException = true;
                }
                catch (ManagedObjectDecodingException e) {
                    this.mode = e;
                    this.gotException = true;
                }
                catch (AuthorizationException e) {
                    this.authze = e;
                    this.gotException = true;
                }
                catch (ManagedObjectNotFoundException e) {
                    this.monfe = e;
                    this.gotException = true;
                }
                catch (ConcurrentModificationException e) {
                    this.cme = e;
                    this.gotException = true;
                }
                catch (CommunicationException e) {
                    this.ce = e;
                    this.gotException = true;
                }
            }
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> void appendManagedObjectPathElement(SingletonRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d) {
            if (!this.gotException) {
                try {
                    ManagedObject<C> child = this.managedObject.getChild(r);
                    if (!child.getManagedObjectDefinition().isChildOf(d)) {
                        this.ae = ArgumentExceptionFactory.wrongManagedObjectType(r, child.getManagedObjectDefinition());
                        this.gotException = true;
                    } else {
                        this.managedObject = child;
                    }
                }
                catch (DefinitionDecodingException e) {
                    this.dde = e;
                    this.gotException = true;
                }
                catch (ManagedObjectDecodingException e) {
                    this.mode = e;
                    this.gotException = true;
                }
                catch (AuthorizationException e) {
                    this.authze = e;
                    this.gotException = true;
                }
                catch (ManagedObjectNotFoundException e) {
                    this.monfe = e;
                    this.gotException = true;
                }
                catch (ConcurrentModificationException e) {
                    this.cme = e;
                    this.gotException = true;
                }
                catch (CommunicationException e) {
                    this.ce = e;
                    this.gotException = true;
                }
            }
        }

        public ManagedObject<?> find(ManagementContext context, ManagedObjectPath<?, ?> path, List<String> args) throws ArgumentException, CommunicationException, AuthorizationException, ConcurrentModificationException, DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException {
            this.managedObject = context.getRootConfigurationManagedObject();
            this.args = args;
            this.argIndex = 0;
            this.gotException = false;
            this.ae = null;
            this.authze = null;
            this.ce = null;
            this.cme = null;
            this.dde = null;
            this.mode = null;
            this.monfe = null;
            path.serialize(this);
            if (this.ae != null) {
                throw this.ae;
            }
            if (this.authze != null) {
                throw this.authze;
            }
            if (this.ce != null) {
                throw this.ce;
            }
            if (this.cme != null) {
                throw this.cme;
            }
            if (this.dde != null) {
                throw this.dde;
            }
            if (this.mode != null) {
                throw this.mode;
            }
            if (this.monfe != null) {
                throw this.monfe;
            }
            return this.managedObject;
        }
    }
}

