/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.util.List;
import java.util.UUID;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.tools.makeldif.Branch;
import org.opends.server.tools.makeldif.Tag;
import org.opends.server.tools.makeldif.TagResult;
import org.opends.server.tools.makeldif.Template;
import org.opends.server.tools.makeldif.TemplateEntry;
import org.opends.server.tools.makeldif.TemplateFile;
import org.opends.server.tools.makeldif.TemplateValue;
import org.opends.server.types.InitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GUIDTag
extends Tag {
    @Override
    public String getName() {
        return "GUID";
    }

    @Override
    public boolean allowedInBranch() {
        return true;
    }

    @Override
    public void initializeForBranch(TemplateFile templateFile, Branch branch, String[] arguments, int lineNumber, List<Message> warnings) throws InitializationException {
        if (arguments.length != 0) {
            Message message = ToolMessages.ERR_MAKELDIF_TAG_INVALID_ARGUMENT_COUNT.get(this.getName(), lineNumber, 0, arguments.length);
            throw new InitializationException(message);
        }
    }

    @Override
    public void initializeForTemplate(TemplateFile templateFile, Template template, String[] arguments, int lineNumber, List<Message> warnings) throws InitializationException {
        if (arguments.length != 0) {
            Message message = ToolMessages.ERR_MAKELDIF_TAG_INVALID_ARGUMENT_COUNT.get(this.getName(), lineNumber, 0, arguments.length);
            throw new InitializationException(message);
        }
    }

    @Override
    public TagResult generateValue(TemplateEntry templateEntry, TemplateValue templateValue) {
        templateValue.append(UUID.randomUUID().toString());
        return TagResult.SUCCESS_RESULT;
    }
}

