/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.tasks;

import java.io.PrintStream;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.tools.LDAPConnection;
import org.opends.server.tools.LDAPConnectionException;
import org.opends.server.tools.tasks.TaskScheduleInformation;
import org.opends.server.tools.tasks.TaskSchedulingClient;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.LDAPConnectionArgumentParser;

public abstract class TaskTool
implements TaskScheduleInformation {
    protected int process(LDAPConnectionArgumentParser argParser, boolean initializeServer, PrintStream out, PrintStream err) {
        int ret;
        if (argParser.isLdapOperation()) {
            try {
                LDAPConnection conn = argParser.connect(out, err);
                TaskSchedulingClient tc = new TaskSchedulingClient(conn);
                ret = tc.schedule(this, out, err);
            }
            catch (LDAPConnectionException e) {
                Message message = ToolMessages.ERR_LDAP_CONN_CANNOT_CONNECT.get(e.getMessage());
                if (err != null) {
                    err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                }
                ret = 91;
            }
            catch (ArgumentException e) {
                Message message = e.getMessageObject();
                if (err != null) {
                    err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                }
                ret = 89;
            }
        } else {
            ret = this.processLocal(initializeServer, out, err);
        }
        return ret;
    }

    protected abstract int processLocal(boolean var1, PrintStream var2, PrintStream var3);
}

