/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.CancelResult;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.Entry;
import org.opends.server.types.Operation;
import org.opends.server.types.OperationType;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.ResultCode;
import org.opends.server.types.StabilityLevel;
import org.opends.server.types.operation.PostResponseOperation;
import org.opends.server.types.operation.PreParseOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public abstract class AbstractOperation
implements Operation,
PreParseOperation,
PostResponseOperation,
Runnable {
    protected static final List<Control> NO_RESPONSE_CONTROLS = new ArrayList<Control>(0);
    protected final ClientConnection clientConnection;
    protected final int messageID;
    protected final long operationID;
    private boolean isInternalOperation;
    private boolean isSynchronizationOperation;
    private CancelResult cancelResult;
    private DN matchedDN;
    private Entry authorizationEntry;
    private Map<String, Object> attachments;
    private List<Control> requestControls;
    private List<String> referralURLs;
    private ResultCode resultCode;
    private MessageBuilder additionalLogMessage;
    private MessageBuilder errorMessage;
    private boolean dontSynchronizeFlag;
    private long processingStartTime;
    private long processingStopTime;

    protected AbstractOperation(ClientConnection clientConnection, long operationID, int messageID, List<Control> requestControls) {
        this.clientConnection = clientConnection;
        this.operationID = operationID;
        this.messageID = messageID;
        this.requestControls = requestControls == null ? new ArrayList<Control>(0) : requestControls;
        this.resultCode = ResultCode.UNDEFINED;
        this.additionalLogMessage = new MessageBuilder();
        this.errorMessage = new MessageBuilder();
        this.attachments = new HashMap<String, Object>();
        this.matchedDN = null;
        this.referralURLs = null;
        this.cancelResult = null;
        this.isInternalOperation = false;
        this.isSynchronizationOperation = false;
        this.authorizationEntry = clientConnection.getAuthenticationInfo().getAuthorizationEntry();
    }

    @Override
    public abstract OperationType getOperationType();

    @Override
    public abstract void disconnectClient(DisconnectReason var1, boolean var2, Message var3);

    @Override
    public final String[][] getCommonLogElements() {
        return new String[][]{{"connID", String.valueOf(this.getConnectionID())}, {"opID", String.valueOf(this.operationID)}, {"messageID", String.valueOf(this.messageID)}};
    }

    @Override
    public abstract String[][] getRequestLogElements();

    @Override
    public abstract String[][] getResponseLogElements();

    @Override
    public final ClientConnection getClientConnection() {
        return this.clientConnection;
    }

    @Override
    public final long getConnectionID() {
        return this.clientConnection.getConnectionID();
    }

    @Override
    public final long getOperationID() {
        return this.operationID;
    }

    @Override
    public final int getMessageID() {
        return this.messageID;
    }

    @Override
    public final List<Control> getRequestControls() {
        return this.requestControls;
    }

    @Override
    public final void addRequestControl(Control control) {
        this.requestControls.add(control);
    }

    @Override
    public final void removeRequestControl(Control control) {
        this.requestControls.remove(control);
    }

    @Override
    public abstract List<Control> getResponseControls();

    @Override
    public abstract void addResponseControl(Control var1);

    @Override
    public abstract void removeResponseControl(Control var1);

    @Override
    public final ResultCode getResultCode() {
        return this.resultCode;
    }

    @Override
    public final void setResultCode(ResultCode resultCode) {
        this.resultCode = resultCode;
    }

    @Override
    public final MessageBuilder getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public final void setErrorMessage(MessageBuilder errorMessage) {
        this.errorMessage = errorMessage == null ? new MessageBuilder() : errorMessage;
    }

    @Override
    public final void appendErrorMessage(Message message) {
        if (this.errorMessage == null) {
            this.errorMessage = new MessageBuilder(message);
        } else {
            if (this.errorMessage.length() > 0) {
                this.errorMessage.append("  ");
            }
            this.errorMessage.append(message);
        }
    }

    @Override
    public final MessageBuilder getAdditionalLogMessage() {
        return this.additionalLogMessage;
    }

    @Override
    public final void setAdditionalLogMessage(MessageBuilder additionalLogMessage) {
        this.additionalLogMessage = additionalLogMessage == null ? new MessageBuilder() : additionalLogMessage;
    }

    @Override
    public final void appendAdditionalLogMessage(Message message) {
        if (this.additionalLogMessage == null) {
            this.additionalLogMessage = new MessageBuilder(message);
        } else {
            this.additionalLogMessage.append(message);
        }
    }

    @Override
    public final DN getMatchedDN() {
        return this.matchedDN;
    }

    @Override
    public final void setMatchedDN(DN matchedDN) {
        this.matchedDN = matchedDN;
    }

    @Override
    public final List<String> getReferralURLs() {
        return this.referralURLs;
    }

    @Override
    public final void setReferralURLs(List<String> referralURLs) {
        this.referralURLs = referralURLs;
    }

    @Override
    public final void setResponseData(DirectoryException directoryException) {
        this.resultCode = directoryException.getResultCode();
        this.matchedDN = directoryException.getMatchedDN();
        this.referralURLs = directoryException.getReferralURLs();
        this.appendErrorMessage(directoryException.getMessageObject());
    }

    @Override
    public final boolean isInternalOperation() {
        return this.isInternalOperation;
    }

    @Override
    public final void setInternalOperation(boolean isInternalOperation) {
        this.isInternalOperation = isInternalOperation;
    }

    @Override
    public final boolean isSynchronizationOperation() {
        return this.isSynchronizationOperation;
    }

    @Override
    public final void setSynchronizationOperation(boolean isSynchronizationOperation) {
        this.isSynchronizationOperation = isSynchronizationOperation;
    }

    @Override
    public boolean dontSynchronize() {
        return this.dontSynchronizeFlag;
    }

    @Override
    public final void setDontSynchronize(boolean dontSynchronize) {
        this.dontSynchronizeFlag = dontSynchronize;
    }

    @Override
    public final Entry getAuthorizationEntry() {
        return this.authorizationEntry;
    }

    @Override
    public final void setAuthorizationEntry(Entry authorizationEntry) {
        this.authorizationEntry = authorizationEntry;
    }

    @Override
    public final DN getAuthorizationDN() {
        if (this.authorizationEntry == null) {
            return DN.nullDN();
        }
        return this.authorizationEntry.getDN();
    }

    @Override
    public final Map<String, Object> getAttachments() {
        return this.attachments;
    }

    @Override
    public final void setAttachments(Map<String, Object> attachments) {
        this.attachments = attachments;
    }

    @Override
    public final Object getAttachment(String name) {
        return this.attachments.get(name);
    }

    @Override
    public final Object removeAttachment(String name) {
        return this.attachments.remove(name);
    }

    @Override
    public final Object setAttachment(String name, Object value) {
        return this.attachments.put(name, value);
    }

    @Override
    public final void operationCompleted() {
        this.clientConnection.removeOperationInProgress(this.messageID);
    }

    @Override
    public abstract CancelResult cancel(CancelRequest var1);

    @Override
    public abstract boolean setCancelRequest(CancelRequest var1);

    @Override
    public abstract CancelRequest getCancelRequest();

    @Override
    public final CancelResult getCancelResult() {
        return this.cancelResult;
    }

    @Override
    public final void setCancelResult(CancelResult cancelResult) {
        this.cancelResult = cancelResult;
    }

    @Override
    public final void indicateCancelled(CancelRequest cancelRequest) {
        this.setCancelResult(CancelResult.CANCELED);
        if (cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
            this.setResultCode(ResultCode.CANCELED);
            Message cancelReason = cancelRequest.getCancelReason();
            if (cancelReason != null) {
                this.appendErrorMessage(cancelReason);
            }
            this.clientConnection.sendResponse(this);
        }
    }

    @Override
    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    @Override
    public abstract void toString(StringBuilder var1);

    @Override
    public final long getProcessingStartTime() {
        return this.processingStartTime;
    }

    @Override
    public final void setProcessingStartTime() {
        this.processingStartTime = System.currentTimeMillis();
    }

    @Override
    public final long getProcessingStopTime() {
        return this.processingStopTime;
    }

    @Override
    public final void setProcessingStopTime() {
        this.processingStopTime = System.currentTimeMillis();
    }

    @Override
    public final long getProcessingTime() {
        return this.processingStopTime - this.processingStartTime;
    }

    @Override
    public abstract void run();
}

