/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import org.opends.messages.Message;
import org.opends.messages.MessageDescriptor;
import org.opends.messages.UtilityMessages;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public enum AccountStatusNotificationType {
    ACCOUNT_TEMPORARILY_LOCKED(UtilityMessages.INFO_ACCTNOTTYPE_ACCOUNT_TEMPORARILY_LOCKED.get()),
    ACCOUNT_PERMANENTLY_LOCKED(UtilityMessages.INFO_ACCTNOTTYPE_ACCOUNT_PERMANENTLY_LOCKED.get()),
    ACCOUNT_UNLOCKED(UtilityMessages.INFO_ACCTNOTTYPE_ACCOUNT_UNLOCKED.get()),
    ACCOUNT_IDLE_LOCKED(UtilityMessages.INFO_ACCTNOTTYPE_ACCOUNT_IDLE_LOCKED.get()),
    ACCOUNT_RESET_LOCKED(UtilityMessages.INFO_ACCTNOTTYPE_ACCOUNT_RESET_LOCKED.get()),
    ACCOUNT_DISABLED(UtilityMessages.INFO_ACCTNOTTYPE_ACCOUNT_DISABLED.get()),
    ACCOUNT_ENABLED(UtilityMessages.INFO_ACCTNOTTYPE_ACCOUNT_ENABLED.get()),
    ACCOUNT_EXPIRED(UtilityMessages.INFO_ACCTNOTTYPE_ACCOUNT_EXPIRED.get()),
    PASSWORD_EXPIRED(UtilityMessages.INFO_ACCTNOTTYPE_PASSWORD_EXPIRED.get()),
    PASSWORD_EXPIRING(UtilityMessages.INFO_ACCTNOTTYPE_PASSWORD_EXPIRING.get()),
    PASSWORD_RESET(UtilityMessages.INFO_ACCTNOTTYPE_PASSWORD_RESET.get()),
    PASSWORD_CHANGED(UtilityMessages.INFO_ACCTNOTTYPE_PASSWORD_CHANGED.get());

    private Message notificationName;

    private AccountStatusNotificationType(Message notification) {
        this.notificationName = notification;
    }

    public static AccountStatusNotificationType typeForMessage(Message notification) {
        MessageDescriptor md = notification.getDescriptor();
        if (UtilityMessages.INFO_ACCTNOTTYPE_ACCOUNT_TEMPORARILY_LOCKED.equals(md)) {
            return ACCOUNT_TEMPORARILY_LOCKED;
        }
        if (UtilityMessages.INFO_ACCTNOTTYPE_ACCOUNT_PERMANENTLY_LOCKED.equals(md)) {
            return ACCOUNT_PERMANENTLY_LOCKED;
        }
        if (UtilityMessages.INFO_ACCTNOTTYPE_ACCOUNT_UNLOCKED.equals(md)) {
            return ACCOUNT_UNLOCKED;
        }
        if (UtilityMessages.INFO_ACCTNOTTYPE_ACCOUNT_IDLE_LOCKED.equals(md)) {
            return ACCOUNT_IDLE_LOCKED;
        }
        if (UtilityMessages.INFO_ACCTNOTTYPE_ACCOUNT_RESET_LOCKED.equals(md)) {
            return ACCOUNT_RESET_LOCKED;
        }
        if (UtilityMessages.INFO_ACCTNOTTYPE_ACCOUNT_DISABLED.equals(md)) {
            return ACCOUNT_DISABLED;
        }
        if (UtilityMessages.INFO_ACCTNOTTYPE_ACCOUNT_ENABLED.equals(md)) {
            return ACCOUNT_ENABLED;
        }
        if (UtilityMessages.INFO_ACCTNOTTYPE_ACCOUNT_EXPIRED.equals(md)) {
            return ACCOUNT_EXPIRED;
        }
        if (UtilityMessages.INFO_ACCTNOTTYPE_PASSWORD_EXPIRED.equals(md)) {
            return PASSWORD_EXPIRED;
        }
        if (UtilityMessages.INFO_ACCTNOTTYPE_PASSWORD_EXPIRING.equals(md)) {
            return PASSWORD_EXPIRING;
        }
        if (UtilityMessages.INFO_ACCTNOTTYPE_PASSWORD_RESET.equals(md)) {
            return PASSWORD_RESET;
        }
        if (UtilityMessages.INFO_ACCTNOTTYPE_PASSWORD_CHANGED.equals(md)) {
            return PASSWORD_CHANGED;
        }
        return null;
    }

    public static AccountStatusNotificationType typeForName(String name) {
        Message lowerName = Message.raw(StaticUtils.toLowerCase(name), new Object[0]);
        if (lowerName.equals(UtilityMessages.INFO_ACCTNOTTYPE_ACCOUNT_TEMPORARILY_LOCKED.get())) {
            return ACCOUNT_TEMPORARILY_LOCKED;
        }
        if (lowerName.equals(UtilityMessages.INFO_ACCTNOTTYPE_ACCOUNT_PERMANENTLY_LOCKED.get())) {
            return ACCOUNT_PERMANENTLY_LOCKED;
        }
        if (lowerName.equals(UtilityMessages.INFO_ACCTNOTTYPE_ACCOUNT_UNLOCKED.get())) {
            return ACCOUNT_UNLOCKED;
        }
        if (lowerName.equals(UtilityMessages.INFO_ACCTNOTTYPE_ACCOUNT_IDLE_LOCKED.get())) {
            return ACCOUNT_IDLE_LOCKED;
        }
        if (lowerName.equals(UtilityMessages.INFO_ACCTNOTTYPE_ACCOUNT_RESET_LOCKED.get())) {
            return ACCOUNT_RESET_LOCKED;
        }
        if (lowerName.equals(UtilityMessages.INFO_ACCTNOTTYPE_ACCOUNT_DISABLED.get())) {
            return ACCOUNT_DISABLED;
        }
        if (lowerName.equals(UtilityMessages.INFO_ACCTNOTTYPE_ACCOUNT_ENABLED.get())) {
            return ACCOUNT_ENABLED;
        }
        if (lowerName.equals(UtilityMessages.INFO_ACCTNOTTYPE_ACCOUNT_EXPIRED.get())) {
            return ACCOUNT_EXPIRED;
        }
        if (lowerName.equals(UtilityMessages.INFO_ACCTNOTTYPE_PASSWORD_EXPIRED.get())) {
            return PASSWORD_EXPIRED;
        }
        if (lowerName.equals(UtilityMessages.INFO_ACCTNOTTYPE_PASSWORD_EXPIRING.get())) {
            return PASSWORD_EXPIRING;
        }
        if (lowerName.equals(UtilityMessages.INFO_ACCTNOTTYPE_PASSWORD_RESET.get())) {
            return PASSWORD_RESET;
        }
        if (lowerName.equals(UtilityMessages.INFO_ACCTNOTTYPE_PASSWORD_CHANGED.get())) {
            return PASSWORD_CHANGED;
        }
        return null;
    }

    public Message getNotificationName() {
        return this.notificationName;
    }

    public String toString() {
        return String.valueOf(this.getNotificationName());
    }
}

