/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import org.opends.messages.Message;
import org.opends.messages.UtilityMessages;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.DirectoryEnvironmentConfig;
import org.opends.server.types.InitializationException;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public final class EmbeddedUtils {
    public static boolean isRunning() {
        return DirectoryServer.isRunning();
    }

    public static void startServer(DirectoryEnvironmentConfig config) throws ConfigException, InitializationException {
        if (DirectoryServer.isRunning()) {
            throw new InitializationException(UtilityMessages.ERR_EMBEDUTILS_SERVER_ALREADY_RUNNING.get());
        }
        DirectoryServer directoryServer = DirectoryServer.reinitialize(config);
        directoryServer.startServer();
    }

    public static void stopServer(String className, Message reason) {
        DirectoryServer.shutDown(className, reason);
    }

    public static void restartServer(String className, Message reason, DirectoryEnvironmentConfig config) {
        DirectoryServer.restart(className, reason, config);
    }

    public static void initializeForClientUse() {
        DirectoryServer directoryServer = DirectoryServer.getInstance();
        directoryServer.bootstrapClient();
    }
}

