/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opends.server.api.DirectoryThread;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public final class TimeThread
extends DirectoryThread {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final TimeThread threadInstance = new TimeThread();
    private static GregorianCalendar calendar;
    private static CopyOnWriteArrayList<SimpleDateFormat> userDefinedFormatters;
    private static ConcurrentHashMap<String, String> userDefinedTimeStrings;
    private static Date date;
    private static int hourAndMinute;
    private static long time;
    private static SimpleDateFormat generalizedTimeFormatter;
    private static SimpleDateFormat localTimestampFormatter;
    private static SimpleDateFormat gmtTimestampFormatter;
    private static String generalizedTime;
    private static String localTimestamp;
    private static String gmtTimestamp;

    private TimeThread() {
        super("Time Thread");
        this.setDaemon(true);
        userDefinedFormatters = new CopyOnWriteArrayList();
        userDefinedTimeStrings = new ConcurrentHashMap();
        TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");
        generalizedTimeFormatter = new SimpleDateFormat("yyyyMMddHHmmss.SSS'Z'");
        generalizedTimeFormatter.setTimeZone(utcTimeZone);
        gmtTimestampFormatter = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        gmtTimestampFormatter.setTimeZone(utcTimeZone);
        localTimestampFormatter = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss Z");
        calendar = new GregorianCalendar();
        date = calendar.getTime();
        time = date.getTime();
        generalizedTime = generalizedTimeFormatter.format(date);
        localTimestamp = localTimestampFormatter.format(date);
        gmtTimestamp = gmtTimestampFormatter.format(date);
        hourAndMinute = calendar.get(11) * 100 + calendar.get(12);
        this.start();
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    calendar = new GregorianCalendar();
                    date = calendar.getTime();
                    time = date.getTime();
                    generalizedTime = generalizedTimeFormatter.format(date);
                    localTimestamp = localTimestampFormatter.format(date);
                    gmtTimestamp = gmtTimestampFormatter.format(date);
                    hourAndMinute = calendar.get(11) * 100 + calendar.get(12);
                    for (SimpleDateFormat format : userDefinedFormatters) {
                        userDefinedTimeStrings.put(format.toPattern(), format.format(date));
                    }
                    Thread.sleep(200L);
                }
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                continue;
            }
            break;
        }
    }

    public static Calendar getCalendar() {
        return calendar;
    }

    public static Date getDate() {
        return date;
    }

    public static long getTime() {
        return time;
    }

    public static String getGeneralizedTime() {
        return generalizedTime;
    }

    public static String getLocalTime() {
        return localTimestamp;
    }

    public static String getGMTTime() {
        return gmtTimestamp;
    }

    public static int getHourAndMinute() {
        return hourAndMinute;
    }

    public static String getUserDefinedTime(String formatString) throws IllegalArgumentException {
        String timeString = userDefinedTimeStrings.get(formatString);
        if (timeString == null) {
            SimpleDateFormat formatter = new SimpleDateFormat(formatString);
            timeString = formatter.format(date);
            userDefinedTimeStrings.put(formatString, timeString);
            userDefinedFormatters.add(formatter);
        }
        return timeString;
    }

    public static void removeUserDefinedFormatter(String formatString) {
        Iterator<SimpleDateFormat> iterator = userDefinedFormatters.iterator();
        while (iterator.hasNext()) {
            SimpleDateFormat format = iterator.next();
            if (!format.toPattern().equals(formatString)) continue;
            iterator.remove();
        }
        userDefinedTimeStrings.remove(formatString);
    }
}

