/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util.args;

import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.UtilityMessages;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;

public class IntegerArgument
extends Argument {
    private boolean hasLowerBound;
    private boolean hasUpperBound;
    private int lowerBound;
    private int upperBound;

    public IntegerArgument(String name, Character shortIdentifier, String longIdentifier, boolean isRequired, boolean needsValue, String valuePlaceholder, Message description) throws ArgumentException {
        super(name, shortIdentifier, longIdentifier, isRequired, false, needsValue, valuePlaceholder, null, null, description);
        this.hasLowerBound = false;
        this.hasUpperBound = false;
        this.lowerBound = Integer.MIN_VALUE;
        this.upperBound = Integer.MAX_VALUE;
    }

    public IntegerArgument(String name, Character shortIdentifier, String longIdentifier, boolean isRequired, boolean needsValue, String valuePlaceholder, boolean hasLowerBound, int lowerBound, boolean hasUpperBound, int upperBound, Message description) throws ArgumentException {
        super(name, shortIdentifier, longIdentifier, isRequired, false, needsValue, valuePlaceholder, null, null, description);
        this.hasLowerBound = hasLowerBound;
        this.hasUpperBound = hasUpperBound;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        if (hasLowerBound && hasUpperBound && lowerBound > upperBound) {
            Message message = UtilityMessages.ERR_INTARG_LOWER_BOUND_ABOVE_UPPER_BOUND.get(name, lowerBound, upperBound);
            throw new ArgumentException(message);
        }
    }

    public IntegerArgument(String name, Character shortIdentifier, String longIdentifier, boolean isRequired, boolean isMultiValued, boolean needsValue, String valuePlaceholder, int defaultValue, String propertyName, Message description) throws ArgumentException {
        super(name, shortIdentifier, longIdentifier, isRequired, isMultiValued, needsValue, valuePlaceholder, String.valueOf(defaultValue), propertyName, description);
        this.hasLowerBound = false;
        this.hasUpperBound = false;
        this.lowerBound = Integer.MIN_VALUE;
        this.upperBound = Integer.MAX_VALUE;
    }

    public IntegerArgument(String name, Character shortIdentifier, String longIdentifier, boolean isRequired, boolean isMultiValued, boolean needsValue, String valuePlaceholder, int defaultValue, String propertyName, boolean hasLowerBound, int lowerBound, boolean hasUpperBound, int upperBound, Message description) throws ArgumentException {
        super(name, shortIdentifier, longIdentifier, isRequired, isMultiValued, needsValue, valuePlaceholder, String.valueOf(defaultValue), propertyName, description);
        this.hasLowerBound = hasLowerBound;
        this.hasUpperBound = hasUpperBound;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        if (hasLowerBound && hasUpperBound && lowerBound > upperBound) {
            Message message = UtilityMessages.ERR_INTARG_LOWER_BOUND_ABOVE_UPPER_BOUND.get(name, lowerBound, upperBound);
            throw new ArgumentException(message);
        }
    }

    public boolean hasLowerBound() {
        return this.hasLowerBound;
    }

    public int getLowerBound() {
        return this.lowerBound;
    }

    public boolean hasUpperBound() {
        return this.hasUpperBound;
    }

    public int getUpperBound() {
        return this.upperBound;
    }

    public boolean valueIsAcceptable(String valueString, MessageBuilder invalidReason) {
        int intValue;
        try {
            intValue = Integer.parseInt(valueString);
        }
        catch (Exception e) {
            invalidReason.append(UtilityMessages.ERR_ARG_CANNOT_DECODE_AS_INT.get(valueString, this.getName()));
            return false;
        }
        if (this.hasLowerBound && intValue < this.lowerBound) {
            invalidReason.append(UtilityMessages.ERR_INTARG_VALUE_BELOW_LOWER_BOUND.get(this.getName(), intValue, this.lowerBound));
            return false;
        }
        if (this.hasUpperBound && intValue > this.upperBound) {
            invalidReason.append(UtilityMessages.ERR_INTARG_VALUE_ABOVE_UPPER_BOUND.get(this.getName(), intValue, this.upperBound));
            return false;
        }
        return true;
    }
}

