/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util.args;

import java.io.PrintStream;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.tools.LDAPConnection;
import org.opends.server.tools.LDAPConnectionException;
import org.opends.server.tools.LDAPConnectionOptions;
import org.opends.server.tools.SSLConnectionException;
import org.opends.server.tools.SSLConnectionFactory;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;

public class LDAPConnectionArgumentParser
extends ArgumentParser {
    protected BooleanArgument trustAll;
    protected BooleanArgument useSSL;
    protected BooleanArgument useStartTLS;
    protected FileBasedArgument bindPWFile;
    protected FileBasedArgument keyStorePWFile;
    protected FileBasedArgument trustStorePWFile;
    protected IntegerArgument port;
    protected StringArgument bindDN;
    protected StringArgument bindPW;
    protected StringArgument certNickname;
    protected StringArgument host;
    protected StringArgument keyStoreFile;
    protected StringArgument keyStorePW;
    protected StringArgument saslOption;
    protected StringArgument trustStoreFile;
    protected StringArgument trustStorePW;

    public LDAPConnectionArgumentParser(String mainClassName, Message toolDescription, boolean longArgumentsCaseSensitive) {
        super(mainClassName, toolDescription, longArgumentsCaseSensitive);
        this.addLdapConnectionArguments();
    }

    public LDAPConnectionArgumentParser(String mainClassName, Message toolDescription, boolean longArgumentsCaseSensitive, boolean allowsTrailingArguments, int minTrailingArguments, int maxTrailingArguments, String trailingArgsDisplayName) {
        super(mainClassName, toolDescription, longArgumentsCaseSensitive, allowsTrailingArguments, minTrailingArguments, maxTrailingArguments, trailingArgsDisplayName);
        this.addLdapConnectionArguments();
    }

    public boolean isLdapOperation() {
        return this.host.isPresent();
    }

    public LDAPConnection connect(PrintStream out, PrintStream err) throws LDAPConnectionException, ArgumentException {
        if (this.bindPW.isPresent() && this.bindPWFile.isPresent()) {
            Message message = ToolMessages.ERR_LDAP_CONN_MUTUALLY_EXCLUSIVE_ARGUMENTS.get(this.bindPW.getLongIdentifier(), this.bindPWFile.getLongIdentifier());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            throw new ArgumentException(message);
        }
        if (this.keyStorePW.isPresent() && this.keyStorePWFile.isPresent()) {
            Message message = ToolMessages.ERR_LDAP_CONN_MUTUALLY_EXCLUSIVE_ARGUMENTS.get(this.keyStorePW.getLongIdentifier(), this.keyStorePWFile.getLongIdentifier());
            throw new ArgumentException(message);
        }
        if (this.trustStorePW.isPresent() && this.trustStorePWFile.isPresent()) {
            Message message = ToolMessages.ERR_LDAP_CONN_MUTUALLY_EXCLUSIVE_ARGUMENTS.get(this.trustStorePW.getLongIdentifier(), this.trustStorePWFile.getLongIdentifier());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            throw new ArgumentException(message);
        }
        LDAPConnectionOptions connectionOptions = new LDAPConnectionOptions();
        connectionOptions.setVersionNumber(3);
        if (this.useSSL.isPresent()) {
            if (this.useStartTLS.isPresent()) {
                Message message = ToolMessages.ERR_LDAP_CONN_MUTUALLY_EXCLUSIVE_ARGUMENTS.get(this.useSSL.getLongIdentifier(), this.useStartTLS.getLongIdentifier());
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                throw new ArgumentException(message);
            }
            connectionOptions.setUseSSL(true);
        } else if (this.useStartTLS.isPresent()) {
            connectionOptions.setStartTLS(true);
        }
        if (this.useSSL.isPresent() || this.useStartTLS.isPresent()) {
            try {
                String clientAlias = this.certNickname.isPresent() ? this.certNickname.getValue() : null;
                SSLConnectionFactory sslConnectionFactory = new SSLConnectionFactory();
                sslConnectionFactory.init(this.trustAll.isPresent(), this.keyStoreFile.getValue(), this.keyStorePW.getValue(), clientAlias, this.trustStoreFile.getValue(), this.trustStorePW.getValue());
                connectionOptions.setSSLConnectionFactory(sslConnectionFactory);
            }
            catch (SSLConnectionException sce) {
                Message message = ToolMessages.ERR_LDAP_CONN_CANNOT_INITIALIZE_SSL.get(sce.getMessage());
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            }
        }
        if (this.saslOption.isPresent()) {
            String mechanism = null;
            LinkedList<String> options = new LinkedList<String>();
            for (String s : this.saslOption.getValues()) {
                int equalPos = s.indexOf(61);
                if (equalPos <= 0) {
                    Message message = ToolMessages.ERR_LDAP_CONN_CANNOT_PARSE_SASL_OPTION.get(s);
                    err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                    throw new ArgumentException(message);
                }
                String name = s.substring(0, equalPos);
                if (name.equalsIgnoreCase("mech")) {
                    mechanism = s;
                    continue;
                }
                options.add(s);
            }
            if (mechanism == null) {
                Message message = ToolMessages.ERR_LDAP_CONN_NO_SASL_MECHANISM.get();
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                throw new ArgumentException(message);
            }
            connectionOptions.setSASLMechanism(mechanism);
            for (String option : options) {
                connectionOptions.addSASLProperty(option);
            }
        }
        AtomicInteger nextMessageID = new AtomicInteger(1);
        LDAPConnection connection = new LDAPConnection(this.host.getValue(), this.port.getIntValue(), connectionOptions, out, err);
        connection.connectToHost(this.bindDN.getValue(), this.bindPW.getValue(), nextMessageID);
        return connection;
    }

    private void addLdapConnectionArguments() {
        try {
            this.host = new StringArgument("host", Character.valueOf('h'), "hostname", false, false, true, "{host}", "127.0.0.1", null, ToolMessages.INFO_LDAP_CONN_DESCRIPTION_HOST.get());
            this.addArgument(this.host);
            this.port = new IntegerArgument("port", Character.valueOf('p'), "port", false, false, true, "{port}", 389, null, true, 1, true, 65535, ToolMessages.INFO_LDAP_CONN_DESCRIPTION_PORT.get());
            this.addArgument(this.port);
            this.useSSL = new BooleanArgument("usessl", Character.valueOf('Z'), "useSSL", ToolMessages.INFO_LDAP_CONN_DESCRIPTION_USESSL.get());
            this.addArgument(this.useSSL);
            this.useStartTLS = new BooleanArgument("usestarttls", Character.valueOf('q'), "useStartTLS", ToolMessages.INFO_LDAP_CONN_DESCRIPTION_USESTARTTLS.get());
            this.addArgument(this.useStartTLS);
            this.bindDN = new StringArgument("binddn", Character.valueOf('D'), "bindDN", false, false, true, "{bindDN}", null, null, ToolMessages.INFO_LDAP_CONN_DESCRIPTION_BINDDN.get());
            this.addArgument(this.bindDN);
            this.bindPW = new StringArgument("bindpw", Character.valueOf('w'), "bindPassword", false, false, true, "{bindPassword}", null, null, ToolMessages.INFO_LDAP_CONN_DESCRIPTION_BINDPW.get());
            this.addArgument(this.bindPW);
            this.bindPWFile = new FileBasedArgument("bindpwfile", Character.valueOf('j'), "bindPasswordFile", false, false, "{bindPasswordFile}", null, null, ToolMessages.INFO_LDAP_CONN_DESCRIPTION_BINDPWFILE.get());
            this.addArgument(this.bindPWFile);
            this.saslOption = new StringArgument("sasloption", Character.valueOf('o'), "saslOption", false, true, true, "{name=value}", null, null, ToolMessages.INFO_LDAP_CONN_DESCRIPTION_SASLOPTIONS.get());
            this.addArgument(this.saslOption);
            this.trustAll = new BooleanArgument("trustall", Character.valueOf('X'), "trustAll", ToolMessages.INFO_LDAP_CONN_DESCRIPTION_TRUST_ALL.get());
            this.addArgument(this.trustAll);
            this.keyStoreFile = new StringArgument("keystorefile", Character.valueOf('K'), "keyStorePath", false, false, true, "{keyStorePath}", null, null, ToolMessages.INFO_LDAP_CONN_DESCRIPTION_KSFILE.get());
            this.addArgument(this.keyStoreFile);
            this.keyStorePW = new StringArgument("keystorepw", Character.valueOf('W'), "keyStorePassword", false, false, true, "{keyStorePassword}", null, null, ToolMessages.INFO_LDAP_CONN_DESCRIPTION_KSPW.get());
            this.addArgument(this.keyStorePW);
            this.keyStorePWFile = new FileBasedArgument("keystorepwfile", Character.valueOf('u'), "keyStorePasswordFile", false, false, "{path}", null, null, ToolMessages.INFO_LDAP_CONN_DESCRIPTION_KSPWFILE.get());
            this.addArgument(this.keyStorePWFile);
            this.certNickname = new StringArgument("certnickname", Character.valueOf('N'), "certNickname", false, false, true, "{nickname}", null, null, ToolMessages.INFO_DESCRIPTION_CERT_NICKNAME.get());
            this.addArgument(this.certNickname);
            this.trustStoreFile = new StringArgument("truststorefile", Character.valueOf('P'), "trustStorePath", false, false, true, "{trustStorePath}", null, null, ToolMessages.INFO_LDAP_CONN_DESCRIPTION_TSFILE.get());
            this.addArgument(this.trustStoreFile);
            this.trustStorePW = new StringArgument("truststorepw", Character.valueOf('T'), "trustStorePassword", false, false, true, "{trustStorePassword}", null, null, ToolMessages.INFO_LDAP_CONN_DESCRIPTION_TSPW.get());
            this.addArgument(this.trustStorePW);
            this.trustStorePWFile = new FileBasedArgument("truststorepwfile", Character.valueOf('U'), "TrustStorePasswordFile", false, false, "{path}", null, null, ToolMessages.INFO_LDAP_CONN_DESCRIPTION_TSPWFILE.get());
            this.addArgument(this.trustStorePWFile);
        }
        catch (ArgumentException argumentException) {
            // empty catch block
        }
    }
}

