/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util.table;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.table.TablePrinter;
import org.opends.server.util.table.TableSerializer;

public final class TextTablePrinter
extends TablePrinter {
    private static final String DEFAULT_COLUMN_SEPARATOR = "";
    private static final char DEFAULT_HEADING_SEPARATOR = '-';
    private static final int DEFAULT_PADDING = 1;
    private String columnSeparator = "";
    private boolean displayHeadings = true;
    private final Map<Integer, Integer> fixedColumns = new HashMap<Integer, Integer>();
    private char headingSeparator = (char)45;
    private int padding = 1;
    private int totalWidth = ServerConstants.MAX_LINE_WIDTH;
    private PrintWriter writer = null;

    public TextTablePrinter(OutputStream stream) {
        this(new BufferedWriter(new OutputStreamWriter(stream)));
    }

    public TextTablePrinter(Writer writer) {
        this.writer = new PrintWriter(writer);
    }

    public final void setColumnSeparator(String columnSeparator) {
        this.columnSeparator = columnSeparator;
    }

    public final void setColumnWidth(int column, int width) throws IllegalArgumentException {
        if (column < 0) {
            throw new IllegalArgumentException("Negative column " + column);
        }
        if (width < 0) {
            throw new IllegalArgumentException("Negative width " + width);
        }
        this.fixedColumns.put(column, width);
    }

    public final void setDisplayHeadings(boolean displayHeadings) {
        this.displayHeadings = displayHeadings;
    }

    public final void setHeadingSeparator(char headingSeparator) {
        this.headingSeparator = headingSeparator;
    }

    public final void setPadding(int padding) {
        this.padding = padding;
    }

    public final void setTotalWidth(int totalWidth) {
        this.totalWidth = totalWidth;
    }

    protected TableSerializer getSerializer() {
        return new Serializer(this.writer, this.columnSeparator, this.fixedColumns, this.displayHeadings, this.headingSeparator, this.padding, this.totalWidth);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Serializer
    extends TableSerializer {
        private int column = 0;
        private final String columnSeparator;
        private final List<Integer> columnWidths = new ArrayList<Integer>();
        private final List<String> currentRow = new ArrayList<String>();
        private final boolean displayHeadings;
        private final Map<Integer, Integer> fixedColumns;
        private final char headingSeparator;
        private final int padding;
        private int totalColumns = 0;
        private final int totalWidth;
        private final PrintWriter writer;

        private Serializer(PrintWriter writer, String columnSeparator, Map<Integer, Integer> fixedColumns, boolean displayHeadings, char headingSeparator, int padding, int totalWidth) {
            this.writer = writer;
            this.columnSeparator = columnSeparator;
            this.fixedColumns = new HashMap<Integer, Integer>(fixedColumns);
            this.displayHeadings = displayHeadings;
            this.headingSeparator = headingSeparator;
            this.padding = padding;
            this.totalWidth = totalWidth;
        }

        @Override
        public void addCell(String s) {
            this.currentRow.add(s);
            ++this.column;
        }

        @Override
        public void addColumn(int width) {
            this.columnWidths.add(width);
            ++this.totalColumns;
        }

        @Override
        public void addHeading(String s) {
            if (this.displayHeadings) {
                this.addCell(s);
            }
        }

        @Override
        public void endHeader() {
            if (this.displayHeadings) {
                this.endRow();
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < this.totalColumns; ++i) {
                    int width = this.columnWidths.get(i);
                    if (this.totalColumns > 1) {
                        width = i == 0 || i == this.totalColumns - 1 ? (width += this.padding) : (width += this.padding * 2);
                    }
                    for (int j = 0; j < width; ++j) {
                        builder.append(this.headingSeparator);
                    }
                    if (i >= this.totalColumns - 1) continue;
                    builder.append(this.columnSeparator);
                }
                this.writer.println(builder.toString());
            }
        }

        @Override
        public void endRow() {
            boolean isRemainingText;
            do {
                isRemainingText = false;
                for (int i = 0; i < this.currentRow.size(); ++i) {
                    int j;
                    String head;
                    int width = this.columnWidths.get(i);
                    String contents = this.currentRow.get(i);
                    String tail = null;
                    if (contents == null) {
                        head = TextTablePrinter.DEFAULT_COLUMN_SEPARATOR;
                    } else if (contents.length() > width) {
                        int endIndex = contents.lastIndexOf(32, width);
                        if (endIndex == -1) {
                            head = contents.substring(0, width);
                            tail = contents.substring(width);
                        } else {
                            head = contents.substring(0, endIndex);
                            tail = contents.substring(endIndex + 1);
                        }
                    } else {
                        head = contents;
                    }
                    StringBuilder builder = new StringBuilder();
                    if (i > 0) {
                        for (j = 0; j < this.padding; ++j) {
                            builder.append(' ');
                        }
                        builder.append(this.columnSeparator);
                        for (j = 0; j < this.padding; ++j) {
                            builder.append(' ');
                        }
                    }
                    builder.append(head);
                    for (j = head.length(); j < width; ++j) {
                        builder.append(' ');
                    }
                    this.writer.print(builder.toString());
                    this.currentRow.set(i, tail);
                    if (tail == null) continue;
                    isRemainingText = true;
                }
                this.writer.println();
            } while (isRemainingText);
        }

        @Override
        public void endTable() {
            this.writer.flush();
        }

        @Override
        public void startHeader() {
            this.determineColumnWidths();
            this.column = 0;
            this.currentRow.clear();
        }

        @Override
        public void startRow() {
            this.column = 0;
            this.currentRow.clear();
        }

        private void determineColumnWidths() {
            int available;
            int minWidth = 0;
            int expandableColumnSize = 0;
            for (int i = 0; i < this.totalColumns; ++i) {
                int actualSize = this.columnWidths.get(i);
                if (this.fixedColumns.containsKey(i)) {
                    int requestedSize = this.fixedColumns.get(i);
                    if (requestedSize == 0) {
                        expandableColumnSize += actualSize;
                    } else {
                        this.columnWidths.set(i, requestedSize);
                        minWidth += requestedSize;
                    }
                } else {
                    minWidth += actualSize;
                }
                if (i <= 0) continue;
                minWidth += this.padding * 2 + this.columnSeparator.length();
            }
            if (minWidth <= this.totalWidth && expandableColumnSize > (available = this.totalWidth - minWidth)) {
                for (int i = 0; i < this.totalColumns; ++i) {
                    int requestedSize;
                    int actualSize = this.columnWidths.get(i);
                    if (!this.fixedColumns.containsKey(i) || (requestedSize = this.fixedColumns.get(i).intValue()) != 0) continue;
                    requestedSize = actualSize * available / expandableColumnSize;
                    this.columnWidths.set(i, requestedSize);
                }
            }
        }
    }
}

