/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.workflowelement.localbackend;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.std.server.PasswordValidatorCfg;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.api.PasswordValidator;
import org.opends.server.controls.PasswordPolicyErrorType;
import org.opends.server.controls.PasswordPolicyResponseControl;
import org.opends.server.core.AddOperation;
import org.opends.server.core.AddOperationWrapper;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PasswordPolicy;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.schema.AuthPasswordSyntax;
import org.opends.server.schema.BooleanSyntax;
import org.opends.server.schema.UserPasswordSyntax;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.ResultCode;
import org.opends.server.types.operation.PostOperationAddOperation;
import org.opends.server.types.operation.PostResponseAddOperation;
import org.opends.server.types.operation.PreOperationAddOperation;
import org.opends.server.util.TimeThread;
import org.opends.server.workflowelement.localbackend.LocalBackendWorkflowElement;

public class LocalBackendAddOperation
extends AddOperationWrapper
implements PreOperationAddOperation,
PostOperationAddOperation,
PostResponseAddOperation {
    private Entry entry;

    public LocalBackendAddOperation(AddOperation add) {
        super(add);
        LocalBackendWorkflowElement.attachLocalOperation(add, this);
    }

    public final Entry getEntryToAdd() {
        return this.entry;
    }

    public final void setEntryToAdd(Entry entry) {
        this.entry = entry;
    }

    public final void handlePasswordPolicy(PasswordPolicy passwordPolicy, Entry userEntry) throws DirectoryException {
        AttributeType passwordAttribute = passwordPolicy.getPasswordAttribute();
        List<Attribute> attrList = userEntry.getAttribute(passwordAttribute);
        if (attrList == null || attrList.isEmpty()) {
            return;
        }
        if (attrList.size() > 1) {
            Message message = CoreMessages.ERR_PWPOLICY_ATTRIBUTE_OPTIONS_NOT_ALLOWED.get(passwordAttribute.getNameOrOID());
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        Attribute passwordAttr = attrList.get(0);
        if (passwordAttr.hasOptions()) {
            Message message = CoreMessages.ERR_PWPOLICY_ATTRIBUTE_OPTIONS_NOT_ALLOWED.get(passwordAttribute.getNameOrOID());
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        LinkedHashSet<AttributeValue> values = passwordAttr.getValues();
        if (values.isEmpty()) {
            return;
        }
        if (!passwordPolicy.allowMultiplePasswordValues() && values.size() > 1) {
            this.addPWPolicyControl(PasswordPolicyErrorType.PASSWORD_MOD_NOT_ALLOWED);
            Message message = CoreMessages.ERR_PWPOLICY_MULTIPLE_PW_VALUES_NOT_ALLOWED.get(passwordAttribute.getNameOrOID());
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        CopyOnWriteArrayList<PasswordStorageScheme> defaultStorageSchemes = passwordPolicy.getDefaultStorageSchemes();
        LinkedHashSet<AttributeValue> newValues = new LinkedHashSet<AttributeValue>(defaultStorageSchemes.size());
        for (AttributeValue v : values) {
            ByteString encodedValue;
            Message message;
            ByteString value = v.getValue();
            if (passwordPolicy.usesAuthPasswordSyntax()) {
                if (AuthPasswordSyntax.isEncoded(value)) {
                    if (passwordPolicy.allowPreEncodedPasswords()) {
                        newValues.add(v);
                        continue;
                    }
                    this.addPWPolicyControl(PasswordPolicyErrorType.INSUFFICIENT_PASSWORD_QUALITY);
                    message = CoreMessages.ERR_PWPOLICY_PREENCODED_NOT_ALLOWED.get(passwordAttribute.getNameOrOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                }
            } else if (UserPasswordSyntax.isEncoded(value)) {
                if (passwordPolicy.allowPreEncodedPasswords()) {
                    newValues.add(v);
                    continue;
                }
                this.addPWPolicyControl(PasswordPolicyErrorType.INSUFFICIENT_PASSWORD_QUALITY);
                message = CoreMessages.ERR_PWPOLICY_PREENCODED_NOT_ALLOWED.get(passwordAttribute.getNameOrOID());
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
            }
            if (!passwordPolicy.skipValidationForAdministrators()) {
                HashSet<ByteString> currentPasswords = new HashSet<ByteString>(0);
                MessageBuilder invalidReason = new MessageBuilder();
                for (PasswordValidator<? extends PasswordValidatorCfg> validator : passwordPolicy.getPasswordValidators().values()) {
                    if (validator.passwordIsAcceptable(value, currentPasswords, this, userEntry, invalidReason)) continue;
                    this.addPWPolicyControl(PasswordPolicyErrorType.INSUFFICIENT_PASSWORD_QUALITY);
                    Message message2 = CoreMessages.ERR_PWPOLICY_VALIDATION_FAILED.get(passwordAttribute.getNameOrOID(), String.valueOf(invalidReason));
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message2);
                }
            }
            if (passwordPolicy.usesAuthPasswordSyntax()) {
                for (PasswordStorageScheme s : defaultStorageSchemes) {
                    encodedValue = s.encodeAuthPassword(value);
                    newValues.add(new AttributeValue(passwordAttribute, encodedValue));
                }
                continue;
            }
            for (PasswordStorageScheme s : defaultStorageSchemes) {
                encodedValue = s.encodePasswordWithScheme(value);
                newValues.add(new AttributeValue(passwordAttribute, encodedValue));
            }
        }
        passwordAttr.setValues(newValues);
        ASN1OctetString timeString = new ASN1OctetString(TimeThread.getGeneralizedTime());
        AttributeType changedTimeType = DirectoryServer.getAttributeType("pwdchangedtime");
        if (changedTimeType == null) {
            changedTimeType = DirectoryServer.getDefaultAttributeType("pwdChangedTime");
        }
        LinkedHashSet<AttributeValue> changedTimeValues = new LinkedHashSet<AttributeValue>(1);
        changedTimeValues.add(new AttributeValue(changedTimeType, (ByteString)timeString));
        ArrayList<Attribute> changedTimeList = new ArrayList<Attribute>(1);
        changedTimeList.add(new Attribute(changedTimeType, "pwdChangedTime", changedTimeValues));
        userEntry.putAttribute(changedTimeType, changedTimeList);
        if (passwordPolicy.forceChangeOnAdd()) {
            this.addPWPolicyControl(PasswordPolicyErrorType.CHANGE_AFTER_RESET);
            AttributeType resetType = DirectoryServer.getAttributeType("pwdreset");
            if (resetType == null) {
                resetType = DirectoryServer.getDefaultAttributeType("pwdReset");
            }
            LinkedHashSet<AttributeValue> resetValues = new LinkedHashSet<AttributeValue>(1);
            resetValues.add(BooleanSyntax.createBooleanValue(true));
            ArrayList<Attribute> resetList = new ArrayList<Attribute>(1);
            resetList.add(new Attribute(resetType, "pwdReset", resetValues));
            userEntry.putAttribute(resetType, resetList);
        }
    }

    private void addPWPolicyControl(PasswordPolicyErrorType errorType) {
        for (Control c : this.getRequestControls()) {
            if (!c.getOID().equals("1.3.6.1.4.1.42.2.27.8.5.1")) continue;
            this.addResponseControl(new PasswordPolicyResponseControl(null, 0, errorType));
        }
    }

    public final void addObjectClassChain(ObjectClass objectClass) {
        Map<ObjectClass, String> objectClasses = this.getObjectClasses();
        if (objectClasses != null) {
            ObjectClass superiorClass;
            if (!objectClasses.containsKey(objectClass)) {
                objectClasses.put(objectClass, objectClass.getNameOrOID());
            }
            if ((superiorClass = objectClass.getSuperiorClass()) != null && !objectClasses.containsKey(superiorClass)) {
                this.addObjectClassChain(superiorClass);
            }
        }
    }
}

