/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.workflowelement.localbackend;

import java.util.ArrayList;
import java.util.List;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.std.meta.PasswordPolicyCfgDefn;
import org.opends.server.api.Backend;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.plugin.PostOperationPluginResult;
import org.opends.server.api.plugin.PreOperationPluginResult;
import org.opends.server.controls.AuthorizationIdentityResponseControl;
import org.opends.server.controls.LDAPAssertionRequestControl;
import org.opends.server.controls.MatchedValuesControl;
import org.opends.server.controls.PasswordExpiredControl;
import org.opends.server.controls.PasswordExpiringControl;
import org.opends.server.controls.PasswordPolicyErrorType;
import org.opends.server.controls.PasswordPolicyResponseControl;
import org.opends.server.controls.PasswordPolicyWarningType;
import org.opends.server.controls.PersistentSearchControl;
import org.opends.server.controls.ProxiedAuthV1Control;
import org.opends.server.controls.ProxiedAuthV2Control;
import org.opends.server.core.AccessControlConfigManager;
import org.opends.server.core.AddOperation;
import org.opends.server.core.BindOperation;
import org.opends.server.core.CompareOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.PasswordPolicyState;
import org.opends.server.core.PersistentSearch;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.AccessLogger;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AccountStatusNotificationType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.CancelResult;
import org.opends.server.types.CancelledOperationException;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.LDAPException;
import org.opends.server.types.LockManager;
import org.opends.server.types.Operation;
import org.opends.server.types.Privilege;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.WritabilityMode;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;
import org.opends.server.workflowelement.LeafWorkflowElement;
import org.opends.server.workflowelement.localbackend.LocalBackendAddOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendBindOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendCompareOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendDeleteOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendModifyDNOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendModifyOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendSearchOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalBackendWorkflowElement
extends LeafWorkflowElement {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    Backend backend;

    public LocalBackendWorkflowElement(String workflowElementID, Backend backend) {
        super(workflowElementID);
        this.backend = backend;
        if (this.backend != null) {
            this.isPrivate = this.backend.isPrivateBackend();
        }
    }

    @Override
    public void execute(Operation operation) {
        switch (operation.getOperationType()) {
            case BIND: {
                this.processBind((BindOperation)operation);
                break;
            }
            case SEARCH: {
                this.processSearch((SearchOperation)operation);
                break;
            }
            case ADD: {
                this.processAdd((AddOperation)operation);
                break;
            }
            case DELETE: {
                this.processDelete((DeleteOperation)operation);
                break;
            }
            case MODIFY: {
                this.processModify((ModifyOperation)operation);
                break;
            }
            case MODIFY_DN: {
                this.processModifyDN((ModifyDNOperation)operation);
                break;
            }
            case COMPARE: {
                this.processCompare((CompareOperation)operation);
                break;
            }
            case ABANDON: {
                break;
            }
            default: {
                Validator.ensureTrue(false);
            }
        }
    }

    public void processModify(ModifyOperation operation) {
        LocalBackendModifyOperation localOperation = new LocalBackendModifyOperation(operation);
        this.processLocalModify(localOperation);
    }

    /*
     * Exception decompiling
     */
    private void processLocalModify(LocalBackendModifyOperation localOp) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 417[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processSearch(SearchOperation operation) {
        PostOperationPluginResult postOperationResult;
        boolean skipPostOperation;
        PluginConfigManager pluginConfigManager;
        LocalBackendSearchOperation localOp;
        block81: {
            localOp = new LocalBackendSearchOperation(operation);
            PersistentSearch persistentSearch = null;
            ClientConnection clientConnection = localOp.getClientConnection();
            pluginConfigManager = DirectoryServer.getPluginConfigManager();
            skipPostOperation = false;
            DN baseDN = localOp.getBaseDN();
            SearchFilter filter = localOp.getFilter();
            if (baseDN != null && filter != null) {
                boolean processSearch = true;
                List<Control> requestControls = localOp.getRequestControls();
                if (requestControls != null && !requestControls.isEmpty()) {
                    for (int i = 0; i < requestControls.size(); ++i) {
                        Entry authorizationEntry;
                        Control proxyControl;
                        Control c = requestControls.get(i);
                        String oid = c.getOID();
                        if (!AccessControlConfigManager.getInstance().getAccessControlHandler().isAllowed(baseDN, localOp, c)) {
                            localOp.setResultCode(ResultCode.INSUFFICIENT_ACCESS_RIGHTS);
                            localOp.appendErrorMessage(CoreMessages.ERR_CONTROL_INSUFFICIENT_ACCESS_RIGHTS.get(oid));
                            skipPostOperation = true;
                            break block81;
                        }
                        if (oid.equals("1.3.6.1.1.12")) {
                            LDAPAssertionRequestControl assertControl;
                            if (c instanceof LDAPAssertionRequestControl) {
                                assertControl = (LDAPAssertionRequestControl)c;
                            } else {
                                try {
                                    assertControl = LDAPAssertionRequestControl.decodeControl(c);
                                    requestControls.set(i, assertControl);
                                }
                                catch (LDAPException le) {
                                    if (DebugLogger.debugEnabled()) {
                                        TRACER.debugCaught(DebugLogLevel.ERROR, le);
                                    }
                                    localOp.setResultCode(ResultCode.valueOf(le.getResultCode()));
                                    localOp.appendErrorMessage(le.getMessageObject());
                                    break block81;
                                }
                            }
                            try {
                                Entry entry;
                                SearchFilter assertionFilter = assertControl.getSearchFilter();
                                try {
                                    entry = DirectoryServer.getEntry(baseDN);
                                }
                                catch (DirectoryException de) {
                                    if (DebugLogger.debugEnabled()) {
                                        TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                    }
                                    localOp.setResultCode(de.getResultCode());
                                    localOp.appendErrorMessage(CoreMessages.ERR_SEARCH_CANNOT_GET_ENTRY_FOR_ASSERTION.get(de.getMessageObject()));
                                    break block81;
                                }
                                if (entry == null) {
                                    localOp.setResultCode(ResultCode.NO_SUCH_OBJECT);
                                    localOp.appendErrorMessage(CoreMessages.ERR_SEARCH_NO_SUCH_ENTRY_FOR_ASSERTION.get());
                                    break block81;
                                }
                                if (assertionFilter.matchesEntry(entry)) continue;
                                localOp.setResultCode(ResultCode.ASSERTION_FAILED);
                                localOp.appendErrorMessage(CoreMessages.ERR_SEARCH_ASSERTION_FAILED.get());
                            }
                            catch (DirectoryException de) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                }
                                localOp.setResultCode(ResultCode.PROTOCOL_ERROR);
                                localOp.appendErrorMessage(CoreMessages.ERR_SEARCH_CANNOT_PROCESS_ASSERTION_FILTER.get(de.getMessageObject()));
                            }
                            break block81;
                        }
                        if (oid.equals("2.16.840.1.113730.3.4.12")) {
                            if (!clientConnection.hasPrivilege(Privilege.PROXIED_AUTH, localOp)) {
                                localOp.appendErrorMessage(CoreMessages.ERR_PROXYAUTH_INSUFFICIENT_PRIVILEGES.get());
                                localOp.setResultCode(ResultCode.AUTHORIZATION_DENIED);
                                break block81;
                            }
                            if (c instanceof ProxiedAuthV1Control) {
                                proxyControl = (ProxiedAuthV1Control)c;
                            } else {
                                try {
                                    proxyControl = ProxiedAuthV1Control.decodeControl(c);
                                }
                                catch (LDAPException le) {
                                    if (DebugLogger.debugEnabled()) {
                                        TRACER.debugCaught(DebugLogLevel.ERROR, le);
                                    }
                                    localOp.setResultCode(ResultCode.valueOf(le.getResultCode()));
                                    localOp.appendErrorMessage(le.getMessageObject());
                                    break block81;
                                }
                            }
                            try {
                                authorizationEntry = ((ProxiedAuthV1Control)proxyControl).getAuthorizationEntry();
                            }
                            catch (DirectoryException de) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                }
                                localOp.setResultCode(de.getResultCode());
                                localOp.appendErrorMessage(de.getMessageObject());
                                break block81;
                            }
                            localOp.setAuthorizationEntry(authorizationEntry);
                            if (authorizationEntry == null) {
                                localOp.setProxiedAuthorizationDN(DN.nullDN());
                                continue;
                            }
                            localOp.setProxiedAuthorizationDN(authorizationEntry.getDN());
                            continue;
                        }
                        if (oid.equals("2.16.840.1.113730.3.4.18")) {
                            if (!clientConnection.hasPrivilege(Privilege.PROXIED_AUTH, localOp)) {
                                localOp.appendErrorMessage(CoreMessages.ERR_PROXYAUTH_INSUFFICIENT_PRIVILEGES.get());
                                localOp.setResultCode(ResultCode.AUTHORIZATION_DENIED);
                                break block81;
                            }
                            if (c instanceof ProxiedAuthV2Control) {
                                proxyControl = (ProxiedAuthV2Control)c;
                            } else {
                                try {
                                    proxyControl = ProxiedAuthV2Control.decodeControl(c);
                                }
                                catch (LDAPException le) {
                                    if (DebugLogger.debugEnabled()) {
                                        TRACER.debugCaught(DebugLogLevel.ERROR, le);
                                    }
                                    localOp.setResultCode(ResultCode.valueOf(le.getResultCode()));
                                    localOp.appendErrorMessage(le.getMessageObject());
                                    break block81;
                                }
                            }
                            try {
                                authorizationEntry = ((ProxiedAuthV2Control)proxyControl).getAuthorizationEntry();
                            }
                            catch (DirectoryException de) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                }
                                localOp.setResultCode(de.getResultCode());
                                localOp.appendErrorMessage(de.getMessageObject());
                                break block81;
                            }
                            localOp.setAuthorizationEntry(authorizationEntry);
                            if (authorizationEntry == null) {
                                localOp.setProxiedAuthorizationDN(DN.nullDN());
                                continue;
                            }
                            localOp.setProxiedAuthorizationDN(authorizationEntry.getDN());
                            continue;
                        }
                        if (oid.equals("2.16.840.1.113730.3.4.3")) {
                            PersistentSearchControl psearchControl;
                            if (c instanceof PersistentSearchControl) {
                                psearchControl = (PersistentSearchControl)c;
                            } else {
                                try {
                                    psearchControl = PersistentSearchControl.decodeControl(c);
                                }
                                catch (LDAPException le) {
                                    if (DebugLogger.debugEnabled()) {
                                        TRACER.debugCaught(DebugLogLevel.ERROR, le);
                                    }
                                    localOp.setResultCode(ResultCode.valueOf(le.getResultCode()));
                                    localOp.appendErrorMessage(le.getMessageObject());
                                    break block81;
                                }
                            }
                            persistentSearch = new PersistentSearch(operation, psearchControl.getChangeTypes(), psearchControl.getReturnECs());
                            localOp.setPersistentSearch(persistentSearch);
                            if (!psearchControl.getChangesOnly()) continue;
                            processSearch = false;
                            continue;
                        }
                        if (oid.equals("1.3.6.1.4.1.7628.5.101.1")) {
                            localOp.setReturnLDAPSubentries(true);
                            continue;
                        }
                        if (oid.equals("1.2.826.0.1.3344810.2.3")) {
                            if (c instanceof MatchedValuesControl) {
                                localOp.setMatchedValuesControl((MatchedValuesControl)c);
                                continue;
                            }
                            try {
                                MatchedValuesControl matchedValuesControl = MatchedValuesControl.decodeControl(c);
                                localOp.setMatchedValuesControl(matchedValuesControl);
                                continue;
                            }
                            catch (LDAPException le) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, le);
                                }
                                localOp.setResultCode(ResultCode.valueOf(le.getResultCode()));
                                localOp.appendErrorMessage(le.getMessageObject());
                                break block81;
                            }
                        } else {
                            if (oid.equals("1.3.6.1.4.1.42.2.27.9.5.8")) {
                                localOp.setIncludeUsableControl(true);
                                continue;
                            }
                            if (oid.equals("2.16.840.1.113730.3.4.17")) {
                                localOp.setRealAttributesOnly(true);
                                continue;
                            }
                            if (oid.equals("2.16.840.1.113730.3.4.19")) {
                                localOp.setVirtualAttributesOnly(true);
                                continue;
                            }
                            if (!c.isCritical() || this.backend != null && this.backend.supportsControl(oid)) continue;
                            localOp.setResultCode(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION);
                            localOp.appendErrorMessage(CoreMessages.ERR_SEARCH_UNSUPPORTED_CRITICAL_CONTROL.get(oid));
                        }
                        break block81;
                    }
                }
                if (!AccessControlConfigManager.getInstance().getAccessControlHandler().isAllowed(localOp)) {
                    localOp.setResultCode(ResultCode.INSUFFICIENT_ACCESS_RIGHTS);
                    localOp.appendErrorMessage(CoreMessages.ERR_SEARCH_AUTHZ_INSUFFICIENT_ACCESS_RIGHTS.get(String.valueOf(baseDN)));
                    skipPostOperation = true;
                } else {
                    if (localOp.getCancelRequest() != null) {
                        return;
                    }
                    PreOperationPluginResult preOpResult = pluginConfigManager.invokePreOperationSearchPlugins(localOp);
                    if (preOpResult.connectionTerminated()) {
                        localOp.setResultCode(ResultCode.CANCELED);
                        localOp.appendErrorMessage(CoreMessages.ERR_CANCELED_BY_PREOP_DISCONNECT.get());
                        localOp.setProcessingStopTime();
                        return;
                    }
                    if (preOpResult.sendResponseImmediately()) {
                        skipPostOperation = true;
                    } else if (preOpResult.skipCoreProcessing()) {
                        skipPostOperation = false;
                    } else {
                        if (localOp.getCancelRequest() != null) {
                            return;
                        }
                        if (this.backend == null) {
                            localOp.setResultCode(ResultCode.NO_SUCH_OBJECT);
                            localOp.appendErrorMessage(CoreMessages.ERR_SEARCH_BASE_DOESNT_EXIST.get(String.valueOf(baseDN)));
                        } else {
                            localOp.setResultCode(ResultCode.SUCCESS);
                            if (persistentSearch != null) {
                                DirectoryServer.registerPersistentSearch(persistentSearch);
                                localOp.setSendResponse(false);
                            }
                            try {
                                if (processSearch) {
                                    localOp.searchBackend(this.backend);
                                }
                            }
                            catch (DirectoryException de) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                }
                                localOp.setResultCode(de.getResultCode());
                                localOp.appendErrorMessage(de.getMessageObject());
                                localOp.setMatchedDN(de.getMatchedDN());
                                localOp.setReferralURLs(de.getReferralURLs());
                                if (persistentSearch != null) {
                                    DirectoryServer.deregisterPersistentSearch(persistentSearch);
                                    localOp.setSendResponse(true);
                                }
                            }
                            catch (CancelledOperationException coe) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, coe);
                                }
                                CancelResult cancelResult = coe.getCancelResult();
                                localOp.setCancelResult(cancelResult);
                                localOp.setResultCode(cancelResult.getResultCode());
                                Message message = coe.getMessageObject();
                                if (message != null && message.length() > 0) {
                                    localOp.appendErrorMessage(message);
                                }
                                if (persistentSearch != null) {
                                    DirectoryServer.deregisterPersistentSearch(persistentSearch);
                                    localOp.setSendResponse(true);
                                }
                                skipPostOperation = true;
                            }
                            catch (Exception e) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                }
                                localOp.setResultCode(DirectoryServer.getServerErrorResultCode());
                                localOp.appendErrorMessage(CoreMessages.ERR_SEARCH_BACKEND_EXCEPTION.get(StaticUtils.getExceptionMessage(e)));
                                if (persistentSearch != null) {
                                    DirectoryServer.deregisterPersistentSearch(persistentSearch);
                                    localOp.setSendResponse(true);
                                }
                                skipPostOperation = true;
                            }
                        }
                    }
                }
            }
        }
        if (localOp.getCancelRequest() != null) {
            return;
        }
        if (!skipPostOperation && (postOperationResult = pluginConfigManager.invokePostOperationSearchPlugins(localOp)).connectionTerminated()) {
            localOp.setResultCode(ResultCode.CANCELED);
            localOp.appendErrorMessage(CoreMessages.ERR_CANCELED_BY_POSTOP_DISCONNECT.get());
            localOp.setProcessingStopTime();
            return;
        }
    }

    public void processBind(BindOperation operation) {
        LocalBackendBindOperation localOperation = new LocalBackendBindOperation(operation);
        this.processLocalBind(localOperation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void processLocalBind(LocalBackendBindOperation localOp) {
        block170: {
            block171: {
                clientConnection = localOp.getClientConnection();
                returnAuthzID = false;
                sizeLimit = DirectoryServer.getSizeLimit();
                timeLimit = DirectoryServer.getTimeLimit();
                lookthroughLimit = DirectoryServer.getLookthroughLimit();
                idleTimeLimit = DirectoryServer.getIdleTimeLimit();
                skipPostOperation = false;
                pwPolicyState = null;
                pwPolicyErrorType = null;
                pwPolicyControlRequested = false;
                isGraceLogin = false;
                mustChangePassword = false;
                pwPolicyWarningType = null;
                pwPolicyWarningValue = -1;
                saslMechanism = localOp.getSASLMechanism();
                isFirstWarning = false;
                authenticatedUserEntry = null;
                pwPolicyState = null;
                pluginConfigManager = DirectoryServer.getPluginConfigManager();
                bindDN = localOp.getBindDN();
                if (AccessControlConfigManager.getInstance().getAccessControlHandler().isAllowed(localOp)) break block171;
                localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                message = CoreMessages.ERR_BIND_AUTHZ_INSUFFICIENT_ACCESS_RIGHTS.get(String.valueOf(bindDN));
                localOp.setAuthFailureReason(message);
                skipPostOperation = true;
                break block170;
            }
            requestControls = localOp.getRequestControls();
            if (requestControls != null && !requestControls.isEmpty()) {
                for (i = 0; i < requestControls.size(); ++i) {
                    c = requestControls.get(i);
                    oid = c.getOID();
                    if (!AccessControlConfigManager.getInstance().getAccessControlHandler().isAllowed(bindDN, localOp, c)) {
                        localOp.setResultCode(ResultCode.INSUFFICIENT_ACCESS_RIGHTS);
                        localOp.appendErrorMessage(CoreMessages.ERR_CONTROL_INSUFFICIENT_ACCESS_RIGHTS.get(oid));
                        skipPostOperation = true;
                    } else {
                        if (oid.equals("2.16.840.1.113730.3.4.16")) {
                            returnAuthzID = true;
                            continue;
                        }
                        if (oid.equals("1.3.6.1.4.1.42.2.27.8.5.1")) {
                            pwPolicyControlRequested = true;
                            continue;
                        }
                        if (!c.isCritical()) continue;
                        localOp.setResultCode(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION);
                        localOp.appendErrorMessage(CoreMessages.ERR_BIND_UNSUPPORTED_CRITICAL_CONTROL.get(String.valueOf(oid)));
                    }
                    break block170;
                }
            }
            switch (1.$SwitchMap$org$opends$server$types$AuthenticationType[localOp.getAuthenticationType().ordinal()]) {
                case 1: {
                    simplePassword = localOp.getSimplePassword();
                    if (simplePassword == null || simplePassword.value().length == 0) {
                        if (DirectoryServer.lockdownMode()) {
                            localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            message = CoreMessages.ERR_BIND_REJECTED_LOCKDOWN_MODE.get();
                            localOp.setAuthFailureReason(message);
                            localOp.setProcessingStopTime();
                            AccessLogger.logBindResponse(localOp);
                            break;
                        }
                        if (DirectoryServer.bindWithDNRequiresPassword() && bindDN != null && !bindDN.isNullDN()) {
                            localOp.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
                            message = CoreMessages.ERR_BIND_DN_BUT_NO_PASSWORD.get();
                            localOp.setAuthFailureReason(message);
                            break;
                        }
                        preOpResult = pluginConfigManager.invokePreOperationBindPlugins(localOp);
                        if (preOpResult.connectionTerminated()) {
                            localOp.setResultCode(ResultCode.CANCELED);
                            localOp.appendErrorMessage(CoreMessages.ERR_CANCELED_BY_PREOP_DISCONNECT.get());
                            return;
                        }
                        if (preOpResult.sendResponseImmediately()) {
                            skipPostOperation = true;
                            break;
                        }
                        if (preOpResult.skipCoreProcessing()) {
                            skipPostOperation = false;
                            break;
                        }
                        localOp.setResultCode(ResultCode.SUCCESS);
                        localOp.setAuthenticationInfo(new AuthenticationInfo());
                        break;
                    }
                    actualRootDN = DirectoryServer.getActualRootBindDN(bindDN);
                    if (actualRootDN != null) {
                        bindDN = actualRootDN;
                    }
                    userLock = null;
                    for (i = 0; i < 3 && (userLock = LockManager.lockRead(bindDN)) == null; ++i) {
                    }
                    if (userLock == null) {
                        message = CoreMessages.ERR_BIND_OPERATION_CANNOT_LOCK_USER.get(String.valueOf(bindDN));
                        localOp.setResultCode(DirectoryServer.getServerErrorResultCode());
                        localOp.setAuthFailureReason(message);
                        break;
                    }
                    try {
                        try {
                            userEntry = this.backend.getEntry(bindDN);
                        }
                        catch (DirectoryException de) {
                            if (DebugLogger.debugEnabled()) {
                                LocalBackendWorkflowElement.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                            }
                            localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            localOp.setAuthFailureReason(de.getMessageObject());
                            userEntry = null;
                            LockManager.unlock(bindDN, userLock);
                            break;
                        }
                        if (userEntry == null) {
                            message = CoreMessages.ERR_BIND_OPERATION_UNKNOWN_USER.get(String.valueOf(bindDN));
                            localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            localOp.setAuthFailureReason(message);
                            break;
                        }
                        localOp.setUserEntryDN(userEntry.getDN());
                        pwPolicyState = new PasswordPolicyState(userEntry, false, false);
                        policy = pwPolicyState.getPolicy();
                        pwType = policy.getPasswordAttribute();
                        pwAttr = userEntry.getAttribute(pwType);
                        if (pwAttr == null || pwAttr.isEmpty()) {
                            message = CoreMessages.ERR_BIND_OPERATION_NO_PASSWORD.get(String.valueOf(bindDN));
                            localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            localOp.setAuthFailureReason(message);
                            break;
                        }
                        if (!(policy.getStateUpdateFailurePolicy() != PasswordPolicyCfgDefn.StateUpdateFailurePolicy.PROACTIVE || policy.getLockoutFailureCount() <= 0 && (policy.getLastLoginTimeAttribute() == null || policy.getLastLoginTimeFormat() == null) || DirectoryServer.getWritabilityMode() != WritabilityMode.DISABLED && this.backend.getWritabilityMode() != WritabilityMode.DISABLED || DirectoryServer.isRootDN(bindDN))) {
                            message = CoreMessages.ERR_BIND_OPERATION_WRITABILITY_DISABLED.get(String.valueOf(bindDN));
                            localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            localOp.setAuthFailureReason(message);
                            break;
                        }
                        if (policy.requireSecureAuthentication() && !clientConnection.isSecure()) {
                            message = CoreMessages.ERR_BIND_OPERATION_INSECURE_SIMPLE_BIND.get(String.valueOf(bindDN));
                            localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            localOp.setAuthFailureReason(message);
                            break;
                        }
                        if (pwPolicyState.isDisabled()) {
                            message = CoreMessages.ERR_BIND_OPERATION_ACCOUNT_DISABLED.get(String.valueOf(bindDN));
                            localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            localOp.setAuthFailureReason(message);
                            break;
                        }
                        if (pwPolicyState.isAccountExpired()) {
                            message = CoreMessages.ERR_BIND_OPERATION_ACCOUNT_EXPIRED.get(String.valueOf(bindDN));
                            localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            localOp.setAuthFailureReason(message);
                            pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.ACCOUNT_EXPIRED, bindDN, message);
                            break;
                        }
                        if (pwPolicyState.lockedDueToFailures()) {
                            message = CoreMessages.ERR_BIND_OPERATION_ACCOUNT_FAILURE_LOCKED.get(String.valueOf(bindDN));
                            if (pwPolicyErrorType == null) {
                                pwPolicyErrorType = PasswordPolicyErrorType.ACCOUNT_LOCKED;
                            }
                            localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            localOp.setAuthFailureReason(message);
                            break;
                        }
                        if (pwPolicyState.lockedDueToMaximumResetAge()) {
                            message = CoreMessages.ERR_BIND_OPERATION_ACCOUNT_RESET_LOCKED.get(String.valueOf(bindDN));
                            if (pwPolicyErrorType == null) {
                                pwPolicyErrorType = PasswordPolicyErrorType.ACCOUNT_LOCKED;
                            }
                            localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            localOp.setAuthFailureReason(message);
                            pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.ACCOUNT_RESET_LOCKED, bindDN, message);
                            break;
                        }
                        if (pwPolicyState.lockedDueToIdleInterval()) {
                            message = CoreMessages.ERR_BIND_OPERATION_ACCOUNT_IDLE_LOCKED.get(String.valueOf(bindDN));
                            if (pwPolicyErrorType == null) {
                                pwPolicyErrorType = PasswordPolicyErrorType.ACCOUNT_LOCKED;
                            }
                            localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            localOp.setAuthFailureReason(message);
                            pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.ACCOUNT_IDLE_LOCKED, bindDN, message);
                            break;
                        }
                        if (!pwPolicyState.isPasswordExpired()) ** GOTO lbl182
                        if (pwPolicyErrorType == null) {
                            pwPolicyErrorType = PasswordPolicyErrorType.PASSWORD_EXPIRED;
                        }
                        if ((maxGraceLogins = policy.getGraceLoginCount()) <= 0 || !pwPolicyState.mayUseGraceLogin()) ** GOTO lbl177
                        graceLoginTimes = pwPolicyState.getGraceLoginTimes();
                        if (graceLoginTimes == null || graceLoginTimes.size() < maxGraceLogins) {
                            isGraceLogin = true;
                            mustChangePassword = true;
                            if (pwPolicyWarningType == null) {
                                pwPolicyWarningType = PasswordPolicyWarningType.GRACE_LOGINS_REMAINING;
                                pwPolicyWarningValue = maxGraceLogins - (graceLoginTimes.size() + 1);
                            }
                        } else {
                            message = CoreMessages.ERR_BIND_OPERATION_PASSWORD_EXPIRED.get(String.valueOf(bindDN));
                            localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            localOp.setAuthFailureReason(message);
                            pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.PASSWORD_EXPIRED, bindDN, message);
                            break;
lbl177:
                            // 1 sources

                            message = CoreMessages.ERR_BIND_OPERATION_PASSWORD_EXPIRED.get(String.valueOf(bindDN));
                            localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            localOp.setAuthFailureReason(message);
                            pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.PASSWORD_EXPIRED, bindDN, message);
                            break;
lbl182:
                            // 1 sources

                            if (pwPolicyState.shouldWarn()) {
                                numSeconds = pwPolicyState.getSecondsUntilExpiration();
                                timeToExpiration = StaticUtils.secondsToTimeString(numSeconds);
                                message = ToolMessages.INFO_BIND_PASSWORD_EXPIRING.get(timeToExpiration);
                                localOp.appendErrorMessage(message);
                                if (pwPolicyWarningType == null) {
                                    pwPolicyWarningType = PasswordPolicyWarningType.TIME_BEFORE_EXPIRATION;
                                    pwPolicyWarningValue = numSeconds;
                                }
                                isFirstWarning = pwPolicyState.isFirstWarning();
                            }
                        }
                        if (pwPolicyState.mustChangePassword()) {
                            mustChangePassword = true;
                            if (pwPolicyErrorType == null) {
                                pwPolicyErrorType = PasswordPolicyErrorType.CHANGE_AFTER_RESET;
                            }
                        }
                        if ((preOpResult = pluginConfigManager.invokePreOperationBindPlugins(localOp)).connectionTerminated()) {
                            localOp.setResultCode(ResultCode.CANCELED);
                            localOp.appendErrorMessage(CoreMessages.ERR_CANCELED_BY_PREOP_DISCONNECT.get());
                            return;
                        }
                        if (preOpResult.sendResponseImmediately()) {
                            skipPostOperation = true;
                            break;
                        }
                        if (preOpResult.skipCoreProcessing()) {
                            skipPostOperation = false;
                            break;
                        }
                        if (pwPolicyState.passwordMatches(simplePassword)) {
                            localOp.setResultCode(ResultCode.SUCCESS);
                            isRoot = DirectoryServer.isRootDN(userEntry.getDN());
                            if (DirectoryServer.lockdownMode() && !isRoot) {
                                localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                                message = CoreMessages.ERR_BIND_REJECTED_LOCKDOWN_MODE.get();
                                localOp.setAuthFailureReason(message);
                                break;
                            }
                            localOp.setAuthenticationInfo(new AuthenticationInfo(userEntry, simplePassword, isRoot));
                            attrType = DirectoryServer.getAttributeType("ds-rlim-size-limit", true);
                            attrList = userEntry.getAttribute(attrType);
                            if (attrList != null && attrList.size() == 1 && (iterator = (values = (a = attrList.get(0)).getValues()).iterator()).hasNext()) {
                                v = (AttributeValue)iterator.next();
                                if (iterator.hasNext()) {
                                    message = CoreMessages.WARN_BIND_MULTIPLE_USER_SIZE_LIMITS.get(String.valueOf(userEntry.getDN()));
                                    ErrorLogger.logError(message);
                                } else {
                                    try {
                                        sizeLimit = Integer.parseInt(v.getStringValue());
                                    }
                                    catch (Exception e) {
                                        if (DebugLogger.debugEnabled()) {
                                            LocalBackendWorkflowElement.TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                        }
                                        message = CoreMessages.WARN_BIND_CANNOT_PROCESS_USER_SIZE_LIMIT.get(v.getStringValue(), String.valueOf(userEntry.getDN()));
                                        ErrorLogger.logError(message);
                                    }
                                }
                            }
                            if ((attrList = userEntry.getAttribute(attrType = DirectoryServer.getAttributeType("ds-rlim-time-limit", true))) != null && attrList.size() == 1 && (iterator = (values = (a = attrList.get(0)).getValues()).iterator()).hasNext()) {
                                v = (AttributeValue)iterator.next();
                                if (iterator.hasNext()) {
                                    message = CoreMessages.WARN_BIND_MULTIPLE_USER_TIME_LIMITS.get(String.valueOf(userEntry.getDN()));
                                    ErrorLogger.logError(message);
                                } else {
                                    try {
                                        timeLimit = Integer.parseInt(v.getStringValue());
                                    }
                                    catch (Exception e) {
                                        if (DebugLogger.debugEnabled()) {
                                            LocalBackendWorkflowElement.TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                        }
                                        message = CoreMessages.WARN_BIND_CANNOT_PROCESS_USER_TIME_LIMIT.get(v.getStringValue(), String.valueOf(userEntry.getDN()));
                                        ErrorLogger.logError(message);
                                    }
                                }
                            }
                            if ((attrList = userEntry.getAttribute(attrType = DirectoryServer.getAttributeType("ds-rlim-idle-time-limit", true))) != null && attrList.size() == 1 && (iterator = (values = (a = attrList.get(0)).getValues()).iterator()).hasNext()) {
                                v = (AttributeValue)iterator.next();
                                if (iterator.hasNext()) {
                                    message = CoreMessages.WARN_BIND_MULTIPLE_USER_IDLE_TIME_LIMITS.get(String.valueOf(userEntry.getDN()));
                                    ErrorLogger.logError(message);
                                } else {
                                    try {
                                        idleTimeLimit = 1000L * Long.parseLong(v.getStringValue());
                                    }
                                    catch (Exception e) {
                                        if (DebugLogger.debugEnabled()) {
                                            LocalBackendWorkflowElement.TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                        }
                                        message = CoreMessages.WARN_BIND_CANNOT_PROCESS_USER_IDLE_TIME_LIMIT.get(v.getStringValue(), String.valueOf(userEntry.getDN()));
                                        ErrorLogger.logError(message);
                                    }
                                }
                            }
                            if ((attrList = userEntry.getAttribute(attrType = DirectoryServer.getAttributeType("ds-rlim-lookthrough-limit", true))) != null && attrList.size() == 1 && (iterator = (values = (a = attrList.get(0)).getValues()).iterator()).hasNext()) {
                                v = (AttributeValue)iterator.next();
                                if (iterator.hasNext()) {
                                    message = CoreMessages.WARN_BIND_MULTIPLE_USER_LOOKTHROUGH_LIMITS.get(String.valueOf(userEntry.getDN()));
                                    ErrorLogger.logError(message);
                                } else {
                                    try {
                                        lookthroughLimit = Integer.parseInt(v.getStringValue());
                                    }
                                    catch (Exception e) {
                                        if (DebugLogger.debugEnabled()) {
                                            LocalBackendWorkflowElement.TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                        }
                                        message = CoreMessages.WARN_BIND_CANNOT_PROCESS_USER_LOOKTHROUGH_LIMIT.get(v.getStringValue(), String.valueOf(userEntry.getDN()));
                                        ErrorLogger.logError(message);
                                    }
                                }
                            }
                            pwPolicyState.handleDeprecatedStorageSchemes(simplePassword);
                            pwPolicyState.clearFailureLockout();
                            if (isFirstWarning) {
                                pwPolicyState.setWarnedTime();
                                numSeconds = pwPolicyState.getSecondsUntilExpiration();
                                timeToExpiration = StaticUtils.secondsToTimeString(numSeconds);
                                message = ToolMessages.INFO_BIND_PASSWORD_EXPIRING.get(timeToExpiration);
                                pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.PASSWORD_EXPIRING, bindDN, message);
                            }
                            if (isGraceLogin) {
                                pwPolicyState.updateGraceLoginTimes();
                            }
                            pwPolicyState.setLastLoginTime();
                            break;
                        }
                        message = CoreMessages.ERR_BIND_OPERATION_WRONG_PASSWORD.get();
                        localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        localOp.setAuthFailureReason(message);
                        if (policy.getLockoutFailureCount() <= 0) break;
                        pwPolicyState.updateAuthFailureTimes();
                        if (!pwPolicyState.lockedDueToFailures()) break;
                        lockoutDuration = pwPolicyState.getSecondsUntilUnlock();
                        if (lockoutDuration > -1) {
                            notificationType = AccountStatusNotificationType.ACCOUNT_TEMPORARILY_LOCKED;
                            message = CoreMessages.ERR_BIND_ACCOUNT_TEMPORARILY_LOCKED.get(StaticUtils.secondsToTimeString(lockoutDuration));
                        } else {
                            notificationType = AccountStatusNotificationType.ACCOUNT_PERMANENTLY_LOCKED;
                            message = CoreMessages.ERR_BIND_ACCOUNT_PERMANENTLY_LOCKED.get();
                        }
                        pwPolicyState.generateAccountStatusNotification(notificationType, localOp.getUserEntryDN(), message);
                        break;
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            LocalBackendWorkflowElement.TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        message = CoreMessages.ERR_BIND_OPERATION_PASSWORD_VALIDATION_EXCEPTION.get(StaticUtils.getExceptionMessage(e));
                        localOp.setResultCode(DirectoryServer.getServerErrorResultCode());
                        localOp.setAuthFailureReason(message);
                        break;
                    }
                    finally {
                        LockManager.unlock(bindDN, userLock);
                    }
                }
                case 2: {
                    saslHandler = DirectoryServer.getSASLMechanismHandler(saslMechanism);
                    if (saslHandler == null) {
                        localOp.setResultCode(ResultCode.AUTH_METHOD_NOT_SUPPORTED);
                        message = CoreMessages.ERR_BIND_OPERATION_UNKNOWN_SASL_MECHANISM.get(saslMechanism);
                        localOp.appendErrorMessage(message);
                        localOp.setAuthFailureReason(message);
                        break;
                    }
                    preOpResult = pluginConfigManager.invokePreOperationBindPlugins(localOp);
                    if (preOpResult.connectionTerminated()) {
                        localOp.setResultCode(ResultCode.CANCELED);
                        localOp.appendErrorMessage(CoreMessages.ERR_CANCELED_BY_PREOP_DISCONNECT.get());
                        return;
                    }
                    if (preOpResult.sendResponseImmediately()) {
                        skipPostOperation = true;
                        break;
                    }
                    if (preOpResult.skipCoreProcessing()) {
                        skipPostOperation = false;
                        break;
                    }
                    saslHandler.processSASLBind(localOp);
                    if (DirectoryServer.lockdownMode() && (resultCode = localOp.getResultCode()) != ResultCode.SASL_BIND_IN_PROGRESS && (resultCode != ResultCode.SUCCESS || localOp.getSASLAuthUserEntry() == null || !DirectoryServer.isRootDN(localOp.getSASLAuthUserEntry().getDN()))) {
                        localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        message = CoreMessages.ERR_BIND_REJECTED_LOCKDOWN_MODE.get();
                        localOp.setAuthFailureReason(message);
                        break;
                    }
                    saslAuthUserEntry = localOp.getSASLAuthUserEntry();
                    if (saslAuthUserEntry == null) {
                        pwPolicyState = null;
                        userDNString = null;
                    } else {
                        try {
                            pwPolicyState = new PasswordPolicyState(saslAuthUserEntry, false, false);
                            localOp.setUserEntryDN(saslAuthUserEntry.getDN());
                            userDNString = String.valueOf(localOp.getUserEntryDN());
                        }
                        catch (DirectoryException de) {
                            if (DebugLogger.debugEnabled()) {
                                LocalBackendWorkflowElement.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                            }
                            localOp.setResponseData(de);
                            break;
                        }
                    }
                    if (pwPolicyState == null) ** GOTO lbl429
                    policy = pwPolicyState.getPolicy();
                    if (policy.getStateUpdateFailurePolicy() == PasswordPolicyCfgDefn.StateUpdateFailurePolicy.PROACTIVE && (policy.getLockoutFailureCount() > 0 || policy.getLastLoginTimeAttribute() != null && policy.getLastLoginTimeFormat() != null) && (DirectoryServer.getWritabilityMode() == WritabilityMode.DISABLED || this.backend.getWritabilityMode() == WritabilityMode.DISABLED)) {
                        if (!DirectoryServer.isRootDN(bindDN)) {
                            message = CoreMessages.ERR_BIND_OPERATION_WRITABILITY_DISABLED.get(userDNString);
                            localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            localOp.setAuthFailureReason(message);
                            break;
                        }
                    } else {
                        if (pwPolicyState.isDisabled()) {
                            localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            message = CoreMessages.ERR_BIND_OPERATION_ACCOUNT_DISABLED.get(userDNString);
                            localOp.setAuthFailureReason(message);
                            break;
                        }
                        if (pwPolicyState.isAccountExpired()) {
                            localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            message = CoreMessages.ERR_BIND_OPERATION_ACCOUNT_EXPIRED.get(userDNString);
                            localOp.setAuthFailureReason(message);
                            pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.ACCOUNT_EXPIRED, bindDN, message);
                            break;
                        }
                    }
                    if (policy.requireSecureAuthentication() && !clientConnection.isSecure() && !saslHandler.isSecure(saslMechanism)) {
                        localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        message = CoreMessages.ERR_BIND_OPERATION_INSECURE_SASL_BIND.get(saslMechanism, userDNString);
                        localOp.setAuthFailureReason(message);
                        break;
                    }
                    if (pwPolicyState.lockedDueToFailures()) {
                        localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        if (pwPolicyErrorType == null) {
                            pwPolicyErrorType = PasswordPolicyErrorType.ACCOUNT_LOCKED;
                        }
                        message = CoreMessages.ERR_BIND_OPERATION_ACCOUNT_FAILURE_LOCKED.get(userDNString);
                        localOp.setAuthFailureReason(message);
                        break;
                    }
                    if (pwPolicyState.lockedDueToIdleInterval()) {
                        localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        if (pwPolicyErrorType == null) {
                            pwPolicyErrorType = PasswordPolicyErrorType.ACCOUNT_LOCKED;
                        }
                        message = CoreMessages.ERR_BIND_OPERATION_ACCOUNT_IDLE_LOCKED.get(userDNString);
                        localOp.setAuthFailureReason(message);
                        pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.ACCOUNT_IDLE_LOCKED, bindDN, message);
                        break;
                    }
                    if (!saslHandler.isPasswordBased(saslMechanism)) ** GOTO lbl429
                    if (pwPolicyState.lockedDueToMaximumResetAge()) {
                        localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        if (pwPolicyErrorType == null) {
                            pwPolicyErrorType = PasswordPolicyErrorType.ACCOUNT_LOCKED;
                        }
                        message = CoreMessages.ERR_BIND_OPERATION_ACCOUNT_RESET_LOCKED.get(userDNString);
                        localOp.setAuthFailureReason(message);
                        pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.ACCOUNT_RESET_LOCKED, bindDN, message);
                        break;
                    }
                    if (!pwPolicyState.isPasswordExpired()) ** GOTO lbl420
                    if (pwPolicyErrorType == null) {
                        pwPolicyErrorType = PasswordPolicyErrorType.PASSWORD_EXPIRED;
                    }
                    if ((maxGraceLogins = policy.getGraceLoginCount()) <= 0 || !pwPolicyState.mayUseGraceLogin()) ** GOTO lbl415
                    graceLoginTimes = pwPolicyState.getGraceLoginTimes();
                    if (graceLoginTimes == null || graceLoginTimes.size() < maxGraceLogins) {
                        isGraceLogin = true;
                        mustChangePassword = true;
                        if (pwPolicyWarningType == null) {
                            pwPolicyWarningType = PasswordPolicyWarningType.GRACE_LOGINS_REMAINING;
                            pwPolicyWarningValue = maxGraceLogins - (graceLoginTimes.size() + 1);
                        }
                    } else {
                        message = CoreMessages.ERR_BIND_OPERATION_PASSWORD_EXPIRED.get(String.valueOf(bindDN));
                        localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        localOp.setAuthFailureReason(message);
                        pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.PASSWORD_EXPIRED, bindDN, message);
                        break;
lbl415:
                        // 1 sources

                        message = CoreMessages.ERR_BIND_OPERATION_PASSWORD_EXPIRED.get(String.valueOf(bindDN));
                        localOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        localOp.setAuthFailureReason(message);
                        pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.PASSWORD_EXPIRED, bindDN, message);
                        break;
lbl420:
                        // 1 sources

                        if (pwPolicyState.shouldWarn()) {
                            numSeconds = pwPolicyState.getSecondsUntilExpiration();
                            timeToExpiration = StaticUtils.secondsToTimeString(numSeconds);
                            message = ToolMessages.INFO_BIND_PASSWORD_EXPIRING.get(timeToExpiration);
                            localOp.appendErrorMessage(message);
                            if (pwPolicyWarningType == null) {
                                pwPolicyWarningType = PasswordPolicyWarningType.TIME_BEFORE_EXPIRATION;
                                pwPolicyWarningValue = numSeconds;
                            }
                            isFirstWarning = pwPolicyState.isFirstWarning();
                        }
                    }
lbl429:
                    // 6 sources

                    if ((resultCode = localOp.getResultCode()) == ResultCode.SUCCESS) {
                        if (pwPolicyState == null) break;
                        if (saslHandler.isPasswordBased(saslMechanism) && pwPolicyState.mustChangePassword()) {
                            mustChangePassword = true;
                        }
                        if (isFirstWarning) {
                            pwPolicyState.setWarnedTime();
                            numSeconds = pwPolicyState.getSecondsUntilExpiration();
                            timeToExpiration = StaticUtils.secondsToTimeString(numSeconds);
                            message = ToolMessages.INFO_BIND_PASSWORD_EXPIRING.get(timeToExpiration);
                            pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.PASSWORD_EXPIRING, bindDN, message);
                        }
                        if (isGraceLogin) {
                            pwPolicyState.updateGraceLoginTimes();
                        }
                        pwPolicyState.setLastLoginTime();
                        attrType = DirectoryServer.getAttributeType("ds-rlim-size-limit", true);
                        attrList = saslAuthUserEntry.getAttribute(attrType);
                        if (attrList != null && attrList.size() == 1 && (iterator = (values = (a = attrList.get(0)).getValues()).iterator()).hasNext()) {
                            v = (AttributeValue)iterator.next();
                            if (iterator.hasNext()) {
                                message = CoreMessages.WARN_BIND_MULTIPLE_USER_SIZE_LIMITS.get(userDNString);
                                ErrorLogger.logError(message);
                            } else {
                                try {
                                    sizeLimit = Integer.parseInt(v.getStringValue());
                                }
                                catch (Exception e) {
                                    if (DebugLogger.debugEnabled()) {
                                        LocalBackendWorkflowElement.TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                    }
                                    message = CoreMessages.WARN_BIND_CANNOT_PROCESS_USER_SIZE_LIMIT.get(v.getStringValue(), userDNString);
                                    ErrorLogger.logError(message);
                                }
                            }
                        }
                        if ((attrList = saslAuthUserEntry.getAttribute(attrType = DirectoryServer.getAttributeType("ds-rlim-time-limit", true))) != null && attrList.size() == 1 && (iterator = (values = (a = attrList.get(0)).getValues()).iterator()).hasNext()) {
                            v = (AttributeValue)iterator.next();
                            if (iterator.hasNext()) {
                                message = CoreMessages.WARN_BIND_MULTIPLE_USER_TIME_LIMITS.get(userDNString);
                                ErrorLogger.logError(message);
                            } else {
                                try {
                                    timeLimit = Integer.parseInt(v.getStringValue());
                                }
                                catch (Exception e) {
                                    if (DebugLogger.debugEnabled()) {
                                        LocalBackendWorkflowElement.TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                    }
                                    message = CoreMessages.WARN_BIND_CANNOT_PROCESS_USER_TIME_LIMIT.get(v.getStringValue(), userDNString);
                                    ErrorLogger.logError(message);
                                }
                            }
                        }
                        if ((attrList = saslAuthUserEntry.getAttribute(attrType = DirectoryServer.getAttributeType("ds-rlim-idle-time-limit", true))) != null && attrList.size() == 1 && (iterator = (values = (a = attrList.get(0)).getValues()).iterator()).hasNext()) {
                            v = (AttributeValue)iterator.next();
                            if (iterator.hasNext()) {
                                message = CoreMessages.WARN_BIND_MULTIPLE_USER_IDLE_TIME_LIMITS.get(String.valueOf(userDNString));
                                ErrorLogger.logError(message);
                            } else {
                                try {
                                    idleTimeLimit = 1000L * Long.parseLong(v.getStringValue());
                                }
                                catch (Exception e) {
                                    if (DebugLogger.debugEnabled()) {
                                        LocalBackendWorkflowElement.TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                    }
                                    message = CoreMessages.WARN_BIND_CANNOT_PROCESS_USER_IDLE_TIME_LIMIT.get(v.getStringValue(), String.valueOf(userDNString));
                                    ErrorLogger.logError(message);
                                }
                            }
                        }
                        if ((attrList = saslAuthUserEntry.getAttribute(attrType = DirectoryServer.getAttributeType("ds-rlim-lookthrough-limit", true))) == null || attrList.size() != 1 || !(iterator = (values = (a = attrList.get(0)).getValues()).iterator()).hasNext()) break;
                        v = (AttributeValue)iterator.next();
                        if (iterator.hasNext()) {
                            message = CoreMessages.WARN_BIND_MULTIPLE_USER_LOOKTHROUGH_LIMITS.get(userDNString);
                            ErrorLogger.logError(message);
                            break;
                        }
                        try {
                            lookthroughLimit = Integer.parseInt(v.getStringValue());
                        }
                        catch (Exception e) {
                            if (DebugLogger.debugEnabled()) {
                                LocalBackendWorkflowElement.TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            message = CoreMessages.WARN_BIND_CANNOT_PROCESS_USER_LOOKTHROUGH_LIMIT.get(v.getStringValue(), userDNString);
                            ErrorLogger.logError(message);
                        }
                        break;
                    }
                    if (resultCode == ResultCode.SASL_BIND_IN_PROGRESS || pwPolicyState == null || !saslHandler.isPasswordBased(saslMechanism) || pwPolicyState.getPolicy().getLockoutFailureCount() <= 0) break;
                    pwPolicyState.updateAuthFailureTimes();
                    if (!pwPolicyState.lockedDueToFailures()) break;
                    lockoutDuration = pwPolicyState.getSecondsUntilUnlock();
                    if (lockoutDuration > -1) {
                        notificationType = AccountStatusNotificationType.ACCOUNT_TEMPORARILY_LOCKED;
                        message = CoreMessages.ERR_BIND_ACCOUNT_TEMPORARILY_LOCKED.get(StaticUtils.secondsToTimeString(lockoutDuration));
                    } else {
                        notificationType = AccountStatusNotificationType.ACCOUNT_PERMANENTLY_LOCKED;
                        message = CoreMessages.ERR_BIND_ACCOUNT_PERMANENTLY_LOCKED.get();
                    }
                    pwPolicyState.generateAccountStatusNotification(notificationType, localOp.getUserEntryDN(), message);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        try {
            if (pwPolicyState != null) {
                pwPolicyState.updateUserEntry();
            }
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                LocalBackendWorkflowElement.TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            localOp.setResponseData(de);
        }
        if (!skipPostOperation && (postOpResult = pluginConfigManager.invokePostOperationBindPlugins(localOp)).connectionTerminated()) {
            localOp.setResultCode(ResultCode.CANCELED);
            localOp.appendErrorMessage(CoreMessages.ERR_CANCELED_BY_PREOP_DISCONNECT.get());
            return;
        }
        authInfo = localOp.getAuthenticationInfo();
        if (localOp.getResultCode() == ResultCode.SUCCESS && authInfo != null) {
            authenticatedUserEntry = authInfo.getAuthenticationEntry();
            clientConnection.setAuthenticationInfo(authInfo);
            clientConnection.setSizeLimit(sizeLimit);
            clientConnection.setTimeLimit(timeLimit);
            clientConnection.setIdleTimeLimit(idleTimeLimit);
            clientConnection.setLookthroughLimit(lookthroughLimit);
            clientConnection.setMustChangePassword(mustChangePassword);
            if (returnAuthzID) {
                localOp.addResponseControl(new AuthorizationIdentityResponseControl(authInfo.getAuthorizationDN()));
            }
        }
        if (localOp.getResultCode() == ResultCode.SUCCESS) {
            if (pwPolicyControlRequested) {
                pwpControl = new PasswordPolicyResponseControl(pwPolicyWarningType, pwPolicyWarningValue, pwPolicyErrorType);
                localOp.addResponseControl(pwpControl);
            } else if (pwPolicyErrorType == PasswordPolicyErrorType.PASSWORD_EXPIRED) {
                localOp.addResponseControl(new PasswordExpiredControl());
            } else if (pwPolicyWarningType == PasswordPolicyWarningType.TIME_BEFORE_EXPIRATION) {
                localOp.addResponseControl(new PasswordExpiringControl(pwPolicyWarningValue));
            }
        } else if (pwPolicyControlRequested) {
            pwpControl = new PasswordPolicyResponseControl(pwPolicyWarningType, pwPolicyWarningValue, pwPolicyErrorType);
            localOp.addResponseControl(pwpControl);
        } else if (pwPolicyErrorType == PasswordPolicyErrorType.PASSWORD_EXPIRED) {
            localOp.addResponseControl(new PasswordExpiredControl());
        }
        localOp.setProcessingStopTime();
    }

    public void processAdd(AddOperation operation) {
        LocalBackendAddOperation localOperation = new LocalBackendAddOperation(operation);
        this.processLocalAdd(localOperation);
    }

    /*
     * Exception decompiling
     */
    private void processLocalAdd(LocalBackendAddOperation localOp) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 412[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void processDelete(DeleteOperation operation) {
        LocalBackendDeleteOperation localOperation = new LocalBackendDeleteOperation(operation);
        this.processLocalDelete(localOperation);
    }

    /*
     * Exception decompiling
     */
    private void processLocalDelete(LocalBackendDeleteOperation localOp) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 78[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void processCompare(CompareOperation operation) {
        LocalBackendCompareOperation localOperation = new LocalBackendCompareOperation(operation);
        this.processLocalCompare(localOperation);
    }

    /*
     * Exception decompiling
     */
    private void processLocalCompare(LocalBackendCompareOperation localOp) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 26[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void processModifyDN(ModifyDNOperation op) {
        LocalBackendModifyDNOperation localOp = new LocalBackendModifyDNOperation(op);
        this.processLocalModifyDN(localOp);
    }

    /*
     * Exception decompiling
     */
    private void processLocalModifyDN(LocalBackendModifyDNOperation op) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 249[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static final <O extends Operation, L> void attachLocalOperation(O globalOperation, L currentLocalOperation) {
        List existingAttachment = (List)globalOperation.getAttachment("LocalBackendOperations");
        ArrayList<L> newAttachment = new ArrayList<L>();
        if (existingAttachment != null) {
            newAttachment.addAll(existingAttachment);
        }
        newAttachment.add(currentLocalOperation);
        globalOperation.setAttachment("LocalBackendOperations", newAttachment);
    }
}

