/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.api;

import org.opends.server.backends.task.Task;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.util.StaticUtils;

public class DirectoryThread
extends Thread {
    private static final String CLASS_NAME = "org.opends.server.core.DirectoryThread";
    private StackTraceElement[] creationStackTrace;
    private Task task;
    private Thread parentThread;

    public DirectoryThread(Runnable runnable, String string) {
        super(DirectoryServer.getDirectoryThreadGroup(), runnable, string);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string)));
        this.init();
    }

    protected DirectoryThread(String string) {
        super(DirectoryServer.getDirectoryThreadGroup(), string);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string)));
        this.init();
    }

    protected DirectoryThread(ThreadGroup threadGroup, String string) {
        super(threadGroup, string);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(threadGroup), String.valueOf(string)));
        this.init();
    }

    private void init() {
        String string;
        this.parentThread = DirectoryThread.currentThread();
        this.creationStackTrace = this.parentThread.getStackTrace();
        this.task = this.parentThread instanceof DirectoryThread ? ((DirectoryThread)this.parentThread).task : null;
        String string2 = System.getProperty("org.opends.server.ForceDaemonThreads");
        if (string2 != null && ((string = StaticUtils.toLowerCase(string2)).equals("true") || string.equals("yes") || string.equals("on") || string.equals("1"))) {
            this.setDaemon(true);
        }
    }

    public StackTraceElement[] getCreationStackTrace() {
        assert (Debug.debugEnter(CLASS_NAME, "getCreationStackTrace", new String[0]));
        return this.creationStackTrace;
    }

    public Thread getParentThread() {
        assert (Debug.debugEnter(CLASS_NAME, "getParentThread", new String[0]));
        return this.parentThread;
    }

    public Task getAssociatedTask() {
        assert (Debug.debugEnter(CLASS_NAME, "getAssociatedTask", new String[0]));
        return this.task;
    }

    public void setAssociatedTask(Task task) {
        assert (Debug.debugEnter(CLASS_NAME, "setAssociatedTask", new String[0]));
        this.task = task;
    }
}

