/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.opends.server.api.Backend;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.RestoreConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.util.LDIFException;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.LDIFWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryBackend
extends Backend {
    private static final String CLASS_NAME = "org.opends.server.backends.MemoryBackend";
    private DN[] baseDNs;
    private HashMap<DN, HashSet<DN>> childDNs;
    private HashSet<DN> baseDNSet;
    private HashSet<String> supportedControls;
    private HashSet<String> supportedFeatures;
    private LinkedHashMap<DN, Entry> entryMap;

    public MemoryBackend() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    @Override
    public synchronized void initializeBackend(ConfigEntry configEntry, DN[] dNArray) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeBackend", String.valueOf(configEntry), String.valueOf(dNArray)));
        if (dNArray == null || dNArray.length != 1) {
            int n = 9699520;
            String string = MessageHandler.getMessage(n);
            throw new ConfigException(n, string);
        }
        this.baseDNs = dNArray;
        this.baseDNSet = new HashSet();
        for (DN dN : dNArray) {
            this.baseDNSet.add(dN);
        }
        this.entryMap = new LinkedHashMap();
        this.childDNs = new HashMap();
        this.supportedControls = new HashSet();
        this.supportedFeatures = new HashSet();
        for (DN dN : dNArray) {
            DirectoryServer.registerSuffix(dN, this);
        }
    }

    public synchronized void clearMemoryBackend() {
        this.entryMap.clear();
        this.childDNs.clear();
    }

    @Override
    public synchronized void finalizeBackend() {
        assert (Debug.debugEnter(CLASS_NAME, "finalizeBackend", new String[0]));
        this.clearMemoryBackend();
    }

    @Override
    public DN[] getBaseDNs() {
        assert (Debug.debugEnter(CLASS_NAME, "getBaseDNs", new String[0]));
        return this.baseDNs;
    }

    @Override
    public boolean isLocal() {
        assert (Debug.debugEnter(CLASS_NAME, "isLocal", new String[0]));
        return true;
    }

    @Override
    public synchronized Entry getEntry(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "getEntry", String.valueOf(dN)));
        return this.entryMap.get(dN);
    }

    @Override
    public synchronized boolean entryExists(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "entryExists", String.valueOf(dN)));
        return this.entryMap.containsKey(dN);
    }

    @Override
    public synchronized void addEntry(Entry entry, AddOperation addOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "addEntry", String.valueOf(entry), String.valueOf(addOperation)));
        DN dN = entry.getDN();
        if (this.entryMap.containsKey(dN)) {
            int n = 9699521;
            String string = MessageHandler.getMessage(n, String.valueOf(dN));
            throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, string, n);
        }
        if (this.baseDNSet.contains(dN)) {
            this.entryMap.put(dN, entry);
            return;
        }
        DN dN2 = dN.getParent();
        if (dN2 == null) {
            int n = 9699522;
            String string = MessageHandler.getMessage(n, String.valueOf(dN));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string, n);
        }
        if (!this.entryMap.containsKey(dN2)) {
            int n = 9699523;
            String string = MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(dN2));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string, n);
        }
        this.entryMap.put(dN, entry);
        HashSet<DN> hashSet = this.childDNs.get(dN2);
        if (hashSet == null) {
            hashSet = new HashSet();
            this.childDNs.put(dN2, hashSet);
        }
        hashSet.add(dN);
    }

    @Override
    public synchronized void deleteEntry(DN dN, DeleteOperation deleteOperation) throws DirectoryException {
        HashSet<DN> hashSet;
        assert (Debug.debugEnter(CLASS_NAME, "deleteEntry", String.valueOf(dN), String.valueOf(deleteOperation)));
        if (!this.entryMap.containsKey(dN)) {
            int n = 9699524;
            String string = MessageHandler.getMessage(n, String.valueOf(dN));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string, n);
        }
        HashSet<DN> hashSet2 = this.childDNs.get(dN);
        if (hashSet2 != null && !hashSet2.isEmpty()) {
            int n = 9699525;
            String string = MessageHandler.getMessage(n, String.valueOf(dN));
            throw new DirectoryException(ResultCode.NOT_ALLOWED_ON_NONLEAF, string, n);
        }
        this.childDNs.remove(dN);
        this.entryMap.remove(dN);
        DN dN2 = dN.getParent();
        if (dN2 != null && (hashSet = this.childDNs.get(dN2)) != null) {
            hashSet.remove(dN);
            if (hashSet.isEmpty()) {
                this.childDNs.remove(dN2);
            }
        }
    }

    @Override
    public synchronized void replaceEntry(Entry entry, ModifyOperation modifyOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "replaceEntry", String.valueOf(entry), String.valueOf(modifyOperation)));
        DN dN = entry.getDN();
        if (!this.entryMap.containsKey(dN)) {
            int n = 9699524;
            String string = MessageHandler.getMessage(n, String.valueOf(dN));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string, n);
        }
        this.entryMap.put(dN, entry);
    }

    @Override
    public synchronized void renameEntry(DN dN, Entry entry, ModifyDNOperation modifyDNOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "renameEntry", String.valueOf(dN), String.valueOf(entry), String.valueOf(modifyDNOperation)));
        if (!this.entryMap.containsKey(dN)) {
            int n = 9699524;
            String string = MessageHandler.getMessage(n, String.valueOf(dN));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string, n);
        }
        HashSet<DN> hashSet = this.childDNs.get(dN);
        if (hashSet != null) {
            if (hashSet.isEmpty()) {
                this.childDNs.remove(dN);
            } else {
                int n = 9699533;
                String string = MessageHandler.getMessage(n, String.valueOf(dN));
                throw new DirectoryException(ResultCode.NOT_ALLOWED_ON_NONLEAF, string, n);
            }
        }
        if (this.entryMap.containsKey(entry.getDN())) {
            int n = 9699521;
            String string = MessageHandler.getMessage(n, String.valueOf(entry.getDN()));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string, n);
        }
        boolean bl = false;
        for (DN dN2 : this.baseDNs) {
            if (!dN2.isAncestorOf(entry.getDN())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            int n = 9699534;
            String string = MessageHandler.getMessage(n, String.valueOf(dN));
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
        }
        DN dN3 = entry.getDN().getParent();
        if (dN3 == null || !this.entryMap.containsKey(dN3)) {
            int string = 9699535;
            String string2 = MessageHandler.getMessage(string, String.valueOf(dN), String.valueOf(dN3));
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string2, string);
        }
        this.deleteEntry(dN, null);
        this.addEntry(entry, null);
    }

    @Override
    public synchronized void search(SearchOperation searchOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "search", String.valueOf(searchOperation)));
        DN dN = searchOperation.getBaseDN();
        SearchScope searchScope = searchOperation.getScope();
        SearchFilter searchFilter = searchOperation.getFilter();
        if (searchScope == SearchScope.BASE_OBJECT) {
            Entry entry = this.entryMap.get(dN);
            if (entry == null) {
                int n = 9699524;
                String string = MessageHandler.getMessage(n, String.valueOf(dN));
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string, n);
            }
            if (searchFilter.matchesEntry(entry)) {
                searchOperation.returnEntry(entry, new LinkedList<Control>());
            }
        } else {
            for (Entry entry : this.entryMap.values()) {
                if (!entry.matchesBaseAndScope(dN, searchScope) || !searchFilter.matchesEntry(entry)) continue;
                searchOperation.returnEntry(entry, new LinkedList<Control>());
            }
        }
    }

    public HashSet<String> getSupportedControls() {
        assert (Debug.debugEnter(CLASS_NAME, "getSupportedControls", new String[0]));
        return this.supportedControls;
    }

    @Override
    public boolean supportsControl(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "supportsControl", String.valueOf(string)));
        return false;
    }

    public HashSet<String> getSupportedFeatures() {
        assert (Debug.debugEnter(CLASS_NAME, "getSupportedFeatures", new String[0]));
        return this.supportedFeatures;
    }

    @Override
    public boolean supportsFeature(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "supportsFeature", String.valueOf(string)));
        return false;
    }

    @Override
    public boolean supportsLDIFExport() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsLDIFExport", new String[0]));
        return true;
    }

    @Override
    public synchronized void exportLDIF(ConfigEntry configEntry, DN[] dNArray, LDIFExportConfig lDIFExportConfig) throws DirectoryException {
        LDIFWriter lDIFWriter;
        assert (Debug.debugEnter(CLASS_NAME, "exportLDIF", String.valueOf(lDIFExportConfig)));
        try {
            lDIFWriter = new LDIFWriter(lDIFExportConfig);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "exportLDIF", exception));
            int n = 9699527;
            String string = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n, exception);
        }
        DN dN = null;
        try {
            for (Entry entry : this.entryMap.values()) {
                dN = entry.getDN();
                lDIFWriter.writeEntry(entry);
            }
        }
        catch (Exception exception) {
            int n = 9699528;
            String string = MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n, exception);
        }
        finally {
            block15: {
                try {
                    lDIFWriter.close();
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "exportLDIF", exception)) break block15;
                    throw new AssertionError();
                }
            }
        }
    }

    @Override
    public boolean supportsLDIFImport() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsLDIFImport", new String[0]));
        return true;
    }

    @Override
    public synchronized void importLDIF(ConfigEntry configEntry, DN[] dNArray, LDIFImportConfig lDIFImportConfig) throws DirectoryException {
        block16: {
            LDIFReader lDIFReader;
            assert (Debug.debugEnter(CLASS_NAME, "importLDIF", String.valueOf(lDIFImportConfig)));
            this.clearMemoryBackend();
            try {
                lDIFReader = new LDIFReader(lDIFImportConfig);
            }
            catch (Exception exception) {
                int n = 9699529;
                String string = MessageHandler.getMessage(n, String.valueOf(exception));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n, exception);
            }
            block12: while (true) {
                try {
                    while (true) {
                        Entry entry;
                        block15: {
                            entry = null;
                            try {
                                entry = lDIFReader.readEntry();
                                if (entry != null) break block15;
                                break block16;
                            }
                            catch (LDIFException lDIFException) {
                                if (lDIFException.canContinueReading()) continue;
                                int n = 9699530;
                                String string = MessageHandler.getMessage(n, String.valueOf(entry));
                                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n, lDIFException);
                            }
                        }
                        try {
                            this.addEntry(entry, null);
                            continue block12;
                        }
                        catch (DirectoryException directoryException) {
                            lDIFReader.rejectLastEntry(directoryException.getErrorMessage());
                            continue;
                        }
                        break;
                    }
                }
                catch (DirectoryException directoryException) {
                    throw directoryException;
                }
                catch (Exception exception) {
                    int n = 9699531;
                    String string = MessageHandler.getMessage(n, String.valueOf(exception));
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n, exception);
                }
            }
            finally {
                lDIFReader.close();
            }
        }
    }

    @Override
    public boolean supportsBackup() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsBackup", new String[0]));
        return false;
    }

    @Override
    public boolean supportsBackup(BackupConfig backupConfig, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "supportsBackup", new String[0]));
        return false;
    }

    @Override
    public void createBackup(ConfigEntry configEntry, BackupConfig backupConfig) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "createBackup", String.valueOf(backupConfig)));
        int n = 9699532;
        String string = MessageHandler.getMessage(n);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
    }

    @Override
    public void removeBackup(BackupDirectory backupDirectory, String string) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "removeBackup", String.valueOf(backupDirectory), String.valueOf(string)));
        int n = 9699532;
        String string2 = MessageHandler.getMessage(n);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string2, n);
    }

    @Override
    public boolean supportsRestore() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsRestore", new String[0]));
        return false;
    }

    @Override
    public void restoreBackup(ConfigEntry configEntry, RestoreConfig restoreConfig) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "restoreBackup", String.valueOf(restoreConfig)));
        int n = 9699532;
        String string = MessageHandler.getMessage(n);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
    }
}

