/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.Transaction;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.backends.jeb.Container;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.EntryIDSet;
import org.opends.server.backends.jeb.EqualityIndexer;
import org.opends.server.backends.jeb.Index;
import org.opends.server.backends.jeb.IndexConfig;
import org.opends.server.backends.jeb.Indexer;
import org.opends.server.backends.jeb.JebException;
import org.opends.server.backends.jeb.OrderingIndexer;
import org.opends.server.backends.jeb.PresenceIndexer;
import org.opends.server.backends.jeb.SubstringIndexer;
import org.opends.server.core.DirectoryException;
import org.opends.server.loggers.Debug;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;
import org.opends.server.types.SearchFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeIndex {
    private static final String CLASS_NAME = "org.opends.server.backends.jeb.AttributeIndex";
    public static final DatabaseEntry presenceKey = new DatabaseEntry("+".getBytes());
    Container container;
    IndexConfig indexConfig;
    Index equalityIndex = null;
    Index presenceIndex = null;
    Index substringIndex = null;
    Index orderingIndex = null;

    public AttributeIndex(IndexConfig indexConfig, Container container) {
        Indexer indexer;
        this.indexConfig = indexConfig;
        this.container = container;
        AttributeType attributeType = indexConfig.getAttributeType();
        String string = attributeType.getNameOrOID();
        if (indexConfig.isEqualityIndex()) {
            indexer = new EqualityIndexer(indexConfig);
            this.equalityIndex = new Index(container, string + ".equality", indexer, indexConfig.getEqualityEntryLimit(), indexConfig.getCursorEntryLimit());
        }
        if (indexConfig.isPresenceIndex()) {
            indexer = new PresenceIndexer(indexConfig);
            this.presenceIndex = new Index(container, string + ".presence", indexer, indexConfig.getPresenceEntryLimit(), indexConfig.getCursorEntryLimit());
        }
        if (indexConfig.isSubstringIndex()) {
            indexer = new SubstringIndexer(indexConfig);
            this.substringIndex = new Index(container, string + ".substring", indexer, indexConfig.getSubstringEntryLimit(), indexConfig.getCursorEntryLimit());
        }
        if (indexConfig.isOrderingIndex()) {
            indexer = new OrderingIndexer(indexConfig);
            this.orderingIndex = new Index(container, string + ".ordering", indexer, indexConfig.getEqualityEntryLimit(), indexConfig.getCursorEntryLimit());
        }
    }

    public void open(DatabaseConfig databaseConfig) throws DatabaseException {
        if (this.equalityIndex != null) {
            this.equalityIndex.open(databaseConfig);
        }
        if (this.presenceIndex != null) {
            this.presenceIndex.open(databaseConfig);
        }
        if (this.substringIndex != null) {
            this.substringIndex.open(databaseConfig);
        }
        if (this.orderingIndex != null) {
            this.orderingIndex.open(databaseConfig);
        }
    }

    public void close() {
    }

    public AttributeType getAttributeType() {
        return this.indexConfig.getAttributeType();
    }

    public void addEntry(Transaction transaction, EntryID entryID, Entry entry) throws DatabaseException, DirectoryException, JebException {
        if (this.equalityIndex != null) {
            this.equalityIndex.addEntry(transaction, entryID, entry);
        }
        if (this.presenceIndex != null) {
            this.presenceIndex.addEntry(transaction, entryID, entry);
        }
        if (this.substringIndex != null) {
            this.substringIndex.addEntry(transaction, entryID, entry);
        }
        if (this.orderingIndex != null) {
            this.orderingIndex.addEntry(transaction, entryID, entry);
        }
    }

    public void removeEntry(Transaction transaction, EntryID entryID, Entry entry) throws DatabaseException, DirectoryException, JebException {
        if (this.equalityIndex != null) {
            this.equalityIndex.removeEntry(transaction, entryID, entry);
        }
        if (this.presenceIndex != null) {
            this.presenceIndex.removeEntry(transaction, entryID, entry);
        }
        if (this.substringIndex != null) {
            this.substringIndex.removeEntry(transaction, entryID, entry);
        }
        if (this.orderingIndex != null) {
            this.orderingIndex.removeEntry(transaction, entryID, entry);
        }
    }

    public void modifyEntry(Transaction transaction, EntryID entryID, Entry entry, Entry entry2, List<Modification> list) throws DatabaseException {
        if (this.equalityIndex != null) {
            this.equalityIndex.modifyEntry(transaction, entryID, entry, entry2, list);
        }
        if (this.presenceIndex != null) {
            this.presenceIndex.modifyEntry(transaction, entryID, entry, entry2, list);
        }
        if (this.substringIndex != null) {
            this.substringIndex.modifyEntry(transaction, entryID, entry, entry2, list);
        }
        if (this.orderingIndex != null) {
            this.orderingIndex.modifyEntry(transaction, entryID, entry, entry2, list);
        }
    }

    private byte[] makeSubstringKey(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    Set<ByteString> substringKeys(byte[] byArray) {
        HashSet<ByteString> hashSet = new HashSet<ByteString>();
        int n = this.indexConfig.getSubstringLength();
        int n2 = 0;
        for (int i = byArray.length; i > 0; --i) {
            int n3 = Math.min(n, i);
            byte[] byArray2 = this.makeSubstringKey(byArray, n2, n3);
            hashSet.add(new ASN1OctetString(byArray2));
            ++n2;
        }
        return hashSet;
    }

    private EntryIDSet matchSubstring(byte[] byArray) {
        Object object;
        int n = this.indexConfig.getSubstringLength();
        if (byArray.length < n) {
            byte[] byArray2 = this.makeSubstringKey(byArray, 0, byArray.length);
            byte[] byArray3 = this.makeSubstringKey(byArray, 0, byArray.length);
            for (int i = byArray3.length - 1; i >= 0; --i) {
                if (byArray3[i] != 255) {
                    byArray3[i] = (byte)(byArray3[i] + 1);
                    break;
                }
                byArray3[i] = 0;
            }
            return this.substringIndex.readRange(byArray2, byArray3, true, false);
        }
        HashSet<byte[]> hashSet = new HashSet<byte[]>();
        int n2 = 0;
        for (int i = n; i <= byArray.length; ++i) {
            object = this.makeSubstringKey(byArray, n2, n);
            hashSet.add((byte[])object);
            ++n2;
        }
        EntryIDSet entryIDSet = new EntryIDSet();
        DatabaseEntry databaseEntry = new DatabaseEntry();
        object = hashSet.iterator();
        while (object.hasNext()) {
            byte[] byArray4 = (byte[])object.next();
            databaseEntry.setData(byArray4);
            EntryIDSet entryIDSet2 = this.substringIndex.readKey(databaseEntry, null, LockMode.DEFAULT);
            entryIDSet.retainAll(entryIDSet2);
            if (!entryIDSet.isDefined() || entryIDSet.size() > 10) continue;
            break;
        }
        return entryIDSet;
    }

    private EntryIDSet matchInitialSubstring(byte[] byArray) {
        byte[] byArray2 = byArray;
        byte[] byArray3 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        for (int i = byArray3.length - 1; i >= 0; --i) {
            if (byArray3[i] != 255) {
                byArray3[i] = (byte)(byArray3[i] + 1);
                break;
            }
            byArray3[i] = 0;
        }
        return this.equalityIndex.readRange(byArray2, byArray3, true, false);
    }

    public EntryIDSet evaluateEqualityFilter(SearchFilter searchFilter) {
        if (!this.indexConfig.isEqualityIndex()) {
            return new EntryIDSet();
        }
        try {
            byte[] byArray = searchFilter.getAssertionValue().getNormalizedValue().value();
            DatabaseEntry databaseEntry = new DatabaseEntry(byArray);
            return this.equalityIndex.readKey(databaseEntry, null, LockMode.DEFAULT);
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "evaluateEqualityFilter", directoryException));
            return new EntryIDSet();
        }
    }

    public EntryIDSet evaluatePresenceFilter(SearchFilter searchFilter) {
        if (!this.indexConfig.isPresenceIndex()) {
            return new EntryIDSet();
        }
        return this.presenceIndex.readKey(presenceKey, null, LockMode.DEFAULT);
    }

    public EntryIDSet evaluateGreaterOrEqualFilter(SearchFilter searchFilter) {
        if (!this.indexConfig.isOrderingIndex() || this.orderingIndex == null) {
            return new EntryIDSet();
        }
        try {
            OrderingMatchingRule orderingMatchingRule = searchFilter.getAttributeType().getOrderingMatchingRule();
            byte[] byArray = orderingMatchingRule.normalizeValue(searchFilter.getAssertionValue().getValue()).value();
            byte[] byArray2 = new byte[]{};
            return this.orderingIndex.readRange(byArray, byArray2, true, false);
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "evaluateGreaterOrEqualFilter", directoryException));
            return new EntryIDSet();
        }
    }

    public EntryIDSet evaluateLessOrEqualFilter(SearchFilter searchFilter) {
        if (!this.indexConfig.isOrderingIndex() || this.orderingIndex == null) {
            return new EntryIDSet();
        }
        try {
            byte[] byArray = new byte[]{};
            OrderingMatchingRule orderingMatchingRule = searchFilter.getAttributeType().getOrderingMatchingRule();
            byte[] byArray2 = orderingMatchingRule.normalizeValue(searchFilter.getAssertionValue().getValue()).value();
            return this.orderingIndex.readRange(byArray, byArray2, false, true);
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "evaluateLessOrEqualFilter", directoryException));
            return new EntryIDSet();
        }
    }

    public EntryIDSet evaluateSubstringFilter(SearchFilter searchFilter) {
        SubstringMatchingRule substringMatchingRule = searchFilter.getAttributeType().getSubstringMatchingRule();
        try {
            Object object;
            Object object2;
            Object object3;
            ArrayList<ByteString> arrayList = new ArrayList<ByteString>();
            EntryIDSet entryIDSet = new EntryIDSet();
            if (searchFilter.getSubInitialElement() != null) {
                if (this.indexConfig.isEqualityIndex()) {
                    object3 = substringMatchingRule.normalizeSubstring(searchFilter.getSubInitialElement());
                    object2 = object3.value();
                    object = this.matchInitialSubstring((byte[])object2);
                    entryIDSet.retainAll((EntryIDSet)object);
                    if (entryIDSet.isDefined() && entryIDSet.size() <= 10) {
                        return entryIDSet;
                    }
                } else {
                    arrayList.add(searchFilter.getSubInitialElement());
                }
            }
            if (!this.indexConfig.isSubstringIndex()) {
                return entryIDSet;
            }
            arrayList.addAll(searchFilter.getSubAnyElements());
            if (searchFilter.getSubFinalElement() != null) {
                arrayList.add(searchFilter.getSubFinalElement());
            }
            object3 = arrayList.iterator();
            while (object3.hasNext()) {
                object2 = (ByteString)object3.next();
                object = substringMatchingRule.normalizeSubstring((ByteString)object2);
                byte[] byArray = object.value();
                EntryIDSet entryIDSet2 = this.matchSubstring(byArray);
                entryIDSet.retainAll(entryIDSet2);
                if (!entryIDSet.isDefined() || entryIDSet.size() > 10) continue;
                break;
            }
            return entryIDSet;
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "evaluateSubstringFilter", directoryException));
            return new EntryIDSet();
        }
    }

    public EntryIDSet evaluateBoundedRange(AttributeValue attributeValue, AttributeValue attributeValue2) {
        if (this.orderingIndex == null) {
            return new EntryIDSet();
        }
        try {
            OrderingMatchingRule orderingMatchingRule = this.getAttributeType().getOrderingMatchingRule();
            byte[] byArray = orderingMatchingRule.normalizeValue(attributeValue.getValue()).value();
            byte[] byArray2 = orderingMatchingRule.normalizeValue(attributeValue2.getValue()).value();
            return this.orderingIndex.readRange(byArray, byArray2, true, true);
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "evaluateBoundedRange", directoryException));
            return new EntryIDSet();
        }
    }

    public void removeIndex() throws DatabaseException {
        AttributeType attributeType = this.indexConfig.getAttributeType();
        String string = attributeType.getNameOrOID();
        if (this.indexConfig.isEqualityIndex()) {
            this.container.removeDatabase(string + ".equality");
        }
        if (this.indexConfig.isPresenceIndex()) {
            this.container.removeDatabase(string + ".presence");
        }
        if (this.indexConfig.isSubstringIndex()) {
            this.container.removeDatabase(string + ".substring");
        }
        if (this.indexConfig.isOrderingIndex()) {
            this.container.removeDatabase(string + ".ordering");
        }
    }

    public long getEntryLimitExceededCount() {
        long l = 0L;
        if (this.equalityIndex != null) {
            l += (long)this.equalityIndex.getEntryLimitExceededCount();
        }
        if (this.presenceIndex != null) {
            l += (long)this.presenceIndex.getEntryLimitExceededCount();
        }
        if (this.substringIndex != null) {
            l += (long)this.substringIndex.getEntryLimitExceededCount();
        }
        if (this.orderingIndex != null) {
            l += (long)this.orderingIndex.getEntryLimitExceededCount();
        }
        return l;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeyComparator
    implements Comparator<byte[]> {
        @Override
        public int compare(byte[] byArray, byte[] byArray2) {
            for (int i = 0; i < byArray.length && i < byArray2.length; ++i) {
                if (byArray[i] > byArray2[i]) {
                    return 1;
                }
                if (byArray[i] >= byArray2[i]) continue;
                return -1;
            }
            if (byArray.length == byArray2.length) {
                return 0;
            }
            if (byArray.length > byArray2.length) {
                return 1;
            }
            return -1;
        }
    }
}

