/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.PreloadConfig;
import com.sleepycat.je.PreloadStatus;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.config.ConfigParam;
import com.sleepycat.je.config.EnvironmentParams;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.opends.server.api.Backend;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.api.MonitorProvider;
import org.opends.server.backends.jeb.BackupManager;
import org.opends.server.backends.jeb.Config;
import org.opends.server.backends.jeb.ConfigurableEnvironment;
import org.opends.server.backends.jeb.Container;
import org.opends.server.backends.jeb.DbPreloadComparator;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.ExportJob;
import org.opends.server.backends.jeb.ImportJob;
import org.opends.server.backends.jeb.JebException;
import org.opends.server.backends.jeb.VerifyConfig;
import org.opends.server.backends.jeb.VerifyJob;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.DNConfigAttribute;
import org.opends.server.core.AddOperation;
import org.opends.server.core.CancelledOperationException;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.monitors.DatabaseEnvironmentMonitor;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogCategory;
import org.opends.server.types.DebugLogSeverity;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.FilePermission;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.RestoreConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.util.LDIFException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackendImpl
extends Backend
implements ConfigurableComponent {
    private static final String CLASS_NAME = "org.opends.server.backends.jeb.BackendImpl";
    private DN configDN;
    private Config config;
    private File backendDirectory;
    private FilePermission backendPermission;
    private ConcurrentHashMap<DN, EntryContainer> baseDNs;
    private Environment dbEnv;
    private ConfigurableEnvironment configurableEnv = null;
    private AtomicInteger threadTotalCount = new AtomicInteger(0);
    private AtomicInteger threadWriteCount = new AtomicInteger(0);
    private ArrayList<MonitorProvider> monitorProviders = new ArrayList();
    private static HashSet<String> supportedControls = new HashSet();
    private static ArrayList<ConfigAttribute> configAttrs;
    private static DNConfigAttribute baseDNStub;

    private void readerBegin() {
        assert (Debug.debugEnter(CLASS_NAME, "readerBegin", new String[0]));
        this.threadTotalCount.getAndIncrement();
    }

    private void readerEnd() {
        assert (Debug.debugEnter(CLASS_NAME, "readerEnd", new String[0]));
        this.threadTotalCount.getAndDecrement();
    }

    private void writerBegin() {
        assert (Debug.debugEnter(CLASS_NAME, "writerBegin", new String[0]));
        this.threadTotalCount.getAndIncrement();
        this.threadWriteCount.getAndIncrement();
    }

    private void writerEnd() {
        assert (Debug.debugEnter(CLASS_NAME, "writerEnd", new String[0]));
        this.threadWriteCount.getAndDecrement();
        this.threadTotalCount.getAndDecrement();
    }

    private void waitUntilQuiescent() {
        assert (Debug.debugEnter(CLASS_NAME, "waitUntilQuiescent", new String[0]));
        while (this.threadTotalCount.get() > 0) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                assert (Debug.debugException(CLASS_NAME, "waitUntilQuiescent", interruptedException));
            }
        }
    }

    private EntryContainer getContainer(DN dN) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "getContainer", new String[0]));
        EntryContainer entryContainer = null;
        DN dN2 = dN;
        while (entryContainer == null && dN2 != null) {
            entryContainer = this.baseDNs.get(dN2);
            if (entryContainer != null) continue;
            dN2 = dN2.getParent();
        }
        if (entryContainer == null) {
            String string = MessageHandler.getMessage(8585217, dN.toString());
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string, 8585217);
        }
        return entryContainer;
    }

    public static String getContainerName(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "getContainerName", new String[0]));
        String string = dN.toNormalizedString();
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append('_');
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initializeBackend(ConfigEntry configEntry, DN[] dNArray) throws ConfigException, InitializationException {
        void var5_16;
        Object object;
        Object object2;
        void var5_13;
        int string;
        assert (Debug.debugEnter(CLASS_NAME, "initializeBackend", new String[0]));
        this.configDN = configEntry.getDN();
        this.config = new Config();
        this.config.initializeConfig(configEntry, dNArray);
        this.backendDirectory = this.config.getBackendDirectory();
        if (!this.backendDirectory.isDirectory()) {
            String string2 = MessageHandler.getMessage(8650761, this.backendDirectory.getPath());
            throw new InitializationException(8650761, string2);
        }
        try {
            this.backendPermission = this.config.getBackendPermission();
            if (!FilePermission.setPermissions(this.backendDirectory, this.backendPermission)) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            string = 0x820080;
            String string3 = MessageHandler.getMessage(string, this.backendDirectory.getPath());
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, string3, string);
        }
        DN[] object4 = dNArray;
        string = object4.length;
        boolean object5 = false;
        while (var5_13 < string) {
            DN dN = object4[var5_13];
            DirectoryServer.registerSuffix(dN, this);
            ++var5_13;
        }
        try {
            this.dbEnv = new Environment(this.backendDirectory, this.config.getEnvironmentConfig());
            Debug.debugMessage(DebugLogCategory.BACKEND, DebugLogSeverity.INFO, CLASS_NAME, "initializeBackend", this.dbEnv.getConfig().toString());
        }
        catch (DatabaseException databaseException) {
            assert (Debug.debugException(CLASS_NAME, "initializeBackend", databaseException));
            String databaseEnvironmentMonitor = MessageHandler.getMessage(8650755, databaseException.getMessage());
            throw new InitializationException(8650755, databaseEnvironmentMonitor, databaseException);
        }
        String string4 = this.getBackendID() + " Database Environment";
        DatabaseEnvironmentMonitor databaseEnvironmentMonitor = new DatabaseEnvironmentMonitor(string4, this.dbEnv);
        this.monitorProviders.add(databaseEnvironmentMonitor);
        DirectoryServer.registerMonitorProvider(databaseEnvironmentMonitor);
        this.baseDNs = new ConcurrentHashMap(dNArray.length);
        for (DN dN : dNArray) {
            String string5 = BackendImpl.getContainerName(dN);
            object2 = new Container(this.dbEnv, string5);
            object = new EntryContainer(this, this.config, (Container)object2);
            try {
                ((EntryContainer)object).open();
            }
            catch (DatabaseException databaseException) {
                assert (Debug.debugException(CLASS_NAME, "initializeBackend", databaseException));
                String string6 = MessageHandler.getMessage(8650754, databaseException.getMessage());
                throw new InitializationException(8650754, string6, databaseException);
            }
            this.baseDNs.put(dN, (EntryContainer)object);
        }
        this.preload();
        Object var5_15 = null;
        long l = 0L;
        for (EntryContainer entryContainer : this.baseDNs.values()) {
            try {
                object2 = entryContainer.getHighestEntryID();
                if (var5_16 == null || ((EntryID)object2).compareTo((EntryID)var5_16) > 0) {
                    Object object3 = object2;
                }
                l += entryContainer.getEntryCount();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializeBackend", exception));
                object = MessageHandler.getMessage(8650757);
                throw new InitializationException(8650757, (String)object, exception);
            }
        }
        EntryID.initialize((EntryID)var5_16);
        int n = 8847402;
        String string7 = MessageHandler.getMessage(n, l);
        Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string7, n);
        DirectoryServer.registerConfigurableComponent(this);
        object2 = this.config.getEnvConfigDN();
        if (object2 != null) {
            this.configurableEnv = new ConfigurableEnvironment((DN)object2, this.dbEnv);
            DirectoryServer.registerConfigurableComponent(this.configurableEnv);
        }
    }

    private void cleanDatabase() throws DatabaseException {
        assert (Debug.debugEnter(CLASS_NAME, "cleanDatabase", new String[0]));
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".jdb");
            }
        };
        int n = this.backendDirectory.list(filenameFilter).length;
        int n2 = 8847389;
        String string = MessageHandler.getMessage(n2, n, this.backendDirectory.getPath());
        Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string, n2);
        int n3 = 0;
        int n4 = 0;
        while ((n3 = this.dbEnv.cleanLog()) > 0) {
            n4 += n3;
        }
        n2 = 8847390;
        string = MessageHandler.getMessage(n2, n4);
        Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string, n2);
        if (n4 > 0) {
            CheckpointConfig checkpointConfig = new CheckpointConfig();
            checkpointConfig.setForce(true);
            this.dbEnv.checkpoint(checkpointConfig);
        }
        int n5 = this.backendDirectory.list(filenameFilter).length;
        n2 = 8847391;
        string = MessageHandler.getMessage(n2, n5);
        Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string, n2);
    }

    @Override
    public void finalizeBackend() {
        assert (Debug.debugEnter(CLASS_NAME, "finalizeBackend", new String[0]));
        if (this.configurableEnv != null) {
            DirectoryServer.deregisterConfigurableComponent(this.configurableEnv);
            this.configurableEnv = null;
        }
        DirectoryServer.deregisterConfigurableComponent(this);
        for (DN object : this.baseDNs.keySet()) {
            try {
                DirectoryServer.deregisterSuffix(object);
            }
            catch (ConfigException configException) {
                assert (Debug.debugException(CLASS_NAME, "finalizeBackend", configException));
            }
        }
        for (MonitorProvider monitorProvider : this.monitorProviders) {
            DirectoryServer.deregisterMonitorProvider(monitorProvider.getMonitorInstanceName().toLowerCase());
        }
        this.monitorProviders = new ArrayList();
        this.waitUntilQuiescent();
        try {
            for (EntryContainer entryContainer : this.baseDNs.values()) {
                entryContainer.close();
            }
            this.dbEnv.close();
        }
        catch (DatabaseException databaseException) {
            assert (Debug.debugException(CLASS_NAME, "finalizeBackend", databaseException));
            int n = 8650766;
            String string = MessageHandler.getMessage(n, databaseException.getMessage());
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
        this.threadTotalCount.set(0);
        this.threadWriteCount.set(0);
        this.config = null;
    }

    @Override
    public boolean isLocal() {
        assert (Debug.debugEnter(CLASS_NAME, "isLocal", new String[0]));
        return true;
    }

    @Override
    public boolean supportsLDIFExport() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsLDIFExport", new String[0]));
        return true;
    }

    @Override
    public boolean supportsLDIFImport() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsLDIFImport", new String[0]));
        return true;
    }

    @Override
    public boolean supportsBackup() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsBackup", new String[0]));
        return true;
    }

    @Override
    public boolean supportsBackup(BackupConfig backupConfig, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "supportsBackup", new String[0]));
        return true;
    }

    @Override
    public boolean supportsRestore() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsRestore", new String[0]));
        return true;
    }

    public HashSet<String> getSupportedFeatures() {
        assert (Debug.debugEnter(CLASS_NAME, "getSupportedFeatures", new String[0]));
        return null;
    }

    @Override
    public boolean supportsFeature(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "supportsFeature", new String[0]));
        return false;
    }

    public HashSet<String> getSupportedControls() {
        assert (Debug.debugEnter(CLASS_NAME, "getSupportedControls", new String[0]));
        return supportedControls;
    }

    @Override
    public boolean supportsControl(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "supportsControl", new String[0]));
        return supportedControls.contains(string);
    }

    @Override
    public DN[] getBaseDNs() {
        assert (Debug.debugEnter(CLASS_NAME, "getBaseDNs", new String[0]));
        return this.config.getBaseDNs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Entry getEntry(DN dN) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "getEntry", new String[0]));
        this.readerBegin();
        try {
            Entry entry;
            EntryContainer entryContainer = this.getContainer(dN);
            try {
                entry = entryContainer.getEntry(dN);
            }
            catch (DatabaseException databaseException) {
                assert (Debug.debugException(CLASS_NAME, "getEntry", databaseException));
                String string = MessageHandler.getMessage(8650766, databaseException.getMessage());
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, 8650766);
            }
            catch (JebException jebException) {
                assert (Debug.debugException(CLASS_NAME, "getEntry", jebException));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), jebException.getMessage(), jebException.getMessageID());
            }
            Entry entry2 = entry;
            return entry2;
        }
        finally {
            this.readerEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEntry(Entry entry, AddOperation addOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "addEntry", new String[0]));
        this.writerBegin();
        try {
            DN dN = entry.getDN();
            EntryContainer entryContainer = this.getContainer(dN);
            try {
                entryContainer.addEntry(entry, addOperation);
            }
            catch (DatabaseException databaseException) {
                assert (Debug.debugException(CLASS_NAME, "addEntry", databaseException));
                String string = MessageHandler.getMessage(8650766, databaseException.getMessage());
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, 8650766);
            }
            catch (JebException jebException) {
                assert (Debug.debugException(CLASS_NAME, "addEntry", jebException));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), jebException.getMessage(), jebException.getMessageID());
            }
        }
        finally {
            this.writerEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteEntry(DN dN, DeleteOperation deleteOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "deleteEntry", new String[0]));
        this.writerBegin();
        try {
            EntryContainer entryContainer = this.getContainer(dN);
            try {
                entryContainer.deleteEntry(dN, deleteOperation);
            }
            catch (DatabaseException databaseException) {
                assert (Debug.debugException(CLASS_NAME, "deleteEntry", databaseException));
                String string = MessageHandler.getMessage(8650766, databaseException.getMessage());
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, 8650766);
            }
            catch (JebException jebException) {
                assert (Debug.debugException(CLASS_NAME, "deleteEntry", jebException));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), jebException.getMessage(), jebException.getMessageID());
            }
        }
        finally {
            this.writerEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceEntry(Entry entry, ModifyOperation modifyOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "replaceEntry", new String[0]));
        this.writerBegin();
        try {
            DN dN = entry.getDN();
            EntryContainer entryContainer = this.getContainer(dN);
            try {
                entryContainer.replaceEntry(entry, modifyOperation);
            }
            catch (DatabaseException databaseException) {
                assert (Debug.debugException(CLASS_NAME, "replaceEntry", databaseException));
                String string = MessageHandler.getMessage(8650766);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, 8650766);
            }
            catch (JebException jebException) {
                assert (Debug.debugException(CLASS_NAME, "replaceEntry", jebException));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), jebException.getMessage(), jebException.getMessageID());
            }
        }
        finally {
            this.writerEnd();
        }
    }

    @Override
    public void renameEntry(DN dN, Entry entry, ModifyDNOperation modifyDNOperation) throws DirectoryException, CancelledOperationException {
        assert (Debug.debugEnter(CLASS_NAME, "renameEntry", new String[0]));
        this.writerBegin();
        try {
            EntryContainer entryContainer = this.getContainer(dN);
            EntryContainer entryContainer2 = this.getContainer(entry.getDN());
            if (entryContainer != entryContainer2) {
                int n = 8519686;
                String string = MessageHandler.getMessage(8519686);
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
            }
            entryContainer.renameEntry(dN, entry, modifyDNOperation);
        }
        catch (DatabaseException databaseException) {
            assert (Debug.debugException(CLASS_NAME, "renameEntry", databaseException));
            String string = MessageHandler.getMessage(8650766);
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, 8650766);
        }
        catch (JebException jebException) {
            assert (Debug.debugException(CLASS_NAME, "renameEntry", jebException));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), jebException.getMessage(), jebException.getMessageID());
        }
        finally {
            this.writerEnd();
        }
    }

    @Override
    public void search(SearchOperation searchOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "search", new String[0]));
        this.readerBegin();
        try {
            EntryContainer entryContainer = this.getContainer(searchOperation.getBaseDN());
            entryContainer.search(searchOperation);
        }
        catch (DatabaseException databaseException) {
            assert (Debug.debugException(CLASS_NAME, "search", databaseException));
            String string = MessageHandler.getMessage(8650766);
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, 8650766);
        }
        finally {
            this.readerEnd();
        }
    }

    @Override
    public void exportLDIF(ConfigEntry configEntry, DN[] dNArray, LDIFExportConfig lDIFExportConfig) throws DirectoryException {
        Environment environment;
        Object object;
        Object object2;
        Object object3;
        assert (Debug.debugEnter(CLASS_NAME, "exportLDIF", new String[0]));
        this.config = new Config();
        try {
            this.config.initializeConfig(configEntry, dNArray);
        }
        catch (ConfigException configException) {
            assert (Debug.debugException(CLASS_NAME, "exportLDIF", configException));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), configException.getMessage(), configException.getMessageID());
        }
        try {
            object3 = this.dbEnv;
            if (object3 == null) {
                object2 = this.config.getEnvironmentConfig();
                object2.setReadOnly(true);
                object2.setAllowCreate(false);
                object2.setTransactional(false);
            } else {
                object2 = object3.getConfig();
            }
            object = this.config.getBackendDirectory();
            environment = new Environment((File)object, (EnvironmentConfig)object2);
            Debug.debugMessage(DebugLogCategory.BACKEND, DebugLogSeverity.INFO, CLASS_NAME, "exportLDIF", environment.getConfig().toString());
        }
        catch (DatabaseException databaseException) {
            assert (Debug.debugException(CLASS_NAME, "exportLDIF", databaseException));
            String string = MessageHandler.getMessage(8650766, databaseException.getMessage());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, 8650766);
        }
        try {
            object2 = new ExportJob(this, this.config, lDIFExportConfig);
            ((ExportJob)object2).exportLDIF(environment);
        }
        catch (IOException iOException) {
            assert (Debug.debugException(CLASS_NAME, "exportLDIF", iOException));
            int n = 8650792;
            object = MessageHandler.getMessage(n, iOException.getMessage());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), (String)object, n);
        }
        catch (JebException jebException) {
            assert (Debug.debugException(CLASS_NAME, "exportLDIF", jebException));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), jebException.getMessage(), jebException.getMessageID());
        }
        catch (DatabaseException databaseException) {
            assert (Debug.debugException(CLASS_NAME, "exportLDIF", databaseException));
            object3 = MessageHandler.getMessage(8650766, databaseException.getMessage());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), (String)object3, 8650766);
        }
        catch (LDIFException lDIFException) {
            assert (Debug.debugException(CLASS_NAME, "exportLDIF", lDIFException));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), lDIFException.getMessage(), lDIFException.getMessageID());
        }
        finally {
            block26: {
                try {
                    environment.close();
                }
                catch (DatabaseException databaseException) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "exportLDIF", databaseException)) break block26;
                    throw new AssertionError();
                }
            }
        }
    }

    @Override
    public void importLDIF(ConfigEntry configEntry, DN[] dNArray, LDIFImportConfig lDIFImportConfig) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "importLDIF", new String[0]));
        this.config = new Config();
        try {
            this.config.initializeConfig(configEntry, dNArray);
        }
        catch (ConfigException configException) {
            assert (Debug.debugException(CLASS_NAME, "importLDIF", configException));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), configException.getMessage(), configException.getMessageID());
        }
        try {
            ImportJob importJob = new ImportJob(this, this.config, lDIFImportConfig);
            importJob.importLDIF();
        }
        catch (IOException iOException) {
            assert (Debug.debugException(CLASS_NAME, "importLDIF", iOException));
            int n = 8650792;
            String string = MessageHandler.getMessage(n, iOException.getMessage());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n);
        }
        catch (JebException jebException) {
            assert (Debug.debugException(CLASS_NAME, "importLDIF", jebException));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), jebException.getMessage(), jebException.getMessageID());
        }
        catch (DatabaseException databaseException) {
            assert (Debug.debugException(CLASS_NAME, "importLDIF", databaseException));
            String string = MessageHandler.getMessage(8650766, databaseException.getMessage());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, 8650766);
        }
    }

    public void verifyBackend(VerifyConfig verifyConfig, ConfigEntry configEntry, DN[] dNArray) throws InitializationException, ConfigException, DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "verifyBackend", new String[0]));
        this.config = new Config();
        this.config.initializeConfig(configEntry, dNArray);
        VerifyJob verifyJob = new VerifyJob(this, this.config, verifyConfig);
        try {
            verifyJob.verifyBackend();
        }
        catch (DatabaseException databaseException) {
            assert (Debug.debugException(CLASS_NAME, "verifyBackend", databaseException));
            String string = MessageHandler.getMessage(8650766, databaseException.getMessage());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, 8650766);
        }
        catch (JebException jebException) {
            assert (Debug.debugException(CLASS_NAME, "verifyBackend", jebException));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), jebException.getMessage(), jebException.getMessageID());
        }
    }

    @Override
    public void createBackup(ConfigEntry configEntry, BackupConfig backupConfig) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "createBackup", new String[0]));
        BackupManager backupManager = new BackupManager(this.getBackendID());
        backupManager.createBackup(configEntry, backupConfig);
    }

    @Override
    public void removeBackup(BackupDirectory backupDirectory, String string) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "removeBackup", new String[0]));
        BackupManager backupManager = new BackupManager(this.getBackendID());
        backupManager.removeBackup(backupDirectory, string);
    }

    @Override
    public void restoreBackup(ConfigEntry configEntry, RestoreConfig restoreConfig) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "restoreBackup", new String[0]));
        BackupManager backupManager = new BackupManager(this.getBackendID());
        backupManager.restoreBackup(configEntry, restoreConfig);
    }

    @Override
    public DN getConfigurableComponentEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurableComponentEntryDN", new String[0]));
        return this.configDN;
    }

    @Override
    public List<ConfigAttribute> getConfigurationAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurationAttributes", new String[0]));
        return configAttrs;
    }

    @Override
    public boolean hasAcceptableConfiguration(ConfigEntry configEntry, List<String> list) {
        Object object;
        assert (Debug.debugEnter(CLASS_NAME, "hasAcceptableConfiguration", new String[0]));
        DN[] dNArray = null;
        boolean bl = true;
        try {
            object = (DNConfigAttribute)configEntry.getConfigAttribute(baseDNStub);
            if (object == null) {
                int n = 3408178;
                String string = MessageHandler.getMessage(n, String.valueOf(configEntry.getDN()));
                list.add(string);
            } else {
                dNArray = ((DNConfigAttribute)object).activeValues().toArray(new DN[0]);
            }
        }
        catch (ConfigException configException) {
            list.add(configException.getMessage());
            bl = false;
        }
        object = new Config();
        try {
            ((Config)object).initializeConfig(configEntry, dNArray);
        }
        catch (ConfigException configException) {
            list.add(configException.getMessage());
            bl = false;
        }
        return bl;
    }

    @Override
    public ConfigChangeResult applyNewConfiguration(ConfigEntry configEntry, boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "applyNewConfiguration", new String[0]));
        try {
            Object object;
            DN[] dNArray = null;
            DNConfigAttribute dNConfigAttribute = (DNConfigAttribute)configEntry.getConfigAttribute(baseDNStub);
            dNArray = dNConfigAttribute.activeValues().toArray(new DN[0]);
            Config config = new Config();
            config.initializeConfig(configEntry, dNArray);
            for (DN environmentConfig2 : this.config.getBaseDNs()) {
                boolean string = false;
                for (DN dN : config.getBaseDNs()) {
                    if (!dN.equals(environmentConfig2)) continue;
                    string = true;
                }
                if (string) continue;
                DirectoryServer.deregisterSuffix(environmentConfig2);
                object = this.baseDNs.remove(environmentConfig2);
                ((EntryContainer)object).close();
                ((EntryContainer)object).removeContainer();
            }
            for (DN environmentConfig2 : config.getBaseDNs()) {
                if (this.baseDNs.containsKey(environmentConfig2)) continue;
                String map = BackendImpl.getContainerName(environmentConfig2);
                object = new Container(this.dbEnv, map);
                EntryContainer entryContainer = new EntryContainer(this, this.config, (Container)object);
                entryContainer.open();
                this.baseDNs.put(environmentConfig2, entryContainer);
                DirectoryServer.registerSuffix(environmentConfig2, this);
            }
            FilePermission filePermission = this.config.getBackendPermission();
            FilePermission filePermission2 = config.getBackendPermission();
            if (!FilePermission.toUNIXMode(filePermission).equals(FilePermission.toUNIXMode(filePermission2))) {
                try {
                    if (!FilePermission.setPermissions(config.getBackendDirectory(), filePermission2)) {
                        throw new Exception();
                    }
                }
                catch (Exception exception) {
                    int n = 0x820080;
                    String string = MessageHandler.getMessage(n, this.backendDirectory.getPath());
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, string, n);
                }
            }
            EnvironmentConfig environmentConfig = this.config.getEnvironmentConfig();
            EnvironmentConfig environmentConfig2 = config.getEnvironmentConfig();
            Map map = EnvironmentParams.SUPPORTED_PARAMS;
            for (Object e : map.values()) {
                String string;
                String string2;
                ConfigParam configParam = (ConfigParam)e;
                if (configParam.isMutable() || (string2 = environmentConfig.getConfigParam(configParam.getName())).equalsIgnoreCase(string = environmentConfig2.getConfigParam(configParam.getName()))) continue;
                System.out.println("The change to the following property will take effect when the backend is restarted: " + configParam.getName());
            }
            this.dbEnv.setMutableConfig((EnvironmentMutableConfig)config.getEnvironmentConfig());
            Debug.debugMessage(DebugLogCategory.BACKEND, DebugLogSeverity.INFO, CLASS_NAME, "applyNewConfiguration", this.dbEnv.getConfig().toString());
            this.config = config;
        }
        catch (Exception exception) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(exception.getMessage());
            ConfigChangeResult configChangeResult = new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), false, arrayList);
            return configChangeResult;
        }
        ConfigChangeResult configChangeResult = new ConfigChangeResult(ResultCode.SUCCESS, false);
        return configChangeResult;
    }

    private void preload() {
        block6: {
            assert (Debug.debugEnter(CLASS_NAME, "preload", new String[0]));
            long l = this.config.getPreloadTimeLimit();
            if (l > 0L) {
                ArrayList<Database> arrayList = new ArrayList<Database>();
                for (EntryContainer entryContainer : this.baseDNs.values()) {
                    entryContainer.listDatabases(arrayList);
                }
                Collections.sort(arrayList, new DbPreloadComparator());
                try {
                    Object object;
                    long l2 = System.currentTimeMillis() + l;
                    PreloadConfig preloadConfig = new PreloadConfig();
                    preloadConfig.setLoadLNs(true);
                    for (Database database : arrayList) {
                        long l3 = l2 - System.currentTimeMillis();
                        if (l3 <= 0L) break;
                        preloadConfig.setMaxMillisecs(l3);
                        object = database.preload(preloadConfig);
                        if (object.getStatus() == PreloadStatus.SUCCESS) continue;
                        break;
                    }
                    EnvironmentStats environmentStats = this.dbEnv.getStats(new StatsConfig());
                    long l4 = environmentStats.getCacheTotalBytes();
                    int n = 8847421;
                    object = MessageHandler.getMessage(n, l4 / 0x100000L);
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, (String)object, n);
                }
                catch (DatabaseException databaseException) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "preload", databaseException)) break block6;
                    throw new AssertionError();
                }
            }
        }
    }

    static {
        supportedControls.add("1.2.840.113556.1.4.805");
        supportedControls.add("1.2.840.113556.1.4.319");
        supportedControls.add("2.16.840.1.113730.3.4.2");
        configAttrs = new ArrayList();
        int n = 0x300131;
        baseDNStub = new DNConfigAttribute("ds-cfg-backend-base-dn", MessageHandler.getMessage(n), true, true, true);
        configAttrs.add(baseDNStub);
    }
}

